/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.util.IOUtils;
import org.netbeans.modules.javacore.parser.ElementInfo;
import org.netbeans.modules.javacore.parser.TypeParamRef;
import org.netbeans.modules.javacore.parser.TypeRef;
import org.openide.util.Utilities;

public class NameRef
extends TypeParamRef {
    public final TypeParamRef parent;
    public final TypeRef[] args;
    public static final NameRef java_lang_Object = new NameRef("java.lang.Object");
    public static final NameRef java_lang_Enum = new NameRef("java.lang.Enum");
    public static final NameRef java_lang_Annotation = new NameRef("java.lang.annotation.Annotation");
    private int hashCode;

    public static Object read(InputStream stream, StorableBaseObject storable) throws IOException {
        TypeParamRef parent = (TypeParamRef)IOUtils.read((InputStream)stream, (StorableBaseObject)storable);
        int len = IOUtils.readInt((InputStream)stream);
        TypeRef[] args = len == 0 ? ElementInfo.EMPTY_TYPEREFS : new TypeRef[len];
        for (int i = 0; i < args.length; ++i) {
            args[i] = (TypeRef)IOUtils.read((InputStream)stream, (StorableBaseObject)storable);
        }
        return new NameRef(stream, parent, args);
    }

    public void write(OutputStream outputStream, StorableBaseObject storable) throws IOException {
        IOUtils.write((OutputStream)outputStream, (Object)this.parent, (StorableBaseObject)storable);
        IOUtils.writeInt((OutputStream)outputStream, (int)this.args.length);
        for (int i = 0; i < this.args.length; ++i) {
            IOUtils.write((OutputStream)outputStream, (Object)this.args[i], (StorableBaseObject)storable);
        }
        super.write(outputStream, storable);
    }

    private NameRef(InputStream stream, TypeParamRef parent, TypeRef[] args) throws IOException {
        super(IOUtils.readString((InputStream)stream));
        this.parent = parent;
        this.args = args;
    }

    public NameRef(String name) {
        this(name, null, null);
    }

    public NameRef(String n, TypeParamRef par, TypeRef[] args) {
        super(NameRef.getName(n, par, args));
        this.parent = this.name != n ? null : par;
        this.args = args == null ? ElementInfo.EMPTY_TYPEREFS : args;
    }

    private static String getName(String name, TypeParamRef parent, TypeRef[] args) {
        String newName = name;
        if (parent != null && parent instanceof NameRef) {
            NameRef parentName = (NameRef)parent;
            if (parentName.parent == null && parentName.args.length == 0) {
                newName = parentName.name.concat(".").concat(name);
            }
        }
        return newName;
    }

    public boolean equals(Object typeRef) {
        if (this == typeRef) {
            return true;
        }
        if (!(typeRef instanceof NameRef)) {
            return false;
        }
        NameRef ref = (NameRef)typeRef;
        if (!this.name.equals(ref.name)) {
            return false;
        }
        if (!Utilities.compareObjects((Object)this.parent, (Object)ref.parent)) {
            return false;
        }
        return Utilities.compareObjects((Object)this.args, (Object)ref.args);
    }

    String getName() {
        String parentString = "";
        if (this.parent != null) {
            parentString = this.parent.getName().concat(".");
        }
        return parentString.concat(this.name);
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            this.hashCode = this.name.hashCode();
            if (this.parent != null) {
                this.hashCode ^= this.parent.hashCode();
            }
            this.hashCode ^= this.args.hashCode();
        }
        return this.hashCode;
    }
}

