/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.memoryimpl;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageFactory;
import org.netbeans.mdr.persistence.memoryimpl.StorageImpl;

public class StorageFactoryImpl
implements StorageFactory {
    public static final String STORAGE_ID = "org.netbeans.mdr.persistence.memoryimpl.id";
    public static final String STORAGE_NAME = "org.netbeans.mdr.persistence.memoryimpl.fileName";
    static final String NULL_STORAGE_ID = ".";
    private static final MOFID NULL_MOFID = new MOFID(0L, ".");
    private StorageImpl nullStorage;
    private static final HashMap storages = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Storage createStorage(Map properties) throws StorageException {
        String name = (String)properties.get(STORAGE_ID);
        if (name == null || name.equals(NULL_STORAGE_ID)) {
            if (this.nullStorage == null) {
                this.nullStorage = new StorageImpl(NULL_STORAGE_ID, null);
            }
            return this.nullStorage;
        }
        HashMap hashMap = storages;
        synchronized (hashMap) {
            if (storages.containsKey(name)) {
                throw new RuntimeException("Storage '" + name + "' already created.");
            }
            StorageImpl result = new StorageImpl(name, (String)properties.get(STORAGE_NAME));
            storages.put(name, result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean serialize(String storageId) throws StorageException {
        StorageImpl storage;
        HashMap hashMap = storages;
        synchronized (hashMap) {
            storage = (StorageImpl)storages.get(storageId);
        }
        if (storage == null) {
            return false;
        }
        storage.serialize();
        return true;
    }

    public MOFID createNullMOFID() throws StorageException {
        return NULL_MOFID;
    }
}

