/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.NbModuleTypeProvider;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.w3c.dom.Element;

final class Evaluator
implements PropertyEvaluator,
PropertyChangeListener,
AntProjectListener {
    private final NbModuleProject project;
    private final NbModuleTypeProvider typeProvider;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private PropertyEvaluator delegate;
    private boolean loadedModuleList = false;
    private boolean runInAtomicAction;
    private final Pattern ANT_PROP_REGEX = Pattern.compile("\\$\\{([a-zA-Z0-9._-]+)\\}");
    static final /* synthetic */ boolean $assertionsDisabled;

    public Evaluator(NbModuleProject project, NbModuleTypeProvider typeProvider) {
        this.project = project;
        this.typeProvider = typeProvider;
        this.delegate = this.createEvaluator(null);
        this.delegate.addPropertyChangeListener((PropertyChangeListener)this);
        project.getHelper().addAntProjectListener((AntProjectListener)this);
    }

    public String getProperty(String prop) {
        PropertyEvaluator eval = this.delegatingEvaluator(false);
        if (!$assertionsDisabled && eval == this) {
            throw new AssertionError();
        }
        String v = eval.getProperty(prop);
        if (v == null && this.isModuleListDependentProperty(prop) || this.isModuleListDependentValue(v)) {
            return this.delegatingEvaluator(true).getProperty(prop);
        }
        return v;
    }

    public String evaluate(String text) {
        String v = this.delegatingEvaluator(false).evaluate(text);
        if (this.isModuleListDependentValue(v)) {
            return this.delegatingEvaluator(true).evaluate(text);
        }
        return v;
    }

    public Map getProperties() {
        return this.delegatingEvaluator(true).getProperties();
    }

    private boolean isModuleListDependentProperty(String p) {
        return p.equals("module.classpath") || p.equals("cp") || p.endsWith(".cp") || p.endsWith(".cp.extra") || p.equals("cluster") || p.endsWith(".dir") && p.lastIndexOf(46, p.length() - 5) == -1;
    }

    private boolean isModuleListDependentValue(String v) {
        if (v == null) {
            return false;
        }
        Matcher m = this.ANT_PROP_REGEX.matcher(v);
        while (m.find()) {
            if (!this.isModuleListDependentProperty(m.group(1))) continue;
            return true;
        }
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    private PropertyEvaluator delegatingEvaluator(boolean reset) {
        if (reset && !this.loadedModuleList) {
            this.reset();
            if (Util.err.isLoggable(1)) {
                Util.err.log("Needed to reset evaluator in " + this.project + "due to use of module-list-dependent property; now cp=" + this.delegate.getProperty("cp"));
            }
        }
        return this.delegate;
    }

    private void reset() {
        this.loadedModuleList = true;
        this.delegate.removePropertyChangeListener((PropertyChangeListener)this);
        try {
            this.delegate = this.createEvaluator(this.project.getModuleList());
        }
        catch (IOException e) {
            Util.err.notify(1, (Throwable)e);
        }
        this.delegate.addPropertyChangeListener((PropertyChangeListener)this);
        this.pcs.firePropertyChange(null, null, null);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("netbeans.dest.dir".equals(evt.getPropertyName()) || evt.getPropertyName() == null) {
            this.reset();
        } else {
            Util.err.log("Refiring property change from delegate in " + evt.getPropertyName() + " for " + this.project);
            this.pcs.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
        if (!this.runInAtomicAction && ev.getPath().equals("nbproject/project.xml")) {
            this.reset();
        }
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    public void setRunInAtomicAction(boolean runInAtomicAction) {
        if (!$assertionsDisabled && !ProjectManager.mutex().isWriteAccess()) {
            throw new AssertionError();
        }
        this.runInAtomicAction = runInAtomicAction;
    }

    public void removeListeners() {
        this.project.getHelper().removeAntProjectListener((AntProjectListener)this);
        this.delegate.removePropertyChangeListener((PropertyChangeListener)this);
    }

    private PropertyEvaluator createEvaluator(ModuleList ml) {
        PropertyEvaluator baseEval;
        File nbroot;
        PropertyProvider predefs = this.project.getHelper().getStockPropertyPreprovider();
        HashMap<String, String> stock = new HashMap<String, String>();
        File dir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        NbModuleTypeProvider.NbModuleType type = this.typeProvider.getModuleType();
        if (type == NbModuleTypeProvider.NETBEANS_ORG) {
            nbroot = ModuleList.findNetBeansOrg(dir);
            if (!$assertionsDisabled && nbroot == null) {
                throw new AssertionError((Object)("netbeans.org-type module not in a complete netbeans.org source root " + dir));
            }
            stock.put("nb_all", nbroot.getAbsolutePath());
            stock.put("netbeans.dest.dir", new File(nbroot, ModuleList.DEST_DIR_IN_NETBEANS_ORG).getAbsolutePath());
        } else {
            nbroot = null;
        }
        if (ml != null) {
            Iterator it = ml.getAllEntriesSoft().iterator();
            while (it.hasNext()) {
                ModuleEntry e = (ModuleEntry)it.next();
                String nborgPath = e.getNetBeansOrgPath();
                if (nborgPath == null) continue;
                stock.put((nborgPath + ".dir").intern(), e.getClusterDirectory().getAbsolutePath().intern());
            }
            ModuleEntry thisEntry = ml.getEntry(this.project.getCodeNameBase());
            if (thisEntry != null) {
                if (!$assertionsDisabled && !(nbroot == null ^ thisEntry.getNetBeansOrgPath() != null)) {
                    throw new AssertionError(thisEntry);
                }
                File clusterDir = thisEntry.getClusterDirectory();
                stock.put("cluster", clusterDir.getAbsolutePath());
            }
        }
        ArrayList<PropertyProvider> providers = new ArrayList<PropertyProvider>();
        providers.add(PropertyUtils.fixedPropertyProvider(stock));
        if (type == NbModuleTypeProvider.SUITE_COMPONENT) {
            providers.add(this.project.getHelper().getPropertyProvider("nbproject/private/suite-private.properties"));
            providers.add(this.project.getHelper().getPropertyProvider("nbproject/suite.properties"));
            baseEval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefs, (PropertyProvider[])providers.toArray(new PropertyProvider[providers.size()]));
            String suiteDirS = baseEval.getProperty("suite.dir");
            if (suiteDirS != null) {
                File suiteDir = PropertyUtils.resolveFile((File)dir, (String)suiteDirS);
                providers.add(PropertyUtils.propertiesFilePropertyProvider((File)new File(suiteDir, "nbproject" + File.separatorChar + "private" + File.separatorChar + "platform-private.properties")));
                providers.add(PropertyUtils.propertiesFilePropertyProvider((File)new File(suiteDir, "nbproject" + File.separatorChar + "platform.properties")));
            }
        } else if (type == NbModuleTypeProvider.STANDALONE) {
            providers.add(this.project.getHelper().getPropertyProvider("nbproject/private/platform-private.properties"));
            providers.add(this.project.getHelper().getPropertyProvider("nbproject/platform.properties"));
        }
        if (type == NbModuleTypeProvider.SUITE_COMPONENT || type == NbModuleTypeProvider.STANDALONE) {
            baseEval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefs, (PropertyProvider[])providers.toArray(new PropertyProvider[providers.size()]));
            providers.add(new Util.UserPropertiesFileProvider(baseEval, dir));
            baseEval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefs, (PropertyProvider[])providers.toArray(new PropertyProvider[providers.size()]));
            class DestDirProvider
            extends Util.ComputedPropertyProvider {
                public DestDirProvider(PropertyEvaluator eval) {
                    super(eval);
                }

                protected Map getProperties(Map inputPropertyValues) {
                    String platformS = (String)inputPropertyValues.get("nbplatform.active");
                    if (platformS != null) {
                        return Collections.singletonMap("netbeans.dest.dir", "${nbplatform." + platformS + ".netbeans.dest.dir}");
                    }
                    return Collections.EMPTY_MAP;
                }

                protected Set inputProperties() {
                    return Collections.singleton("nbplatform.active");
                }
            }
            providers.add(new DestDirProvider(baseEval));
        }
        if (type == NbModuleTypeProvider.NETBEANS_ORG) {
            File nbbuild = new File(nbroot, "nbbuild");
            providers.add(PropertyUtils.propertiesFilePropertyProvider((File)new File(nbbuild, "user.build.properties")));
            providers.add(PropertyUtils.propertiesFilePropertyProvider((File)new File(nbbuild, "site.build.properties")));
        }
        baseEval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefs, (PropertyProvider[])providers.toArray(new PropertyProvider[providers.size()]));
        providers.add(new NbJdkProvider(baseEval));
        providers.add(this.project.getHelper().getPropertyProvider("nbproject/private/private.properties"));
        providers.add(this.project.getHelper().getPropertyProvider("nbproject/project.properties"));
        HashMap<String, String> defaults = new HashMap<String, String>();
        defaults.put("code.name.base.dashes", this.project.getCodeNameBase().replace('.', '-'));
        defaults.put("module.jar.dir", "modules");
        defaults.put("module.jar.basename", "${code.name.base.dashes}.jar");
        defaults.put("module.jar", "${module.jar.dir}/${module.jar.basename}");
        defaults.put("manifest.mf", "manifest.mf");
        defaults.put("src.dir", "src");
        defaults.put("build.classes.dir", "build/classes");
        defaults.put("test.unit.src.dir", "test/unit/src");
        defaults.put("test.qa-functional.src.dir", "test/qa-functional/src");
        defaults.put("test.qa-performance.src.dir", "test/qa-performance/src");
        defaults.put("build.test.unit.classes.dir", "build/test/unit/classes");
        defaults.put("javac.source", "1.4");
        providers.add(PropertyUtils.fixedPropertyProvider(defaults));
        if (ml != null) {
            String jelly2NbJar;
            String testJars;
            providers.add(PropertyUtils.fixedPropertyProvider(Collections.singletonMap("module.classpath", this.computeModuleClasspath(ml))));
            HashMap<String, String> buildDefaults = new HashMap<String, String>();
            buildDefaults.put("cp.extra", "");
            buildDefaults.put("cp", "${module.classpath}:${cp.extra}");
            buildDefaults.put("run.cp", this.computeRuntimeModuleClasspath(ml) + ":${cp.extra}:${build.classes.dir}");
            baseEval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefs, (PropertyProvider[])providers.toArray(new PropertyProvider[providers.size()]));
            buildDefaults.put("test.unit.cp.extra", "");
            if (type == NbModuleTypeProvider.NETBEANS_ORG) {
                buildDefaults.put("xtest.home", "${nb_all}/xtest");
                testJars = "${xtest.home}/lib/junit.jar:${xtest.home}/lib/nbjunit.jar:${xtest.home}/lib/nbjunit-ide.jar:${xtest.home}/lib/insanelib.jar";
            } else {
                testJars = "${test.unit.lib.cp}:${netbeans.dest.dir}/ide6/modules/ext/junit-3.8.1.jar:${netbeans.dest.dir}/ide7/modules/ext/junit-3.8.1.jar:${netbeans.dest.dir}/ide8/modules/ext/junit-3.8.2.jar:${netbeans.dest.dir}/testtools/modules/ext/nbjunit.jar:${netbeans.dest.dir}/testtools/modules/ext/insanelib.jar:${netbeans.home}/../ide7/modules/ext/junit-3.8.1.jar:${netbeans.home}/../testtools/modules/ext/nbjunit.jar:${netbeans.home}/../testtools/modules/ext/insanelib.jar:${netbeans.user}/modules/ext/nbjunit.jar:${netbeans.user}/modules/ext/insanelib.jar:${netbeans.dest.dir}/../../xtest/lib/junit.jar:${netbeans.dest.dir}/../../xtest/lib/nbjunit.jar:${netbeans.dest.dir}/../../xtest/lib/insanelib.jar";
            }
            buildDefaults.put("test.unit.cp", "${cp}:${cluster}/${module.jar}:" + testJars + ":${test.unit.cp.extra}");
            buildDefaults.put("test.unit.run.cp.extra", "");
            buildDefaults.put("test.unit.run.cp", "${test.unit.cp}:${build.test.unit.classes.dir}:${test.unit.run.cp.extra}");
            buildDefaults.put("test.qa-functional.cp.extra", "");
            String jemmyJar = this.findJemmyJar(baseEval);
            if (jemmyJar != null) {
                buildDefaults.put("jemmy.jar", jemmyJar);
            }
            if ((jelly2NbJar = this.findJelly2NbJar(baseEval)) != null) {
                buildDefaults.put("jelly2-nb.jar", jelly2NbJar);
            }
            buildDefaults.put("test.qa-functional.cp", testJars + ":${netbeans.home}/../testtools/modules/ext/nbjunit-ide.jar" + ":${netbeans.user}/testtools/modules/ext/nbjunit.jar" + ":${jemmy.jar}" + ":${jelly2-nb.jar}" + ":${test.qa-functional.cp.extra}");
            buildDefaults.put("build.test.qa-functional.classes.dir", "build/test/qa-functional/classes");
            buildDefaults.put("test.qa-functional.run.cp", "${test.qa-functional.cp}:${build.test.qa-functional.classes.dir}");
            providers.add(PropertyUtils.fixedPropertyProvider(buildDefaults));
        }
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefs, (PropertyProvider[])providers.toArray(new PropertyProvider[providers.size()]));
    }

    private String findJemmyJar(PropertyEvaluator eval) {
        File f = this.project.getNbrootFile("jemmy/builds/jemmy.jar", eval);
        if (f != null) {
            return f.getAbsolutePath();
        }
        return null;
    }

    private String findJelly2NbJar(PropertyEvaluator eval) {
        File f = this.project.getNbrootFile("jellytools/builds/jelly2-nb.jar", eval);
        if (f != null) {
            return f.getAbsolutePath();
        }
        return null;
    }

    private String computeModuleClasspath(ModuleList ml) {
        Element data = this.project.getHelper().getPrimaryConfigurationData(true);
        Element moduleDependencies = Util.findElement(data, "module-dependencies", "http://www.netbeans.org/ns/nb-module-project/2");
        List deps = Util.findSubElements(moduleDependencies);
        Iterator it = deps.iterator();
        StringBuffer cp = new StringBuffer();
        while (it.hasNext()) {
            Element dep = (Element)it.next();
            if (Util.findElement(dep, "compile-dependency", "http://www.netbeans.org/ns/nb-module-project/2") == null) continue;
            Element cnbEl = Util.findElement(dep, "code-name-base", "http://www.netbeans.org/ns/nb-module-project/2");
            String cnb = Util.findText(cnbEl);
            ModuleEntry module = ml.getEntry(cnb);
            if (module == null) {
                Util.err.log(16, "Warning - could not find dependent module " + cnb + " for " + FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory()));
                continue;
            }
            File moduleJar = module.getJarLocation();
            if (cp.length() > 0) {
                cp.append(File.pathSeparatorChar);
            }
            cp.append(moduleJar.getAbsolutePath());
            cp.append(module.getClassPathExtensions());
        }
        ModuleEntry myself = ml.getEntry(this.project.getCodeNameBase());
        if (myself == null) {
            return "";
        }
        cp.append(myself.getClassPathExtensions());
        return cp.toString();
    }

    private String computeRuntimeModuleClasspath(ModuleList ml) {
        HashSet<String> unprocessed = new HashSet<String>();
        unprocessed.add(this.project.getCodeNameBase());
        HashSet<String> processed = new HashSet<String>();
        StringBuffer cp = new StringBuffer();
        while (!unprocessed.isEmpty()) {
            Iterator it = unprocessed.iterator();
            String cnb = (String)it.next();
            it.remove();
            if (!processed.add(cnb)) continue;
            ModuleEntry module = ml.getEntry(cnb);
            if (module == null) {
                Util.err.log(16, "Warning - could not find dependent module " + cnb + " for " + FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory()));
                continue;
            }
            if (!cnb.equals(this.project.getCodeNameBase())) {
                if (cp.length() > 0) {
                    cp.append(File.pathSeparatorChar);
                }
                cp.append(module.getJarLocation().getAbsolutePath());
                cp.append(module.getClassPathExtensions());
            }
            String[] newDeps = module.getRunDependencies();
            unprocessed.addAll(Arrays.asList(newDeps));
        }
        return cp.toString();
    }

    static {
        $assertionsDisabled = !Evaluator.class.desiredAssertionStatus();
    }

    private final class NbJdkProvider
    implements PropertyProvider,
    PropertyChangeListener {
        private final PropertyEvaluator eval;
        private final List listeners = new ArrayList();
        private final PropertyChangeListener weakListener = WeakListeners.propertyChange((PropertyChangeListener)this, null);

        public NbJdkProvider(PropertyEvaluator eval) {
            this.eval = eval;
            eval.addPropertyChangeListener(this.weakListener);
            JavaPlatformManager.getDefault().addPropertyChangeListener(this.weakListener);
        }

        public final Map getProperties() {
            Collection installs;
            JavaPlatform platform;
            String active;
            HashMap<String, String> props = new HashMap<String, String>();
            String home = this.eval.getProperty("nbjdk.home");
            if (home == null && (active = this.eval.getProperty("nbjdk.active")) != null && !active.equals("default") && (home = this.eval.getProperty("platforms." + active + ".home")) != null) {
                props.put("nbjdk.home", home);
            }
            if (home == null && (platform = JavaPlatformManager.getDefault().getDefaultPlatform()) != null && (installs = platform.getInstallFolders()).size() == 1) {
                home = FileUtil.toFile((FileObject)((FileObject)installs.iterator().next())).getAbsolutePath();
            }
            String bootcp = null;
            if (home != null) {
                FileObject homeFO = FileUtil.toFileObject((File)new File(home));
                if (homeFO != null) {
                    JavaPlatform[] platforms = JavaPlatformManager.getDefault().getInstalledPlatforms();
                    for (int i = 0; i < platforms.length; ++i) {
                        if (!new HashSet(platforms[i].getInstallFolders()).equals(Collections.singleton(homeFO))) continue;
                        StringBuffer bootcpSB = new StringBuffer();
                        ClassPath boot = platforms[i].getBootstrapLibraries();
                        boot.removePropertyChangeListener(this.weakListener);
                        boot.addPropertyChangeListener(this.weakListener);
                        Iterator entries = boot.entries().iterator();
                        while (entries.hasNext()) {
                            URL nested;
                            ClassPath.Entry entry = (ClassPath.Entry)entries.next();
                            URL u = entry.getURL();
                            if (u.toExternalForm().endsWith("!/") && (nested = FileUtil.getArchiveFile((URL)u)) != null) {
                                u = nested;
                            }
                            if (!"file".equals(u.getProtocol())) continue;
                            File f = new File(URI.create(u.toExternalForm()));
                            if (bootcpSB.length() > 0) {
                                bootcpSB.append(File.pathSeparatorChar);
                            }
                            bootcpSB.append(f.getAbsolutePath());
                        }
                        bootcp = bootcpSB.toString();
                        break;
                    }
                }
                if (bootcp == null) {
                    bootcp = "${nbjdk.home}/jre/lib/rt.jar".replace('/', File.separatorChar);
                }
            }
            if (bootcp == null) {
                bootcp = "${sun.boot.class.path}";
            }
            props.put("nbjdk.bootclasspath", bootcp);
            props.put("tools.jar", "${nbjdk.home}/lib/tools.jar".replace('/', File.separatorChar));
            if (Util.err.isLoggable(1)) {
                TreeMap<String, String> _props = new TreeMap<String, String>(this.eval.getProperties());
                Iterator it = _props.entrySet().iterator();
                while (it.hasNext()) {
                    String k = (String)it.next().getKey();
                    if (k.startsWith("nbjdk.") || k.startsWith("platforms.")) continue;
                    it.remove();
                }
                _props.putAll(props);
                Util.err.log("JDK-related properties of " + Evaluator.this.project + ": " + _props);
            }
            return props;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addChangeListener(ChangeListener l) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void removeChangeListener(ChangeListener l) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.remove(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void propertyChange(PropertyChangeEvent evt) {
            Iterator it;
            String p = evt.getPropertyName();
            if (!(p == null || p.startsWith("nbjdk.") || p.startsWith("platforms.") || p.equals("entries") || p.equals("installedPlatforms"))) {
                return;
            }
            final ChangeEvent ev = new ChangeEvent(this);
            List list = this.listeners;
            synchronized (list) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                it = new HashSet(this.listeners).iterator();
            }
            final Mutex.Action action = new Mutex.Action(){

                public Object run() {
                    while (it.hasNext()) {
                        ((ChangeListener)it.next()).stateChanged(ev);
                    }
                    return null;
                }
            };
            if (ProjectManager.mutex().isWriteAccess()) {
                ProjectManager.mutex().readAccess(action);
            } else if (ProjectManager.mutex().isReadAccess()) {
                action.run();
            } else {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        ProjectManager.mutex().readAccess(action);
                    }
                });
            }
        }
    }
}

