/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.NbModuleTypeProvider;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.FindAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderLookup;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class ModuleActions
implements ActionProvider {
    private final NbModuleProject project;
    private final Map globalCommands = new HashMap();
    private final String[] supportedActions;
    private static final Pattern SRCDIRJAVA;
    private static final String SUBST = "Test.java";
    static final /* synthetic */ boolean $assertionsDisabled;

    static Action[] getProjectActions(NbModuleProject project) {
        ArrayList<Action> actions;
        block14: {
            Properties props;
            boolean isNetBeansOrg;
            actions = new ArrayList<Action>();
            actions.add(CommonProjectActions.newFileAction());
            actions.add(null);
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"build", (String)NbBundle.getMessage((Class)ModuleActions.class, (String)"ACTION_build"), null));
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)NbBundle.getMessage((Class)ModuleActions.class, (String)"ACTION_rebuild"), null));
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"clean", (String)NbBundle.getMessage((Class)ModuleActions.class, (String)"ACTION_clean"), null));
            actions.add(null);
            boolean bl = isNetBeansOrg = Util.getModuleType(project) == NbModuleTypeProvider.NETBEANS_ORG;
            if (isNetBeansOrg) {
                String path = project.getPathWithinNetBeansOrg();
                actions.add(ModuleActions.createMasterAction(project, new String[]{"init", "all-" + path}, NbBundle.getMessage((Class)ModuleActions.class, (String)"ACTION_build_with_deps")));
                actions.add(ModuleActions.createMasterAction(project, new String[]{"init", "all-" + path, "tryme"}, NbBundle.getMessage((Class)ModuleActions.class, (String)"ACTION_build_with_deps_tryme")));
            } else {
                actions.add(ModuleActions.createSimpleAction(project, new String[]{"run"}, NbBundle.getMessage((Class)ModuleActions.class, (String)"ACTION_run")));
            }
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"debug", (String)NbBundle.getMessage((Class)ModuleActions.class, (String)"ACTION_debug"), null));
            actions.add(null);
            boolean testactions = false;
            if (project.supportsUnitTests()) {
                actions.add(ProjectSensitiveActions.projectCommandAction((String)"test", (String)NbBundle.getMessage((Class)ModuleActions.class, (String)"ACTION_test"), null));
                if (ModuleActions.findTestBuildXml(project) != null) {
                    props = new Properties();
                    props.setProperty("xtest.testtype", "unit");
                    actions.add(ModuleActions.createTestAction(project, new String[]{"cleanresults", "runtests", "show-results-nb"}, props, NbBundle.getMessage((Class)ModuleActions.class, (String)"ACTION_xtest")));
                    actions.add(ModuleActions.createTestAction(project, new String[]{"cleanresults", "coverage", "show-coverage-results-nb"}, props, NbBundle.getMessage((Class)ModuleActions.class, (String)"ACTION_coverage")));
                }
                testactions = true;
            }
            if (project.getFunctionalTestSourceDirectory() != null) {
                props = new Properties();
                props.setProperty("xtest.testtype", "qa-functional");
                actions.add(ModuleActions.createTestAction(project, new String[]{"buildtests"}, props, NbBundle.getMessage((Class)ModuleActions.class, (String)"ACTION_build_func_tests")));
                props = new Properties();
                props.setProperty("xtest.testtype", "qa-functional");
                actions.add(ModuleActions.createTestAction(project, new String[]{"cleanresults", "runtests", "show-results-nb"}, props, NbBundle.getMessage((Class)ModuleActions.class, (String)"ACTION_xtest_functional")));
                testactions = true;
            }
            if (project.getPerformanceTestSourceDirectory() != null) {
                props = new Properties();
                props.setProperty("xtest.testtype", "qa-performance");
                actions.add(ModuleActions.createTestAction(project, new String[]{"buildtests"}, props, NbBundle.getMessage((Class)ModuleActions.class, (String)"ACTION_build_perf_tests")));
                props = new Properties();
                props.setProperty("xtest.testtype", "qa-performance");
                actions.add(ModuleActions.createTestAction(project, new String[]{"cleanresults", "runtests", "show-results-nb"}, props, NbBundle.getMessage((Class)ModuleActions.class, (String)"ACTION_xtest_perf")));
                testactions = true;
            }
            if (testactions) {
                actions.add(null);
            }
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"javadoc", (String)NbBundle.getMessage((Class)ModuleActions.class, (String)"ACTION_javadoc"), null));
            actions.add(ModuleActions.createArchAction(project));
            actions.add(null);
            if (isNetBeansOrg) {
                actions.add(ModuleActions.createCheckBundleAction(project, NbBundle.getMessage((Class)ModuleActions.class, (String)"ACTION_unused_bundle_keys")));
                actions.add(null);
            }
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)NbBundle.getMessage((Class)ModuleActions.class, (String)"ACTION_reload"), null));
            actions.add(ModuleActions.createReloadInIDEAction(project, new String[]{"reload-in-ide"}, NbBundle.getMessage((Class)ModuleActions.class, (String)"ACTION_reload_in_ide")));
            actions.add(ModuleActions.createSimpleAction(project, new String[]{"nbm"}, NbBundle.getMessage((Class)ModuleActions.class, (String)"ACTION_nbm")));
            actions.add(null);
            actions.add(CommonProjectActions.setAsMainProjectAction());
            actions.add(CommonProjectActions.openSubprojectsAction());
            actions.add(CommonProjectActions.closeProjectAction());
            actions.add(null);
            actions.add((Action)SystemAction.get((Class)FindAction.class));
            actions.add(null);
            actions.add(CommonProjectActions.renameProjectAction());
            actions.add(CommonProjectActions.moveProjectAction());
            actions.add(CommonProjectActions.copyProjectAction());
            actions.add(CommonProjectActions.deleteProjectAction());
            try {
                FileSystem sfs = Repository.getDefault().getDefaultFileSystem();
                FileObject fo = sfs.findResource("Projects/Actions");
                if (fo != null) {
                    DataObject dobj = DataObject.find((FileObject)fo);
                    FolderLookup actionRegistry = new FolderLookup((DataObject.Container)((DataFolder)dobj));
                    Lookup.Template query = new Lookup.Template(Object.class);
                    Lookup lookup = actionRegistry.getLookup();
                    Iterator it = lookup.lookup(query).allInstances().iterator();
                    if (it.hasNext()) {
                        actions.add(null);
                    }
                    while (it.hasNext()) {
                        Object next = it.next();
                        if (next instanceof Action) {
                            actions.add((Action)next);
                            continue;
                        }
                        if (!(next instanceof JSeparator)) continue;
                        actions.add(null);
                    }
                }
            }
            catch (DataObjectNotFoundException ex) {
                if ($assertionsDisabled) break block14;
                throw new AssertionError((Object)ex);
            }
        }
        actions.add(null);
        actions.add((Action)SystemAction.get((Class)ToolsAction.class));
        actions.add(null);
        actions.add(CommonProjectActions.customizeProjectAction());
        return actions.toArray(new Action[actions.size()]);
    }

    public ModuleActions(NbModuleProject project) {
        this.project = project;
        HashSet<Object> supportedActionsSet = new HashSet<Object>();
        this.globalCommands.put("build", new String[]{"netbeans"});
        this.globalCommands.put("clean", new String[]{"clean"});
        this.globalCommands.put("rebuild", new String[]{"clean", "netbeans"});
        this.globalCommands.put("debug", new String[]{"debug"});
        this.globalCommands.put("run", new String[]{"reload"});
        this.globalCommands.put("profile", new String[]{"profile"});
        this.globalCommands.put("javadoc", new String[]{"javadoc-nb"});
        if (project.supportsUnitTests()) {
            this.globalCommands.put("test", new String[]{"test"});
        }
        supportedActionsSet.addAll(this.globalCommands.keySet());
        supportedActionsSet.add("compile.single");
        supportedActionsSet.add("debug.fix");
        if (project.supportsUnitTests()) {
            supportedActionsSet.add("test.single");
            supportedActionsSet.add("debug.test.single");
            supportedActionsSet.add("run.single");
            supportedActionsSet.add("debug.single");
        }
        if (project.getFunctionalTestSourceDirectory() != null) {
            supportedActionsSet.add("run.single");
        }
        if (project.getPerformanceTestSourceDirectory() != null) {
            supportedActionsSet.add("run.single");
        }
        supportedActionsSet.add("rename");
        supportedActionsSet.add("move");
        supportedActionsSet.add("copy");
        supportedActionsSet.add("delete");
        this.supportedActions = supportedActionsSet.toArray(new String[supportedActionsSet.size()]);
    }

    public String[] getSupportedActions() {
        return this.supportedActions;
    }

    private static FileObject findBuildXml(NbModuleProject project) {
        return project.getProjectDirectory().getFileObject("build.xml");
    }

    private static FileObject findTestBuildXml(NbModuleProject project) {
        return project.getProjectDirectory().getFileObject("test/build.xml");
    }

    private static FileObject findMasterBuildXml(NbModuleProject project) {
        return project.getNbrootFileObject("nbbuild/build.xml");
    }

    public boolean isActionEnabled(String command, Lookup context) {
        if ("delete".equals(command) || "rename".equals(command) || "move".equals(command) || "copy".equals(command)) {
            return true;
        }
        if (command.equals("compile.single")) {
            return ModuleActions.findBuildXml(this.project) != null && (this.findSources(context) != null || this.findTestSources(context, false) != null);
        }
        if (command.equals("test.single")) {
            return ModuleActions.findBuildXml(this.project) != null && this.findTestSourcesForSources(context) != null;
        }
        if (command.equals("debug.test.single")) {
            FileObject[] files = this.findTestSourcesForSources(context);
            return ModuleActions.findBuildXml(this.project) != null && files != null && files.length == 1;
        }
        if (command.equals("run.single")) {
            FileObject[] files = this.findFunctionalTestSources(context);
            if (files != null && files.length == 1 && ModuleActions.findTestBuildXml(this.project) != null) {
                return true;
            }
            files = this.findPerformanceTestSources(context);
            if (files != null && files.length == 1 && ModuleActions.findTestBuildXml(this.project) != null) {
                return true;
            }
            files = this.findTestSources(context, false);
            return files != null;
        }
        if (command.equals("debug.single")) {
            FileObject[] files = this.findTestSources(context, false);
            return files != null && files.length == 1;
        }
        if (command.equals("debug.fix")) {
            FileObject[] files = this.findSources(context);
            if (files != null && files.length == 1 && ModuleActions.findBuildXml(this.project) != null) {
                return true;
            }
            files = this.findTestSources(context, false);
            return files != null && files.length == 1 && ModuleActions.findBuildXml(this.project) != null;
        }
        return ModuleActions.findBuildXml(this.project) != null;
    }

    private FileObject[] findSources(Lookup context) {
        FileObject srcDir = this.project.getSourceDirectory();
        if (srcDir != null) {
            FileObject[] files = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)srcDir, (String)".java", (boolean)true);
            return files;
        }
        return null;
    }

    private FileObject[] findTestSources(Lookup context, boolean checkInSrcDir) {
        FileObject[] files2;
        FileObject[] files;
        FileObject srcDir;
        FileObject[] files3;
        FileObject testSrcDir = this.project.getTestSourceDirectory();
        if (testSrcDir != null && (files3 = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)testSrcDir, (String)".java", (boolean)true)) != null) {
            return files3;
        }
        if (checkInSrcDir && testSrcDir != null && (srcDir = this.project.getSourceDirectory()) != null && (files = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)srcDir, (String)".java", (boolean)true)) != null && (files2 = ActionUtils.regexpMapFiles((FileObject[])files, (FileObject)srcDir, (Pattern)SRCDIRJAVA, (FileObject)testSrcDir, (String)SUBST, (boolean)true)) != null) {
            return files2;
        }
        return null;
    }

    private FileObject[] findTestSourcesForSources(Lookup context) {
        FileObject[] sourceFiles = this.findSources(context);
        if (sourceFiles == null) {
            return null;
        }
        FileObject testSrcDir = this.project.getTestSourceDirectory();
        FileObject srcDir = this.project.getSourceDirectory();
        return ActionUtils.regexpMapFiles((FileObject[])sourceFiles, (FileObject)srcDir, (Pattern)SRCDIRJAVA, (FileObject)testSrcDir, (String)SUBST, (boolean)true);
    }

    private FileObject[] findFunctionalTestSources(Lookup context) {
        FileObject srcDir = this.project.getFunctionalTestSourceDirectory();
        if (srcDir != null) {
            FileObject[] files = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)srcDir, (String)".java", (boolean)true);
            return files;
        }
        return null;
    }

    private FileObject[] findPerformanceTestSources(Lookup context) {
        FileObject srcDir = this.project.getPerformanceTestSourceDirectory();
        if (srcDir != null) {
            FileObject[] files = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)srcDir, (String)".java", (boolean)true);
            return files;
        }
        return null;
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        String[] targetNames;
        Properties p;
        FileObject[] files;
        if ("delete".equals(command)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("rename".equals(command)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
        if ("move".equals(command)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("copy".equals(command)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        FileObject buildScript = null;
        if (command.equals("compile.single")) {
            files = this.findSources(context);
            p = new Properties();
            if (files != null) {
                p.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)this.project.getSourceDirectory()));
                targetNames = new String[]{"compile-single"};
            } else {
                files = this.findTestSources(context, false);
                p.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)this.project.getTestSourceDirectory()));
                targetNames = new String[]{"compile-test-single"};
            }
        } else if (command.equals("test.single")) {
            p = new Properties();
            files = this.findTestSourcesForSources(context);
            targetNames = this.setupTestSingle(p, files);
        } else if (command.equals("debug.test.single")) {
            p = new Properties();
            files = this.findTestSourcesForSources(context);
            targetNames = this.setupDebugTestSingle(p, files);
        } else if (command.equals("run.single")) {
            files = this.findFunctionalTestSources(context);
            if (files != null) {
                String path = FileUtil.getRelativePath((FileObject)this.project.getFunctionalTestSourceDirectory(), (FileObject)files[0]);
                p = new Properties();
                p.setProperty("xtest.testtype", "qa-functional");
                p.setProperty("classname", path.substring(0, path.length() - 5).replace('/', '.'));
                targetNames = new String[]{"internal-execution"};
                buildScript = ModuleActions.findTestBuildXml(this.project);
            } else {
                files = this.findPerformanceTestSources(context);
                if (files != null) {
                    String path = FileUtil.getRelativePath((FileObject)this.project.getPerformanceTestSourceDirectory(), (FileObject)files[0]);
                    p = new Properties();
                    p.setProperty("xtest.testtype", "qa-performance");
                    p.setProperty("classname", path.substring(0, path.length() - 5).replace('/', '.'));
                    targetNames = new String[]{"internal-execution"};
                    buildScript = ModuleActions.findTestBuildXml(this.project);
                } else {
                    files = this.findTestSources(context, false);
                    p = new Properties();
                    targetNames = this.setupTestSingle(p, files);
                }
            }
        } else if (command.equals("debug.single")) {
            files = this.findTestSources(context, false);
            p = new Properties();
            targetNames = this.setupDebugTestSingle(p, files);
        } else if (command.equals("debug.fix")) {
            files = this.findSources(context);
            String path = null;
            if (files != null) {
                path = FileUtil.getRelativePath((FileObject)this.project.getSourceDirectory(), (FileObject)files[0]);
                if (!$assertionsDisabled && path == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !path.endsWith(".java")) {
                    throw new AssertionError();
                }
                targetNames = new String[]{"debug-fix-nb"};
            } else {
                files = this.findTestSources(context, false);
                path = FileUtil.getRelativePath((FileObject)this.project.getTestSourceDirectory(), (FileObject)files[0]);
                if (!$assertionsDisabled && path == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !path.endsWith(".java")) {
                    throw new AssertionError();
                }
                targetNames = new String[]{"debug-fix-test-nb"};
            }
            String clazzSlash = path.substring(0, path.length() - 5);
            p = new Properties();
            p.setProperty("fix.class", clazzSlash);
            buildScript = ModuleActions.findBuildXml(this.project);
        } else {
            if (command.equals("javadoc") && !this.project.supportsJavadoc()) {
                this.promptForPublicPackagesToDocument();
                return;
            }
            p = null;
            targetNames = (String[])this.globalCommands.get(command);
            if (targetNames == null) {
                throw new IllegalArgumentException(command);
            }
        }
        if (buildScript == null) {
            buildScript = ModuleActions.findBuildXml(this.project);
        }
        try {
            ActionUtils.runTarget((FileObject)buildScript, (String[])targetNames, (Properties)p);
        }
        catch (IOException e) {
            Util.err.notify((Throwable)e);
        }
    }

    private void promptForPublicPackagesToDocument() {
        if (UIUtil.showAcceptCancelDialog(NbBundle.getMessage((Class)ModuleActions.class, (String)"TITLE_javadoc_disabled"), NbBundle.getMessage((Class)ModuleActions.class, (String)"ERR_javadoc_disabled"), NbBundle.getMessage((Class)ModuleActions.class, (String)"LBL_configure_pubpkg"), null, 2)) {
            CustomizerProviderImpl cpi = (CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class);
            cpi.showCustomizer("Versioning", "publicPackages");
        }
    }

    private String[] setupTestSingle(Properties p, FileObject[] files) {
        p.setProperty("test.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)this.project.getTestSourceDirectory()));
        return new String[]{"test-single"};
    }

    private String[] setupDebugTestSingle(Properties p, FileObject[] files) {
        String path = FileUtil.getRelativePath((FileObject)this.project.getTestSourceDirectory(), (FileObject)files[0]);
        p.setProperty("test.class", path.substring(0, path.length() - 5).replace('/', '.'));
        return new String[]{"debug-test-single-nb"};
    }

    private static Action createSimpleAction(final NbModuleProject project, final String[] targetNames, String displayName) {
        return new AbstractAction(displayName){

            public boolean isEnabled() {
                return ModuleActions.findBuildXml(project) != null;
            }

            public void actionPerformed(ActionEvent ignore) {
                try {
                    ActionUtils.runTarget((FileObject)ModuleActions.findBuildXml(project), (String[])targetNames, null);
                }
                catch (IOException e) {
                    Util.err.notify((Throwable)e);
                }
            }
        };
    }

    private static Action createMasterAction(final NbModuleProject project, final String[] targetNames, String displayName) {
        return new AbstractAction(displayName){

            public boolean isEnabled() {
                return ModuleActions.findMasterBuildXml(project) != null;
            }

            public void actionPerformed(ActionEvent ignore) {
                try {
                    ActionUtils.runTarget((FileObject)ModuleActions.findMasterBuildXml(project), (String[])targetNames, null);
                }
                catch (IOException e) {
                    Util.err.notify((Throwable)e);
                }
            }
        };
    }

    private static Action createTestAction(final NbModuleProject project, final String[] targetNames, final Properties props, String displayName) {
        return new AbstractAction(displayName){

            public boolean isEnabled() {
                return ModuleActions.findTestBuildXml(project) != null;
            }

            public void actionPerformed(ActionEvent ignore) {
                try {
                    ActionUtils.runTarget((FileObject)ModuleActions.findTestBuildXml(project), (String[])targetNames, (Properties)props);
                }
                catch (IOException e) {
                    Util.err.notify((Throwable)e);
                }
            }
        };
    }

    private static Action createCheckBundleAction(final NbModuleProject project, String displayName) {
        return new AbstractAction(displayName){

            public boolean isEnabled() {
                return this.findMonitorXml() != null && project.getPathWithinNetBeansOrg() != null;
            }

            public void actionPerformed(ActionEvent ignore) {
                Properties props = new Properties();
                props.put("modules", project.getPathWithinNetBeansOrg());
                props.put("fixedmodules", "");
                try {
                    ActionUtils.runTarget((FileObject)this.findMonitorXml(), (String[])new String[]{"check-bundle-usage"}, (Properties)props);
                }
                catch (IOException e) {
                    Util.err.notify((Throwable)e);
                }
            }

            private FileObject findMonitorXml() {
                return project.getNbrootFileObject("nbbuild/monitor.xml");
            }
        };
    }

    private static Action createReloadInIDEAction(final NbModuleProject project, final String[] targetNames, String displayName) {
        return new AbstractAction(displayName){
            static final /* synthetic */ boolean $assertionsDisabled;

            public boolean isEnabled() {
                if (ModuleActions.findBuildXml(project) == null) {
                    return false;
                }
                NbModuleTypeProvider.NbModuleType type = Util.getModuleType(project);
                if (type == NbModuleTypeProvider.NETBEANS_ORG) {
                    return true;
                }
                if (type == NbModuleTypeProvider.STANDALONE) {
                    NbPlatform p = project.getPlatform(false);
                    return p != null && p.isDefault();
                }
                if (!$assertionsDisabled && type != NbModuleTypeProvider.SUITE_COMPONENT) {
                    throw new AssertionError(type);
                }
                try {
                    SuiteProject suite = SuiteUtils.findSuite(project);
                    if (suite == null) {
                        return false;
                    }
                    NbPlatform p = suite.getPlatform(false);
                    if (p == null || !p.isDefault()) {
                        return false;
                    }
                    return SuiteProperties.getArrayProperty(suite.getEvaluator(), "enabled.clusters").length == 0 && SuiteProperties.getArrayProperty(suite.getEvaluator(), "disabled.clusters").length == 0 && SuiteProperties.getArrayProperty(suite.getEvaluator(), "disabled.modules").length == 0;
                }
                catch (IOException e) {
                    Util.err.notify(1, (Throwable)e);
                    return false;
                }
            }

            public void actionPerformed(ActionEvent ignore) {
                if (ModuleUISettings.getDefault().getConfirmReloadInIDE()) {
                    NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$ModuleActions == null ? (class$org$netbeans$modules$apisupport$project$ui$ModuleActions = ModuleActions.class$("org.netbeans.modules.apisupport.project.ui.ModuleActions")) : class$org$netbeans$modules$apisupport$project$ui$ModuleActions), (String)"LBL_reload_in_ide_confirm"), NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$ModuleActions == null ? (class$org$netbeans$modules$apisupport$project$ui$ModuleActions = ModuleActions.class$("org.netbeans.modules.apisupport.project.ui.ModuleActions")) : class$org$netbeans$modules$apisupport$project$ui$ModuleActions), (String)"LBL_reload_in_ide_confirm_title"), 2);
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) != NotifyDescriptor.OK_OPTION) {
                        return;
                    }
                    ModuleUISettings.getDefault().setConfirmReloadInIDE(false);
                }
                try {
                    ActionUtils.runTarget((FileObject)ModuleActions.findBuildXml(project), (String[])targetNames, null);
                }
                catch (IOException e) {
                    Util.err.notify((Throwable)e);
                }
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$apisupport$project$ui$ModuleActions == null ? (class$org$netbeans$modules$apisupport$project$ui$ModuleActions = ModuleActions.class$("org.netbeans.modules.apisupport.project.ui.ModuleActions")) : class$org$netbeans$modules$apisupport$project$ui$ModuleActions).desiredAssertionStatus();
            }
        };
    }

    private static Action createArchAction(final NbModuleProject project) {
        return new AbstractAction(NbBundle.getMessage((Class)ModuleActions.class, (String)"ACTION_arch")){

            public boolean isEnabled() {
                return ModuleActions.findBuildXml(project) != null;
            }

            public void actionPerformed(ActionEvent ignore) {
                ProjectManager.mutex().writeAccess(new Mutex.Action(){

                    public Object run() {
                        String prop = "javadoc.arch";
                        if (project.evaluator().getProperty(prop) == null) {
                            EditableProperties props = project.getHelper().getProperties("nbproject/project.properties");
                            props.setProperty(prop, "${basedir}/arch.xml");
                            project.getHelper().putProperties("nbproject/project.properties", props);
                            try {
                                ProjectManager.getDefault().saveProject((Project)project);
                            }
                            catch (IOException e) {
                                Util.err.notify((Throwable)e);
                            }
                        }
                        return null;
                    }
                });
                try {
                    ActionUtils.runTarget((FileObject)ModuleActions.findBuildXml(project), (String[])new String[]{"arch-nb"}, null);
                }
                catch (IOException e) {
                    Util.err.notify((Throwable)e);
                }
            }
        };
    }

    static {
        $assertionsDisabled = !ModuleActions.class.desiredAssertionStatus();
        SRCDIRJAVA = Pattern.compile("\\.java$");
    }
}

