/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.options.NewOptionsIterator;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class OptionsPanel
extends BasicWizardIterator.Panel {
    private final NewOptionsIterator.DataModel data;
    private DocumentListener updateListener;
    private JLabel createdFiles;
    private JTextArea createdFilesValue;
    private JScrollPane createdFilesValueS;
    private JLabel lblPrefix;
    private JLabel modifiedFiles;
    private JTextArea modifiedFilesValue;
    private JScrollPane modifiedFilesValueS;
    private JComboBox packageName;
    private JLabel packageNameTxt;
    private JLabel projectName;
    private JTextField projectNameValue;
    private JTextField txtPrefix;

    public OptionsPanel(WizardDescriptor setting, NewOptionsIterator.DataModel data) {
        super(setting);
        this.data = data;
        this.initComponents();
        this.initAccessibility();
        if (data.getPackageName() != null) {
            this.packageName.setSelectedItem(data.getPackageName());
        }
        this.putClientProperty("NewFileWizard_Title", OptionsPanel.getMessage("LBL_OptionsWizardTitle"));
    }

    private void addListeners() {
        if (this.updateListener == null) {
            this.updateListener = new UIUtil.DocumentAdapter(){

                public void insertUpdate(DocumentEvent e) {
                    OptionsPanel.this.updateData();
                }
            };
            this.txtPrefix.getDocument().addDocumentListener(this.updateListener);
            Component editorComp = this.packageName.getEditor().getEditorComponent();
            if (editorComp instanceof JTextComponent) {
                ((JTextComponent)editorComp).getDocument().addDocumentListener(this.updateListener);
            }
        }
    }

    private void removeListeners() {
        if (this.updateListener != null) {
            this.txtPrefix.getDocument().removeDocumentListener(this.updateListener);
            Component editorComp = this.packageName.getEditor().getEditorComponent();
            if (editorComp instanceof JTextComponent) {
                ((JTextComponent)editorComp).getDocument().removeDocumentListener(this.updateListener);
            }
            this.updateListener = null;
        }
    }

    protected void storeToDataModel() {
        this.removeListeners();
        this.updateData();
    }

    protected void readFromDataModel() {
        this.addListeners();
        this.txtPrefix.setText(this.data.getClassNamePrefix());
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeListeners();
    }

    public void addNotify() {
        super.addNotify();
        this.addListeners();
        this.updateData();
    }

    private void updateData() {
        int errCode = this.data.setPackageAndPrefix(this.packageName.getEditor().getItem().toString(), this.txtPrefix.getText());
        this.data.getCreatedModifiedFiles();
        this.createdFilesValue.setText(UIUtil.generateTextAreaContent(this.data.getCreatedModifiedFiles().getCreatedPaths()));
        this.modifiedFilesValue.setText(UIUtil.generateTextAreaContent(this.data.getCreatedModifiedFiles().getModifiedPaths()));
        String[] invalid = this.data.getCreatedModifiedFiles().getInvalidPaths();
        if (NewOptionsIterator.DataModel.isErrorCode(errCode)) {
            this.setError(this.data.getErrorMessage(errCode));
        } else if (invalid.length > 0) {
            this.setError(NbBundle.getMessage((Class)OptionsPanel.class, (String)"ERR_ToBeCreateFileExists", (Object)invalid[0]));
        } else if (NewOptionsIterator.DataModel.isSuccessCode(errCode)) {
            this.markValid();
        }
    }

    protected String getPanelName() {
        return OptionsPanel.getMessage("LBL_OptionsPanel1_Title");
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(OptionsPanel.class);
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage((Class)OptionsPanel.class, (String)key);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(OptionsPanel.getMessage("ACS_OptionsPanel"));
        this.projectNameValue.getAccessibleContext().setAccessibleDescription(OptionsPanel.getMessage("ACS_CTL_ProjectName"));
        this.packageName.getAccessibleContext().setAccessibleDescription(OptionsPanel.getMessage("ACS_CTL_PackageName"));
        this.createdFilesValue.getAccessibleContext().setAccessibleDescription(OptionsPanel.getMessage("ACS_CTL_CreatedFilesValue"));
        this.modifiedFilesValue.getAccessibleContext().setAccessibleDescription(OptionsPanel.getMessage("ACS_CTL_ModifiedFilesValue"));
        this.txtPrefix.getAccessibleContext().setAccessibleDescription(OptionsPanel.getMessage("ACS_CTL__ClassNamePrefix"));
    }

    private void initComponents() {
        this.projectName = new JLabel();
        this.projectNameValue = new JTextField(ProjectUtils.getInformation((Project)this.data.getProject()).getDisplayName());
        this.createdFiles = new JLabel();
        this.modifiedFiles = new JLabel();
        this.createdFilesValueS = new JScrollPane();
        this.createdFilesValue = new JTextArea();
        this.modifiedFilesValueS = new JScrollPane();
        this.modifiedFilesValue = new JTextArea();
        this.packageName = UIUtil.createPackageComboBox(this.data.getSourceRootGroup());
        this.packageNameTxt = new JLabel();
        this.lblPrefix = new JLabel();
        this.txtPrefix = new JTextField();
        this.setLayout(new GridBagLayout());
        this.projectName.setLabelFor(this.projectNameValue);
        Mnemonics.setLocalizedText((JLabel)this.projectName, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/options/Bundle").getString("LBL_ProjectName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 0, 6, 12);
        this.add((Component)this.projectName, gridBagConstraints);
        this.projectNameValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.projectNameValue, gridBagConstraints);
        this.createdFiles.setLabelFor(this.createdFilesValue);
        Mnemonics.setLocalizedText((JLabel)this.createdFiles, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/options/Bundle").getString("LBL_CreatedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(18, 0, 6, 12);
        this.add((Component)this.createdFiles, gridBagConstraints);
        this.modifiedFiles.setLabelFor(this.modifiedFilesValue);
        Mnemonics.setLocalizedText((JLabel)this.modifiedFiles, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/options/Bundle").getString("LBL_ModifiedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.modifiedFiles, gridBagConstraints);
        this.createdFilesValue.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.createdFilesValue.setColumns(20);
        this.createdFilesValue.setEditable(false);
        this.createdFilesValue.setRows(5);
        this.createdFilesValue.setBorder(null);
        this.createdFilesValueS.setViewportView(this.createdFilesValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(18, 0, 6, 0);
        this.add((Component)this.createdFilesValueS, gridBagConstraints);
        this.modifiedFilesValue.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.modifiedFilesValue.setColumns(20);
        this.modifiedFilesValue.setEditable(false);
        this.modifiedFilesValue.setRows(5);
        this.modifiedFilesValue.setToolTipText("modifiedFilesValue");
        this.modifiedFilesValue.setBorder(null);
        this.modifiedFilesValueS.setViewportView(this.modifiedFilesValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.modifiedFilesValueS, gridBagConstraints);
        this.packageName.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.packageName, gridBagConstraints);
        this.packageNameTxt.setLabelFor(this.packageName);
        Mnemonics.setLocalizedText((JLabel)this.packageNameTxt, (String)NbBundle.getMessage((Class)OptionsPanel.class, (String)"LBL_PackageName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.packageNameTxt, gridBagConstraints);
        this.lblPrefix.setLabelFor(this.txtPrefix);
        Mnemonics.setLocalizedText((JLabel)this.lblPrefix, (String)NbBundle.getMessage((Class)OptionsPanel.class, (String)"LBL_Prefix"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 0, 6, 12);
        this.add((Component)this.lblPrefix, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 6, 0);
        this.add((Component)this.txtPrefix, gridBagConstraints);
    }
}

