/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.Frame;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ui.KeyboardPopupSwitcher;
import org.netbeans.swing.popupswitcher.SwitcherTableItem;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class RecentViewListAction
extends AbstractAction
implements PropertyChangeListener {
    public RecentViewListAction() {
        this.putValue("Name", NbBundle.getMessage((Class)RecentViewListAction.class, (String)"CTL_RecentViewListAction"));
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
        this.updateEnabled();
    }

    public void actionPerformed(ActionEvent evt) {
        KeyStroke keyStroke;
        TopComponent[] documents = this.getRecentDocuments();
        if (documents.length < 2) {
            return;
        }
        if (!"immediately".equals(evt.getActionCommand()) && !(evt.getSource() instanceof JMenuItem) && (keyStroke = Utilities.stringToKey((String)evt.getActionCommand())) != null) {
            int triggerKey = keyStroke.getKeyCode();
            int reverseKey = 16;
            int releaseKey = 0;
            int modifiers = keyStroke.getModifiers();
            if ((2 & modifiers) != 0) {
                releaseKey = 17;
            } else if ((8 & modifiers) != 0) {
                releaseKey = 18;
            } else if ((4 & modifiers) != 0) {
                releaseKey = 4;
            }
            if (releaseKey != 0) {
                if (!KeyboardPopupSwitcher.isShown()) {
                    Frame owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() instanceof Frame ? (Frame)KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() : WindowManager.getDefault().getMainWindow();
                    KeyboardPopupSwitcher.selectItem(this.createSwitcherItems(documents), releaseKey, triggerKey);
                }
                return;
            }
        }
        TopComponent tc = documents[1];
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        ModeImpl mode = (ModeImpl)wm.findMode(tc);
        if (mode != null && mode != wm.getMaximizedMode()) {
            wm.setMaximizedMode(null);
        }
        tc.requestActive();
    }

    private SwitcherTableItem[] createSwitcherItems(TopComponent[] tcs) {
        SwitcherTableItem[] items = new SwitcherTableItem[tcs.length];
        for (int i = 0; i < tcs.length; ++i) {
            String htmlName;
            TopComponent tc = tcs[i];
            String name = tc.getDisplayName();
            if (name == null || name.trim().length() == 0) {
                name = tc.getName();
            }
            if ((htmlName = tc.getHtmlDisplayName()) == null) {
                htmlName = name;
            }
            Image image = tc.getIcon();
            String description = tc.getToolTipText();
            ImageIcon imageIcon = image != null ? new ImageIcon(image) : null;
            items[i] = new SwitcherTableItem((SwitcherTableItem.Activatable)new ActivatableTC(tc), name, htmlName, (Icon)imageIcon, false, description != null ? description : name);
        }
        return items;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("opened".equals(evt.getPropertyName())) {
            this.updateEnabled();
        }
    }

    public static String getStringRep4Unixes() {
        if (Utilities.isUnix()) {
            return "Actions/Window/org-netbeans-core-windows-actions-RecentViewListAction.instance";
        }
        return null;
    }

    private void updateEnabled() {
        this.setEnabled(this.isMoreThanOneDocOpened());
    }

    private boolean isMoreThanOneDocOpened() {
        Iterator it = WindowManagerImpl.getInstance().getModes().iterator();
        while (it.hasNext()) {
            ModeImpl mode = (ModeImpl)it.next();
            if (mode.getKind() != 1) continue;
            return mode.getOpenedTopComponents().size() > 1;
        }
        return false;
    }

    private TopComponent[] getRecentDocuments() {
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        TopComponent[] documents = wm.getRecentViewList();
        ArrayList<TopComponent> docsList = new ArrayList<TopComponent>();
        for (int i = 0; i < documents.length; ++i) {
            ModeImpl mode;
            TopComponent tc = documents[i];
            if (tc == null || (mode = (ModeImpl)wm.findMode(tc)) == null || mode.getKind() != 1) continue;
            docsList.add(tc);
        }
        return docsList.toArray(new TopComponent[0]);
    }

    private class ActivatableTC
    implements SwitcherTableItem.Activatable {
        private TopComponent tc;

        private ActivatableTC(TopComponent tc) {
            this.tc = tc;
        }

        public void activate() {
            if (this.tc != null) {
                this.tc.requestActive();
            }
        }
    }
}

