/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.model.TopComponentGroupModel;
import org.openide.windows.TopComponent;

final class DefaultTopComponentGroupModel
implements TopComponentGroupModel {
    private final String name;
    private boolean opened;
    private final Set topComponents = new HashSet(3);
    private final Set openedTopComponents = new HashSet(3);
    private final Set openedBeforeTopComponents = new HashSet(3);
    private final Set openingTopComponents = new HashSet(3);
    private final Set closingTopComponents = new HashSet(3);
    private final Object LOCK_OPENED = new Object();
    private final Object LOCK_TOPCOMPONENTS = new Object();

    public DefaultTopComponentGroupModel(String name, boolean opened) {
        this.name = name;
        this.opened = opened;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(Collection openedTopComponents, Collection openedBeforeTopComponents) {
        Object object = this.LOCK_OPENED;
        synchronized (object) {
            String tcID;
            this.opened = true;
            this.openedTopComponents.clear();
            Iterator it = openedTopComponents.iterator();
            while (it.hasNext()) {
                tcID = DefaultTopComponentGroupModel.getID((TopComponent)it.next());
                if (tcID == null) continue;
                this.openedTopComponents.add(tcID);
            }
            this.openedBeforeTopComponents.clear();
            it = openedBeforeTopComponents.iterator();
            while (it.hasNext()) {
                tcID = DefaultTopComponentGroupModel.getID((TopComponent)it.next());
                if (tcID == null) continue;
                this.openedBeforeTopComponents.add(tcID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.LOCK_OPENED;
        synchronized (object) {
            this.opened = false;
            this.openedTopComponents.clear();
            this.openedBeforeTopComponents.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpened() {
        Object object = this.LOCK_OPENED;
        synchronized (object) {
            return this.opened;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getTopComponents() {
        HashSet s;
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            s = new HashSet(this.topComponents);
        }
        HashSet<TopComponent> result = new HashSet<TopComponent>(s.size());
        Iterator it = s.iterator();
        while (it.hasNext()) {
            TopComponent tc = DefaultTopComponentGroupModel.getTopComponent((String)it.next());
            if (tc == null) continue;
            result.add(tc);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getOpenedTopComponents() {
        HashSet s;
        Object object = this.LOCK_OPENED;
        synchronized (object) {
            s = new HashSet(this.openedTopComponents);
        }
        HashSet<TopComponent> result = new HashSet<TopComponent>(s.size());
        Iterator it = s.iterator();
        while (it.hasNext()) {
            TopComponent tc = DefaultTopComponentGroupModel.getTopComponent((String)it.next());
            if (tc == null) continue;
            result.add(tc);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getOpenedBeforeTopComponents() {
        HashSet s;
        Object object = this.LOCK_OPENED;
        synchronized (object) {
            s = new HashSet(this.openedBeforeTopComponents);
        }
        HashSet<TopComponent> result = new HashSet<TopComponent>(s.size());
        Iterator it = s.iterator();
        while (it.hasNext()) {
            TopComponent tc = DefaultTopComponentGroupModel.getTopComponent((String)it.next());
            if (tc == null) continue;
            result.add(tc);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getOpeningTopComponents() {
        HashSet s;
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            s = new HashSet(this.openingTopComponents);
        }
        HashSet<TopComponent> result = new HashSet<TopComponent>(s.size());
        Iterator it = s.iterator();
        while (it.hasNext()) {
            TopComponent tc = DefaultTopComponentGroupModel.getTopComponent((String)it.next());
            if (tc == null) continue;
            result.add(tc);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getClosingTopComponents() {
        HashSet s;
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            s = new HashSet(this.closingTopComponents);
        }
        HashSet<TopComponent> result = new HashSet<TopComponent>(s.size());
        Iterator it = s.iterator();
        while (it.hasNext()) {
            TopComponent tc = DefaultTopComponentGroupModel.getTopComponent((String)it.next());
            if (tc == null) continue;
            result.add(tc);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUnloadedTopComponent(String tcID) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return this.topComponents.add(tcID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUnloadedTopComponent(String tcID) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            if (this.openingTopComponents.contains(tcID)) {
                this.openingTopComponents.remove(tcID);
            }
            if (this.closingTopComponents.contains(tcID)) {
                this.closingTopComponents.remove(tcID);
            }
            return this.topComponents.remove(tcID);
        }
    }

    public boolean addOpeningTopComponent(TopComponent tc) {
        return this.addUnloadedOpeningTopComponent(DefaultTopComponentGroupModel.getID(tc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUnloadedOpeningTopComponent(String tcID) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            if (!this.topComponents.contains(tcID)) {
                this.topComponents.add(tcID);
            }
            return this.openingTopComponents.add(tcID);
        }
    }

    public boolean removeOpeningTopComponent(TopComponent tc) {
        return this.removeUnloadedOpeningTopComponent(DefaultTopComponentGroupModel.getID(tc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUnloadedOpeningTopComponent(String tcID) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return this.openingTopComponents.remove(tcID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUnloadedClosingTopComponent(String tcID) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            if (!this.topComponents.contains(tcID)) {
                this.topComponents.add(tcID);
            }
            return this.closingTopComponents.add(tcID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUnloadedClosingTopComponent(String tcID) {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return this.closingTopComponents.remove(tcID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUnloadedOpenedTopComponent(String tcID) {
        Object object = this.LOCK_OPENED;
        synchronized (object) {
            if (!this.opened) {
                return false;
            }
            this.openedTopComponents.add(tcID);
        }
        return true;
    }

    private static TopComponent getTopComponent(String tcID) {
        return WindowManagerImpl.getInstance().getTopComponentForID(tcID);
    }

    private static String getID(TopComponent tc) {
        return WindowManagerImpl.getInstance().findTopComponentID(tc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getTopComponentsIDs() {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return new HashSet(this.topComponents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getOpeningSetIDs() {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return new HashSet(this.openingTopComponents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getClosingSetIDs() {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return new HashSet(this.closingTopComponents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getOpenedTopComponentsIDs() {
        Object object = this.LOCK_TOPCOMPONENTS;
        synchronized (object) {
            return new HashSet(this.openedTopComponents);
        }
    }
}

