/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.dnd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.DropTarget;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.Controller;
import org.netbeans.core.windows.view.EditorView;
import org.netbeans.core.windows.view.ModeView;
import org.netbeans.core.windows.view.ViewElement;
import org.netbeans.core.windows.view.dnd.DropTargetGlassPane;
import org.netbeans.core.windows.view.dnd.EnhancedDragPainter;
import org.netbeans.core.windows.view.dnd.TopComponentDragSupport;
import org.netbeans.core.windows.view.dnd.TopComponentDroppable;
import org.netbeans.core.windows.view.ui.MainWindow;
import org.netbeans.core.windows.view.ui.ModeComponent;
import org.openide.ErrorManager;
import org.openide.util.WeakSet;
import org.openide.windows.TopComponent;

public final class WindowDnDManager
implements DropTargetGlassPane.Observer,
DropTargetGlassPane.Informer {
    private final TopComponentDragSupport topComponentDragSupport = new TopComponentDragSupport(this);
    private DragSource windowDragSource;
    private boolean dragging;
    private boolean dropSuccess;
    private final Map root2glass = new HashMap();
    private final Set floatingFrames = new WeakSet(4);
    private Reference lastTargetWRef = new WeakReference<Object>(null);
    private final ViewAccessor viewAccessor;
    private TopComponentDroppable startingDroppable;
    private Point startingPoint;
    private TopComponent startingTransfer;
    private static WeakReference centerDropWRef = new WeakReference<Object>(null);
    private static final boolean DEBUG = Debug.isLoggable(WindowDnDManager.class);
    private CenterSlidingDroppable lastSlideDroppable;
    static /* synthetic */ Class class$javax$swing$RootPaneContainer;

    public WindowDnDManager(ViewAccessor viewAccessor) {
        this.viewAccessor = viewAccessor;
        Toolkit.getDefaultToolkit().addAWTEventListener(this.topComponentDragSupport, 48L);
    }

    public static boolean isDnDEnabled() {
        return !Constants.SWITCH_DND_DISABLE;
    }

    public synchronized DragSource getWindowDragSource() {
        if (this.windowDragSource == null) {
            this.windowDragSource = new DragSource();
            this.windowDragSource.addDragSourceMotionListener(new MotionListener(this, this.topComponentDragSupport));
        }
        return this.windowDragSource;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDropSuccess(boolean dropSuccess) {
        this.dropSuccess = dropSuccess;
    }

    public boolean isDropSuccess() {
        return this.dropSuccess;
    }

    public void setLastDropTarget(DropTargetGlassPane target) {
        if (target != this.lastTargetWRef.get()) {
            this.lastTargetWRef = new WeakReference<DropTargetGlassPane>(target);
        }
    }

    public void resetDragSource() {
        this.dragFinished();
    }

    public TopComponentDroppable getStartingDroppable() {
        return this.startingDroppable;
    }

    public Point getStartingPoint() {
        return this.startingPoint;
    }

    public TopComponent getStartingTransfer() {
        return this.startingTransfer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dragStarting(TopComponentDroppable startingDroppable, Point startingPoint, TopComponent startingTransfer) {
        Object object;
        if (DEBUG) {
            WindowDnDManager.debugLog("");
            WindowDnDManager.debugLog("dragStarting");
        }
        this.startingDroppable = startingDroppable;
        this.startingPoint = startingPoint;
        this.startingTransfer = startingTransfer;
        HashMap<JRootPane, Component> addedRoots = new HashMap<JRootPane, Component>();
        HashSet<Frame> addedFrames = new HashSet<Frame>();
        Iterator it = this.viewAccessor.getModeComponents().iterator();
        while (it.hasNext()) {
            Component originalGlass;
            Component comp = (Component)it.next();
            if (!(comp instanceof TopComponentDroppable)) continue;
            JRootPane root = null;
            if (comp instanceof RootPaneContainer) {
                root = ((RootPaneContainer)((Object)comp)).getRootPane();
            } else {
                RootPaneContainer rootContainer = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(class$javax$swing$RootPaneContainer == null ? WindowDnDManager.class$("javax.swing.RootPaneContainer") : class$javax$swing$RootPaneContainer, comp));
                if (rootContainer != null) {
                    root = rootContainer.getRootPane();
                }
            }
            if (root == null || (originalGlass = WindowDnDManager.setDropTargetGlassPane(root, this)) == null) continue;
            addedRoots.put(root, originalGlass);
        }
        it = this.viewAccessor.getSeparateModeFrames().iterator();
        while (it.hasNext()) {
            Frame frame = (Frame)it.next();
            if (frame == null) continue;
            addedFrames.add(frame);
        }
        if (!addedRoots.isEmpty()) {
            object = this.root2glass;
            synchronized (object) {
                this.root2glass.putAll(addedRoots);
            }
        }
        if (!addedFrames.isEmpty()) {
            object = this.floatingFrames;
            synchronized (object) {
                this.floatingFrames.addAll(addedFrames);
            }
        }
        this.dragging = true;
        this.dropSuccess = false;
    }

    private static Component setDropTargetGlassPane(JRootPane rootPane, WindowDnDManager windowDnDManager) {
        Component glassPane = rootPane.getGlassPane();
        if (glassPane instanceof DropTargetGlassPane) {
            return null;
        }
        DropTargetGlassPane dropGlass = new DropTargetGlassPane(windowDnDManager);
        new DropTarget(dropGlass, 3, dropGlass);
        rootPane.setGlassPane(dropGlass);
        dropGlass.initialize();
        return glassPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dragFinished() {
        HashMap removedRoots;
        if (DEBUG) {
            WindowDnDManager.debugLog("");
            WindowDnDManager.debugLog("dragFinished");
        }
        this.startingDroppable = null;
        this.startingPoint = null;
        this.startingTransfer = null;
        this.topComponentDragSupport.dragFinished();
        this.dragging = false;
        Map map = this.root2glass;
        synchronized (map) {
            removedRoots = new HashMap(this.root2glass);
            this.root2glass.clear();
        }
        Iterator it = removedRoots.keySet().iterator();
        while (it.hasNext()) {
            JRootPane root = (JRootPane)it.next();
            WindowDnDManager.setOriginalGlassPane(root, (Component)removedRoots.get(root));
        }
    }

    private static void setOriginalGlassPane(JRootPane rootPane, Component originalGlass) {
        JInternalFrame internalFrame;
        Component glass = rootPane.getGlassPane();
        if (glass instanceof DropTargetGlassPane) {
            DropTargetGlassPane dropGlass = (DropTargetGlassPane)glass;
            dropGlass.setDropTarget(null);
            dropGlass.uninitialize();
        }
        if (originalGlass != null) {
            rootPane.setGlassPane(originalGlass);
        }
        if ((internalFrame = (JInternalFrame)SwingUtilities.getAncestorOfClass(JInternalFrame.class, originalGlass)) != null && !internalFrame.isSelected() && !originalGlass.isVisible()) {
            originalGlass.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dragFinishedEx() {
        Set set = this.floatingFrames;
        synchronized (set) {
            this.floatingFrames.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getFloatingFrames() {
        Set set = this.floatingFrames;
        synchronized (set) {
            return new HashSet(this.floatingFrames);
        }
    }

    public boolean isInFloatingFrame(Point location) {
        Iterator it = this.getFloatingFrames().iterator();
        while (it.hasNext()) {
            Frame frame = (Frame)it.next();
            if (!frame.getBounds().contains(location)) continue;
            return true;
        }
        return false;
    }

    public boolean isCopyOperationPossible() {
        return this.topComponentDragSupport.isCopyOperationPossible();
    }

    public Controller getController() {
        return this.viewAccessor.getController();
    }

    private static void debugLog(String message) {
        Debug.log(WindowDnDManager.class, message);
    }

    static boolean isInMainWindow(Point location) {
        return WindowManagerImpl.getInstance().getMainWindow().getBounds().contains(location);
    }

    private boolean isInMainWindowDroppable(Point location, int kind, TopComponent transfer) {
        return this.findMainWindowDroppable(location, kind, transfer) != null;
    }

    private static boolean isInFloatingFrameDroppable(Set floatingFrames, Point location, int kind, TopComponent transfer) {
        return WindowDnDManager.findFloatingFrameDroppable(floatingFrames, location, kind, transfer) != null;
    }

    private static boolean isInFreeArea(Point location) {
        Frame[] frames = Frame.getFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isVisible() || !frames[i].getBounds().contains(location.x, location.y)) continue;
            return false;
        }
        return true;
    }

    private TopComponentDroppable findDroppableFromScreen(Set floatingFrames, Point location, int kind, TopComponent transfer) {
        TopComponentDroppable droppable = this.findMainWindowDroppable(location, kind, transfer);
        if (droppable != null) {
            return droppable;
        }
        droppable = WindowDnDManager.findFloatingFrameDroppable(floatingFrames, location, kind, transfer);
        if (droppable != null) {
            return droppable;
        }
        if (WindowDnDManager.isInFreeArea(location)) {
            return WindowDnDManager.getFreeAreaDroppable(location);
        }
        return null;
    }

    private TopComponentDroppable findMainWindowDroppable(Point location, int kind, TopComponent transfer) {
        CenterSlidingDroppable drop;
        MainWindow mainWindow = (MainWindow)WindowManagerImpl.getInstance().getMainWindow();
        Point p = new Point(location);
        SwingUtilities.convertPointFromScreen(p, mainWindow.getContentPane());
        if (this.lastSlideDroppable != null && this.lastSlideDroppable.isWithinSlide(p)) {
            return this.lastSlideDroppable;
        }
        TopComponentDroppable droppable = WindowDnDManager.findSlideDroppable(this.viewAccessor.getSlidingModeComponent("left"));
        if (droppable != null && (drop = new CenterSlidingDroppable(this.viewAccessor, droppable, "left")).isWithinSlide(p)) {
            this.lastSlideDroppable = drop;
            return drop;
        }
        droppable = WindowDnDManager.findSlideDroppable(this.viewAccessor.getSlidingModeComponent("right"));
        if (droppable != null && (drop = new CenterSlidingDroppable(this.viewAccessor, droppable, "right")).isWithinSlide(p)) {
            this.lastSlideDroppable = drop;
            return drop;
        }
        droppable = WindowDnDManager.findSlideDroppable(this.viewAccessor.getSlidingModeComponent("bottom"));
        if (droppable != null && (drop = new CenterSlidingDroppable(this.viewAccessor, droppable, "bottom")).isWithinSlide(p)) {
            this.lastSlideDroppable = drop;
            return drop;
        }
        this.lastSlideDroppable = null;
        if (WindowDnDManager.isNearEdge(location, this.viewAccessor)) {
            return this.getCenterPanelDroppable();
        }
        Point mainP = new Point(location);
        SwingUtilities.convertPointFromScreen(mainP, mainWindow);
        return WindowDnDManager.findDroppable(mainWindow, mainP, kind, transfer);
    }

    private static TopComponentDroppable findSlideDroppable(Component comp) {
        TopComponentDroppable droppable = null;
        droppable = comp instanceof TopComponentDroppable ? (TopComponentDroppable)((Object)comp) : (TopComponentDroppable)((Object)SwingUtilities.getAncestorOfClass(TopComponentDroppable.class, comp));
        return droppable;
    }

    private static TopComponentDroppable findFloatingFrameDroppable(Set floatingFrames, Point location, int kind, TopComponent transfer) {
        Iterator it = floatingFrames.iterator();
        while (it.hasNext()) {
            TopComponentDroppable droppable;
            Component comp = (Component)it.next();
            Rectangle bounds = comp.getBounds();
            if (!bounds.contains(location) || (droppable = WindowDnDManager.findDroppable(comp, new Point(location.x - bounds.x, location.y - bounds.y), kind, transfer)) == null) continue;
            return droppable;
        }
        return null;
    }

    private static TopComponentDroppable findDroppable(Component comp, Point location, int kind, TopComponent transfer) {
        TopComponentDroppable droppable;
        JFrame frame;
        if (comp instanceof JFrame) {
            frame = (JFrame)comp;
        } else {
            Window w = SwingUtilities.getWindowAncestor(comp);
            if (w instanceof JFrame) {
                frame = (JFrame)w;
            } else {
                return null;
            }
        }
        Container contentPane = frame.getContentPane();
        location = SwingUtilities.convertPoint(comp, location, contentPane);
        Component deepest = SwingUtilities.getDeepestComponentAt(contentPane, location.x, location.y);
        if (deepest instanceof TopComponentDroppable && (droppable = (TopComponentDroppable)((Object)deepest)).supportsKind(kind, transfer)) {
            return droppable;
        }
        while (deepest != null) {
            TopComponentDroppable nextDroppable = (TopComponentDroppable)((Object)SwingUtilities.getAncestorOfClass(class$org$netbeans$core$windows$view$dnd$TopComponentDroppable == null ? WindowDnDManager.class$("org.netbeans.core.windows.view.dnd.TopComponentDroppable") : class$org$netbeans$core$windows$view$dnd$TopComponentDroppable, deepest));
            if (nextDroppable != null && nextDroppable.supportsKind(kind, transfer)) {
                return nextDroppable;
            }
            deepest = (Component)((Object)nextDroppable);
        }
        return null;
    }

    static boolean isAroundCenterPanel(Point location) {
        Component desktop = ((MainWindow)WindowManagerImpl.getInstance().getMainWindow()).getDesktop();
        if (desktop == null) {
            return false;
        }
        Point p = new Point(location);
        SwingUtilities.convertPointFromScreen(p, desktop.getParent());
        Rectangle centerBounds = desktop.getBounds();
        if (!centerBounds.contains(p)) {
            centerBounds.grow(20, 20);
            if (centerBounds.contains(p)) {
                return true;
            }
        }
        return false;
    }

    static boolean isNearEdge(Point location, ViewAccessor viewAccessor) {
        Component desktop = ((MainWindow)WindowManagerImpl.getInstance().getMainWindow()).getDesktop();
        if (desktop == null) {
            return false;
        }
        Point p = new Point(location);
        SwingUtilities.convertPointFromScreen(p, desktop);
        Rectangle centerBounds = desktop.getBounds();
        centerBounds.y -= 20;
        centerBounds.height += 20;
        Rectangle shrinked = desktop.getBounds();
        shrinked.grow(-10, 0);
        shrinked.height -= 10;
        Component dr = viewAccessor.getSlidingModeComponent("left");
        if (dr != null) {
            shrinked.x += dr.getBounds().width;
            shrinked.width -= dr.getBounds().width;
        }
        if ((dr = viewAccessor.getSlidingModeComponent("right")) != null) {
            shrinked.width -= dr.getBounds().width;
        }
        if ((dr = viewAccessor.getSlidingModeComponent("bottom")) != null) {
            shrinked.height -= dr.getBounds().height;
        }
        boolean cont = centerBounds.contains(p) && !shrinked.contains(p);
        return cont;
    }

    private TopComponentDroppable getCenterPanelDroppable() {
        CenterPanelDroppable droppable = (CenterPanelDroppable)centerDropWRef.get();
        if (droppable == null) {
            droppable = new CenterPanelDroppable();
            centerDropWRef = new WeakReference<CenterPanelDroppable>(droppable);
        }
        return droppable;
    }

    private static TopComponentDroppable getFreeAreaDroppable(Point location) {
        return new FreeAreaDroppable(location);
    }

    boolean tryPerformDrop(Controller controller, Set floatingFrames, Point location, int dropAction, Transferable transferable) {
        TopComponent[] tcArray = WindowDnDManager.extractTopComponent(dropAction == 1, transferable);
        if (tcArray == null || tcArray.length == 0) {
            return false;
        }
        ModeImpl mode = (ModeImpl)WindowManagerImpl.getInstance().findMode(tcArray[0]);
        int kind = mode != null ? mode.getKind() : 1;
        TopComponentDroppable droppable = this.findDroppableFromScreen(floatingFrames, location, kind, tcArray[0]);
        if (droppable == null) {
            return false;
        }
        Component dropComponent = droppable.getDropComponent();
        if (dropComponent != null) {
            SwingUtilities.convertPointFromScreen(location, dropComponent);
        }
        return WindowDnDManager.performDrop(controller, droppable, dropAction, tcArray, location);
    }

    static TopComponent[] extractTopComponent(boolean clone, Transferable tr) {
        DataFlavor df = WindowDnDManager.getDataFlavorForDropAction(clone);
        if (df == null) {
            return null;
        }
        if (tr.isDataFlavorSupported(df)) {
            try {
                TopComponent tc;
                if (clone) {
                    TopComponent.Cloneable ctc = (TopComponent.Cloneable)tr.getTransferData(df);
                    tc = ctc.cloneComponent();
                } else {
                    tc = (TopComponent)tr.getTransferData(df);
                }
                return new TopComponent[]{tc};
            }
            catch (UnsupportedFlavorException ufe) {
                ErrorManager.getDefault().notify(1, (Throwable)ufe);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify(1, (Throwable)ioe);
            }
        }
        if (tr.isDataFlavorSupported(df = new DataFlavor("application/x-java-jvm-local-objectref; class=org.netbeans.core.windows.view.dnd.TopComponentDragSupport$TopComponentArray", null))) {
            try {
                return (TopComponent[])tr.getTransferData(df);
            }
            catch (UnsupportedFlavorException ufe) {
                ErrorManager.getDefault().notify(1, (Throwable)ufe);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify(1, (Throwable)ioe);
            }
        }
        return null;
    }

    private static DataFlavor getDataFlavorForDropAction(boolean clone) {
        DataFlavor df = clone ? new DataFlavor("application/x-java-jvm-local-objectref; class=org.openide.windows.TopComponent$Cloneable", null) : new DataFlavor("application/x-java-jvm-local-objectref; class=org.openide.windows.TopComponent", null);
        return df;
    }

    private static boolean performDrop(Controller controller, TopComponentDroppable droppable, int dropAction, TopComponent[] tcArray, Point location) {
        if (DEBUG) {
            WindowDnDManager.debugLog("");
            WindowDnDManager.debugLog("performDrop");
            WindowDnDManager.debugLog("droppable=" + droppable);
        }
        if (tcArray == null || tcArray.length == 0) {
            return true;
        }
        if (!droppable.canDrop(tcArray[0], location)) {
            return true;
        }
        ViewElement viewElement = droppable.getDropViewElement();
        Object constr = droppable.getConstraintForLocation(location);
        if (viewElement instanceof EditorView) {
            int kind;
            ModeImpl mode = (ModeImpl)WindowManagerImpl.getInstance().findMode(tcArray[0]);
            int n = kind = mode != null ? mode.getKind() : 1;
            if (kind == 1) {
                controller.userDroppedTopComponentsIntoEmptyEditor(tcArray);
            } else if (constr == "top" || constr == "left" || constr == "right" || constr == "bottom") {
                controller.userDroppedTopComponentsAroundEditor(tcArray, (String)constr);
            } else if (Constants.SWITCH_MODE_ADD_NO_RESTRICT || WindowManagerImpl.getInstance().isTopComponentAllowedToMoveAnywhere(tcArray[0])) {
                controller.userDroppedTopComponentsIntoEmptyEditor(tcArray);
            }
        } else if (viewElement instanceof ModeView) {
            ModeView modeView = (ModeView)viewElement;
            if (constr == "top" || constr == "left" || constr == "right" || constr == "bottom") {
                controller.userDroppedTopComponents(modeView, tcArray, (String)constr);
            } else if (constr instanceof Integer) {
                controller.userDroppedTopComponents(modeView, tcArray, (Integer)constr);
            } else {
                controller.userDroppedTopComponents(modeView, tcArray);
            }
        } else if (viewElement == null) {
            if (constr == "top" || constr == "left" || constr == "right" || constr == "bottom") {
                controller.userDroppedTopComponentsAround(tcArray, (String)constr);
            } else if (constr instanceof Rectangle) {
                Rectangle bounds = (Rectangle)constr;
                Container modeComp = SwingUtilities.getAncestorOfClass(ModeComponent.class, (Component)tcArray[0]);
                if (modeComp != null) {
                    bounds.setSize(modeComp.getWidth(), modeComp.getHeight());
                }
                controller.userDroppedTopComponentsIntoFreeArea(tcArray, bounds);
            }
        }
        return true;
    }

    private static class CenterSlidingDroppable
    implements TopComponentDroppable,
    EnhancedDragPainter {
        private ViewAccessor accesor;
        private TopComponentDroppable original;
        private String side;
        JPanel pan;
        private boolean isShowing;

        public CenterSlidingDroppable(ViewAccessor viewAccesor, TopComponentDroppable slidingBarDelegate, String side) {
            this.original = slidingBarDelegate;
            this.accesor = viewAccesor;
            this.side = side;
            this.pan = new JPanel();
            this.isShowing = false;
        }

        public boolean canDrop(TopComponent transfer, Point location) {
            return this.original.canDrop(transfer, location);
        }

        public Object getConstraintForLocation(Point location) {
            return this.original.getConstraintForLocation(location);
        }

        public Component getDropComponent() {
            return this.original.getDropComponent();
        }

        public ViewElement getDropViewElement() {
            return this.original.getDropViewElement();
        }

        public Shape getIndicationForLocation(Point location) {
            Shape toReturn = this.original.getIndicationForLocation(location);
            Rectangle dim = this.original.getDropComponent().getBounds();
            if (dim.width < 10 || dim.height < 10) {
                Rectangle rect = toReturn.getBounds();
                if ("left".equals(this.side)) {
                    toReturn = new Rectangle(0, 0, Math.max(rect.width, 20), Math.max(rect.height, 20));
                } else if ("right".equals(this.side)) {
                    toReturn = new Rectangle(-20, 0, Math.max(rect.width, 20), Math.max(rect.height, 20));
                } else if ("bottom".equals(this.side)) {
                    toReturn = new Rectangle(0, -20, Math.max(rect.width, 20), Math.max(rect.height, 20));
                }
            }
            return toReturn;
        }

        public boolean isWithinSlide(Point location) {
            JRootPane root = SwingUtilities.getRootPane(this.original.getDropComponent());
            Point barLoc = SwingUtilities.convertPoint(root, location, this.original.getDropComponent());
            if (this.original.getDropComponent().contains(barLoc)) {
                return true;
            }
            if ("left".equals(this.side)) {
                Dimension dim = this.original.getDropComponent().getSize();
                int abs = Math.abs(barLoc.x);
                if (this.isShowing && abs < 20) {
                    return true;
                }
                if (!this.isShowing && barLoc.x <= 0 && barLoc.x > -20) {
                    return true;
                }
            } else if ("right".equals(this.side)) {
                Dimension dim = this.original.getDropComponent().getSize();
                if (this.isShowing && (barLoc.x < 0 && barLoc.x > -20 || barLoc.x > 0 && barLoc.x - dim.width < 20)) {
                    return true;
                }
                if (!this.isShowing && barLoc.x >= 0 && barLoc.x < 20 + dim.width) {
                    return true;
                }
            } else if ("bottom".equals(this.side)) {
                Dimension dim = this.original.getDropComponent().getSize();
                if (this.isShowing && (barLoc.y < 0 && barLoc.y > -20 || barLoc.y > 0 && barLoc.y - dim.height < 20)) {
                    return true;
                }
                if (!this.isShowing && barLoc.y >= 0 && barLoc.y < 20 + dim.height) {
                    return true;
                }
            }
            return false;
        }

        public boolean supportsKind(int kind, TopComponent transfer) {
            return this.original.supportsKind(kind, transfer);
        }

        public void additionalDragPaint(Graphics2D g) {
            Point secondDevider;
            Point firstDivider;
            Rectangle dim = this.original.getDropComponent().getBounds();
            if (dim.width > 10 && dim.height > 10) {
                return;
            }
            this.isShowing = true;
            Component glassPane = ((JComponent)this.original.getDropComponent()).getRootPane().getGlassPane();
            Point leftTop = SwingUtilities.convertPoint(this.original.getDropComponent(), 0, 0, glassPane);
            if ("right".equals(this.side)) {
                leftTop = new Point(leftTop.x - 24, leftTop.y);
                firstDivider = new Point(leftTop);
                secondDevider = new Point(leftTop.x, leftTop.y + dim.height);
            } else if ("bottom".equals(this.side)) {
                leftTop = new Point(0, leftTop.y - 24);
                firstDivider = new Point(leftTop);
                secondDevider = new Point(leftTop.x + glassPane.getBounds().width, leftTop.y);
            } else {
                firstDivider = new Point(leftTop.x + 25, leftTop.y);
                secondDevider = new Point(leftTop.x + 25, leftTop.y + dim.height);
            }
            Rectangle rect = new Rectangle(leftTop.x, leftTop.y, Math.max(25, dim.width), Math.max(25, dim.height));
            if ("bottom".equals(this.side)) {
                rect.width = glassPane.getBounds().width;
            }
            Color col = g.getColor();
            g.setColor(this.pan.getBackground());
            g.fill(rect);
            g.setColor(this.pan.getBackground().darker());
            g.drawLine(firstDivider.x, firstDivider.y, secondDevider.x, secondDevider.y);
            g.setColor(col);
        }
    }

    private static class FreeAreaDroppable
    implements TopComponentDroppable {
        private Point location;

        public FreeAreaDroppable(Point location) {
            this.location = location;
        }

        public Shape getIndicationForLocation(Point p) {
            return null;
        }

        public Object getConstraintForLocation(Point p) {
            return new Rectangle(this.location.x, this.location.y, Constants.DROP_NEW_MODE_SIZE.width, Constants.DROP_NEW_MODE_SIZE.height);
        }

        public Component getDropComponent() {
            return null;
        }

        public ViewElement getDropViewElement() {
            return null;
        }

        public boolean canDrop(TopComponent transfer, Point location) {
            ModeImpl mode = (ModeImpl)WindowManagerImpl.getInstance().findMode(transfer);
            return mode != null && (mode.getKind() == 0 || mode.getKind() == 2);
        }

        public boolean supportsKind(int kind, TopComponent transfer) {
            if (Constants.SWITCH_MODE_ADD_NO_RESTRICT || WindowManagerImpl.getInstance().isTopComponentAllowedToMoveAnywhere(transfer)) {
                return true;
            }
            return kind == 0 || kind == 2;
        }
    }

    private class CenterPanelDroppable
    implements TopComponentDroppable {
        private CenterPanelDroppable() {
        }

        public Shape getIndicationForLocation(Point p) {
            Rectangle bounds = this.getDropComponent().getBounds();
            Rectangle res = null;
            double ratio = 0.25;
            Object constraint = this.getConstraintForLocation(p);
            if (constraint == "left") {
                res = new Rectangle(0, 0, (int)((double)bounds.width * ratio) - 1, bounds.height - 1);
            } else if (constraint == "top") {
                res = new Rectangle(0, 0, bounds.width - 1, (int)((double)bounds.height * ratio) - 1);
            } else if (constraint == "right") {
                res = new Rectangle(bounds.width - (int)((double)bounds.width * ratio), 0, (int)((double)bounds.width * ratio) - 1, bounds.height - 1);
            } else if (constraint == "bottom") {
                res = new Rectangle(0, bounds.height - (int)((double)bounds.height * ratio), bounds.width - 1, (int)((double)bounds.height * ratio) - 1);
            }
            return res;
        }

        public Object getConstraintForLocation(Point p) {
            Rectangle bounds = this.getDropComponent().getBounds();
            Component leftSlide = WindowDnDManager.this.viewAccessor.getSlidingModeComponent("left");
            Component rightSlide = WindowDnDManager.this.viewAccessor.getSlidingModeComponent("right");
            Component bottomSlide = WindowDnDManager.this.viewAccessor.getSlidingModeComponent("bottom");
            if (null != leftSlide && p.x < leftSlide.getBounds().width + 10) {
                return "left";
            }
            if (p.y < bounds.y) {
                return "top";
            }
            if (null != rightSlide && null != leftSlide && p.x > bounds.width - 10 - rightSlide.getBounds().width - leftSlide.getBounds().width) {
                return "right";
            }
            if (null != bottomSlide && p.y > bounds.height - 10 - bottomSlide.getBounds().height) {
                return "bottom";
            }
            return null;
        }

        public Component getDropComponent() {
            return ((MainWindow)WindowManagerImpl.getInstance().getMainWindow()).getDesktop();
        }

        public ViewElement getDropViewElement() {
            return null;
        }

        public boolean canDrop(TopComponent transfer, Point location) {
            if (Constants.SWITCH_MODE_ADD_NO_RESTRICT || WindowManagerImpl.getInstance().isTopComponentAllowedToMoveAnywhere(transfer)) {
                return true;
            }
            ModeImpl mode = (ModeImpl)WindowManagerImpl.getInstance().findMode(transfer);
            return mode != null && (mode.getKind() == 0 || mode.getKind() == 2);
        }

        public boolean supportsKind(int kind, TopComponent transfer) {
            if (Constants.SWITCH_MODE_ADD_NO_RESTRICT || WindowManagerImpl.getInstance().isTopComponentAllowedToMoveAnywhere(transfer)) {
                return true;
            }
            return kind == 0 || kind == 2;
        }
    }

    public static interface ViewAccessor {
        public Set getModeComponents();

        public Set getSeparateModeFrames();

        public Controller getController();

        public Component getSlidingModeComponent(String var1);
    }

    private static class MotionListener
    implements DragSourceMotionListener {
        private final WindowDnDManager windowDnDManager;
        private final TopComponentDragSupport topComponentDragSupport;

        private MotionListener(WindowDnDManager windowDnDManager, TopComponentDragSupport topComponentDragSupport) {
            this.windowDnDManager = windowDnDManager;
            this.topComponentDragSupport = topComponentDragSupport;
        }

        public void dragMouseMoved(DragSourceDragEvent evt) {
            Point location;
            if (DEBUG) {
                WindowDnDManager.debugLog("dragMouseMoved evt=" + evt);
            }
            if ((location = evt.getLocation()) == null) {
                return;
            }
            ModeImpl mode = (ModeImpl)WindowManagerImpl.getInstance().findMode(this.windowDnDManager.startingTransfer);
            int kind = mode != null ? mode.getKind() : 1;
            boolean isInMainDroppable = this.windowDnDManager.isInMainWindowDroppable(location, kind, this.windowDnDManager.startingTransfer);
            boolean isInFrameDroppable = WindowDnDManager.isInFloatingFrameDroppable(this.windowDnDManager.getFloatingFrames(), location, kind, this.windowDnDManager.startingTransfer);
            boolean isAroundCenterPanel = WindowDnDManager.isAroundCenterPanel(location);
            if (isInMainDroppable || isInFrameDroppable || isAroundCenterPanel) {
                TopComponentDroppable droppable = this.windowDnDManager.findDroppableFromScreen(this.windowDnDManager.getFloatingFrames(), location, kind, this.windowDnDManager.startingTransfer);
                if (droppable instanceof FreeAreaDroppable) {
                    if (WindowManagerImpl.getInstance().getEditorAreaState() == 1 && droppable.canDrop(this.windowDnDManager.startingTransfer, location)) {
                        this.topComponentDragSupport.setSuccessCursor();
                    } else {
                        this.topComponentDragSupport.setUnsuccessCursor();
                    }
                } else if (droppable != null) {
                    JComponent cp = (JComponent)droppable.getDropComponent();
                    Component glass = cp.getRootPane().getGlassPane();
                    if (glass instanceof DropTargetGlassPane) {
                        this.windowDnDManager.setLastDropTarget((DropTargetGlassPane)glass);
                    }
                    Point p = new Point(location);
                    SwingUtilities.convertPointFromScreen(p, droppable.getDropComponent());
                    if (droppable.canDrop(this.windowDnDManager.startingTransfer, p)) {
                        this.topComponentDragSupport.setSuccessCursor();
                    } else {
                        this.topComponentDragSupport.setUnsuccessCursor();
                    }
                    this.dragOverDropTarget(location, droppable);
                }
            } else if (!WindowDnDManager.isInMainWindow(location) && this.windowDnDManager.isInFloatingFrame(location)) {
                this.topComponentDragSupport.setSuccessCursor();
            } else if (WindowDnDManager.isInFreeArea(location) && WindowManagerImpl.getInstance().getEditorAreaState() == 1 && WindowDnDManager.getFreeAreaDroppable(location).canDrop(this.windowDnDManager.startingTransfer, location)) {
                this.topComponentDragSupport.setSuccessCursor();
            } else {
                this.topComponentDragSupport.setUnsuccessCursor();
            }
            if (!(isInMainDroppable || isInFrameDroppable || isAroundCenterPanel)) {
                this.clearExitedDropTarget();
            }
        }

        private void dragOverDropTarget(Point location, TopComponentDroppable droppable) {
            DropTargetGlassPane lastTarget = (DropTargetGlassPane)this.windowDnDManager.lastTargetWRef.get();
            if (lastTarget != null) {
                Point p = new Point(location);
                SwingUtilities.convertPointFromScreen(p, lastTarget);
                lastTarget.dragOver(p, droppable);
            }
        }

        private void clearExitedDropTarget() {
            DropTargetGlassPane lastTarget = (DropTargetGlassPane)this.windowDnDManager.lastTargetWRef.get();
            if (lastTarget != null) {
                lastTarget.clearIndications();
                this.windowDnDManager.lastTargetWRef = new WeakReference<Object>(null);
            }
        }

        private static DropTargetGlassPane getMainDropTargetGlassPane() {
            Component glass = ((JFrame)WindowManagerImpl.getInstance().getMainWindow()).getGlassPane();
            if (glass instanceof DropTargetGlassPane) {
                return (DropTargetGlassPane)glass;
            }
            return null;
        }
    }
}

