/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2ee.blueprints.ui.editor;

import com.sun.j2ee.blueprints.ui.editor.RichTextareaEditorComponent;
import com.sun.j2ee.blueprints.ui.util.Util;
import java.beans.Beans;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.apache.shale.remoting.Mechanism;
import org.apache.shale.remoting.XhtmlHelper;

public class RichTextareaEditorRenderer
extends Renderer {
    private static final String SCRIPT_RESOURCE = "/META-INF/editor/script.js";
    private static String[] booleanPassthruAttributes = new String[]{"disabled", "readonly", "ismap"};
    private static String[] integerPassthruAttributes = new String[]{"cols", "maxlength", "rows", "size"};
    private static String[] passthruAttributes = new String[]{"accept", "accesskey", "alt", "bgcolor", "border", "cellpadding", "cellspacing", "charset", "coords", "dir", "enctype", "frame", "height", "hreflang", "lang", "longdesc", "onblur", "onchange", "onclick", "ondblclick", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onload", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onreset", "onselect", "onsubmit", "onunload", "rel", "rev", "rules", "shape", "summary", "tabindex", "target", "title", "usemap", "width"};
    private static XhtmlHelper helper = new XhtmlHelper();

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        RichTextareaEditorComponent editor = (RichTextareaEditorComponent)component;
        if (editor.isDisabled() || editor.isReadonly()) {
            return;
        }
        String clientId = editor.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId);
        editor.setSubmittedValue(submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String items;
        RichTextareaEditorComponent editor = (RichTextareaEditorComponent)component;
        String clientId = editor.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        if (!Beans.isDesignTime()) {
            helper.linkJavascript(context, component, writer, Mechanism.CLASS_RESOURCE, "/META-INF/common/script.js");
            Util.renderDojoLoading(context, component, writer);
            helper.linkJavascript(context, component, writer, Mechanism.CLASS_RESOURCE, SCRIPT_RESOURCE);
        }
        writer.startElement("div", (UIComponent)editor);
        String style = editor.getStyle();
        if (style != null) {
            if (style.indexOf("border") < 1) {
                style = style + "; border: 1px solid black";
            }
            writer.writeAttribute("style", (Object)style, "style");
        } else {
            writer.writeAttribute("style", (Object)"border: 1px solid black", null);
        }
        String styleClass = editor.getStyleClass();
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        writer.write("\n");
        writer.startElement("textarea", (UIComponent)editor);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, "clientId");
        writer.writeAttribute("dojoType", (Object)"Editor", null);
        if (Beans.isDesignTime()) {
            writer.writeAttribute("style", (Object)"height: 100%; width: 100%", null);
        }
        if ((items = editor.getItems()) != null) {
            writer.writeAttribute("items", (Object)items, "items");
        }
        this.renderBooleanPassThruAttributes(writer, component);
        this.renderIntegerPassThruAttributes(writer, component);
        this.renderStringPassThruAttributes(writer, component);
        writer.write("\n");
        Object value = editor.getValue();
        if (value != null) {
            writer.write(value.toString());
            writer.write("\n");
        }
        writer.endElement("textarea");
        writer.write("\n");
        writer.endElement("div");
        writer.write("\n");
    }

    private void renderBooleanPassThruAttributes(ResponseWriter writer, UIComponent component) throws IOException {
        boolean result = false;
        for (int i = 0; i < booleanPassthruAttributes.length; ++i) {
            Object value = component.getAttributes().get(booleanPassthruAttributes[i]);
            if (value == null) continue;
            if (value instanceof Boolean) {
                result = (Boolean)value;
            } else if (value instanceof String) {
                result = new Boolean((String)value);
            }
            if (!result) continue;
            writer.writeAttribute(booleanPassthruAttributes[i], (Object)booleanPassthruAttributes[i], booleanPassthruAttributes[i]);
        }
    }

    private void renderIntegerPassThruAttributes(ResponseWriter writer, UIComponent component) throws IOException {
        for (int i = 0; i < integerPassthruAttributes.length; ++i) {
            int intValue;
            Object value = component.getAttributes().get(integerPassthruAttributes[i]);
            if (value == null || !(value instanceof Integer) || (intValue = ((Integer)value).intValue()) == Integer.MIN_VALUE) continue;
            writer.writeAttribute(integerPassthruAttributes[i], (Object)value.toString(), integerPassthruAttributes[i]);
        }
    }

    private void renderStringPassThruAttributes(ResponseWriter writer, UIComponent component) throws IOException {
        for (int i = 0; i < passthruAttributes.length; ++i) {
            Object value = component.getAttributes().get(passthruAttributes[i]);
            if (value == null) continue;
            if (!(value instanceof String)) {
                value = value.toString();
            }
            writer.writeAttribute(passthruAttributes[i], (Object)((String)value), passthruAttributes[i]);
        }
    }
}

