/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutEvent;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutPersistenceManager;
import org.netbeans.modules.form.layoutdesign.LayoutRegion;
import org.w3c.dom.NodeList;

public class LayoutModel
implements LayoutConstants {
    private Map idToComponents = new HashMap();
    private ArrayList listeners;
    private boolean recordingChanges = true;
    private boolean undoRedoInProgress;
    private int changeMark;
    private int oldestMark;
    private int changeCountHardLimit = 10000;
    private Map undoMap = new HashMap(500);
    private Map redoMap = new HashMap(100);
    private LayoutUndoableEdit lastUndoableEdit;
    private boolean corrected;
    private Map linkSizeGroupsH = new HashMap();
    private Map linkSizeGroupsV = new HashMap();
    private int maxLinkGroupId = 0;

    public LayoutComponent getLayoutComponent(String compId) {
        return (LayoutComponent)this.idToComponents.get(compId);
    }

    public void addRootComponent(LayoutComponent comp) {
        this.addComponent(comp, null, -1);
    }

    public void removeComponent(String compId, boolean fromModel) {
        LayoutComponent comp = this.getLayoutComponent(compId);
        if (comp != null) {
            this.removeComponentAndIntervals(comp, fromModel);
        }
    }

    public boolean changeComponentToContainer(String componentId) {
        LayoutComponent component = this.getLayoutComponent(componentId);
        if (component != null) {
            this.setLayoutContainer(component, true);
            return true;
        }
        return false;
    }

    public boolean changeContainerToComponent(String componentId) {
        LayoutComponent component = this.getLayoutComponent(componentId);
        if (component == null) {
            return false;
        }
        for (int i = component.getSubComponentCount() - 1; i >= 0; --i) {
            LayoutComponent sub;
            this.removeComponentAndIntervals(sub, !(sub = component.getSubComponent(i)).isLayoutContainer());
        }
        if (component.getParent() == null) {
            this.removeComponent(component, true);
        }
        this.setLayoutContainer(component, false);
        return true;
    }

    void registerComponent(LayoutComponent comp, boolean recursive) {
        this.registerComponentImpl(comp);
        if (recursive && comp.isLayoutContainer()) {
            Iterator it = comp.getSubcomponents();
            while (it.hasNext()) {
                this.registerComponent((LayoutComponent)it.next(), recursive);
            }
        }
    }

    void registerComponentImpl(LayoutComponent comp) {
        LayoutComponent lc = this.idToComponents.put(comp.getId(), comp);
        if (lc != comp) {
            LayoutEvent ev = new LayoutEvent(this, 11);
            ev.setComponent(comp);
            this.addChange(ev);
            this.fireEvent(ev);
        }
    }

    void unregisterComponent(LayoutComponent comp, boolean recursive) {
        if (recursive && comp.isLayoutContainer()) {
            Iterator it = comp.getSubcomponents();
            while (it.hasNext()) {
                this.unregisterComponent((LayoutComponent)it.next(), recursive);
            }
        }
        this.removeComponentFromLinkSizedGroup(comp, 0);
        this.removeComponentFromLinkSizedGroup(comp, 1);
        this.unregisterComponentImpl(comp);
    }

    void unregisterComponentImpl(LayoutComponent comp) {
        Object lc = this.idToComponents.remove(comp.getId());
        if (lc != null) {
            LayoutEvent ev = new LayoutEvent(this, 12);
            ev.setComponent(comp);
            this.addChange(ev);
            this.fireEvent(ev);
        }
    }

    void changeComponentId(LayoutComponent comp, String newId) {
        this.unregisterComponentImpl(comp);
        comp.setId(newId);
        this.registerComponentImpl(comp);
    }

    Iterator getAllComponents() {
        return this.idToComponents.values().iterator();
    }

    public void addNewComponent(LayoutComponent component, LayoutComponent parent, LayoutComponent prototype) {
        for (int i = 0; i < 2; ++i) {
            LayoutInterval interval = component.getLayoutInterval(i);
            if (parent != null) {
                this.addInterval(interval, parent.getLayoutRoot(i), -1);
            }
            this.setIntervalAlignment(interval, -1);
            if (prototype == null) continue;
            LayoutInterval pInt = prototype.getLayoutInterval(i);
            this.setIntervalSize(interval, interval.getMinimumSize(), pInt.getPreferredSize(), interval.getMaximumSize());
        }
        this.addComponent(component, parent, -1);
    }

    void addComponent(LayoutComponent component, LayoutComponent parent, int index) {
        this.addComponentImpl(component, parent, index);
        this.registerComponent(component, true);
    }

    void addComponentImpl(LayoutComponent component, LayoutComponent parent, int index) {
        assert (component.getParent() == null);
        if (parent != null) {
            assert (this.getLayoutComponent(parent.getId()) == parent);
            index = parent.add(component, index);
        } else assert (component.isLayoutContainer());
        LayoutEvent ev = new LayoutEvent(this, 1);
        ev.setComponent(component, parent, index);
        this.addChange(ev);
        this.fireEvent(ev);
    }

    void removeComponent(LayoutComponent component) {
        this.removeComponent(component, true);
    }

    void removeComponent(LayoutComponent component, boolean fromModel) {
        this.removeComponentImpl(component);
        if (fromModel && this.getLayoutComponent(component.getId()) != null) {
            this.unregisterComponent(component, true);
        }
    }

    void removeComponentImpl(LayoutComponent component) {
        LayoutComponent parent = component.getParent();
        if (parent == null) {
            return;
        }
        int index = parent.remove(component);
        LayoutEvent ev = new LayoutEvent(this, 2);
        ev.setComponent(component, parent, index);
        this.addChange(ev);
        this.fireEvent(ev);
    }

    void removeComponentAndIntervals(LayoutComponent comp, boolean fromModel) {
        boolean wasRoot = comp.getParent() == null;
        this.removeComponent(comp, fromModel);
        if (!wasRoot) {
            for (int i = 0; i < 2; ++i) {
                LayoutInterval interval = comp.getLayoutInterval(i);
                if (interval.getParent() == null) continue;
                this.removeInterval(interval);
            }
        }
    }

    void addInterval(LayoutInterval interval, LayoutInterval parent, int index) {
        assert (interval.getParent() == null);
        index = parent.add(interval, index);
        LayoutEvent ev = new LayoutEvent(this, 3);
        ev.setInterval(interval, parent, index);
        this.addChange(ev);
        this.fireEvent(ev);
    }

    int removeInterval(LayoutInterval interval) {
        LayoutInterval parent = interval.getParent();
        int index = parent.remove(interval);
        LayoutEvent ev = new LayoutEvent(this, 4);
        ev.setInterval(interval, parent, index);
        this.addChange(ev);
        this.fireEvent(ev);
        return index;
    }

    LayoutInterval removeInterval(LayoutInterval parent, int index) {
        LayoutInterval interval = parent.remove(index);
        LayoutEvent ev = new LayoutEvent(this, 4);
        ev.setInterval(interval, parent, index);
        this.addChange(ev);
        this.fireEvent(ev);
        return interval;
    }

    void changeIntervalAttribute(LayoutInterval interval, int attribute, boolean set) {
        int oldAttributes = interval.getAttributes();
        if (set) {
            interval.setAttribute(attribute);
        } else {
            interval.unsetAttribute(attribute);
        }
        int newAttributes = interval.getAttributes();
        LayoutEvent ev = new LayoutEvent(this, 8);
        ev.setAttributes(interval, oldAttributes, newAttributes);
        this.addChange(ev);
    }

    void setIntervalAlignment(LayoutInterval interval, int alignment) {
        int oldAlignment = interval.getRawAlignment();
        interval.setAlignment(alignment);
        LayoutEvent ev = new LayoutEvent(this, 5);
        ev.setAlignment(interval, oldAlignment, alignment);
        this.addChange(ev);
    }

    void setGroupAlignment(LayoutInterval group, int alignment) {
        int oldAlignment = group.getGroupAlignment();
        if (alignment == oldAlignment) {
            return;
        }
        group.setGroupAlignment(alignment);
        LayoutEvent ev = new LayoutEvent(this, 6);
        ev.setAlignment(group, oldAlignment, alignment);
        this.addChange(ev);
    }

    void setLayoutContainer(LayoutComponent component, boolean container) {
        boolean oldContainer = component.isLayoutContainer();
        if (oldContainer != container) {
            LayoutInterval[] roots = component.getLayoutRoots();
            component.setLayoutContainer(container, null);
            LayoutEvent ev = new LayoutEvent(this, 10);
            ev.setContainer(component, roots);
            this.addChange(ev);
        }
    }

    public void setIntervalSize(LayoutInterval interval, int min, int pref, int max) {
        int oldMin = interval.getMinimumSize();
        int oldPref = interval.getPreferredSize();
        int oldMax = interval.getMaximumSize();
        if (min == oldMin && pref == oldPref && max == oldMax) {
            return;
        }
        interval.setSizes(min, pref, max);
        if (interval.isComponent()) {
            boolean horizontal;
            LayoutComponent comp = interval.getComponent();
            boolean bl = horizontal = interval == comp.getLayoutInterval(0);
            if (oldMin != min) {
                comp.firePropertyChange(horizontal ? "horizontalMinSize" : "verticalMinSize", new Integer(oldMin), new Integer(min));
            }
            if (oldPref != pref) {
                comp.firePropertyChange(horizontal ? "horizontalPrefSize" : "verticalPrefSize", new Integer(oldPref), new Integer(pref));
            }
            if (oldMax != max) {
                comp.firePropertyChange(horizontal ? "horizontalMaxSize" : "verticalMaxSize", new Integer(oldMax), new Integer(max));
            }
        }
        LayoutEvent ev = new LayoutEvent(this, 7);
        ev.setSize(interval, oldMin, oldPref, oldMax, min, pref, max);
        this.addChange(ev);
    }

    public void copyModelFrom(LayoutModel sourceModel, Map sourceToTargetIds, String sourceContainerId, String targetContainerId) {
        LayoutComponent sourceContainer = sourceModel.getLayoutComponent(sourceContainerId);
        LayoutComponent targetContainer = this.getLayoutComponent(targetContainerId);
        if (targetContainer == null) {
            targetContainer = new LayoutComponent(targetContainerId, true);
            this.addRootComponent(targetContainer);
        } else if (!targetContainer.isLayoutContainer()) {
            this.changeComponentToContainer(targetContainerId);
        }
        for (Map.Entry entry : sourceToTargetIds.entrySet()) {
            String targetId = (String)entry.getValue();
            LayoutComponent targetLC = this.getLayoutComponent(targetId);
            if (targetLC == null) {
                String sourceId = (String)entry.getKey();
                LayoutComponent sourceLC = sourceModel.getLayoutComponent(sourceId);
                targetLC = new LayoutComponent(targetId, sourceLC.isLayoutContainer());
            }
            if (targetLC.getParent() != null) continue;
            this.addComponent(targetLC, targetContainer, -1);
        }
        for (int dim = 0; dim < 2; ++dim) {
            LayoutInterval sourceInterval = sourceContainer.getLayoutRoot(dim);
            LayoutInterval targetInterval = targetContainer.getLayoutRoot(dim);
            this.copyInterval(sourceInterval, targetInterval, sourceToTargetIds);
        }
    }

    private void copyInterval(LayoutInterval sourceInterval, LayoutInterval targetInterval, Map sourceToTargetIds) {
        Iterator iter = sourceInterval.getSubIntervals();
        while (iter.hasNext()) {
            LayoutInterval sourceSub = (LayoutInterval)iter.next();
            LayoutInterval clone = null;
            if (sourceSub.isComponent()) {
                String compId = (String)sourceToTargetIds.get(sourceSub.getComponent().getId());
                LayoutComponent comp = this.getLayoutComponent(compId);
                int dimension = sourceSub == sourceSub.getComponent().getLayoutInterval(0) ? 0 : 1;
                clone = comp.getLayoutInterval(dimension);
            }
            LayoutInterval targetSub = LayoutInterval.cloneInterval(sourceSub, clone);
            if (sourceSub.isGroup()) {
                this.copyInterval(sourceSub, targetSub, sourceToTargetIds);
            }
            this.addInterval(targetSub, targetInterval, -1);
        }
    }

    public void createModel(String containerId, Container cont, Map idToComponent) {
        Border border;
        if (idToComponent.isEmpty()) {
            return;
        }
        LayoutComponent lCont = this.getLayoutComponent(containerId);
        assert (lCont != null);
        Insets insets = new Insets(0, 0, 0, 0);
        if (cont instanceof JComponent && (border = ((JComponent)cont).getBorder()) != null) {
            insets = border.getBorderInsets(cont);
        }
        HashMap<String, Rectangle> idToBounds = new HashMap<String, Rectangle>();
        Iterator iter = idToComponent.entrySet().iterator();
        Rectangle notKnown = new Rectangle();
        while (iter.hasNext()) {
            LayoutInterval interval;
            Map.Entry entry = iter.next();
            String id = (String)entry.getKey();
            Component component = (Component)entry.getValue();
            LayoutComponent lComp = this.getLayoutComponent(id);
            if (lComp == null) {
                lComp = new LayoutComponent(id, false);
            }
            this.addComponent(lComp, lCont, -1);
            Rectangle bounds = component.getBounds();
            Dimension dim = component.getPreferredSize();
            if (bounds.equals(notKnown)) {
                bounds.setSize(dim);
            }
            bounds = new Rectangle(bounds.x - insets.left, bounds.y - insets.top, bounds.width, bounds.height);
            idToBounds.put(id, bounds);
            if (dim.width != bounds.width) {
                interval = lComp.getLayoutInterval(0);
                this.setIntervalSize(interval, interval.getMinimumSize(), bounds.width, interval.getMaximumSize());
            }
            if (dim.height == bounds.height) continue;
            interval = lComp.getLayoutInterval(1);
            this.setIntervalSize(interval, interval.getMinimumSize(), bounds.height, interval.getMaximumSize());
        }
        RegionInfo region = new RegionInfo(idToBounds);
        region.calculateIntervals();
        this.addInterval(region.getInterval(0), lCont.getLayoutRoot(0), -1);
        this.addInterval(region.getInterval(1), lCont.getLayoutRoot(1), -1);
    }

    public LayoutInterval[] createIntervalsFromBounds(LayoutRegion space, LayoutComponent[] components, LayoutRegion[] bounds) {
        HashMap<String, Rectangle> idToBounds = new HashMap<String, Rectangle>();
        for (int i = 0; i < components.length; ++i) {
            for (int dim = 0; dim < 2; ++dim) {
                LayoutInterval interval = components[i].getLayoutInterval(dim);
                this.setIntervalSize(interval, interval.getMinimumSize(), bounds[i].size(dim), interval.getMaximumSize());
            }
            Rectangle compBounds = new Rectangle(bounds[i].positions[0][0] - space.positions[0][0], bounds[i].positions[1][0] - space.positions[1][0], bounds[i].size(0), bounds[i].size(1));
            idToBounds.put(components[i].getId(), compBounds);
        }
        RegionInfo region = new RegionInfo(idToBounds);
        region.calculateIntervals();
        LayoutInterval[] result = new LayoutInterval[2];
        for (int dim = 0; dim < 2; ++dim) {
            result[dim] = region.getInterval(dim);
        }
        return result;
    }

    void addListener(Listener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        } else {
            this.listeners.remove(l);
        }
        this.listeners.add(l);
    }

    void removeListener(Listener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    private void fireEvent(LayoutEvent event) {
        if (this.listeners != null && this.listeners.size() > 0) {
            Iterator it = ((List)this.listeners.clone()).iterator();
            while (it.hasNext()) {
                ((Listener)it.next()).layoutChanged(event);
            }
        }
    }

    public boolean isChangeRecording() {
        return this.recordingChanges;
    }

    public void setChangeRecording(boolean record) {
        this.recordingChanges = record;
    }

    boolean isUndoRedoInProgress() {
        return this.undoRedoInProgress;
    }

    public Object getChangeMark() {
        return new Integer(this.changeMark);
    }

    public void endUndoableEdit() {
        if (this.lastUndoableEdit != null) {
            this.lastUndoableEdit.endMark = this.getChangeMark();
            this.lastUndoableEdit = null;
        }
    }

    public boolean isUndoableEditInProgress() {
        return this.lastUndoableEdit != null;
    }

    public UndoableEdit getUndoableEdit() {
        if (this.recordingChanges && !this.undoRedoInProgress) {
            LayoutUndoableEdit undoEdit = new LayoutUndoableEdit();
            undoEdit.startMark = this.getChangeMark();
            this.endUndoableEdit();
            this.lastUndoableEdit = undoEdit;
            return undoEdit;
        }
        return null;
    }

    private void addChange(LayoutEvent change) {
        if (this.recordingChanges && !this.undoRedoInProgress) {
            this.redoMap.clear();
            if (this.undoMap.size() == 0) {
                this.oldestMark = this.changeMark;
            }
            this.undoMap.put(new Integer(this.changeMark++), change);
            while (this.undoMap.size() > this.changeCountHardLimit) {
                this.undoMap.remove(new Integer(this.oldestMark++));
            }
        }
    }

    boolean undo(Object startMark, Object endMark) {
        assert (!this.undoRedoInProgress);
        if (!this.undoMap.containsKey(startMark)) {
            return false;
        }
        int start = (Integer)startMark;
        int end = (Integer)endMark;
        this.undoRedoInProgress = true;
        while (end > start) {
            Integer key;
            LayoutEvent change;
            if ((change = (LayoutEvent)this.undoMap.remove(key = new Integer(--end))) == null) continue;
            change.undo();
            this.redoMap.put(key, change);
        }
        this.undoRedoInProgress = false;
        return true;
    }

    boolean redo(Object startMark, Object endMark) {
        assert (!this.undoRedoInProgress);
        if (!this.redoMap.containsKey(startMark)) {
            return false;
        }
        int start = (Integer)startMark;
        int end = (Integer)endMark;
        this.undoRedoInProgress = true;
        while (start < end) {
            Integer key;
            LayoutEvent change;
            if ((change = (LayoutEvent)this.redoMap.remove(key = new Integer(start++))) == null) continue;
            change.redo();
            this.undoMap.put(key, change);
        }
        this.undoRedoInProgress = false;
        return true;
    }

    void releaseChanges(Object fromMark, Object toMark) {
        int m2 = (Integer)toMark;
        for (int m1 = ((Integer)fromMark).intValue(); m1 < m2; ++m1) {
            Integer m = new Integer(m1);
            this.undoMap.remove(m);
            this.redoMap.remove(m);
        }
    }

    public String dump(final Map idToNameMap) {
        TreeSet<LayoutComponent> roots = new TreeSet<LayoutComponent>(new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 == o2) {
                    return 0;
                }
                LayoutComponent lc1 = (LayoutComponent)o1;
                LayoutComponent lc2 = (LayoutComponent)o2;
                if (lc1.isParentOf(lc2)) {
                    return -1;
                }
                if (lc2.isParentOf(lc1)) {
                    return 1;
                }
                LayoutComponent parent = LayoutComponent.getCommonParent(lc1, lc2);
                while (lc1.getParent() != parent) {
                    lc1 = lc1.getParent();
                }
                while (lc2.getParent() != parent) {
                    lc2 = lc2.getParent();
                }
                if (parent != null) {
                    return parent.indexOf(lc1) < parent.indexOf(lc2) ? -1 : 1;
                }
                String id1 = lc1.getId();
                String id2 = lc2.getId();
                if (idToNameMap != null) {
                    id1 = (String)idToNameMap.get(id1);
                    id2 = (String)idToNameMap.get(id2);
                    if (id1 == null) {
                        return -1;
                    }
                    if (id2 == null) {
                        return 1;
                    }
                }
                return id1.compareTo(id2);
            }
        });
        for (Map.Entry entry : this.idToComponents.entrySet()) {
            LayoutComponent comp = (LayoutComponent)entry.getValue();
            if (!comp.isLayoutContainer()) continue;
            roots.add(comp);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<LayoutModel>\n");
        for (LayoutComponent root : roots) {
            String rootId = root.getId();
            if (idToNameMap != null) {
                rootId = (String)idToNameMap.get(rootId);
            }
            if (rootId != null) {
                sb.append("  <Root id=\"" + rootId + "\">\n");
            } else {
                sb.append("  <Root>\n");
            }
            sb.append(this.dumpLayout(2, root, idToNameMap, true));
            sb.append("  </Root>\n");
        }
        sb.append("</LayoutModel>\n");
        return sb.toString();
    }

    public String dump(LayoutInterval interval, int dimension) {
        return new LayoutPersistenceManager(this).saveIntervalLayout(2, interval, dimension);
    }

    public String dumpLayout(int indent, LayoutComponent root, Map idToNameMap, boolean humanReadable) {
        return new LayoutPersistenceManager(this).saveLayout(indent, root, idToNameMap, humanReadable);
    }

    public void loadModel(String rootId, NodeList dimLayoutList, Map nameToIdMap) throws IOException {
        new LayoutPersistenceManager(this).loadModel(rootId, dimLayoutList, nameToIdMap);
    }

    public boolean wasCorrected() {
        return this.corrected;
    }

    void setCorrected() {
        this.corrected = true;
    }

    void addComponentToLinkSizedGroup(int groupId, String compId, int dimension) {
        Integer groupIdInt;
        Map linkSizeGroups;
        List l;
        if (-1 == groupId) {
            return;
        }
        if (this.maxLinkGroupId < groupId) {
            this.maxLinkGroupId = groupId;
        }
        if ((l = (List)(linkSizeGroups = dimension == 0 ? this.linkSizeGroupsH : this.linkSizeGroupsV).get(groupIdInt = new Integer(groupId))) != null && (l.contains(compId) || !this.sameContainer(compId, (String)l.get(0)))) {
            return;
        }
        this.addComponentToLinkSizedGroupImpl(groupId, compId, dimension);
    }

    void addComponentToLinkSizedGroupImpl(int groupId, String compId, int dimension) {
        Integer groupIdInt;
        LayoutComponent lc = this.getLayoutComponent(compId);
        Map linkSizeGroups = dimension == 0 ? this.linkSizeGroupsH : this.linkSizeGroupsV;
        ArrayList<String> l = (ArrayList<String>)linkSizeGroups.get(groupIdInt = new Integer(groupId));
        if (l != null) {
            l.add(lc.getId());
        } else {
            l = new ArrayList<String>();
            l.add(lc.getId());
            linkSizeGroups.put(groupIdInt, l);
        }
        int oldLinkSizeId = lc.getLinkSizeId(dimension);
        lc.setLinkSizeId(groupId, dimension);
        LayoutEvent ev = new LayoutEvent(this, 9);
        ev.setLinkSizeGroup(lc, oldLinkSizeId, groupId, dimension);
        this.addChange(ev);
        this.fireEvent(ev);
    }

    private boolean sameContainer(String compId1, String compId2) {
        LayoutComponent lc1 = this.getLayoutComponent(compId1);
        LayoutComponent lc2 = this.getLayoutComponent(compId2);
        return lc1.getParent().equals(lc2.getParent());
    }

    void removeComponentFromLinkSizedGroup(LayoutComponent comp, int dimension) {
        if (comp == null) {
            return;
        }
        int linkId = comp.getLinkSizeId(dimension);
        if (linkId != -1) {
            Map map = dimension == 0 ? this.linkSizeGroupsH : this.linkSizeGroupsV;
            Integer linkIdInt = new Integer(linkId);
            List l = null;
            l = (List)map.get(linkIdInt);
            l.remove(comp.getId());
            comp.setLinkSizeId(-1, dimension);
            if (l.size() == 1) {
                LayoutComponent lc = this.getLayoutComponent((String)l.get(0));
                int oldLinkSizeId = lc.getLinkSizeId(dimension);
                lc.setLinkSizeId(-1, dimension);
                map.remove(linkIdInt);
                LayoutEvent ev = new LayoutEvent(this, 9);
                ev.setLinkSizeGroup(lc, oldLinkSizeId, -1, dimension);
                this.addChange(ev);
                this.fireEvent(ev);
            }
            if (l.size() == 0) {
                map.remove(linkIdInt);
            }
            LayoutEvent ev = new LayoutEvent(this, 9);
            ev.setLinkSizeGroup(comp, linkId, -1, dimension);
            this.addChange(ev);
            this.fireEvent(ev);
        }
    }

    public int areComponentsLinkSized(List components, int dimension) {
        if (components.size() == 1) {
            String id = (String)components.get(0);
            boolean retVal = this.getLayoutComponent(id).isLinkSized(dimension);
            return retVal ? 1 : 0;
        }
        Iterator i = components.iterator();
        boolean someUnlinkedPresent = false;
        ArrayList<Integer> idsFound = new ArrayList<Integer>();
        while (i.hasNext()) {
            String cid = (String)i.next();
            LayoutComponent lc = this.getLayoutComponent(cid);
            Integer linkSizeId = new Integer(lc.getLinkSizeId(dimension));
            if (!idsFound.contains(linkSizeId)) {
                idsFound.add(linkSizeId);
            }
            if (idsFound.size() <= 2) continue;
            return -1;
        }
        if (idsFound.size() == 1) {
            if (idsFound.contains(new Integer(-1))) {
                return 0;
            }
            return 1;
        }
        if (idsFound.contains(new Integer(-1))) {
            return 0;
        }
        return -1;
    }

    Map getLinkSizeGroups(int dimension) {
        if (0 == dimension) {
            return this.linkSizeGroupsH;
        }
        if (1 == dimension) {
            return this.linkSizeGroupsV;
        }
        return null;
    }

    public void unsetSameSize(List components, int dimension) {
        for (String cid : components) {
            LayoutComponent lc = this.getLayoutComponent(cid);
            this.removeComponentFromLinkSizedGroup(lc, dimension);
        }
    }

    public void setSameSize(List components, int dimension) {
        Iterator i = components.iterator();
        int groupId = this.findGroupId(components, dimension);
        while (i.hasNext()) {
            String cid = (String)i.next();
            LayoutComponent lc = this.getLayoutComponent(cid);
            this.addComponentToLinkSizedGroup(groupId, lc.getId(), dimension);
        }
    }

    private int findGroupId(List components, int dimension) {
        for (String cid : components) {
            LayoutComponent lc = this.getLayoutComponent(cid);
            if (!lc.isLinkSized(dimension)) continue;
            return lc.getLinkSizeId(dimension);
        }
        return ++this.maxLinkGroupId;
    }

    private class LayoutUndoableEdit
    extends AbstractUndoableEdit {
        private Object startMark;
        private Object endMark;

        private LayoutUndoableEdit() {
        }

        public void undo() throws CannotUndoException {
            super.undo();
            if (this.endMark == null) {
                assert (LayoutModel.this.lastUndoableEdit == this);
                this.endMark = LayoutModel.this.getChangeMark();
                LayoutModel.this.lastUndoableEdit = null;
            }
            LayoutModel.this.undo(this.startMark, this.endMark);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            LayoutModel.this.redo(this.startMark, this.endMark);
        }

        public String getUndoPresentationName() {
            return "";
        }

        public String getRedoPresentationName() {
            return "";
        }

        public void die() {
            LayoutModel.this.releaseChanges(this.startMark, this.endMark != null ? this.endMark : LayoutModel.this.getChangeMark());
        }
    }

    static interface Listener {
        public void layoutChanged(LayoutEvent var1);
    }

    private class RegionInfo {
        private LayoutInterval horizontal = null;
        private LayoutInterval vertical = null;
        private Map idToBounds;
        private int minx;
        private int maxx;
        private int miny;
        private int maxy;
        private int dimension;

        public RegionInfo(Map idToBounds) {
            this.idToBounds = idToBounds;
            this.dimension = -1;
            this.miny = 0;
            this.minx = 0;
            this.updateRegionBounds();
        }

        private RegionInfo(Map idToBounds, int dimension) {
            this.idToBounds = idToBounds;
            this.dimension = dimension;
            this.miny = Short.MAX_VALUE;
            this.minx = Short.MAX_VALUE;
            this.updateRegionBounds();
        }

        private void updateRegionBounds() {
            this.maxx = Short.MIN_VALUE;
            this.maxy = Short.MIN_VALUE;
            for (Rectangle bounds : this.idToBounds.values()) {
                this.minx = Math.min(this.minx, bounds.x);
                this.miny = Math.min(this.miny, bounds.y);
                this.maxx = Math.max(this.maxx, bounds.x + bounds.width);
                this.maxy = Math.max(this.maxy, bounds.y + bounds.height);
            }
        }

        public void calculateIntervals() {
            if (this.idToBounds.size() == 1) {
                String id = (String)this.idToBounds.keySet().iterator().next();
                Rectangle bounds = (Rectangle)this.idToBounds.get(id);
                LayoutComponent comp = LayoutModel.this.getLayoutComponent(id);
                this.horizontal = comp.getLayoutInterval(0);
                this.horizontal = this.prefixByGap(this.horizontal, bounds.x - this.minx);
                this.vertical = comp.getLayoutInterval(1);
                this.vertical = this.prefixByGap(this.vertical, bounds.y - this.miny);
                return;
            }
            int effDim = -1;
            List parts = null;
            HashMap<String, Rectangle> removedIdToBounds = null;
            do {
                boolean remove;
                boolean bl = remove = this.dimension == -1 && effDim == 0 || this.dimension != -1 && effDim != -1;
                if (remove) {
                    effDim = -1;
                }
                if (this.dimension == -1) {
                    switch (effDim) {
                        case -1: {
                            effDim = 1;
                            break;
                        }
                        case 1: {
                            effDim = 0;
                            break;
                        }
                        case 0: {
                            remove = true;
                        }
                    }
                } else {
                    effDim = this.dimension;
                }
                if (remove) {
                    String id = (String)this.idToBounds.keySet().iterator().next();
                    Rectangle bounds = (Rectangle)this.idToBounds.remove(id);
                    if (removedIdToBounds == null) {
                        removedIdToBounds = new HashMap<String, Rectangle>();
                    }
                    removedIdToBounds.put(id, bounds);
                }
                SortedSet cutSet = this.createPossibleCuts(effDim);
                parts = this.cutIntoParts(cutSet, effDim);
            } while (!this.idToBounds.isEmpty() && parts.isEmpty());
            this.dimension = effDim;
            LinkedList<RegionInfo> regions = new LinkedList<RegionInfo>();
            for (Map part : parts) {
                RegionInfo region = new RegionInfo(part, this.dimension == 0 ? 1 : 0);
                region.calculateIntervals();
                regions.add(region);
            }
            this.mergeSubRegions(regions, this.dimension);
            if (removedIdToBounds != null) {
                for (int dim = 0; dim <= 1; ++dim) {
                    LayoutInterval parent;
                    Iterator<Object> iter = removedIdToBounds.entrySet().iterator();
                    LayoutInterval layoutInterval = parent = dim == 0 ? this.horizontal : this.vertical;
                    if (!parent.isParallel()) {
                        LayoutInterval parGroup = new LayoutInterval(103);
                        LayoutModel.this.addInterval(parent, parGroup, -1);
                        if (dim == 0) {
                            this.horizontal = parGroup;
                        } else {
                            this.vertical = parGroup;
                        }
                        parent = parGroup;
                    }
                    while (iter.hasNext()) {
                        Map.Entry entry = (Map.Entry)iter.next();
                        String id = (String)entry.getKey();
                        Rectangle bounds = (Rectangle)entry.getValue();
                        LayoutComponent comp = LayoutModel.this.getLayoutComponent(id);
                        LayoutInterval interval = comp.getLayoutInterval(dim);
                        int gap = dim == 0 ? bounds.x - this.minx : bounds.y - this.miny;
                        interval = this.prefixByGap(interval, gap);
                        LayoutModel.this.addInterval(interval, parent, -1);
                    }
                }
            }
        }

        private SortedSet createPossibleCuts(int dimension) {
            TreeSet<Integer> cutSet = new TreeSet<Integer>();
            for (String id : this.idToBounds.keySet()) {
                Rectangle bounds = (Rectangle)this.idToBounds.get(id);
                int leading = dimension == 0 ? bounds.x : bounds.y;
                cutSet.add(new Integer(leading));
            }
            cutSet.add(new Integer(dimension == 0 ? this.maxx : this.maxy));
            return cutSet;
        }

        private List cutIntoParts(Set cutSet, int dimension) {
            LinkedList parts = new LinkedList();
            for (Integer cutInt : cutSet) {
                int cut = cutInt;
                boolean isCut = true;
                HashMap<String, Rectangle> preIdToBounds = new HashMap<String, Rectangle>();
                HashMap<String, Rectangle> postIdToBounds = new HashMap<String, Rectangle>();
                Iterator it = this.idToBounds.entrySet().iterator();
                while (isCut && it.hasNext()) {
                    Map.Entry entry = it.next();
                    String id = (String)entry.getKey();
                    Rectangle bounds = (Rectangle)entry.getValue();
                    int leading = dimension == 0 ? bounds.x : bounds.y;
                    int trailing = leading + (dimension == 0 ? bounds.width : bounds.height);
                    if (leading >= cut) {
                        postIdToBounds.put(id, bounds);
                        continue;
                    }
                    if (trailing <= cut) {
                        preIdToBounds.put(id, bounds);
                        continue;
                    }
                    isCut = false;
                }
                if (!isCut || preIdToBounds.isEmpty() || parts.isEmpty() && preIdToBounds.size() == this.idToBounds.size()) continue;
                this.idToBounds.keySet().removeAll(preIdToBounds.keySet());
                parts.add(preIdToBounds);
            }
            return parts;
        }

        private void mergeSubRegions(List regions, int dimension) {
            if (regions.size() == 0) {
                this.horizontal = new LayoutInterval(103);
                this.vertical = new LayoutInterval(103);
                return;
            }
            LayoutInterval seqGroup = new LayoutInterval(102);
            LayoutInterval parGroup = new LayoutInterval(103);
            int lastSeqTrailing = dimension == 0 ? this.minx : this.miny;
            for (RegionInfo region : regions) {
                int seqGap;
                int parGap;
                LayoutInterval parInterval;
                LayoutInterval seqInterval;
                if (dimension == 0) {
                    seqInterval = region.horizontal;
                    parInterval = region.vertical;
                    parGap = region.miny - this.miny;
                    seqGap = region.minx - lastSeqTrailing;
                    lastSeqTrailing = region.maxx;
                } else {
                    seqInterval = region.vertical;
                    parInterval = region.horizontal;
                    parGap = region.minx - this.minx;
                    seqGap = region.miny - lastSeqTrailing;
                    lastSeqTrailing = region.maxy;
                }
                if (seqGap > 0) {
                    LayoutInterval gap = new LayoutInterval(101);
                    gap.setSize(seqGap);
                    LayoutModel.this.addInterval(gap, seqGroup, -1);
                }
                LayoutModel.this.addInterval(seqInterval, seqGroup, -1);
                parInterval = this.prefixByGap(parInterval, parGap);
                LayoutModel.this.addInterval(parInterval, parGroup, -1);
            }
            if (dimension == 0) {
                this.horizontal = seqGroup;
                this.vertical = parGroup;
            } else {
                this.horizontal = parGroup;
                this.vertical = seqGroup;
            }
        }

        private LayoutInterval prefixByGap(LayoutInterval interval, int size) {
            if (size > 0) {
                LayoutInterval gap = new LayoutInterval(101);
                gap.setSize(size);
                if (interval.isSequential()) {
                    LayoutModel.this.addInterval(gap, interval, 0);
                } else {
                    LayoutInterval group = new LayoutInterval(102);
                    LayoutModel.this.addInterval(gap, group, -1);
                    LayoutModel.this.addInterval(interval, group, -1);
                    interval = group;
                }
            }
            return interval;
        }

        public LayoutInterval getInterval(int dimension) {
            return dimension == 0 ? this.horizontal : this.vertical;
        }
    }
}

