/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Dialog;
import java.io.File;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.form.palette.BeanInstaller;
import org.netbeans.modules.form.palette.ChooseBeansWizardPanel;
import org.netbeans.modules.form.palette.ChooseCategoryWizardPanel;
import org.netbeans.modules.form.palette.ChooseJARWizardPanel;
import org.netbeans.modules.form.palette.ChooseLibraryWizardPanel;
import org.netbeans.modules.form.palette.ChooseProjectWizardPanel;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;

class AddToPaletteWizard
extends WizardDescriptor {
    ATPWizardIterator wizardIterator;
    private File[] selectedFiles;
    private BeanInstaller.ItemInfo[] selectedBeans;
    private String selectedCategory;
    private String sourceType;
    Map libraryNameMap;
    private Dialog dialog;

    public AddToPaletteWizard() {
        this(new ATPWizardIterator());
    }

    private AddToPaletteWizard(ATPWizardIterator iterator) {
        super((WizardDescriptor.Iterator)iterator);
        this.wizardIterator = iterator;
        this.putProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
        this.putProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
        this.putProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        this.setTitle(PaletteUtils.getBundleString("CTL_AddToPaletteWizard_Title"));
        this.setTitleFormat(new MessageFormat("{0}"));
    }

    public boolean show(String sourceType) {
        String firstStep_key;
        this.sourceType = sourceType;
        if ("jar".equals(sourceType)) {
            firstStep_key = "CTL_SelectJAR_Step";
        } else if ("library".equals(sourceType)) {
            firstStep_key = "CTL_SelectLibrary_Step";
        } else if ("project".equals(sourceType)) {
            firstStep_key = "CTL_SelectProject_Step";
        } else {
            throw new IllegalArgumentException();
        }
        this.putProperty("WizardPanel_contentData", new String[]{PaletteUtils.getBundleString(firstStep_key), PaletteUtils.getBundleString("CTL_SelectBeans_Step"), PaletteUtils.getBundleString("CTL_SelectCategory_Step")});
        this.libraryNameMap = null;
        this.wizardIterator.setSourceType(sourceType);
        this.updateState();
        if (this.dialog == null) {
            this.dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this);
        }
        this.dialog.setVisible(true);
        this.dialog.dispose();
        return this.getValue() == FINISH_OPTION;
    }

    void stepToNext() {
        if (this.wizardIterator.hasNext()) {
            this.wizardIterator.nextPanel();
            this.updateState();
        }
    }

    void setJARFiles(File[] files) {
        this.selectedFiles = files;
    }

    File[] getJARFiles() {
        return this.selectedFiles;
    }

    void setSelectedBeans(BeanInstaller.ItemInfo[] beans) {
        this.selectedBeans = beans;
    }

    BeanInstaller.ItemInfo[] getSelectedBeans() {
        return this.selectedBeans;
    }

    void setSelectedCategory(String name) {
        this.selectedCategory = name;
    }

    String getSelectedCategory() {
        return this.selectedCategory;
    }

    String getSourceType() {
        return this.sourceType;
    }

    static class ATPWizardIterator
    implements WizardDescriptor.Iterator {
        WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[ATPWizardIterator.getPanelsCount()];
        int stage;

        ATPWizardIterator() {
        }

        void setSourceType(String sourceType) {
            if ("jar".equals(sourceType)) {
                this.panels[0] = new ChooseJARWizardPanel();
            } else if ("library".equals(sourceType)) {
                this.panels[0] = new ChooseLibraryWizardPanel();
            } else if ("project".equals(sourceType)) {
                this.panels[0] = new ChooseProjectWizardPanel();
            } else {
                throw new IllegalArgumentException();
            }
            this.panels[1] = new ChooseBeansWizardPanel();
            this.panels[2] = new ChooseCategoryWizardPanel();
            this.stage = 1;
        }

        static int getPanelsCount() {
            return 3;
        }

        public WizardDescriptor.Panel current() {
            return this.panels[this.stage - 1];
        }

        public boolean hasNext() {
            return this.stage < ATPWizardIterator.getPanelsCount();
        }

        public boolean hasPrevious() {
            return this.stage > 1;
        }

        public String name() {
            return "";
        }

        public void nextPanel() {
            if (this.stage < ATPWizardIterator.getPanelsCount()) {
                ++this.stage;
            }
        }

        public void previousPanel() {
            if (this.stage > 1) {
                --this.stage;
            }
        }

        public void addChangeListener(ChangeListener listener) {
        }

        public void removeChangeListener(ChangeListener listener) {
        }
    }
}

