/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.j2ee.sun.share.configbean.ASDDVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTableDialogPanelAccessor;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.ValidationSupport;

public class GenericTableDialogPanel
extends JPanel
implements GenericTableDialogPanelAccessor {
    private static final ResourceBundle bundle;
    private List fieldEntries;
    private String[] values;
    private JTextField[] textFields;
    private int preferredWidth;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void init(ASDDVersion asVersion, int width, List entries, Object data) {
        this.fieldEntries = entries;
        this.preferredWidth = width;
        this.values = new String[entries.size()];
        this.textFields = new JTextField[entries.size()];
        this.initUserComponents();
    }

    public void setValues(Object[] v) {
        if (v != null && v.length == this.values.length) {
            for (int i = 0; i < this.values.length && i < v.length; ++i) {
                this.values[i] = v[i] != null ? v[i].toString() : "";
            }
        } else {
            if (v != null && !$assertionsDisabled && v.length != this.values.length) {
                throw new AssertionError();
            }
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = "";
            }
        }
        this.setComponentValues();
    }

    public Object[] getValues() {
        return this.values;
    }

    private void setComponentValues() {
        for (int i = 0; i < this.values.length; ++i) {
            this.textFields[i].setText(this.values[i]);
        }
    }

    private void initUserComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(5, 5, 0, 5)));
        this.setPreferredSize(new Dimension(this.preferredWidth, 22 * this.fieldEntries.size() + 8));
        for (int i = 0; i < this.fieldEntries.size(); ++i) {
            GenericTableModel.TableEntry entry = (GenericTableModel.TableEntry)this.fieldEntries.get(i);
            JLabel requiredMark = new JLabel();
            JLabel label = new JLabel();
            this.textFields[i] = new JTextField();
            if (entry.isRequiredField()) {
                requiredMark.setText(bundle.getString("LBL_RequiredMark"));
                requiredMark.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_RequiredMark"));
                requiredMark.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_RequiredMark"));
            }
            requiredMark.setLabelFor(this.textFields[i]);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 4, 4);
            this.add((Component)requiredMark, gridBagConstraints);
            label.setLabelFor(this.textFields[i]);
            label.setText(entry.getLabelName());
            label.setDisplayedMnemonic(entry.getLabelMnemonic());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 4, 4);
            this.add((Component)label, gridBagConstraints);
            this.textFields[i].addKeyListener(new TextFieldHandler(this.textFields[i], i));
            this.textFields[i].getAccessibleContext().setAccessibleName(entry.getAccessibleName());
            this.textFields[i].getAccessibleContext().setAccessibleDescription(entry.getAccessibleDescription());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 4, 0);
            this.add((Component)this.textFields[i], gridBagConstraints);
        }
    }

    public Collection getErrors(ValidationSupport validationSupport) {
        ArrayList<String> errorList = new ArrayList<String>();
        for (int i = 0; i < this.fieldEntries.size(); ++i) {
            Object[] args;
            GenericTableModel.TableEntry entry = (GenericTableModel.TableEntry)this.fieldEntries.get(i);
            if (entry.isRequiredField() && !Utils.notEmpty(this.values[i])) {
                args = new Object[]{entry.getColumnName()};
                errorList.add(MessageFormat.format(bundle.getString("ERR_SpecifiedFieldIsEmpty"), args));
                continue;
            }
            if (!entry.isNameField() || !Utils.containsWhitespace(this.values[i])) continue;
            args = new Object[]{entry.getColumnName()};
            errorList.add(MessageFormat.format(bundle.getString("ERR_NameFieldContainsWhitespace"), args));
        }
        return errorList;
    }

    public boolean requiredFieldsFilled() {
        boolean result = true;
        for (int i = 0; i < this.fieldEntries.size(); ++i) {
            GenericTableModel.TableEntry entry = (GenericTableModel.TableEntry)this.fieldEntries.get(i);
            if (!entry.isRequiredField() || Utils.notEmpty(this.values[i])) continue;
            result = false;
            break;
        }
        return result;
    }

    static {
        $assertionsDisabled = !GenericTableDialogPanel.class.desiredAssertionStatus();
        bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    }

    private class TextFieldHandler
    extends KeyAdapter {
        private JTextField textField;
        private int controlIndex;

        public TextFieldHandler(JTextField tf, int index) {
            this.textField = tf;
            this.controlIndex = index;
        }

        public void keyReleased(KeyEvent evt) {
            ((GenericTableDialogPanel)GenericTableDialogPanel.this).values[this.controlIndex] = this.textField.getText();
            GenericTableDialogPanel.this.firePropertyChange("UserDataChanged", null, null);
        }
    }
}

