/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ServerString;
import org.netbeans.modules.j2ee.deployment.impl.TargetModuleConverter;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class TargetModule
implements TargetModuleID,
Serializable {
    private static final long serialVersionUID = 69446832504L;
    private final String id;
    private final String instanceUrl;
    private final String targetName;
    private final long timestamp;
    private final String contentDirectory;
    private final String contextRoot;
    private transient TargetModuleID delegate;
    public static final TargetModuleID[] EMPTY_TMID_ARRAY = new TargetModuleID[0];

    public TargetModule(String id, String url, long timestamp, String contentDir, String contextRoot, TargetModuleID delegate) {
        this(id, url, delegate.getTarget().getName(), timestamp, contentDir, contextRoot);
        this.delegate = delegate;
    }

    public TargetModule(String id, String url, String targetName, long timestamp, String contentDir, String contextRoot) {
        if (id == null || url == null || targetName == null || timestamp < 0L) {
            java.util.List<Object> args = Arrays.asList(id, url, targetName, new Long(timestamp));
            throw new IllegalArgumentException(NbBundle.getMessage(TargetModule.class, (String)"MSG_BadTargetModuleAttributes", args));
        }
        this.id = id;
        this.instanceUrl = url;
        this.targetName = targetName;
        this.timestamp = timestamp;
        this.contentDirectory = contentDir;
        this.contextRoot = contextRoot == null ? "" : contextRoot;
    }

    public TargetModule(String id, TargetModuleID delegate) {
        this(id, "someurl", 0L, null, null, delegate);
    }

    public String getId() {
        return this.id;
    }

    public String getInstanceUrl() {
        return this.instanceUrl;
    }

    public String getTargetName() {
        if (this.delegate != null) {
            return this.delegate.getTarget().getName();
        }
        return this.targetName;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getContentDirectory() {
        return this.contentDirectory;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public Target findTarget() {
        ServerInstance instance = ServerRegistry.getInstance().getServerInstance(this.instanceUrl);
        return instance.getServerTarget(this.targetName).getTarget();
    }

    public void initDelegate(ModuleType type) {
        if (this.delegate == null) {
            ServerInstance instance = ServerRegistry.getInstance().getServerInstance(this.instanceUrl);
            DeploymentManager dm = instance.getDeploymentManager();
            Target target = this.findTarget();
            try {
                TargetModuleID[] tmIDs = dm.getAvailableModules(type, new Target[]{target});
                for (int i = 0; i < tmIDs.length; ++i) {
                    if (!this.id.equals(tmIDs[i].toString())) continue;
                    this.delegate = tmIDs[i];
                    break;
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    public void initDelegate(TargetModuleID delegate) {
        this.delegate = delegate;
    }

    public static TargetModuleID[] toTargetModuleID(TargetModule[] targetModules) {
        if (targetModules == null) {
            return new TargetModuleID[0];
        }
        TargetModuleID[] ret = new TargetModuleID[targetModules.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = targetModules[i].delegate();
        }
        return ret;
    }

    public static Target[] toTarget(TargetModule[] targetModules) {
        if (targetModules == null) {
            return new Target[0];
        }
        Target[] ret = new Target[targetModules.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = targetModules[i].delegate().getTarget();
        }
        return ret;
    }

    public TargetModuleID delegate() {
        if (this.delegate == null) {
            throw new IllegalStateException("Delegate is not set yet");
        }
        return this.delegate;
    }

    public TargetModuleID[] getChildTargetModuleID() {
        return this.delegate().getChildTargetModuleID();
    }

    public String getModuleID() {
        return this.delegate().getModuleID();
    }

    public TargetModuleID getParentTargetModuleID() {
        return this.delegate().getParentTargetModuleID();
    }

    public Target getTarget() {
        return this.delegate().getTarget();
    }

    public String getWebURL() {
        return this.delegate().getWebURL();
    }

    public String toString() {
        if (this.delegate == null) {
            return this.id;
        }
        return this.delegate.toString();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TargetModuleID) {
            TargetModuleID that = (TargetModuleID)obj;
            return this.getModuleID().equals(that.getModuleID()) && this.getTargetName().equals(that.getTarget().getName());
        }
        return false;
    }

    public static java.util.List initDelegate(java.util.List targetModules, Map delegateTMIDsMap) {
        ArrayList<TargetModule> result = new ArrayList<TargetModule>();
        for (TargetModule tm : targetModules) {
            TargetModuleID tmid = (TargetModuleID)delegateTMIDsMap.get(tm.getId());
            if (tmid == null) continue;
            tm.initDelegate(tmid);
            result.add(tm);
        }
        return result;
    }

    public static java.util.List findByContextRoot(ServerString server, String contextRoot) {
        String managerDirName = TargetModule.getManagerDirName(server);
        String[] targetNames = server.getTargets(true);
        ArrayList targetModules = new ArrayList();
        for (int i = 0; i < targetNames.length; ++i) {
            String targDirName = TargetModule.getReadableName(targetNames[i]);
            java.util.List tml = TargetModuleConverter.getTargetModulesByContextRoot(managerDirName, targDirName, contextRoot);
            targetModules.addAll(tml);
        }
        return targetModules;
    }

    public static void removeByContextRoot(ServerString server, String contextRoot) {
        java.util.List tms = TargetModule.findByContextRoot(server, contextRoot);
        for (TargetModule tm : tms) {
            tm.remove();
        }
    }

    private static String getManagerDirName(ServerString server) {
        return TargetModule.getReadableName(server.getUrl());
    }

    private String getManagerDirName() {
        return TargetModule.getReadableName(this.getInstanceUrl());
    }

    public static TargetModule[] load(ServerString server, String fileName) {
        String managerDirName = TargetModule.getManagerDirName(server);
        String[] targetNames = server.getTargets(true);
        ArrayList<TargetModule> targetModules = new ArrayList<TargetModule>();
        for (int i = 0; i < targetNames.length; ++i) {
            String targDirName = TargetModule.getReadableName(targetNames[i]);
            TargetModule tm = TargetModuleConverter.readTargetModule(managerDirName, targDirName, fileName);
            if (tm == null) continue;
            targetModules.add(tm);
        }
        return targetModules.toArray(new TargetModule[targetModules.size()]);
    }

    public void save(String fileName) {
        TargetModuleConverter.writeTargetModule(this, this.getManagerDirName(), TargetModule.getReadableName(this.targetName), fileName);
    }

    public void remove() {
        String managerDirName = this.getManagerDirName();
        String targDirName = TargetModule.getReadableName(this.targetName);
        String fileName = TargetModule.shortNameFromPath(this.getContentDirectory());
        TargetModuleConverter.remove(managerDirName, targDirName, fileName);
    }

    public static String getReadableName(String s) {
        int code = s.hashCode();
        int end = 16;
        if (end > s.length()) {
            end = s.length();
        }
        StringBuffer sb = TargetModule.subStringBuffer(s, 0, end);
        sb.append(String.valueOf(code));
        return sb.toString();
    }

    public static StringBuffer subStringBuffer(String s, int start, int end) {
        StringBuffer sb = new StringBuffer(64);
        if (end < 0) {
            sb.append(s.substring(start));
        } else {
            sb.append(s.substring(start, end));
        }
        for (int i = 0; i < sb.length(); ++i) {
            if (Character.isLetterOrDigit(sb.charAt(i))) continue;
            sb.setCharAt(i, '_');
        }
        return sb;
    }

    public static String shortNameFromPath(String pathName) {
        int code = pathName.hashCode();
        int start = pathName.length() - 16;
        if (start < 0) {
            start = 0;
        }
        StringBuffer sb = TargetModule.subStringBuffer(pathName, start, -1);
        sb.append(String.valueOf(code));
        return sb.toString();
    }

    public static class List
    implements Serializable {
        private static final long serialVersionUID = 69446832514L;
        private TargetModule[] targetModules;

        public List(TargetModule[] targetModules) {
            this.targetModules = targetModules;
        }

        public List(TargetModule tm) {
            this.targetModules = new TargetModule[]{tm};
        }

        public TargetModule[] getTargetModules() {
            return this.targetModules;
        }
    }
}

