/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.sunresources.beans;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.sun.api.ResourceConfiguratorInterface;
import org.netbeans.modules.j2ee.sun.dd.api.DDProvider;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.AdminObjectResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.ConnectorConnectionPool;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.ConnectorResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JdbcConnectionPool;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JdbcResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.PropertyElement;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.Resources;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.ResourceUtils;
import org.netbeans.modules.j2ee.sun.share.serverresources.SunDatasource;
import org.netbeans.modules.j2ee.sun.sunresources.beans.DatabaseUtils;
import org.netbeans.modules.j2ee.sun.sunresources.beans.Field;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldGroup;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldGroupHelper;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldHelper;
import org.netbeans.modules.j2ee.sun.sunresources.beans.Wizard;
import org.netbeans.modules.j2ee.sun.sunresources.beans.WizardConstants;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public class ResourceConfigurator
implements ResourceConfiguratorInterface {
    public static final String __JMSResource = "jms";
    public static final String __JMSConnectionFactory = "jms_CF";
    public static final String __JdbcConnectionPool = "connection-pool";
    public static final String __SunResourceExt = "sun-resource";
    private static final char BLANK = ' ';
    private static final char DOT = '.';
    private static final char[] ILLEGAL_FILENAME_CHARS;
    private static final char REPLACEMENT_CHAR = '_';
    private static final char DASH = '-';
    public static final String __ConnectionPool = "ConnectionPool";
    private static final String DATAFILE = "org/netbeans/modules/j2ee/sun/sunresources/beans/CPWizard.xml";
    private boolean showMsg = false;
    private DeploymentManager currentDM = null;
    ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.ide.sunresources.beans.Bundle");
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setDeploymentManager(DeploymentManager dm) {
        this.currentDM = dm;
    }

    public boolean isJMSResourceDefined(String jndiName, File dir) {
        return this.resourceAlreadyDefined(jndiName, dir, __JMSResource);
    }

    public void createJMSResource(String jndiName, String msgDstnType, String msgDstnName, String ejbName, File dir) {
        try {
            Resources resources = DDProvider.getDefault().getResourcesGraph();
            AdminObjectResource aoresource = resources.newAdminObjectResource();
            aoresource.setJndiName(jndiName);
            aoresource.setResType(msgDstnType);
            aoresource.setResAdapter("jmsra");
            aoresource.setEnabled("true");
            aoresource.setDescription("");
            PropertyElement prop = aoresource.newPropertyElement();
            prop.setName("Name");
            prop.setValue(ejbName);
            aoresource.addPropertyElement(prop);
            resources.addAdminObjectResource(aoresource);
            this.createFile(dir, jndiName, __JMSResource, resources);
            resources = DDProvider.getDefault().getResourcesGraph();
            ConnectorResource connresource = resources.newConnectorResource();
            ConnectorConnectionPool connpoolresource = resources.newConnectorConnectionPool();
            String connectionFactoryJndiName = "jms/" + msgDstnName + "Factory";
            connresource.setJndiName(connectionFactoryJndiName);
            connresource.setDescription("");
            connresource.setEnabled("true");
            connresource.setPoolName(connectionFactoryJndiName);
            connpoolresource.setName(connectionFactoryJndiName);
            connpoolresource.setResourceAdapterName("jmsra");
            if (msgDstnType.equals("javax.jms.Queue")) {
                connpoolresource.setConnectionDefinitionName("javax.jms.QueueConnectionFactory");
            } else if (msgDstnType.equals("javax.jms.Topic")) {
                connpoolresource.setConnectionDefinitionName("javax.jms.TopicConnectionFactory");
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            resources.addConnectorResource(connresource);
            resources.addConnectorConnectionPool(connpoolresource);
            this.createFile(dir, jndiName, __JMSConnectionFactory, resources);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
        }
    }

    public void createJDBCDataSourceFromRef(String refName, String databaseInfo, File dir) {
    }

    public String createJDBCDataSourceForCmp(String beanName, String databaseInfo, File dir) {
        return null;
    }

    private void createFile(File targetFolder, String beanName, String resourceType, Resources res) throws IOException {
        if (resourceType.indexOf("/") != -1) {
            resourceType = resourceType.substring(0, resourceType.indexOf("/")) + "_" + resourceType.substring(resourceType.indexOf("/") + 1, resourceType.length());
        }
        if (resourceType.indexOf("\\") != -1) {
            resourceType = resourceType.substring(0, resourceType.indexOf("\\")) + "_" + resourceType.substring(resourceType.indexOf("\\") + 1, resourceType.length());
        }
        this.ensureFolderExists(targetFolder);
        String filename = this.getFileName(beanName, resourceType);
        File resourceFile = new File(targetFolder, filename);
        if (!resourceFile.exists()) {
            res.write((OutputStream)new BufferedOutputStream(new FileOutputStream(resourceFile)));
        }
    }

    private boolean isLegalFilename(String filename) {
        for (int i = 0; i < ILLEGAL_FILENAME_CHARS.length; ++i) {
            if (filename.indexOf(ILLEGAL_FILENAME_CHARS[i]) < 0) continue;
            return false;
        }
        return true;
    }

    private boolean isFriendlyFilename(String filename) {
        if (filename.indexOf(32) >= 0 || filename.indexOf(46) >= 0) {
            return false;
        }
        return this.isLegalFilename(filename);
    }

    private String makeLegalFilename(String filename) {
        for (int i = 0; i < ILLEGAL_FILENAME_CHARS.length; ++i) {
            filename = filename.replace(ILLEGAL_FILENAME_CHARS[i], '_');
        }
        return filename;
    }

    private String makeShorterLegalFilename(String filename) {
        if (filename.indexOf("://") != -1) {
            filename = filename.substring(0, filename.indexOf("://")) + "_" + filename.substring(filename.indexOf("://") + 3, filename.length());
        }
        if (filename.indexOf("//") != -1) {
            filename = filename.substring(0, filename.indexOf("//")) + "_" + filename.substring(filename.indexOf("//") + 2, filename.length());
        }
        filename = this.makeLegalFilename(filename);
        return filename;
    }

    private void ensureFolderExists(File folder) throws IOException {
        if (!folder.exists()) {
            folder.mkdir();
        }
    }

    private String getFileName(String beanName, String resourceType) {
        if (!$assertionsDisabled && beanName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && beanName.length() == 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && resourceType == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && resourceType.length() == 0) {
            throw new AssertionError();
        }
        String fileName = resourceType;
        if (!this.isFriendlyFilename(beanName)) {
            beanName = this.makeLegalFilename(beanName);
        }
        if (!this.isFriendlyFilename(fileName)) {
            fileName = this.makeLegalFilename(fileName);
        }
        fileName = fileName + '-' + beanName + '.' + __SunResourceExt;
        return fileName;
    }

    private JdbcConnectionPool setDerbyProps(String vendorName, String url, JdbcConnectionPool jdbcConnectionPool) {
        url = this.stripExtraDBInfo(url);
        String workingUrl = url.substring(url.indexOf("//") + 2, url.length());
        String hostName = this.getDerbyServerName(workingUrl);
        PropertyElement servName = jdbcConnectionPool.newPropertyElement();
        servName.setName("serverName");
        servName.setValue(hostName);
        String portNumber = this.getDerbyPortNo(workingUrl);
        PropertyElement portno = jdbcConnectionPool.newPropertyElement();
        portno.setName("PortNumber");
        portno.setValue(portNumber);
        String databaseName = this.getDerbyDatabaseName(workingUrl);
        PropertyElement dbName = jdbcConnectionPool.newPropertyElement();
        dbName.setName("DatabaseName");
        dbName.setValue(databaseName);
        String connectionAttr = this.getDerbyConnAttrs(workingUrl);
        if (!connectionAttr.equals("")) {
            PropertyElement connAttr = jdbcConnectionPool.newPropertyElement();
            connAttr.setName("connectionAttributes");
            connAttr.setValue(connectionAttr);
            jdbcConnectionPool.addPropertyElement(connAttr);
        }
        jdbcConnectionPool.addPropertyElement(servName);
        jdbcConnectionPool.addPropertyElement(portno);
        jdbcConnectionPool.addPropertyElement(dbName);
        return jdbcConnectionPool;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JdbcConnectionPool setAdditionalProps(String vendorName, String url, JdbcConnectionPool jdbcConnectionPool) {
        String workingUrl = url = this.stripExtraDBInfo(url);
        if (vendorName.equals("sybase2")) {
            int index = url.indexOf("Tds:");
            if (index == -1) return jdbcConnectionPool;
            workingUrl = url.substring(index + 4, url.length());
        } else {
            workingUrl = url.substring(url.indexOf("//") + 2, url.length());
        }
        String hostName = this.getUrlServerName(workingUrl);
        PropertyElement servName = jdbcConnectionPool.newPropertyElement();
        servName.setName("serverName");
        servName.setValue(hostName);
        String portNumber = this.getUrlPortNo(workingUrl);
        PropertyElement portno = jdbcConnectionPool.newPropertyElement();
        portno.setName("portNumber");
        portno.setValue(portNumber);
        if (Arrays.asList(WizardConstants.VendorsDBNameProp).contains(vendorName)) {
            PropertyElement dbName = jdbcConnectionPool.newPropertyElement();
            String databaseName = "";
            if (vendorName.equals("sun_oracle") || vendorName.equals("datadirect_oracle")) {
                databaseName = this.getUrlSIDName(workingUrl);
                dbName.setName("SID");
            } else {
                databaseName = this.getUrlDatabaseName(workingUrl);
                dbName.setName("databaseName");
                if (databaseName.equals("")) {
                    databaseName = this.getUrlDbName(workingUrl);
                }
            }
            dbName.setValue(databaseName);
            jdbcConnectionPool.addPropertyElement(dbName);
        }
        jdbcConnectionPool.addPropertyElement(servName);
        jdbcConnectionPool.addPropertyElement(portno);
        return jdbcConnectionPool;
    }

    private JdbcConnectionPool setDBProp(String vendorName, String url, JdbcConnectionPool jdbcConnectionPool) {
        url = this.stripExtraDBInfo(url);
        String workingUrl = url.substring(url.indexOf("//") + 2, url.length());
        String databaseName = this.getUrlDatabaseName(workingUrl);
        PropertyElement dbName = jdbcConnectionPool.newPropertyElement();
        dbName.setName("DatabaseName");
        dbName.setValue(databaseName);
        jdbcConnectionPool.addPropertyElement(dbName);
        return jdbcConnectionPool;
    }

    private String getDatasourceClassName(String vendorName, boolean isXA, Wizard wizard) {
        if (vendorName == null) {
            return null;
        }
        try {
            FieldGroup generalGroup = FieldGroupHelper.getFieldGroup(wizard, "general");
            Field dsField = null;
            dsField = isXA ? FieldHelper.getField(generalGroup, "datasource-classname-xa") : FieldHelper.getField(generalGroup, "datasource-classname");
            return FieldHelper.getConditionalFieldValue(dsField, vendorName);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getDatabaseVendorName(String url, Wizard wizard) {
        String vendorName = "";
        try {
            if (wizard == null) {
                wizard = ResourceConfigurator.getWizardInfo();
            }
            FieldGroup propGroup = FieldGroupHelper.getFieldGroup(wizard, "propertiesUrl");
            Field urlField = FieldHelper.getField(propGroup, "vendorUrls");
            vendorName = FieldHelper.getOptionNameFromValue(urlField, url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vendorName;
    }

    private String convertToValidName(String database) {
        String vendorName = ResourceConfigurator.getDatabaseVendorName(database = this.stripExtraDBInfo(database), null);
        if (vendorName != null) {
            if (!vendorName.equals("")) {
                if (!this.isFriendlyFilename(vendorName)) {
                    vendorName = this.makeLegalFilename(vendorName);
                }
                this.showMsg = false;
            } else {
                this.showMsg = true;
                vendorName = this.makeShorterLegalFilename(database);
            }
        }
        return vendorName;
    }

    private String getDatabaseName(String database) {
        String result = null;
        int index = database.lastIndexOf(47) + 1;
        if (index > 0) {
            result = database.substring(index);
        }
        return result;
    }

    private String getResourceType(boolean isXA) {
        if (isXA) {
            return "javax.sql.XADataSource";
        }
        return "javax.sql.DataSource";
    }

    private boolean resourceAlreadyDefined(String resName, File dir, String resType) {
        String filename;
        File resourceFile;
        boolean result = false;
        if (dir != null && dir.exists() && (resourceFile = new File(dir, filename = this.getFileName(resName, resType))).exists()) {
            result = true;
        }
        return result;
    }

    private String isSameDatabaseConnection(File resourceFile, String databaseUrl, String username, String password) {
        String poolJndiName = null;
        try {
            FileInputStream in;
            block15: {
                PropertyElement[] pl;
                JdbcConnectionPool connPool;
                block16: {
                    in = new FileInputStream(resourceFile);
                    Resources resources = DDProvider.getDefault().getResourcesGraph((InputStream)in);
                    JdbcConnectionPool[] pools = resources.getJdbcConnectionPool();
                    if (pools.length == 0) break block15;
                    connPool = pools[0];
                    pl = connPool.getPropertyElement();
                    if (!databaseUrl.startsWith("jdbc:derby:")) break block16;
                    databaseUrl = this.stripExtraDBInfo(databaseUrl);
                    String workingUrl = databaseUrl.substring(databaseUrl.indexOf("//") + 2, databaseUrl.length());
                    String hostName = this.getDerbyServerName(workingUrl);
                    String portNumber = this.getDerbyPortNo(workingUrl);
                    String databaseName = this.getDerbyDatabaseName(workingUrl);
                    String hostProp = null;
                    String portProp = null;
                    String dbProp = null;
                    String dbUser = null;
                    String dbPwd = null;
                    for (int i = 0; i < pl.length; ++i) {
                        String prop = pl[i].getName();
                        if (prop.equalsIgnoreCase("serverName")) {
                            hostProp = pl[i].getValue();
                            continue;
                        }
                        if (prop.equals("PortNumber")) {
                            portProp = pl[i].getValue();
                            continue;
                        }
                        if (prop.equals("DatabaseName")) {
                            dbProp = pl[i].getValue();
                            continue;
                        }
                        if (prop.equals("User")) {
                            dbUser = pl[i].getValue();
                            continue;
                        }
                        if (!prop.equals("Password")) continue;
                        dbPwd = pl[i].getValue();
                    }
                    if (!hostName.equals(hostProp) || !portNumber.equals(portProp) || !databaseName.equals(dbProp) || dbUser == null || dbPwd == null || !dbUser.equals(username) || !dbPwd.equals(password)) break block15;
                    poolJndiName = connPool.getName();
                    break block15;
                }
                String hostName = "";
                String portNumber = "";
                String databaseName = "";
                String sid = "";
                String user = "";
                String pwd = "";
                for (int i = 0; i < pl.length; ++i) {
                    String prop = pl[i].getName();
                    if (prop.equalsIgnoreCase("serverName")) {
                        hostName = pl[i].getValue();
                        continue;
                    }
                    if (prop.equals("portNumber")) {
                        portNumber = pl[i].getValue();
                        continue;
                    }
                    if (prop.equals("databaseName")) {
                        databaseName = pl[i].getValue();
                        continue;
                    }
                    if (prop.equals("SID")) {
                        sid = pl[i].getValue();
                        continue;
                    }
                    if (prop.equals("User")) {
                        user = pl[i].getValue();
                        continue;
                    }
                    if (!prop.equals("Password")) continue;
                    pwd = pl[i].getValue();
                }
                String serverPort = hostName + ":" + portNumber;
                if (databaseUrl.indexOf(serverPort) != -1 && (databaseUrl.indexOf(databaseName) != -1 || databaseUrl.indexOf(sid) != -1) && username != null && user.equals(username) && password != null && pwd.equals(password)) {
                    poolJndiName = connPool.getName();
                }
                for (int i = 0; i < pl.length; ++i) {
                    String urlValue;
                    String prop = pl[i].getName();
                    if (!prop.equals("URL") && !prop.equals("databaseName") || !(urlValue = pl[i].getValue()).equals(databaseUrl) || username == null || !user.equals(username) || password == null || !pwd.equals(password)) continue;
                    poolJndiName = connPool.getName();
                    break;
                }
            }
            in.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return poolJndiName;
    }

    private String stripExtraDBInfo(String dbConnectionString) {
        if (dbConnectionString.indexOf("[") != -1) {
            dbConnectionString = dbConnectionString.substring(0, dbConnectionString.indexOf("[")).trim();
        }
        return dbConnectionString;
    }

    public static void showInformation(final String msg) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)msg, 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            }
        });
    }

    private static Wizard getWizardInfo() {
        Wizard wizard = null;
        try {
            InputStream in = Wizard.class.getClassLoader().getResourceAsStream(DATAFILE);
            wizard = Wizard.createGraph(in);
            in.close();
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
        }
        return wizard;
    }

    private String getDerbyServerName(String url) {
        String hostName = "";
        int index = url.indexOf(":");
        if (index != -1) {
            hostName = url.substring(0, index);
        } else {
            index = url.indexOf("/");
            if (index != -1) {
                hostName = url.substring(0, index);
            }
        }
        return hostName;
    }

    private String getDerbyPortNo(String url) {
        String portNumber = "1527";
        int index = url.indexOf(":");
        if (index != -1) {
            portNumber = url.substring(index + 1, url.indexOf("/"));
        }
        return portNumber;
    }

    private String getDerbyDatabaseName(String url) {
        String databaseName = "";
        int index = url.indexOf("/");
        if (index != -1) {
            int colonIndex = url.indexOf(";");
            databaseName = colonIndex != -1 ? url.substring(index + 1, colonIndex) : url.substring(index + 1, url.length());
        }
        return databaseName;
    }

    private String getDerbyConnAttrs(String url) {
        String connAttr = "";
        int colonIndex = url.indexOf(";");
        if (colonIndex != -1) {
            connAttr = url.substring(colonIndex, url.length());
        }
        return connAttr;
    }

    private String getUrlServerName(String url) {
        String hostName = "";
        int index = url.indexOf(":");
        if (index != -1) {
            hostName = url.substring(0, index);
        } else {
            index = url.indexOf("/");
            if (index != -1) {
                hostName = url.substring(0, index);
            } else {
                index = url.indexOf(";");
                if (index != -1) {
                    hostName = url.substring(0, index);
                }
            }
        }
        return hostName;
    }

    private String getUrlPortNo(String url) {
        String portNumber = "";
        int index = url.indexOf(":");
        if (index != -1) {
            int slashIndex = url.indexOf("/");
            int colonIndex = url.indexOf(";");
            portNumber = slashIndex != -1 ? url.substring(index + 1, slashIndex) : (colonIndex != -1 ? url.substring(index + 1, colonIndex) : url.substring(index + 1, url.length()));
        }
        return portNumber;
    }

    private String getUrlDatabaseName(String url) {
        String databaseName = "";
        int dbIndex = url.indexOf(";databaseName=");
        if (dbIndex != -1) {
            int eqIndex = url.indexOf("=", dbIndex);
            int lenIndex = url.indexOf(";", eqIndex);
            databaseName = lenIndex != -1 ? url.substring(eqIndex + 1, lenIndex) : url.substring(eqIndex + 1, url.length());
        }
        return databaseName;
    }

    private String getUrlSIDName(String url) {
        String databaseName = "";
        int sidIndex = url.indexOf(";SID=");
        if (sidIndex != -1) {
            int eqIndex = url.indexOf("=", sidIndex);
            databaseName = url.substring(eqIndex + 1, url.length());
        }
        return databaseName;
    }

    private String getUrlDbName(String url) {
        String databaseName = "";
        int slashIndex = url.indexOf("/");
        int clIndex = url.indexOf(";", slashIndex);
        int scIndex = url.indexOf(":", slashIndex);
        int qIndex = url.indexOf("?", slashIndex);
        if (slashIndex != -1) {
            databaseName = clIndex != -1 ? url.substring(slashIndex + 1, clIndex) : (scIndex != -1 ? url.substring(slashIndex + 1, scIndex) : (qIndex != -1 ? url.substring(slashIndex + 1, qIndex) : url.substring(slashIndex + 1, url.length())));
        }
        return databaseName;
    }

    public HashSet getServerDataSources() {
        return ResourceUtils.getServerDataSources(this.currentDM);
    }

    public HashSet getResources(File resourceDir) {
        HashSet serverresources = this.getServerResourceFiles(resourceDir);
        if (serverresources.size() == 0) {
            return serverresources;
        }
        HashSet<SunDatasource> dsources = new HashSet<SunDatasource>();
        HashMap connPools = this.getConnectionPools(serverresources);
        List dataSources = this.getJdbcResources(serverresources);
        for (int i = 0; i < dataSources.size(); ++i) {
            JdbcResource datasourceBean = (JdbcResource)dataSources.get(i);
            String poolName = datasourceBean.getPoolName();
            try {
                JdbcConnectionPool connectionPoolBean = (JdbcConnectionPool)connPools.get(poolName);
                String url = "";
                String username = "";
                String password = "";
                String driverClass = "";
                String serverName = "";
                String portNo = "";
                String dbName = "";
                String sid = "";
                if (connectionPoolBean != null) {
                    DatabaseConnection databaseConnection;
                    PropertyElement[] props = connectionPoolBean.getPropertyElement();
                    driverClass = connectionPoolBean.getDatasourceClassname();
                    HashMap properties = new HashMap();
                    for (int j = 0; j < props.length; ++j) {
                        String propName;
                        String val = props[j].getValue();
                        String propValue = "";
                        if (val != null) {
                            propValue = val.toString();
                        }
                        if ((propName = props[j].getName()).equalsIgnoreCase("databaseName")) {
                            if (driverClass.indexOf("pointbase") != -1) {
                                url = propValue;
                                continue;
                            }
                            if (driverClass.indexOf("derby") != -1) {
                                dbName = propValue;
                                continue;
                            }
                            dbName = propValue;
                            continue;
                        }
                        if (propName.equalsIgnoreCase("User")) {
                            username = propValue;
                            continue;
                        }
                        if (propName.equalsIgnoreCase("Password")) {
                            password = propValue;
                            continue;
                        }
                        if (propName.equalsIgnoreCase("URL")) {
                            url = propValue;
                            continue;
                        }
                        if (propName.equalsIgnoreCase("serverName")) {
                            serverName = propValue;
                            continue;
                        }
                        if (propName.equalsIgnoreCase("PortNumber")) {
                            portNo = propValue;
                            continue;
                        }
                        if (!propName.equalsIgnoreCase("SID")) continue;
                        sid = propValue;
                    }
                    if (driverClass.indexOf("derby") != -1) {
                        url = "jdbc:derby://";
                        if (serverName != null) {
                            url = url + serverName;
                            if (portNo != null) {
                                url = url + ":" + portNo;
                            }
                            url = url + "/" + dbName;
                        }
                    } else if (url.equals("")) {
                        String urlPrefix = DatabaseUtils.getUrlPrefix(driverClass);
                        String vName = ResourceConfigurator.getDatabaseVendorName(urlPrefix, null);
                        if (serverName != null) {
                            url = vName.equals("sybase2") ? urlPrefix + serverName : urlPrefix + "//" + serverName;
                            if (portNo != null) {
                                url = url + ":" + portNo;
                            }
                        }
                        if (vName.equals("sun_oracle") || vName.equals("datadirect_oracle")) {
                            url = url + ";SID=" + sid;
                        } else if (Arrays.asList(WizardConstants.Reqd_DBName).contains(vName)) {
                            url = url + ";databaseName=" + dbName;
                        } else if (Arrays.asList(WizardConstants.VendorsDBNameProp).contains(vName)) {
                            url = url + "/" + dbName;
                        }
                    }
                    if ((databaseConnection = ResourceUtils.getDatabaseConnection(url)) != null) {
                        driverClass = databaseConnection.getDriverClass();
                    } else {
                        String drivername = DatabaseUtils.getDriverName(url);
                        if (drivername != null) {
                            driverClass = drivername;
                        }
                    }
                    SunDatasource sunResource = new SunDatasource(datasourceBean.getJndiName(), url, username, password, driverClass);
                    sunResource.setResourceDir(resourceDir);
                    dsources.add(sunResource);
                    continue;
                }
                HashMap poolValues = ResourceUtils.getConnPoolValues(resourceDir, poolName);
                if (poolValues.isEmpty()) continue;
                username = (String)poolValues.get("User");
                password = (String)poolValues.get("Password");
                url = (String)poolValues.get("URL");
                driverClass = (String)poolValues.get("driverClassName");
                if (url == null || url.equals("")) continue;
                SunDatasource sunResource = new SunDatasource(datasourceBean.getJndiName(), url, username, password, driverClass);
                sunResource.setResourceDir(resourceDir);
                dsources.add(sunResource);
                continue;
            }
            catch (Exception ex) {
                ErrorManager.getDefault().log(1, "Cannot construct SunDatasource for jdbc resource : " + datasourceBean.getJndiName() + "with pool " + poolName);
            }
        }
        return dsources;
    }

    public SunDatasource createDataSource(String jndiName, String url, String username, String password, String driver, File dir) throws DatasourceAlreadyExistsException {
        SunDatasource ds = null;
        try {
            if (this.isDataSourcePresent(jndiName, dir)) {
                throw new DatasourceAlreadyExistsException((Datasource)new SunDatasource(jndiName, url, username, password, driver));
            }
            if (url != null) {
                String vendorName = this.convertToValidName(url);
                if (vendorName == null) {
                    vendorName = jndiName;
                } else if (vendorName.equals("derby_embedded")) {
                    NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)this.bundle.getString("Err_UnSupportedDerby"), 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                    return null;
                }
                this.ensureFolderExists(dir);
                String poolName = vendorName + "Pool";
                HashMap poolMap = this.updatePoolName(jndiName, poolName, dir, url, username, password);
                Object[] pools = poolMap.keySet().toArray();
                String newPoolName = (String)pools[0];
                Object resFile = poolMap.get(pools[0]);
                if (resFile != null) {
                    if (this.resourceFileExists(jndiName, dir)) {
                        ds = null;
                    } else {
                        this.createJDBCResource(jndiName, newPoolName, dir);
                        ds = new SunDatasource(jndiName, url, username, password, driver);
                    }
                } else {
                    this.createCPPoolResource(newPoolName, url, username, password, driver, dir);
                    this.createJDBCResource(jndiName, newPoolName, dir);
                    ds = new SunDatasource(jndiName, url, username, password, driver);
                }
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
        }
        return ds;
    }

    private void createCPPoolResource(String name, String databaseUrl, String username, String password, String driver, File resourceDir) throws IOException {
        Resources resources = DDProvider.getDefault().getResourcesGraph();
        JdbcConnectionPool jdbcConnectionPool = resources.newJdbcConnectionPool();
        jdbcConnectionPool.setName(name);
        jdbcConnectionPool.setResType(this.getResourceType(false));
        Wizard wizard = ResourceConfigurator.getWizardInfo();
        String vendorName = ResourceConfigurator.getDatabaseVendorName(databaseUrl, wizard);
        String datasourceClassName = "";
        if (!vendorName.equals("")) {
            datasourceClassName = this.getDatasourceClassName(vendorName, false, wizard);
        }
        if (datasourceClassName.equals("") && ((datasourceClassName = DatabaseUtils.getDSClassName(databaseUrl)) == null || datasourceClassName.equals(""))) {
            datasourceClassName = driver;
        }
        if (datasourceClassName != null) {
            jdbcConnectionPool.setDatasourceClassname(datasourceClassName);
        }
        PropertyElement user = jdbcConnectionPool.newPropertyElement();
        user.setName("User");
        PropertyElement passElement = jdbcConnectionPool.newPropertyElement();
        passElement.setName("Password");
        String dbUser = username;
        String dbPassword = password;
        if (vendorName.equals("derby_net")) {
            jdbcConnectionPool = this.setDerbyProps(vendorName, databaseUrl, jdbcConnectionPool);
            if (dbUser == null || dbUser.trim().length() == 0) {
                dbUser = "app";
            }
            if (dbPassword == null || dbPassword.trim().length() == 0) {
                dbPassword = "app";
            }
        } else if (Arrays.asList(WizardConstants.VendorsExtraProps).contains(vendorName)) {
            jdbcConnectionPool = this.setAdditionalProps(vendorName, databaseUrl, jdbcConnectionPool);
        } else {
            PropertyElement databaseOrUrl = jdbcConnectionPool.newPropertyElement();
            if (vendorName.equals("pointbase")) {
                databaseOrUrl.setName("databaseName");
            } else {
                databaseOrUrl.setName("URL");
            }
            databaseOrUrl.setValue(databaseUrl);
            jdbcConnectionPool.addPropertyElement(databaseOrUrl);
        }
        user.setValue(dbUser);
        jdbcConnectionPool.addPropertyElement(user);
        passElement.setValue(dbPassword);
        jdbcConnectionPool.addPropertyElement(passElement);
        resources.addJdbcConnectionPool(jdbcConnectionPool);
        ResourceUtils.createFile(FileUtil.toFileObject((File)resourceDir), name, resources);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private void createJDBCResource(String jndiName, String poolName, File resourceDir) throws IOException {
        Resources resources = DDProvider.getDefault().getResourcesGraph();
        JdbcResource jdbcResource = resources.newJdbcResource();
        jdbcResource.setPoolName(poolName);
        jdbcResource.setJndiName(jndiName);
        resources.addJdbcResource(jdbcResource);
        ResourceUtils.createFile(FileUtil.toFileObject((File)resourceDir), jndiName, resources);
    }

    private HashSet getServerResourceFiles(File resourceDir) {
        HashSet<FileObject> serverresources = new HashSet<FileObject>();
        if (resourceDir.exists()) {
            FileObject resDir = FileUtil.toFileObject((File)resourceDir);
            Enumeration files = resDir.getChildren(true);
            while (files.hasMoreElements()) {
                FileObject file = (FileObject)files.nextElement();
                if (file.isFolder() || !file.getNameExt().endsWith(".sun-resource") || !file.canRead()) continue;
                serverresources.add(file);
            }
        }
        return serverresources;
    }

    private List getJdbcResources(HashSet serverresources) {
        ArrayList<JdbcResource> dataSources = new ArrayList<JdbcResource>();
        Iterator it = serverresources.iterator();
        while (it.hasNext()) {
            try {
                FileObject dsObj = (FileObject)it.next();
                File dsFile = FileUtil.toFile((FileObject)dsObj);
                if (dsFile.isDirectory()) continue;
                FileInputStream in = new FileInputStream(dsFile);
                Resources resources = DDProvider.getDefault().getResourcesGraph((InputStream)in);
                JdbcResource[] dSources = resources.getJdbcResource();
                if (dSources.length == 0) continue;
                dataSources.add(dSources[0]);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return dataSources;
    }

    private HashMap getConnectionPools(HashSet serverresources) {
        HashMap<String, JdbcConnectionPool> connPools = new HashMap<String, JdbcConnectionPool>();
        Iterator it = serverresources.iterator();
        while (it.hasNext()) {
            try {
                FileObject dsObj = (FileObject)it.next();
                File dsFile = FileUtil.toFile((FileObject)dsObj);
                if (dsFile.isDirectory()) continue;
                FileInputStream in = new FileInputStream(dsFile);
                Resources resources = DDProvider.getDefault().getResourcesGraph((InputStream)in);
                JdbcConnectionPool[] pools = resources.getJdbcConnectionPool();
                if (pools.length == 0) continue;
                JdbcConnectionPool cp = pools[0];
                connPools.put(cp.getName(), cp);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return connPools;
    }

    private HashMap getPoolFiles(HashSet serverresources) {
        HashMap<String, File> connPools = new HashMap<String, File>();
        Iterator it = serverresources.iterator();
        while (it.hasNext()) {
            try {
                FileObject dsObj = (FileObject)it.next();
                File dsFile = FileUtil.toFile((FileObject)dsObj);
                if (dsFile.isDirectory()) continue;
                FileInputStream in = new FileInputStream(dsFile);
                Resources resources = DDProvider.getDefault().getResourcesGraph((InputStream)in);
                JdbcConnectionPool[] pools = resources.getJdbcConnectionPool();
                if (pools.length == 0) continue;
                connPools.put(dsObj.getName(), dsFile);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return connPools;
    }

    private boolean isDataSourcePresent(String jndiName, File dir) {
        boolean exists = false;
        HashMap serverResources = this.getDataSourceMap(this.getResources(dir));
        if (serverResources.containsKey(jndiName)) {
            exists = true;
        }
        return exists;
    }

    private HashMap getDataSourceMap(HashSet resources) {
        HashMap<String, SunDatasource> dSources = new HashMap<String, SunDatasource>();
        Iterator it = resources.iterator();
        while (it.hasNext()) {
            SunDatasource ds = (SunDatasource)it.next();
            dSources.put(ds.getJndiName(), ds);
        }
        return dSources;
    }

    private HashMap updatePoolName(String dsJndiName, String poolName, File dir, String url, String username, String password) {
        HashMap<String, File> poolAndFile = new HashMap<String, File>();
        String cpName = poolName;
        HashSet resourceFiles = this.getServerResourceFiles(dir);
        HashMap poolFiles = this.getPoolFiles(resourceFiles);
        Iterator itr = poolFiles.values().iterator();
        while (itr.hasNext()) {
            String poolJndiName;
            File resourceFile = (File)itr.next();
            if (resourceFile == null || !resourceFile.exists() || (poolJndiName = this.isSameDatabaseConnection(resourceFile, url, username, password)) == null) continue;
            cpName = poolJndiName;
            poolAndFile.put(cpName, resourceFile);
            break;
        }
        if (poolAndFile.size() == 0) {
            cpName = FileUtil.findFreeFileName((FileObject)FileUtil.toFileObject((File)dir), (String)poolName, (String)__SunResourceExt);
            poolAndFile.put(cpName, null);
        }
        return poolAndFile;
    }

    private File getResourceFile(String fileName, File dir) {
        File resourceFile = null;
        if (dir != null && dir.exists()) {
            String filename = fileName + '.' + __SunResourceExt;
            resourceFile = new File(dir, filename);
        }
        return resourceFile;
    }

    private boolean resourceFileExists(String resName, File dir) {
        String filename;
        File resourceFile;
        boolean result = false;
        if (dir != null && dir.exists() && (resourceFile = new File(dir, filename = resName + '.' + __SunResourceExt)).exists()) {
            result = true;
        }
        return result;
    }

    static {
        $assertionsDisabled = !ResourceConfigurator.class.desiredAssertionStatus();
        ILLEGAL_FILENAME_CHARS = new char[]{'/', '\\', ':', '*', '?', '\"', '<', '>', '|', ',', '=', ';'};
    }
}

