/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.dd.api;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.dd.api.DDException;
import org.netbeans.modules.j2ee.sun.dd.api.RootInterface;
import org.netbeans.modules.j2ee.sun.dd.api.app.SunApplication;
import org.netbeans.modules.j2ee.sun.dd.api.client.SunApplicationClient;
import org.netbeans.modules.j2ee.sun.dd.api.ejb.SunEjbJar;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.Resources;
import org.netbeans.modules.j2ee.sun.dd.api.web.SunWebApp;
import org.netbeans.modules.j2ee.sun.dd.impl.app.SunApplicationProxy;
import org.netbeans.modules.j2ee.sun.dd.impl.client.SunApplicationClientProxy;
import org.netbeans.modules.j2ee.sun.dd.impl.common.SunBaseBean;
import org.netbeans.modules.j2ee.sun.dd.impl.ejb.SunEjbJarProxy;
import org.netbeans.modules.j2ee.sun.dd.impl.serverresources.ResourcesProxy;
import org.netbeans.modules.j2ee.sun.dd.impl.web.SunWebAppProxy;
import org.netbeans.modules.schema2beans.BaseBean;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DDProvider {
    private static final String EJB_30_90_DOCTYPE = "-//Sun Microsystems, Inc.//DTD Application Server 9.0 EJB 3.0//EN";
    private static final String EJB_21_81_DOCTYPE = "-//Sun Microsystems, Inc.//DTD Application Server 8.1 EJB 2.1//EN";
    private static final String EJB_21_80_DOCTYPE = "-//Sun Microsystems, Inc.//DTD Application Server 8.0 EJB 2.1//EN";
    private static final String EJB_20_70_DOCTYPE_SUNONE = "-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 EJB 2.0//EN";
    private static final String EJB_21_80_DOCTYPE_SUNONE = "-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 8.0 EJB 2.1//EN";
    private static final String WEB_25_90_DOCTYPE = "-//Sun Microsystems, Inc.//DTD Application Server 9.0 Servlet 2.5//EN";
    private static final String WEB_21_81_DOCTYPE = "-//Sun Microsystems, Inc.//DTD Application Server 8.1 Servlet 2.4//EN";
    private static final String WEB_21_80_DOCTYPE = "-//Sun Microsystems, Inc.//DTD Application Server 8.0 Servlet 2.4//EN";
    private static final String WEB_20_70_DOCTYPE_SUNONE = "-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 Servlet 2.3//EN";
    private static final String WEB_21_80_DOCTYPE_SUNONE = "-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 8.0 Servlet 2.4//EN";
    private static final String APP_50_90_DOCTYPE = "-//Sun Microsystems, Inc.//DTD Application Server 9.0 Java EE Application 5.0//EN";
    private static final String APP_14_81_DOCTYPE = "-//Sun Microsystems, Inc.//DTD Application Server 8.1 J2EE Application 1.4//EN";
    private static final String APP_14_80_DOCTYPE = "-//Sun Microsystems, Inc.//DTD Application Server 8.0 J2EE Application 1.4//EN";
    private static final String APP_13_70_DOCTYPE_SUNONE = "-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 J2EE Application 1.3//EN";
    private static final String APP_14_80_DOCTYPE_SUNONE = "-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 8.0 J2EE Application 1.4//EN";
    private static final String APPCLIENT_50_90_DOCTYPE = "-//Sun Microsystems, Inc.//DTD Application Server 9.0 Application Client 5.0//EN";
    private static final String APPCLIENT_14_81_DOCTYPE = "-//Sun Microsystems, Inc.//DTD Application Server 8.1 Application Client 1.4//EN";
    private static final String APPCLIENT_14_80_DOCTYPE = "-//Sun Microsystems, Inc.//DTD Application Server 8.0 Application Client 1.4//EN";
    private static final String APPCLIENT_14_80_DOCTYPE_SUNONE = "-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 8.0 Application Client 1.4//EN";
    private static final String APPCLIENT_13_70_DOCTYPE = "-//Sun Microsystems, Inc.//DTD Sun ONE Application Server 7.0 Application Client 1.3//EN";
    private static final DDProvider ddProvider = new DDProvider();
    private Map ddMap = new HashMap(5);
    private static HashMap apiToVersionMap = new HashMap(11);
    private static HashMap sunWebAppVersionMap = new HashMap(11);
    private static HashMap sunEjbJarVersionMap = new HashMap(11);
    private static HashMap sunApplicationVersionMap = new HashMap(11);
    private static HashMap sunAppClientVersionMap = new HashMap(11);

    private DDProvider() {
    }

    public static DDProvider getDefault() {
        return ddProvider;
    }

    public SunEjbJar getEjbDDRoot(InputSource is) throws IOException, SAXException {
        DDParse parse = this.parseDD(is);
        SunEjbJar ejbRoot = DDProvider.createEjbJar(parse);
        SunEjbJarProxy proxy = new SunEjbJarProxy(ejbRoot, ejbRoot.getVersion().toString());
        DDProvider.setEjbProxyErrorStatus(proxy, parse);
        return proxy;
    }

    public SunWebApp getWebDDRoot(InputSource is) throws IOException, SAXException, DDException {
        DDParse parse = this.parseDD(is);
        return this.processWebAppParseTree(parse);
    }

    public SunWebApp getWebDDRoot(InputStream is) throws IOException, SAXException, DDException {
        DDParse parse = this.parseDD(is);
        return this.processWebAppParseTree(parse);
    }

    public SunWebApp getWebDDRoot(Document doc) throws DDException {
        DDParse parse = new DDParse(doc, null);
        return this.processWebAppParseTree(parse);
    }

    private SunWebApp processWebAppParseTree(DDParse parse) throws DDException {
        SunWebApp webRoot = DDProvider.createWebApp(parse);
        SunWebAppProxy proxy = new SunWebAppProxy(webRoot, webRoot.getVersion().toString());
        DDProvider.setWebProxyErrorStatus(proxy, parse);
        return proxy;
    }

    public SunApplication getAppDDRoot(InputSource is) throws IOException, SAXException {
        DDParse parse = this.parseDD(is);
        SunApplication appRoot = DDProvider.createApplication(parse);
        SunApplicationProxy proxy = new SunApplicationProxy(appRoot, appRoot.getVersion().toString());
        DDProvider.setAppProxyErrorStatus(proxy, parse);
        return proxy;
    }

    public SunApplicationClient getAppClientDDRoot(InputSource is) throws IOException, SAXException {
        DDParse parse = this.parseDD(is);
        SunApplicationClient appClientRoot = DDProvider.createApplicationClient(parse);
        SunApplicationClientProxy proxy = new SunApplicationClientProxy(appClientRoot, appClientRoot.getVersion().toString());
        DDProvider.setAppClientProxyErrorStatus(proxy, parse);
        return proxy;
    }

    public BaseBean getBaseBean(CommonDDBean bean) {
        if (bean instanceof BaseBean) {
            return (BaseBean)bean;
        }
        if (bean instanceof SunEjbJarProxy) {
            return (BaseBean)((SunEjbJarProxy)bean).getOriginal();
        }
        if (bean instanceof SunWebAppProxy) {
            return (BaseBean)((SunWebAppProxy)bean).getOriginal();
        }
        if (bean instanceof SunApplicationProxy) {
            return (BaseBean)((SunApplicationProxy)bean).getOriginal();
        }
        if (bean instanceof SunApplicationClientProxy) {
            return (BaseBean)((SunApplicationClientProxy)bean).getOriginal();
        }
        return null;
    }

    private static void setEjbProxyErrorStatus(SunEjbJarProxy ejbJarProxy, DDParse parse) {
        SAXParseException error = parse.getWarning();
        ejbJarProxy.setError(error);
    }

    private static void setAppProxyErrorStatus(SunApplicationProxy appProxy, DDParse parse) {
        SAXParseException error = parse.getWarning();
        appProxy.setError(error);
    }

    private static void setWebProxyErrorStatus(SunWebAppProxy webProxy, DDParse parse) {
        SAXParseException error = parse.getWarning();
        webProxy.setError(error);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RootInterface newGraph(Class rootType, String version) {
        RootInterface result = null;
        SunBaseBean graphRoot = null;
        Object graphRootClass = null;
        Map versionMap = (Map)apiToVersionMap.get(rootType);
        if (versionMap == null) throw new IllegalStateException("No version map for " + rootType.getName());
        VersionInfo vInfo = (VersionInfo)versionMap.get(version);
        if (vInfo == null) throw new IllegalStateException("No version information for " + version + " of type " + rootType.getName());
        try {
            graphRoot = (SunBaseBean)vInfo.getImplClass().newInstance();
            graphRoot.graphManager().setDoctype(vInfo.getPublicId(), vInfo.getSystemId());
            Class proxyClass = vInfo.getProxyClass();
            Constructor proxyConstructor = proxyClass.getConstructor(rootType, String.class);
            return (RootInterface)proxyConstructor.newInstance(graphRoot, version);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private static void setAppClientProxyErrorStatus(SunApplicationClientProxy appClientProxy, DDParse parse) {
        SAXParseException error = parse.getWarning();
        appClientProxy.setError(error);
    }

    public RootInterface newGraph(Class rootType) {
        if (SunWebApp.class.equals(rootType)) {
            return this.newGraph(rootType, "2.41");
        }
        if (SunEjbJar.class.equals(rootType)) {
            return this.newGraph(rootType, "2.11");
        }
        if (SunApplication.class.equals(rootType)) {
            return this.newGraph(rootType, "1.40");
        }
        if (SunApplicationClient.class.equals(rootType)) {
            return this.newGraph(rootType, "1.41");
        }
        return null;
    }

    private static SunEjbJar createEjbJar(DDParse parse) {
        Object jar = null;
        String version = parse.getVersion();
        if ("3.00".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_3_0_0.SunEjbJar(parse.getDocument(), 2);
        }
        if ("2.11".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_2_1_1.SunEjbJar(parse.getDocument(), 2);
        }
        if ("2.10".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_2_1_0.SunEjbJar(parse.getDocument(), 2);
        }
        if ("2.00".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_2_0_0.SunEjbJar(parse.getDocument(), 2);
        }
        return new org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_3_0_0.SunEjbJar(parse.getDocument(), 2);
    }

    private static SunWebApp createWebApp(DDParse parse) throws DDException {
        Object webRoot = null;
        String version = parse.getVersion();
        if ("2.50".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_5_0.SunWebApp(parse.getDocument(), 2);
        }
        if ("2.41".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_4_1.SunWebApp(parse.getDocument(), 2);
        }
        if ("2.40".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_4_0.SunWebApp(parse.getDocument(), 2);
        }
        if ("2.30".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_3_0.SunWebApp(parse.getDocument(), 2);
        }
        throw new DDException(MessageFormat.format(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/dd/api/Bundle").getString("MSG_UnknownWebXml"), version));
    }

    private static SunApplication createApplication(DDParse parse) {
        SunApplication jar = null;
        String version = parse.getVersion();
        if ("5.00".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.app.model_5_0_0.SunApplication(parse.getDocument(), 2);
        }
        if ("1.40".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.app.model_1_4_0.SunApplication(parse.getDocument(), 2);
        }
        if ("1.30".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.app.model_1_3_0.SunApplication(parse.getDocument(), 2);
        }
        return jar;
    }

    private static SunApplicationClient createApplicationClient(DDParse parse) {
        SunApplicationClient jar = null;
        String version = parse.getVersion();
        if ("5.00".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.client.model_5_0_0.SunApplicationClient(parse.getDocument(), 2);
        }
        if ("1.41".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.client.model_1_4_1.SunApplicationClient(parse.getDocument(), 2);
        }
        if ("1.40".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.client.model_1_4_0.SunApplicationClient(parse.getDocument(), 2);
        }
        if ("1.30".equals(version)) {
            return new org.netbeans.modules.j2ee.sun.dd.impl.client.model_1_3_0.SunApplicationClient(parse.getDocument(), 2);
        }
        return jar;
    }

    public Resources getResourcesGraph() {
        org.netbeans.modules.j2ee.sun.dd.impl.serverresources.model.Resources resourcesRoot = org.netbeans.modules.j2ee.sun.dd.impl.serverresources.model.Resources.createGraph();
        ResourcesProxy proxy = new ResourcesProxy(resourcesRoot);
        return proxy;
    }

    public Resources getResourcesGraph(InputStream in) {
        org.netbeans.modules.j2ee.sun.dd.impl.serverresources.model.Resources resourcesRoot = org.netbeans.modules.j2ee.sun.dd.impl.serverresources.model.Resources.createGraph(in);
        ResourcesProxy proxy = new ResourcesProxy(resourcesRoot);
        return proxy;
    }

    private DDParse parseDD(InputStream is) throws SAXException, IOException {
        return this.parseDD(new InputSource(is));
    }

    private DDParse parseDD(InputSource is) throws SAXException, IOException {
        ErrorHandler errorHandler = new ErrorHandler();
        DocumentBuilder parser = DDProvider.createParser(errorHandler);
        parser.setEntityResolver(DDResolver.getInstance());
        Document document = parser.parse(is);
        SAXParseException error = errorHandler.getError();
        return new DDParse(document, error);
    }

    private static DocumentBuilder createParser(ErrorHandler errorHandler) throws SAXException {
        DocumentBuilder parser = null;
        try {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            parser = fact.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException(ex.getMessage());
        }
        parser.setErrorHandler(errorHandler);
        return parser;
    }

    static {
        sunWebAppVersionMap.put("2.30", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_3_0.SunWebApp.class, SunWebAppProxy.class, WEB_20_70_DOCTYPE_SUNONE, "http://www.sun.com/software/sunone/appserver/dtds/sun-web-app_2_3-0.dtd"));
        sunWebAppVersionMap.put("2.40", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_4_0.SunWebApp.class, SunWebAppProxy.class, WEB_21_80_DOCTYPE, "http://www.sun.com/software/appserver/dtds/sun-web-app_2_4-0.dtd"));
        sunWebAppVersionMap.put("2.41", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_4_1.SunWebApp.class, SunWebAppProxy.class, WEB_21_81_DOCTYPE, "http://www.sun.com/software/appserver/dtds/sun-web-app_2_4-1.dtd"));
        sunWebAppVersionMap.put("2.50", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.web.model_2_5_0.SunWebApp.class, SunWebAppProxy.class, WEB_25_90_DOCTYPE, "http://www.sun.com/software/appserver/dtds/sun-web-app_2_5-0.dtd"));
        sunEjbJarVersionMap.put("2.00", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_2_0_0.SunEjbJar.class, SunEjbJarProxy.class, EJB_20_70_DOCTYPE_SUNONE, "http://www.sun.com/software/sunone/appserver/dtds/sun-ejb-jar_2_0-0.dtd"));
        sunEjbJarVersionMap.put("2.10", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_2_1_0.SunEjbJar.class, SunEjbJarProxy.class, EJB_21_80_DOCTYPE, "http://www.sun.com/software/appserver/dtds/sun-ejb-jar_2_1-0.dtd"));
        sunEjbJarVersionMap.put("2.11", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_2_1_1.SunEjbJar.class, SunEjbJarProxy.class, EJB_21_81_DOCTYPE, "http://www.sun.com/software/appserver/dtds/sun-ejb-jar_2_1-1.dtd"));
        sunEjbJarVersionMap.put("3.00", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.ejb.model_3_0_0.SunEjbJar.class, SunEjbJarProxy.class, EJB_30_90_DOCTYPE, "http://www.sun.com/software/appserver/dtds/sun-ejb-jar_3_0-0.dtd"));
        sunApplicationVersionMap.put("1.30", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.app.model_1_3_0.SunApplication.class, SunApplicationProxy.class, APP_13_70_DOCTYPE_SUNONE, "http://www.sun.com/software/sunone/appserver/dtds/sun-application_1_3-0.dtd"));
        sunApplicationVersionMap.put("1.40", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.app.model_1_4_0.SunApplication.class, SunApplicationProxy.class, APP_14_80_DOCTYPE, "http://www.sun.com/software/appserver/dtds/sun-application_1_4-0.dtd"));
        sunApplicationVersionMap.put("5.00", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.app.model_5_0_0.SunApplication.class, SunApplicationProxy.class, APP_50_90_DOCTYPE, "http://www.sun.com/software/appserver/dtds/sun-application_5_0-0.dtd"));
        sunAppClientVersionMap.put("1.30", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.client.model_1_3_0.SunApplicationClient.class, SunApplicationClientProxy.class, APPCLIENT_13_70_DOCTYPE, "http://www.sun.com/software/sunone/appserver/dtds/sun-application-client_1_3-0.dtd"));
        sunAppClientVersionMap.put("1.40", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.client.model_1_4_0.SunApplicationClient.class, SunApplicationClientProxy.class, APPCLIENT_14_80_DOCTYPE, "http://www.sun.com/software/appserver/dtds/sun-application-client_1_4-0.dtd"));
        sunAppClientVersionMap.put("1.41", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.client.model_1_4_1.SunApplicationClient.class, SunApplicationClientProxy.class, APPCLIENT_14_81_DOCTYPE, "http://www.sun.com/software/appserver/dtds/sun-application-client_1_4-1.dtd"));
        sunAppClientVersionMap.put("5.00", new VersionInfo(org.netbeans.modules.j2ee.sun.dd.impl.client.model_5_0_0.SunApplicationClient.class, SunApplicationClientProxy.class, APPCLIENT_50_90_DOCTYPE, "http://www.sun.com/software/appserver/dtds/sun-application-client_5_0-0.dtd"));
        apiToVersionMap.put(SunWebApp.class, sunWebAppVersionMap);
        apiToVersionMap.put(SunEjbJar.class, sunEjbJarVersionMap);
        apiToVersionMap.put(SunApplication.class, sunApplicationVersionMap);
        apiToVersionMap.put(SunApplicationClient.class, sunAppClientVersionMap);
    }

    private static class DDParse {
        private Document document;
        private SAXParseException saxException;
        private String version;

        public DDParse(Document d, SAXParseException saxEx) {
            this.document = d;
            this.saxException = saxEx;
            this.extractVersion();
        }

        public Document getDocument() {
            return this.document;
        }

        private void extractVersion() {
            DocumentType dt = this.document.getDoctype();
            this.version = "3.00";
            if (dt != null) {
                if (DDProvider.EJB_21_81_DOCTYPE.equals(dt.getPublicId())) {
                    this.version = "2.11";
                } else if (DDProvider.EJB_21_80_DOCTYPE.equals(dt.getPublicId())) {
                    this.version = "2.10";
                } else if (DDProvider.EJB_30_90_DOCTYPE.equals(dt.getPublicId())) {
                    this.version = "3.00";
                } else if (DDProvider.EJB_21_80_DOCTYPE_SUNONE.equals(dt.getPublicId())) {
                    this.version = "2.10";
                } else if (DDProvider.EJB_20_70_DOCTYPE_SUNONE.equals(dt.getPublicId())) {
                    this.version = "2.00";
                } else if (DDProvider.WEB_25_90_DOCTYPE.equals(dt.getPublicId())) {
                    this.version = "2.50";
                } else if (DDProvider.WEB_21_81_DOCTYPE.equals(dt.getPublicId())) {
                    this.version = "2.41";
                } else if (DDProvider.WEB_21_80_DOCTYPE.equals(dt.getPublicId())) {
                    this.version = "2.40";
                } else if (DDProvider.WEB_21_80_DOCTYPE_SUNONE.equals(dt.getPublicId())) {
                    this.version = "2.40";
                } else if (DDProvider.WEB_20_70_DOCTYPE_SUNONE.equals(dt.getPublicId())) {
                    this.version = "2.30";
                } else if (DDProvider.APP_50_90_DOCTYPE.equals(dt.getPublicId())) {
                    this.version = "5.00";
                } else if (DDProvider.APP_14_80_DOCTYPE.equals(dt.getPublicId()) || DDProvider.APP_14_81_DOCTYPE.equals(dt.getPublicId()) || DDProvider.APP_14_80_DOCTYPE_SUNONE.equals(dt.getPublicId())) {
                    this.version = "1.40";
                } else if (DDProvider.APP_13_70_DOCTYPE_SUNONE.equals(dt.getPublicId())) {
                    this.version = "1.30";
                } else if (DDProvider.APPCLIENT_50_90_DOCTYPE.equals(dt.getPublicId())) {
                    this.version = "5.00";
                } else if (DDProvider.APPCLIENT_14_81_DOCTYPE.equals(dt.getPublicId())) {
                    this.version = "1.41";
                } else if (DDProvider.APPCLIENT_14_80_DOCTYPE.equals(dt.getPublicId()) || DDProvider.APPCLIENT_14_80_DOCTYPE_SUNONE.equals(dt.getPublicId())) {
                    this.version = "1.40";
                } else if (DDProvider.APPCLIENT_13_70_DOCTYPE.equals(dt.getPublicId())) {
                    this.version = "1.30";
                }
            }
        }

        public String getVersion() {
            return this.version;
        }

        public SAXParseException getWarning() {
            return this.saxException;
        }
    }

    private static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        private int errorType = -1;
        SAXParseException error;

        private ErrorHandler() {
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 0) {
                this.errorType = 0;
                this.error = sAXParseException;
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 1) {
                this.errorType = 1;
                this.error = sAXParseException;
            }
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.errorType = 2;
            throw sAXParseException;
        }

        public int getErrorType() {
            return this.errorType;
        }

        public SAXParseException getError() {
            return this.error;
        }
    }

    private static class DDResolver
    implements EntityResolver {
        static DDResolver resolver;

        private DDResolver() {
        }

        static synchronized DDResolver getInstance() {
            if (resolver == null) {
                resolver = new DDResolver();
            }
            return resolver;
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            String resource = null;
            if (DDProvider.EJB_30_90_DOCTYPE.equals(publicId)) {
                resource = "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-ejb-jar_3_0-0.dtd";
            } else if (DDProvider.EJB_21_81_DOCTYPE.equals(publicId)) {
                resource = "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-ejb-jar_2_1-1.dtd";
            } else if (DDProvider.EJB_21_80_DOCTYPE.equals(publicId)) {
                resource = "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-ejb-jar_2_1-0.dtd";
            } else if (DDProvider.EJB_21_80_DOCTYPE_SUNONE.equals(publicId)) {
                resource = "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-ejb-jar_2_1-0.dtd";
            } else if (DDProvider.EJB_20_70_DOCTYPE_SUNONE.equals(publicId)) {
                resource = "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-ejb-jar_2_0-0.dtd";
            } else if (DDProvider.WEB_25_90_DOCTYPE.equals(publicId)) {
                resource = "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-web-app_2_5-0.dtd";
            } else if (DDProvider.WEB_21_81_DOCTYPE.equals(publicId)) {
                resource = "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-web-app_2_4-1.dtd";
            } else if (DDProvider.WEB_21_80_DOCTYPE.equals(publicId)) {
                resource = "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-web-app_2_4-0.dtd";
            } else if (DDProvider.WEB_21_80_DOCTYPE_SUNONE.equals(publicId)) {
                resource = "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-web-app_2_4-0.dtd";
            } else if (DDProvider.WEB_20_70_DOCTYPE_SUNONE.equals(publicId)) {
                resource = "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-web-app_2_3-0.dtd";
            } else if (DDProvider.APP_50_90_DOCTYPE.equals(publicId)) {
                resource = "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application_5_0-0.dtd";
            } else if (DDProvider.APP_14_80_DOCTYPE.equals(publicId) || DDProvider.APP_14_81_DOCTYPE.equals(publicId) || DDProvider.APP_14_80_DOCTYPE_SUNONE.equals(publicId)) {
                resource = "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application_1_4-0.dtd";
            } else if (DDProvider.APP_13_70_DOCTYPE_SUNONE.equals(publicId)) {
                resource = "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application_1_3-0.dtd";
            } else if (DDProvider.APPCLIENT_50_90_DOCTYPE.equals(publicId)) {
                resource = "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application-client_5_0-0.dtd";
            } else if (DDProvider.APPCLIENT_14_81_DOCTYPE.equals(publicId)) {
                resource = "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application-client_1_4-1.dtd";
            } else if (DDProvider.APPCLIENT_14_80_DOCTYPE.equals(publicId)) {
                resource = "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application-client_1_4-0.dtd";
            } else if (DDProvider.APPCLIENT_14_80_DOCTYPE_SUNONE.equals(publicId)) {
                resource = "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application-client_1_4-0.dtd";
            } else if (DDProvider.APPCLIENT_13_70_DOCTYPE.equals(publicId)) {
                resource = "/org/netbeans/modules/j2ee/sun/dd/impl/resources/sun-application-client_1_3-0.dtd";
            }
            URL url = this.getClass().getResource(resource);
            return new InputSource(url.toString());
        }
    }

    private static class VersionInfo {
        private Class implClass;
        private Class proxyClass;
        private String publicId;
        private String systemId;

        public VersionInfo(Class implClass, Class proxyClass, String publicId, String systemId) {
            this.implClass = implClass;
            this.proxyClass = proxyClass;
            this.publicId = publicId;
            this.systemId = systemId;
        }

        public Class getImplClass() {
            return this.implClass;
        }

        public Class getProxyClass() {
            return this.proxyClass;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }
    }
}

