/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring.whereused;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.j2ee.refactoring.whereused.AbstractWhereUsedRefactoringElement;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.netbeans.modules.web.taglib.model.FunctionType;
import org.netbeans.modules.web.taglib.model.ListenerType;
import org.netbeans.modules.web.taglib.model.TagType;
import org.netbeans.modules.web.taglib.model.Taglib;
import org.netbeans.modules.web.taglib.model.ValidatorType;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public final class TldWhereUsedRefactoring {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring.whereused");

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Problem prepare(AbstractRefactoring refactoring, RefObject refObject, RefactoringElementsBag refactoringElements) {
        Problem problem = null;
        if (!(refObject instanceof JavaClass)) return problem;
        JavaClass jClass = (JavaClass)refObject;
        err.log("jClass: " + jClass);
        String name = jClass.getName();
        err.log("name: " + name);
        Resource res = jClass.getResource();
        err.log("res: " + res);
        FileObject fo = JavaModel.getFileObject((Resource)res);
        err.log("fo: " + fo);
        WebModule wm = WebModule.getWebModule((FileObject)fo);
        if (wm == null) return problem;
        FileObject webInf = wm.getWebInf();
        Enumeration e = null;
        if (webInf != null) {
            e = webInf.getChildren(true);
        }
        if (e == null) return problem;
        while (e.hasMoreElements()) {
            FileObject tld = (FileObject)e.nextElement();
            if (!this.isTld(tld)) continue;
            DataObject tldData = null;
            try {
                tldData = DataObject.find((FileObject)tld);
            }
            catch (DataObjectNotFoundException dne) {
                // empty catch block
            }
            if (tldData == null || !(tldData instanceof TLDDataObject)) continue;
            Taglib taglib = null;
            try {
                taglib = ((TLDDataObject)tldData).getTaglib();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (taglib != null) {
                void var19_29;
                ListenerType[] listenerTypes;
                String validatorClass;
                ValidatorType validatorType;
                FunctionType[] functionTypes;
                TagType[] tagTypes = taglib.getTag();
                if (tagTypes != null && tagTypes.length > 0) {
                    for (int tt = 0; tt < tagTypes.length; ++tt) {
                        String string;
                        TagType tagT = tagTypes[tt];
                        String tagClass = tagT.getTagClass();
                        if (tagClass != null && tagClass.equals(name)) {
                            TaglibTagClassWhereUsedRefactoringElement taglibTagClassWhereUsedRefactoringElement = new TaglibTagClassWhereUsedRefactoringElement(taglib, name, tld);
                            refactoringElements.add(refactoring, (RefactoringElementImplementation)taglibTagClassWhereUsedRefactoringElement);
                        }
                        if ((string = tagT.getTeiClass()) == null || !string.equals(name)) continue;
                        TaglibTeiClassWhereUsedRefactoringElement taglibTeiClassWhereUsedRefactoringElement = new TaglibTeiClassWhereUsedRefactoringElement(taglib, name, tld);
                        refactoringElements.add(refactoring, (RefactoringElementImplementation)taglibTeiClassWhereUsedRefactoringElement);
                    }
                }
                if ((functionTypes = taglib.getFunction()) != null && functionTypes.length > 0) {
                    for (int tt = 0; tt < functionTypes.length; ++tt) {
                        FunctionType functionT = functionTypes[tt];
                        String string = functionT.getFunctionClass();
                        if (string == null || !string.equals(name)) continue;
                        TaglibFunctionClassWhereUsedRefactoringElement taglibFunctionClassWhereUsedRefactoringElement = new TaglibFunctionClassWhereUsedRefactoringElement(taglib, name, tld);
                        refactoringElements.add(refactoring, (RefactoringElementImplementation)taglibFunctionClassWhereUsedRefactoringElement);
                    }
                }
                if ((validatorType = taglib.getValidator()) != null && (validatorClass = validatorType.getValidatorClass()) != null && validatorClass.equals(name)) {
                    TaglibValidatorClassWhereUsedRefactoringElement taglibValidatorClassWhereUsedRefactoringElement = new TaglibValidatorClassWhereUsedRefactoringElement(taglib, name, tld);
                    refactoringElements.add(refactoring, (RefactoringElementImplementation)taglibValidatorClassWhereUsedRefactoringElement);
                }
                if ((listenerTypes = taglib.getListener()) == null || listenerTypes.length <= 0) continue;
                boolean bl = false;
                while (var19_29 < listenerTypes.length) {
                    ListenerType listenerType = listenerTypes[var19_29];
                    String listenerClass = listenerType.getListenerClass();
                    if (listenerClass != null && listenerClass.equals(name)) {
                        TaglibListenerClassWhereUsedRefactoringElement elem = new TaglibListenerClassWhereUsedRefactoringElement(taglib, name, tld);
                        refactoringElements.add(refactoring, (RefactoringElementImplementation)elem);
                    }
                    ++var19_29;
                }
                continue;
            }
            Object[] args = new Object[]{tld.getNameExt()};
            String msg = MessageFormat.format(NbBundle.getMessage(TldWhereUsedRefactoring.class, (String)"TXT_TaglibWhereUsedInvalidProblem"), args);
            Problem newProblem = new Problem(false, msg);
            problem = Utility.addProblemsToEnd(problem, newProblem);
        }
        return problem;
    }

    private boolean isTld(FileObject fo) {
        String ext;
        boolean isTld = false;
        if (fo != null && "tld".equalsIgnoreCase(ext = fo.getExt())) {
            isTld = true;
        }
        return isTld;
    }

    public final class TaglibFunctionClassWhereUsedRefactoringElement
    extends AbstractWhereUsedRefactoringElement {
        protected Taglib taglib;

        public TaglibFunctionClassWhereUsedRefactoringElement(Taglib taglib, String name, FileObject parentFile) {
            this.taglib = taglib;
            this.name = name;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.name};
            return MessageFormat.format(NbBundle.getMessage(TldWhereUsedRefactoring.class, (String)"TXT_TaglibFunctionClassWhereUsed"), args);
        }
    }

    public final class TaglibListenerClassWhereUsedRefactoringElement
    extends AbstractWhereUsedRefactoringElement {
        protected Taglib taglib;

        public TaglibListenerClassWhereUsedRefactoringElement(Taglib taglib, String name, FileObject parentFile) {
            this.taglib = taglib;
            this.name = name;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.name};
            return MessageFormat.format(NbBundle.getMessage(TldWhereUsedRefactoring.class, (String)"TXT_TaglibListenerClassWhereUsed"), args);
        }
    }

    public final class TaglibValidatorClassWhereUsedRefactoringElement
    extends AbstractWhereUsedRefactoringElement {
        protected Taglib taglib;

        public TaglibValidatorClassWhereUsedRefactoringElement(Taglib taglib, String name, FileObject parentFile) {
            this.taglib = taglib;
            this.name = name;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.name};
            return MessageFormat.format(NbBundle.getMessage(TldWhereUsedRefactoring.class, (String)"TXT_TaglibValidatorClassWhereUsed"), args);
        }
    }

    public final class TaglibTeiClassWhereUsedRefactoringElement
    extends AbstractWhereUsedRefactoringElement {
        protected Taglib taglib;

        public TaglibTeiClassWhereUsedRefactoringElement(Taglib taglib, String name, FileObject parentFile) {
            this.taglib = taglib;
            this.name = name;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.name};
            return MessageFormat.format(NbBundle.getMessage(TldWhereUsedRefactoring.class, (String)"TXT_TaglibTeiClassWhereUsed"), args);
        }
    }

    public final class TaglibTagClassWhereUsedRefactoringElement
    extends AbstractWhereUsedRefactoringElement {
        protected Taglib taglib;

        public TaglibTagClassWhereUsedRefactoringElement(Taglib taglib, String name, FileObject parentFile) {
            this.taglib = taglib;
            this.name = name;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.name};
            return MessageFormat.format(NbBundle.getMessage(TldWhereUsedRefactoring.class, (String)"TXT_TaglibTagClassWhereUsed"), args);
        }
    }
}

