/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.derby.DerbyOptions;
import org.netbeans.modules.derby.ExecSupport;
import org.netbeans.modules.derby.StartAction;
import org.netbeans.modules.derby.Util;
import org.netbeans.modules.derby.api.DerbyDatabases;
import org.netbeans.spi.db.explorer.DatabaseRuntime;
import org.openide.ErrorManager;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class RegisterDerby
implements DatabaseRuntime {
    private static final ErrorManager LOGGER = ErrorManager.getDefault().getInstance(RegisterDerby.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(1);
    private static RegisterDerby reg = null;
    static Process process = null;

    private RegisterDerby() {
    }

    public static synchronized RegisterDerby getDefault() {
        if (reg == null) {
            reg = new RegisterDerby();
        }
        return reg;
    }

    public boolean acceptsDatabaseURL(String url) {
        return url.trim().startsWith("jdbc:derby://localhost");
    }

    public boolean isRunning() {
        if (process != null) {
            try {
                int e = process.exitValue();
                process = null;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
        return process != null;
    }

    public String getJDBCDriverClass() {
        return "org.apache.derby.jdbc.ClientDriver";
    }

    public boolean canStart() {
        return DerbyOptions.getDefault().getLocation().length() > 0;
    }

    public void start() {
        this.start(5000);
    }

    private String getNetworkServerClasspath() {
        return Util.getDerbyFile("lib/derby.jar").getAbsolutePath() + File.pathSeparator + Util.getDerbyFile("lib/derbytools.jar").getAbsolutePath() + File.pathSeparator + Util.getDerbyFile("lib/derbynet.jar").getAbsolutePath();
    }

    private JDBCDriver getRegisteredDerbyDriver() {
        JDBCDriver[] drvs = JDBCDriverManager.getDefault().getDrivers("org.apache.derby.jdbc.ClientDriver");
        if (drvs.length > 0) {
            return drvs[0];
        }
        return null;
    }

    public int getPort() {
        return 1527;
    }

    void postCreateNewDatabase(final String databaseName, final String user, final String password) throws Exception {
        this.ensureStarted();
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage((Class)(class$org$netbeans$modules$derby$RegisterDerby == null ? (class$org$netbeans$modules$derby$RegisterDerby = RegisterDerby.class$("org.netbeans.modules.derby.RegisterDerby")) : class$org$netbeans$modules$derby$RegisterDerby), (String)"MSG_CreatingDBProgressLabel", (Object)databaseName));
                    ph.start();
                    try {
                        DerbyDatabases.createDatabase(databaseName, user, password);
                    }
                    finally {
                        ph.finish();
                    }
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                    String message = NbBundle.getMessage((Class)(class$org$netbeans$modules$derby$RegisterDerby == null ? (class$org$netbeans$modules$derby$RegisterDerby = RegisterDerby.class$("org.netbeans.modules.derby.RegisterDerby")) : class$org$netbeans$modules$derby$RegisterDerby), (String)"ERR_CreateDatabase", (Object)e.getMessage());
                    Util.showInformation(message);
                }
            }
        });
    }

    private String getDerbySystemHome() {
        return DerbyOptions.getDefault().getSystemHome();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDerbyPropertiesFile() {
        File derbyProperties = new File(this.getDerbySystemHome(), "derby.properties");
        if (derbyProperties.exists()) {
            return;
        }
        Properties derbyProps = new Properties();
        if (4096 == Utilities.getOperatingSystem()) {
            derbyProps.setProperty("derby.storage.fileSyncTransactionLog", "true");
        }
        OutputStream fileos = null;
        try {
            File derbyPropertiesParent = derbyProperties.getParentFile();
            derbyPropertiesParent.mkdirs();
            fileos = new FileOutputStream(derbyProperties);
            derbyProps.store(fileos, NbBundle.getMessage((Class)RegisterDerby.class, (String)"MSG_DerbyPropsFile"));
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        finally {
            if (fileos != null) {
                try {
                    fileos.close();
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        }
    }

    private File getInstallLocation() {
        String location = DerbyOptions.getDefault().getLocation();
        if (location.equals("")) {
            return null;
        }
        return new File(location);
    }

    private String[] getEnvironment() {
        String location = DerbyOptions.getDefault().getLocation();
        if (location.equals("")) {
            return null;
        }
        return new String[]{"DERBY_INSTALL=" + location};
    }

    private JavaPlatform getJavaPlatform() {
        JavaPlatformManager jpm = JavaPlatformManager.getDefault();
        return jpm.getDefaultPlatform();
    }

    private void start(int waitTime) {
        if (process != null) {
            this.stop();
        }
        if (!Util.hasInstallLocation()) {
            Util.showInformation(NbBundle.getMessage((Class)RegisterDerby.class, (String)"MSG_DerbyLocationIncorrect"));
            return;
        }
        try {
            ExecSupport ee = new ExecSupport();
            ee.setStringToLookFor("" + this.getPort());
            FileObject javaFO = this.getJavaPlatform().findTool("java");
            if (javaFO == null) {
                throw new Exception(NbBundle.getMessage((Class)RegisterDerby.class, (String)"EXC_JavaExecutableNotFound"));
            }
            String java = FileUtil.toFile((FileObject)javaFO).getAbsolutePath();
            this.createDerbyPropertiesFile();
            NbProcessDescriptor desc = new NbProcessDescriptor(java, "-Dderby.system.home=\"" + this.getDerbySystemHome() + "\" " + "-classpath \"" + this.getNetworkServerClasspath() + "\"" + " org.apache.derby.drda.NetworkServerControl start");
            if (LOG) {
                LOGGER.log(1, "Running " + desc.getProcessName() + " " + desc.getArguments());
            }
            process = desc.exec(null, this.getEnvironment(), true, this.getInstallLocation());
            ee.displayProcessOutputs(process, NbBundle.getMessage((Class)StartAction.class, (String)"LBL_outputtab"));
            if (waitTime > 0) {
                ee.waitForMessage(NbBundle.getMessage((Class)RegisterDerby.class, (String)"MSG_StartingDerby"), waitTime);
            }
        }
        catch (Exception e) {
            Util.showInformation(e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            if (process == null) {
                return;
            }
            String java = FileUtil.toFile((FileObject)this.getJavaPlatform().findTool("java")).getAbsolutePath();
            if (java == null) {
                throw new Exception(NbBundle.getMessage((Class)RegisterDerby.class, (String)"EXC_JavaExecutableNotFound"));
            }
            NbProcessDescriptor desc = new NbProcessDescriptor(java, "-Dderby.system.home=\"" + this.getDerbySystemHome() + "\" " + "-classpath \"" + this.getNetworkServerClasspath() + "\"" + " org.apache.derby.drda.NetworkServerControl shutdown");
            if (LOG) {
                LOGGER.log(1, "Running " + desc.getProcessName() + " " + desc.getArguments());
            }
            Process shutwownProcess = desc.exec(null, this.getEnvironment(), true, this.getInstallLocation());
            shutwownProcess.waitFor();
            process.destroy();
        }
        catch (Exception e) {
            Util.showInformation(e.getMessage());
        }
        finally {
            process = null;
        }
    }

    public void ensureStarted() {
        if (!this.isRunning() && this.canStart()) {
            this.start();
        }
    }
}

