/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.macros;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.options.keymap.ActionImpl;
import org.netbeans.modules.options.keymap.KeymapViewModel;
import org.netbeans.modules.options.macros.MacrosPanel;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class MacrosModel {
    private KeymapViewModel keymapModel;
    private Map macroNameToText;
    private DefaultTableModel tableModel;
    private boolean changed = false;

    MacrosModel(Lookup lookup) {
        this.keymapModel = (KeymapViewModel)lookup.lookup(KeymapViewModel.class);
        this.init();
    }

    private void init() {
        this.macroNameToText = new HashMap();
        Iterator<Object> it = AllOptionsFolder.getDefault().getInstalledOptions().iterator();
        while (it.hasNext()) {
            Class optionsClass = (Class)it.next();
            BaseOptions baseOptions = (BaseOptions)BaseOptions.findObject((Class)optionsClass, (boolean)true);
            this.macroNameToText.putAll(baseOptions.getMacroMap());
        }
        this.macroNameToText.remove(null);
        it = this.macroNameToText.keySet().iterator();
        Vector data = new Vector();
        while (it.hasNext()) {
            String[] shortcuts;
            String macroName = (String)it.next();
            String shortcut = "";
            ActionImpl action = this.keymapModel.findActionForId("macro-" + macroName);
            if (action == null) {
                action = this.keymapModel.findActionForId(macroName);
            }
            if (action != null && (shortcuts = this.keymapModel.getShortcuts(action)).length > 0) {
                shortcut = shortcuts[0];
            }
            Vector<String> line = new Vector<String>();
            line.add(macroName);
            line.add(shortcut);
            data.add(line);
        }
        Collections.sort(data, new MComparator());
        Vector<String> columns = new Vector<String>(2);
        columns.add(MacrosModel.loc("Macro_Name_Title"));
        columns.add(MacrosModel.loc("Macro_Code_Title"));
        this.tableModel = new DefaultTableModel(data, columns){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.tableModel.getColumnName(2);
    }

    DefaultTableModel getShortcutsTableModel() {
        return this.tableModel;
    }

    boolean isChanged() {
        return this.changed;
    }

    Collection getMacroNames() {
        return Collections.unmodifiableCollection(this.macroNameToText.keySet());
    }

    String getMacroText(String macroName) {
        return (String)this.macroNameToText.get(macroName);
    }

    void addMacro(String macroName, String text) {
        this.tableModel.insertRow(0, new Object[]{macroName, text});
        this.macroNameToText.put(macroName, text);
    }

    void removeMacro(int index) {
        String macroName = (String)this.tableModel.getValueAt(index, 0);
        this.macroNameToText.remove(macroName);
        this.tableModel.removeRow(index);
    }

    void setMacroText(String macroName, String text) {
        if (this.macroNameToText.containsKey(macroName) && text.equals(this.macroNameToText.get(macroName))) {
            return;
        }
        this.macroNameToText.put(macroName, text);
        this.changed = true;
    }

    void setShortcut(int index, String shortcut) {
        this.tableModel.setValueAt(shortcut, index, 1);
        this.saveMacros();
        this.keymapModel.refreshActions();
        ActionImpl actionImpl = this.keymapModel.findActionForId("macro-" + this.tableModel.getValueAt(index, 0));
        this.keymapModel.setShortcuts(actionImpl, Collections.singleton(shortcut));
        this.changed = true;
    }

    void applyChanges() {
        this.saveMacros();
        this.changed = false;
    }

    void cancel() {
        this.init();
        this.changed = false;
    }

    private static String loc(String key) {
        return NbBundle.getMessage((Class)MacrosPanel.class, (String)key);
    }

    private void saveMacros() {
        Iterator it = AllOptionsFolder.getDefault().getInstalledOptions().iterator();
        while (it.hasNext()) {
            Class optionsClass = (Class)it.next();
            BaseOptions baseOptions = (BaseOptions)BaseOptions.findObject((Class)optionsClass, (boolean)true);
            baseOptions.setMacroMap(new HashMap(this.macroNameToText));
        }
    }

    private static class MComparator
    implements Comparator {
        private MComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = (String)((Vector)o1).get(0);
            String s2 = (String)((Vector)o2).get(0);
            return s1.compareTo(s2);
        }
    }
}

