/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.util.Locale;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;

public final class Util {
    public static final String HELP_ID_PROPERTIES = "propfiles.prop";
    public static final String HELP_ID_CREATING = "propfiles.creating";
    public static final String HELP_ID_ADDING = "propfiles.adding";
    public static final String HELP_ID_MODIFYING = "propfiles.modifying";
    public static final String HELP_ID_ADDLOCALE = "propfiles.addlocale";
    public static final String HELP_ID_EDITLOCALE = "propfiles.editlocale";
    public static final char PRB_SEPARATOR_CHAR = '_';
    public static final int LABEL_FIRST_PART_LENGTH = 10;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static String stringToKey(String source) {
        StringBuffer result = new StringBuffer();
        block3: for (int i = 0; i < source.length(); ++i) {
            char x = source.charAt(i);
            switch (x) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ':': 
                case '=': {
                    result.append('_');
                    continue block3;
                }
                default: {
                    result.append(x);
                }
            }
        }
        return result.toString();
    }

    public static String assembleName(String baseName, String lang) {
        if (lang.length() == 0) {
            return baseName;
        }
        if (lang.charAt(0) != '_') {
            StringBuffer res = new StringBuffer().append(baseName).append('_').append(lang);
            return res.toString();
        }
        return baseName + lang;
    }

    public static String getLocaleSuffix(MultiDataObject.Entry fe) {
        MultiDataObject.Entry pe = fe.getDataObject().getPrimaryEntry();
        if (fe == pe) {
            return "";
        }
        String myName = fe.getFile().getName();
        String baseName = pe.getFile().getName();
        if (!$assertionsDisabled && !myName.startsWith(baseName)) {
            throw new AssertionError();
        }
        return myName.substring(baseName.length());
    }

    public static String getLanguage(String localeSuffix) {
        return Util.getFirstPart(localeSuffix);
    }

    public static String getCountry(String localeSuffix) {
        if (localeSuffix.length() == 0) {
            return null;
        }
        int start = localeSuffix.indexOf(95, 1);
        return start != -1 ? Util.getFirstPart(localeSuffix.substring(start)) : "";
    }

    public static String getVariant(String localeSuffix) {
        if (localeSuffix.length() == 0) {
            return null;
        }
        int start = localeSuffix.indexOf(95, 1);
        if (start == -1) {
            return "";
        }
        return (start = localeSuffix.indexOf(95, start + 1)) != -1 ? localeSuffix.substring(start + 1) : "";
    }

    private static String getFirstPart(String localeSuffix) {
        if (localeSuffix.length() == 0) {
            return null;
        }
        if (!$assertionsDisabled && localeSuffix.charAt(0) != '_') {
            throw new AssertionError();
        }
        int end = localeSuffix.indexOf(95, 1);
        return end != -1 ? localeSuffix.substring(1, end) : localeSuffix.substring(1);
    }

    public static String getLocaleLabel(MultiDataObject.Entry fe) {
        String variantName;
        String langName;
        String variant;
        String country;
        String language;
        String localeSuffix = Util.getLocaleSuffix(fe);
        if (localeSuffix.length() == 0) {
            language = "";
            country = "";
            variant = "";
        } else {
            language = Util.getLanguage(localeSuffix);
            country = Util.getCountry(localeSuffix);
            variant = Util.getVariant(localeSuffix);
            language = language.length() != 0 ? language : "";
            country = country.length() != 0 ? country : "";
            variant = variant.length() != 0 ? variant : "";
        }
        String defaultLangName = null;
        if (language == "") {
            defaultLangName = NbBundle.getMessage((Class)Util.class, (String)"LAB_defaultLanguage");
        }
        if (language == "" && country == "" && variant == "") {
            return defaultLangName;
        }
        String localeSpec = localeSuffix.substring(1);
        Locale locale = new Locale(language, country, variant);
        if (language == "") {
            langName = defaultLangName;
        } else {
            langName = locale.getDisplayLanguage();
            if (langName.equals(language)) {
                langName = NbBundle.getMessage((Class)Util.class, (String)"LAB_unknownLanguage", (Object)language);
            }
        }
        if (country == "" && variant == "") {
            return NbBundle.getMessage((Class)Util.class, (String)"LAB_localeSpecLang", (Object)localeSpec, (Object)langName);
        }
        String countryName = "";
        if (country != "" && (countryName = locale.getDisplayCountry()).equals(country)) {
            countryName = NbBundle.getMessage((Class)Util.class, (String)"LAB_unknownCountry", (Object)country);
        }
        String string = variantName = variant == "" ? "" : locale.getDisplayVariant();
        String countryAndVariant = variantName == "" ? countryName : (countryName == "" ? variantName : countryName + ", " + variantName);
        return NbBundle.getMessage((Class)Util.class, (String)"LAB_localeSpecLangCountry", (Object)localeSpec, (Object)langName, (Object)countryAndVariant);
    }

    static {
        $assertionsDisabled = !Util.class.desiredAssertionStatus();
    }
}

