/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import org.netbeans.modules.palette.DefaultModel;
import org.netbeans.modules.palette.Settings;
import org.netbeans.modules.palette.ui.PalettePanel;
import org.netbeans.spi.palette.PaletteController;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public final class Utils {
    private static FileObject paletteFolder;
    private static DataFolder paletteDataFolder;
    static /* synthetic */ Class class$org$openide$nodes$Index;
    static /* synthetic */ Class class$org$openide$util$datatransfer$ExClipboard;

    private Utils() {
    }

    public static ResourceBundle getBundle() {
        return NbBundle.getBundle((Class)Utils.class);
    }

    public static String getBundleString(String key) {
        return Utils.getBundle().getString(key);
    }

    public static Action[] mergeActions(Action[] first, Action[] second) {
        if (null == first) {
            return second;
        }
        if (null == second) {
            return first;
        }
        Action[] res = new Action[first.length + second.length + 1];
        System.arraycopy(first, 0, res, 0, first.length);
        res[first.length] = null;
        System.arraycopy(second, 0, res, first.length + 1, second.length);
        return res;
    }

    public static boolean isReadonly(Node node) {
        DataObject dobj;
        Object val = node.getValue("isReadonly");
        if (null == val && null != (dobj = (DataObject)node.getCookie(DataObject.class))) {
            val = dobj.getPrimaryFile().getAttribute("isReadonly");
        }
        if (null != val) {
            return Boolean.valueOf(val.toString());
        }
        return !node.canDestroy();
    }

    public static String getHelpId(Node node) {
        DataObject dobj;
        Object val = node.getValue("helpId");
        if (null == val && null != (dobj = (DataObject)node.getCookie(DataObject.class))) {
            val = dobj.getPrimaryFile().getAttribute("helpId");
        }
        return null == val ? null : val.toString();
    }

    public static void addCustomizationMenuItems(JPopupMenu popup, PaletteController controller, Settings settings) {
        popup.addSeparator();
        popup.add(new ShowNamesAction(settings));
        popup.add(new ChangeIconSizeAction(settings));
        popup.addSeparator();
        popup.add(new ShowCustomizerAction(controller));
    }

    public static Node findCategoryNode(Node root, String categoryName) {
        Node category = root.getChildren().findChild(categoryName);
        return category;
    }

    private static class ShowCustomizerAction
    extends AbstractAction {
        private PaletteController palette;

        public ShowCustomizerAction(PaletteController palette) {
            this.palette = palette;
            this.putValue("Name", Utils.getBundleString("CTL_ShowCustomizer"));
        }

        public void actionPerformed(ActionEvent event) {
            this.palette.showCustomizer();
        }
    }

    static class RemoveItemAction
    extends AbstractAction {
        private Node itemNode;

        public RemoveItemAction(Node itemNode) {
            this.itemNode = itemNode;
            this.putValue("Name", Utils.getBundleString("CTL_Delete"));
        }

        public void actionPerformed(ActionEvent event) {
            String message = MessageFormat.format(Utils.getBundleString("FMT_ConfirmBeanDelete"), this.itemNode.getDisplayName());
            NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)message, Utils.getBundleString("CTL_ConfirmBeanTitle"), 0);
            if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)desc))) {
                try {
                    this.itemNode.destroy();
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        }

        public boolean isEnabled() {
            return this.itemNode.canDestroy();
        }
    }

    public static class CopyItemAction
    extends AbstractAction {
        private Node itemNode;

        public CopyItemAction(Node itemNode) {
            this.itemNode = itemNode;
            this.putValue("Name", Utils.getBundleString("CTL_Copy"));
        }

        public void actionPerformed(ActionEvent event) {
            try {
                Transferable trans = this.itemNode.clipboardCopy();
                if (trans != null) {
                    Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(class$org$openide$util$datatransfer$ExClipboard == null ? (class$org$openide$util$datatransfer$ExClipboard = Utils.class$("org.openide.util.datatransfer.ExClipboard")) : class$org$openide$util$datatransfer$ExClipboard);
                    clipboard.setContents(trans, new StringSelection(""));
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    public static class CutItemAction
    extends AbstractAction {
        private Node itemNode;

        public CutItemAction(Node itemNode) {
            this.itemNode = itemNode;
            this.putValue("Name", Utils.getBundleString("CTL_Cut"));
        }

        public void actionPerformed(ActionEvent event) {
            try {
                Transferable trans = this.itemNode.clipboardCut();
                if (trans != null) {
                    Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(class$org$openide$util$datatransfer$ExClipboard == null ? (class$org$openide$util$datatransfer$ExClipboard = Utils.class$("org.openide.util.datatransfer.ExClipboard")) : class$org$openide$util$datatransfer$ExClipboard);
                    clipboard.setContents(trans, new StringSelection(""));
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    public static class PasteItemAction
    extends AbstractAction {
        private Node categoryNode;

        public PasteItemAction(Node categoryNode) {
            this.categoryNode = categoryNode;
            this.putValue("Name", Utils.getBundleString("CTL_Paste"));
        }

        public void actionPerformed(ActionEvent event) {
            PasteType type = this.getPasteType();
            if (type != null) {
                try {
                    Transferable trans = type.paste();
                    if (trans != null) {
                        ClipboardOwner owner = trans instanceof ClipboardOwner ? (ClipboardOwner)((Object)trans) : new StringSelection("");
                        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(class$org$openide$util$datatransfer$ExClipboard == null ? (class$org$openide$util$datatransfer$ExClipboard = Utils.class$("org.openide.util.datatransfer.ExClipboard")) : class$org$openide$util$datatransfer$ExClipboard);
                        clipboard.setContents(trans, owner);
                    }
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        }

        public boolean isEnabled() {
            return this.getPasteType() != null;
        }

        private PasteType getPasteType() {
            PasteType[] pasteTypes;
            Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(class$org$openide$util$datatransfer$ExClipboard == null ? (class$org$openide$util$datatransfer$ExClipboard = Utils.class$("org.openide.util.datatransfer.ExClipboard")) : class$org$openide$util$datatransfer$ExClipboard);
            Transferable trans = clipboard.getContents(this);
            if (trans != null && (pasteTypes = this.categoryNode.getPasteTypes(trans)) != null && pasteTypes.length != 0) {
                return pasteTypes[0];
            }
            return null;
        }
    }

    static class SortItemsAction
    extends AbstractAction {
        private Node categoryNode;

        public SortItemsAction(Node categoryNode) {
            this.putValue("Name", Utils.getBundleString("CTL_SortItems"));
            this.categoryNode = categoryNode;
        }

        public void actionPerformed(ActionEvent event) {
            Index order = (Index)this.categoryNode.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = Utils.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
            if (order != null) {
                Node[] nodes = this.categoryNode.getChildren().getNodes(DefaultModel.canBlock());
                Arrays.sort(nodes, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        Node n1 = (Node)o1;
                        Node n2 = (Node)o2;
                        return n1.getDisplayName().compareTo(n2.getDisplayName());
                    }
                });
                int[] perm = new int[nodes.length];
                for (int i = 0; i < perm.length; ++i) {
                    perm[i] = order.indexOf(nodes[i]);
                }
                order.reorder(perm);
            }
        }

        public boolean isEnabled() {
            return this.categoryNode.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = Utils.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index) != null;
        }
    }

    static class RenameCategoryAction
    extends AbstractAction {
        private Node categoryNode;

        public RenameCategoryAction(Node categoryNode) {
            this.categoryNode = categoryNode;
            this.putValue("Name", Utils.getBundleString("CTL_RenameCategory"));
        }

        public void actionPerformed(ActionEvent event) {
            NotifyDescriptor.InputLine desc = new NotifyDescriptor.InputLine(Utils.getBundleString("CTL_NewName"), Utils.getBundleString("CTL_Rename"));
            desc.setInputText(this.categoryNode.getName());
            if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)desc))) {
                String newName = null;
                try {
                    newName = desc.getInputText();
                    if (!"".equals(newName)) {
                        this.categoryNode.setName(newName);
                    }
                }
                catch (IllegalArgumentException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        }

        public boolean isEnabled() {
            return this.categoryNode.canRename();
        }
    }

    static class DeleteCategoryAction
    extends AbstractAction {
        private Node categoryNode;

        public DeleteCategoryAction(Node categoryNode) {
            this.categoryNode = categoryNode;
            this.putValue("Name", Utils.getBundleString("CTL_DeleteCategory"));
        }

        public void actionPerformed(ActionEvent event) {
            String message = MessageFormat.format(Utils.getBundleString("FMT_ConfirmCategoryDelete"), this.categoryNode.getName());
            NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)message, Utils.getBundleString("CTL_ConfirmCategoryTitle"), 0);
            if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)desc))) {
                try {
                    this.categoryNode.destroy();
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        }

        public boolean isEnabled() {
            return this.categoryNode.canDestroy();
        }
    }

    static class RefreshPaletteAction
    extends AbstractAction {
        public RefreshPaletteAction() {
            this.putValue("Name", Utils.getBundleString("CTL_RefreshPalette"));
        }

        public void actionPerformed(ActionEvent event) {
            PalettePanel.getDefault().doRefresh();
        }
    }

    private static class ChangeIconSizeAction
    extends AbstractAction {
        private Settings settings;

        public ChangeIconSizeAction(Settings settings) {
            this.settings = settings;
        }

        public void actionPerformed(ActionEvent event) {
            int oldSize = this.settings.getIconSize();
            int newSize = oldSize == 1 ? 2 : 1;
            this.settings.setIconSize(newSize);
        }

        public Object getValue(String key) {
            if ("Name".equals(key)) {
                String namePattern = Utils.getBundleString("CTL_IconSize");
                String name = MessageFormat.format(namePattern, new Integer(this.settings.getIconSize()));
                return name;
            }
            return super.getValue(key);
        }
    }

    private static class ShowNamesAction
    extends AbstractAction {
        private Settings settings;

        public ShowNamesAction(Settings settings) {
            this.settings = settings;
        }

        public void actionPerformed(ActionEvent event) {
            this.settings.setShowItemNames(!this.settings.getShowItemNames());
        }

        public Object getValue(String key) {
            if ("Name".equals(key)) {
                boolean showNames = this.settings.getShowItemNames();
                String name = Utils.getBundleString(showNames ? "CTL_HideNames" : "CTL_ShowNames");
                return name;
            }
            return super.getValue(key);
        }
    }

    static class SortCategoriesAction
    extends AbstractAction {
        private Node paletteNode;

        public SortCategoriesAction(Node paletteNode) {
            this.putValue("Name", Utils.getBundleString("CTL_SortCategories"));
            this.paletteNode = paletteNode;
        }

        public void actionPerformed(ActionEvent event) {
            Index order = (Index)this.paletteNode.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = Utils.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
            if (order != null) {
                Node[] nodes = this.paletteNode.getChildren().getNodes(DefaultModel.canBlock());
                Arrays.sort(nodes, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        Node n1 = (Node)o1;
                        Node n2 = (Node)o2;
                        return n1.getDisplayName().compareTo(n2.getDisplayName());
                    }
                });
                int[] perm = new int[nodes.length];
                for (int i = 0; i < perm.length; ++i) {
                    perm[i] = order.indexOf(nodes[i]);
                }
                order.reorder(perm);
            }
        }

        public boolean isEnabled() {
            return this.paletteNode.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = Utils.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index) != null;
        }
    }

    public static class NewCategoryAction
    extends AbstractAction {
        private Node paletteNode;

        public NewCategoryAction(Node paletteRootNode) {
            this.putValue("Name", Utils.getBundleString("CTL_CreateCategory"));
            this.paletteNode = paletteRootNode;
        }

        public void actionPerformed(ActionEvent event) {
            NewType[] newTypes = this.paletteNode.getNewTypes();
            try {
                if (null != newTypes && newTypes.length > 0) {
                    newTypes[0].create();
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }
}

