/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeObjectList;

public class TreeObjectListProxyListener
implements PropertyChangeListener {
    private final TreeObjectList list;
    private PropertyChangeSupport changeSupport;

    public TreeObjectListProxyListener(TreeObjectList list) {
        this.list = list;
        list.addPropertyChangeListener(this);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            TreeObject next = (TreeObject)it.next();
            if (next == null) continue;
            next.addPropertyChangeListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        Object source = e.getSource();
        if (source == this.list) {
            TreeObject oldObject;
            if ("contentInsert".equals(name)) {
                TreeObject newObject = (TreeObject)e.getNewValue();
                if (newObject != null) {
                    newObject.addPropertyChangeListener(this);
                }
            } else if ("contentRemove".equals(name) && (oldObject = (TreeObject)e.getOldValue()) != null) {
                oldObject.removePropertyChangeListener(this);
            }
        }
        this.forward(e);
    }

    private void forward(PropertyChangeEvent e) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener l) {
        TreeObjectListProxyListener treeObjectListProxyListener = this;
        synchronized (treeObjectListProxyListener) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
        }
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(l);
        }
    }
}

