/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.bridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.bridge.AuxClassLoader;
import org.apache.tools.ant.module.bridge.BridgeInterface;
import org.apache.tools.ant.module.bridge.DummyBridgeImpl;
import org.openide.ErrorManager;
import org.openide.execution.NbClassPath;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.io.NullOutputStream;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class AntBridge {
    private static final ErrorManager err;
    private static final String KEY_MAIN_CLASS_PATH = "mainClassPath";
    private static final String KEY_MAIN_CLASS_LOADER = "mainClassLoader";
    private static final String KEY_BRIDGE_CLASS_LOADER = "bridgeClassLoader";
    private static final String KEY_BRIDGE = "bridge";
    private static final String KEY_CUSTOM_DEFS = "customDefs";
    private static final String KEY_CUSTOM_DEF_CLASS_LOADERS = "customDefClassLoaders";
    private static Reference stuff;
    private static List listeners;
    private static MiscListener miscListener;
    private static Lookup.Result modulesResult;
    private static String originalJavaClassPath;
    private static int delegating;
    private static InputStream origIn;
    private static PrintStream origOut;
    private static PrintStream origErr;
    private static Map delegateIns;
    private static Map delegateOuts;
    private static Map delegateErrs;
    private static List suspendedDelegationTasks;
    private static int fakingJavaClassPath;
    static final /* synthetic */ boolean $assertionsDisabled;

    private AntBridge() {
    }

    public static synchronized void addChangeListener(ChangeListener l) {
        listeners.add(l);
    }

    public static synchronized void removeChangeListener(ChangeListener l) {
        listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireChange() {
        ChangeListener[] ls;
        stuff = null;
        ChangeEvent ev = new ChangeEvent(AntBridge.class);
        Class clazz = AntBridge.class;
        synchronized (clazz) {
            ls = listeners.toArray(new ChangeListener[listeners.size()]);
        }
        for (int i = 0; i < ls.length; ++i) {
            ls[i].stateChanged(ev);
        }
    }

    public static ClassLoader getMainClassLoader() {
        return (ClassLoader)AntBridge.getStuff().get(KEY_MAIN_CLASS_LOADER);
    }

    private static ClassLoader getBridgeClassLoader() {
        return (ClassLoader)AntBridge.getStuff().get(KEY_BRIDGE_CLASS_LOADER);
    }

    public static Map getCustomDefsWithNamespace() {
        return (Map)AntBridge.getStuff().get(KEY_CUSTOM_DEFS);
    }

    public static Map getCustomDefsNoNamespace() {
        HashMap m = new HashMap();
        Iterator it = AntBridge.getCustomDefsWithNamespace().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String type = (String)entry.getKey();
            Map defs = (Map)entry.getValue();
            HashMap<String, Class> m2 = new HashMap<String, Class>();
            Iterator it2 = defs.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry entry2 = it2.next();
                String fqn = (String)entry2.getKey();
                Class clazz = (Class)entry2.getValue();
                int idx = fqn.lastIndexOf(58);
                String name = idx != -1 ? fqn.substring(idx + 1) : fqn;
                m2.put(name, clazz);
            }
            m.put(type, m2);
        }
        return m;
    }

    public static Map getCustomDefClassLoaders() throws IOException {
        return (Map)AntBridge.getStuff().get(KEY_CUSTOM_DEF_CLASS_LOADERS);
    }

    public static BridgeInterface getInterface() {
        return (BridgeInterface)AntBridge.getStuff().get(KEY_BRIDGE);
    }

    private static synchronized Map getStuff() {
        Map m = stuff != null ? (Map)stuff.get() : null;
        if (m == null) {
            m = AntBridge.createStuff();
            stuff = new SoftReference<Map>(m);
        }
        return m;
    }

    private static Map createStuff() {
        err.log("AntBridge.createStuff - loading Ant installation...");
        HashMap<String, Object> m = new HashMap<String, Object>();
        try {
            List mainClassPath = AntBridge.createMainClassPath();
            err.log("mainClassPath=" + mainClassPath);
            m.put(KEY_MAIN_CLASS_PATH, AntBridge.classPathToString(mainClassPath));
            ClassLoader main = AntBridge.createMainClassLoader(mainClassPath);
            m.put(KEY_MAIN_CLASS_LOADER, main);
            ClassLoader bridgeLoader = AntBridge.createBridgeClassLoader(main);
            m.put(KEY_BRIDGE_CLASS_LOADER, bridgeLoader);
            Class<?> ihClazz = Class.forName("org.apache.tools.ant.input.InputHandler", false, bridgeLoader);
            ClassLoader loaderUsedForAnt = ihClazz.getClassLoader();
            if (loaderUsedForAnt != main) {
                throw new IllegalStateException("Wrong class loader is finding Ant: " + loaderUsedForAnt);
            }
            Class<?> ihClazz2 = Class.forName("org.apache.tools.ant.input.InputHandler", false, main);
            if (ihClazz2 != ihClazz) {
                throw new IllegalStateException("Main and bridge class loaders do not agree on version of Ant: " + ihClazz2.getClassLoader());
            }
            try {
                Class<?> alClazz = Class.forName("org.apache.tools.ant.taskdefs.Antlib", false, bridgeLoader);
                if (alClazz.getClassLoader() != main) {
                    throw new IllegalStateException("Bridge loader is loading stuff from elsewhere: " + alClazz.getClassLoader());
                }
                Class<?> alClazz2 = Class.forName("org.apache.tools.ant.taskdefs.Antlib", false, main);
                if (alClazz2 != alClazz) {
                    throw new IllegalStateException("Main and bridge class loaders do not agree on version of Ant: " + alClazz2.getClassLoader());
                }
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
            Class<?> impl = bridgeLoader.loadClass("org.apache.tools.ant.module.bridge.impl.BridgeImpl");
            if (impl.getClassLoader() != bridgeLoader) {
                throw new IllegalStateException("Wrong class loader is finding bridge impl: " + impl.getClassLoader());
            }
            m.put(KEY_BRIDGE, (BridgeInterface)impl.newInstance());
            Map cDCLs = AntBridge.createCustomDefClassLoaders(main);
            m.put(KEY_CUSTOM_DEF_CLASS_LOADERS, cDCLs);
            m.put(KEY_CUSTOM_DEFS, AntBridge.createCustomDefs(cDCLs));
        }
        catch (Exception e) {
            AntBridge.fallback(m, e);
        }
        catch (LinkageError e) {
            AntBridge.fallback(m, e);
        }
        return m;
    }

    private static void fallback(Map m, Throwable e) {
        m.clear();
        ClassLoader dummy = ClassLoader.getSystemClassLoader();
        m.put(KEY_MAIN_CLASS_LOADER, dummy);
        m.put(KEY_BRIDGE_CLASS_LOADER, dummy);
        m.put(KEY_BRIDGE, new DummyBridgeImpl(e));
        HashMap defs = new HashMap();
        defs.put("task", new HashMap());
        defs.put("type", new HashMap());
        m.put(KEY_CUSTOM_DEFS, defs);
        m.put(KEY_CUSTOM_DEF_CLASS_LOADERS, Collections.EMPTY_MAP);
    }

    private static String classPathToString(List cp) {
        StringBuffer b = new StringBuffer();
        Iterator it = cp.iterator();
        while (it.hasNext()) {
            b.append(((File)it.next()).getAbsolutePath());
            if (!it.hasNext()) continue;
            b.append(File.pathSeparator);
        }
        return b.toString();
    }

    public static String getMainClassPath() {
        return (String)AntBridge.getStuff().get(KEY_MAIN_CLASS_PATH) + File.pathSeparatorChar + originalJavaClassPath;
    }

    private static List createMainClassPath() throws Exception {
        File[] libs;
        LinkedHashSet<File> cp = new LinkedHashSet<File>();
        File libdir = new File(AntSettings.getDefault().getAntHomeWithDefault(), "lib");
        if (!libdir.isDirectory()) {
            throw new IOException("No such Ant library dir: " + libdir);
        }
        err.log("Creating main class loader from " + libdir);
        File[] patches = new File(libdir.getParentFile(), "patches").listFiles(new JarFilter());
        if (patches != null) {
            for (int i = 0; i < patches.length; ++i) {
                cp.add(patches[i]);
            }
        }
        if ((libs = libdir.listFiles(new JarFilter())) == null) {
            throw new IOException("Listing: " + libdir);
        }
        for (int i = 0; i < libs.length; ++i) {
            cp.add(libs[i]);
        }
        NbClassPath extra = AntSettings.getDefault().getExtraClasspath();
        String extrapath = extra.getClassPath();
        if (extrapath.startsWith("\"") && extrapath.endsWith("\"")) {
            extrapath = extrapath.substring(1, extrapath.length() - 1);
        }
        StringTokenizer tok = new StringTokenizer(extrapath, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            cp.add(new File(tok.nextToken()));
        }
        extra = AntSettings.getDefault().getAutomaticExtraClasspath();
        extrapath = extra.getClassPath();
        if (extrapath.startsWith("\"") && extrapath.endsWith("\"")) {
            extrapath = extrapath.substring(1, extrapath.length() - 1);
        }
        tok = new StringTokenizer(extrapath, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            cp.add(new File(tok.nextToken()));
        }
        return new ArrayList(cp);
    }

    private static ClassLoader createMainClassLoader(List mainClassPath) throws Exception {
        URL[] cp = new URL[mainClassPath.size()];
        Iterator it = mainClassPath.iterator();
        int i = 0;
        while (it.hasNext()) {
            cp[i++] = ((File)it.next()).toURI().toURL();
        }
        ClassLoader parent = ClassLoader.getSystemClassLoader();
        if (err.isLoggable(1)) {
            List<URL> parentURLs = parent instanceof URLClassLoader ? Arrays.asList(((URLClassLoader)parent).getURLs()) : null;
            err.log("AntBridge.createMainClassLoader: cp=" + Arrays.asList(cp) + " parent.urls=" + parentURLs);
        }
        return new MaskedClassLoader(cp, parent);
    }

    private static ClassLoader createBridgeClassLoader(ClassLoader main) throws Exception {
        File bridgeJar = InstalledFileLocator.getDefault().locate("ant/nblib/bridge.jar", "org.apache.tools.ant.module", false);
        if (bridgeJar == null) {
            throw new IllegalStateException("no ant/nblib/bridge.jar found");
        }
        return AntBridge.createAuxClassLoader(bridgeJar, main, AntBridge.class.getClassLoader());
    }

    private static ClassLoader createAuxClassLoader(File lib, ClassLoader main, ClassLoader moduleLoader) throws IOException {
        return new AuxClassLoader(moduleLoader, main, lib.toURI().toURL());
    }

    private static Map createCustomDefClassLoaders(ClassLoader main) throws IOException {
        HashMap<String, ClassLoader> m = new HashMap<String, ClassLoader>();
        ModuleInfo[] modules = miscListener.getEnabledModules();
        InstalledFileLocator ifl = InstalledFileLocator.getDefault();
        for (int i = 0; i < modules.length; ++i) {
            String cnb = modules[i].getCodeNameBase();
            String cnbDashes = cnb.replace('.', '-');
            File lib = ifl.locate("ant/nblib/" + cnbDashes + ".jar", cnb, false);
            if (lib == null) continue;
            ClassLoader l = AntBridge.createAuxClassLoader(lib, main, modules[i].getClassLoader());
            m.put(cnb, l);
        }
        return m;
    }

    private static Map createCustomDefs(Map cDCLs) throws IOException {
        HashMap m = new HashMap();
        HashMap tasks = new HashMap();
        HashMap types = new HashMap();
        m.put("task", tasks);
        m.put("type", types);
        Iterator it = cDCLs.entrySet().iterator();
        while (it.hasNext()) {
            Document doc;
            String resource;
            Map.Entry entry = it.next();
            String cnb = (String)entry.getKey();
            ClassLoader l = (ClassLoader)entry.getValue();
            URL antlib = l.getResource(resource = cnb.replace('.', '/') + "/antlib.xml");
            if (antlib == null) {
                throw new IOException("Could not find " + resource + " in ant/nblib/" + cnb.replace('.', '-') + ".jar");
            }
            try {
                doc = XMLUtil.parse((InputSource)new InputSource(antlib.toExternalForm()), (boolean)false, (boolean)true, null, null);
            }
            catch (SAXException e) {
                throw (IOException)new IOException(e.toString()).initCause(e);
            }
            Element docEl = doc.getDocumentElement();
            if (!docEl.getLocalName().equals("antlib")) {
                throw new IOException("Bad root element for " + antlib + ": " + docEl);
            }
            NodeList nl = docEl.getChildNodes();
            Properties newTaskDefs = new Properties();
            Properties newTypeDefs = new Properties();
            for (int i = 0; i < nl.getLength(); ++i) {
                boolean type;
                Node n = nl.item(i);
                if (n.getNodeType() != 1) continue;
                Element def = (Element)n;
                if (def.getNodeName().equals("taskdef")) {
                    type = false;
                } else if (def.getNodeName().equals("typedef")) {
                    type = true;
                } else {
                    err.log(16, "Warning: unrecognized definition " + def + " in " + antlib);
                    continue;
                }
                String name = def.getAttribute("name");
                if (name == null) {
                    err.log(16, "Warning: skipping definition " + def + " with no 'name' in " + antlib);
                    continue;
                }
                String classname = def.getAttribute("classname");
                if (classname == null) {
                    throw new IOException("No 'classname' attr on def of " + name + " in " + antlib);
                }
                (type ? newTypeDefs : newTaskDefs).setProperty(name, classname);
            }
            AntBridge.loadDefs(newTaskDefs, tasks, l);
            AntBridge.loadDefs(newTypeDefs, types, l);
        }
        return m;
    }

    private static void loadDefs(Properties p, Map defs, ClassLoader l) throws IOException {
        Iterator<Map.Entry<Object, Object>> it = p.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            String name = (String)entry.getKey();
            String clazzname = (String)entry.getValue();
            try {
                Class<?> clazz = l.loadClass(clazzname);
                defs.put(name, clazz);
            }
            catch (ClassNotFoundException cnfe) {
                IOException ioe = new IOException("Could not load class " + clazzname + ": " + cnfe);
                err.annotate((Throwable)ioe, (Throwable)cnfe);
                throw ioe;
            }
            catch (NoClassDefFoundError ncdfe) {
                err.log("AntBridge.loadDefs: skipping " + clazzname + ": " + ncdfe);
            }
            catch (LinkageError e) {
                IOException ioe = new IOException("Could not load class " + clazzname + ": " + e);
                err.annotate((Throwable)ioe, (Throwable)e);
                throw ioe;
            }
        }
    }

    private static boolean masked(String clazz) {
        return clazz.startsWith("org.apache.tools.") || clazz.startsWith("org.netbeans.");
    }

    public static synchronized void pushSystemInOutErr(InputStream in, PrintStream out, PrintStream err) {
        if (delegating++ == 0) {
            origIn = System.in;
            origOut = System.out;
            origErr = System.err;
            System.setIn(new MultiplexInputStream());
            System.setOut(new MultiplexPrintStream(false));
            System.setErr(new MultiplexPrintStream(true));
        }
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        delegateIns.put(tg, in);
        delegateOuts.put(tg, out);
        delegateErrs.put(tg, err);
    }

    public static synchronized void restoreSystemInOutErr() {
        if (!$assertionsDisabled && delegating <= 0) {
            throw new AssertionError();
        }
        if (--delegating == 0) {
            System.setIn(origIn);
            System.setOut(origOut);
            System.setErr(origErr);
            origIn = null;
            origOut = null;
            origErr = null;
        }
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        delegateIns.remove(tg);
        delegateOuts.remove(tg);
        delegateErrs.remove(tg);
    }

    public static synchronized void suspendDelegation() {
        Thread t = Thread.currentThread();
        suspendedDelegationTasks.add(t);
    }

    public static synchronized void resumeDelegation() {
        Thread t = Thread.currentThread();
        if (!$assertionsDisabled && !suspendedDelegationTasks.contains(t)) {
            throw new AssertionError((Object)("Have not suspended delegation in " + t));
        }
        suspendedDelegationTasks.remove(t);
    }

    public static synchronized void fakeJavaClassPath() {
        if (fakingJavaClassPath++ == 0) {
            String cp = AntBridge.getMainClassPath();
            err.log("Faking java.class.path=" + cp);
            System.setProperty("java.class.path", cp);
        }
    }

    public static synchronized void unfakeJavaClassPath() {
        if (--fakingJavaClassPath == 0) {
            err.log("Restoring java.class.path=" + originalJavaClassPath);
            System.setProperty("java.class.path", originalJavaClassPath);
        }
    }

    static {
        $assertionsDisabled = !AntBridge.class.desiredAssertionStatus();
        err = ErrorManager.getDefault().getInstance(AntBridge.class.getName());
        stuff = null;
        listeners = new ArrayList();
        miscListener = new MiscListener();
        modulesResult = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class));
        AntSettings.getDefault().addPropertyChangeListener(miscListener);
        modulesResult.addLookupListener((LookupListener)miscListener);
        originalJavaClassPath = System.getProperty("java.class.path");
        delegating = 0;
        delegateIns = new HashMap();
        delegateOuts = new HashMap();
        delegateErrs = new HashMap();
        suspendedDelegationTasks = new ArrayList();
        fakingJavaClassPath = 0;
    }

    private static final class MultiplexPrintStream
    extends PrintStream {
        private final boolean err;
        static final /* synthetic */ boolean $assertionsDisabled;

        public MultiplexPrintStream(boolean err) {
            this(new NullOutputStream(), err);
        }

        private MultiplexPrintStream(NullOutputStream nos, boolean err) {
            super((OutputStream)nos);
            nos.throwException = true;
            this.err = err;
        }

        private PrintStream delegate() {
            ThreadGroup tg;
            Map delegates;
            Thread t = Thread.currentThread();
            Map map = delegates = this.err ? delegateErrs : delegateOuts;
            for (tg = t.getThreadGroup(); tg != null && !delegates.containsKey(tg); tg = tg.getParent()) {
            }
            PrintStream ps = (PrintStream)delegates.get(tg);
            if (ps != null && !suspendedDelegationTasks.contains(t)) {
                return ps;
            }
            if (delegating > 0) {
                PrintStream orig;
                PrintStream printStream = orig = this.err ? origErr : origOut;
                if (!$assertionsDisabled && orig == null) {
                    throw new AssertionError();
                }
                return orig;
            }
            return this.err ? System.err : System.out;
        }

        public boolean checkError() {
            return this.delegate().checkError();
        }

        public void close() {
            this.delegate().close();
        }

        public void flush() {
            this.delegate().flush();
        }

        public void print(long l) {
            this.delegate().print(l);
        }

        public void print(char[] s) {
            this.delegate().print(s);
        }

        public void print(int i) {
            this.delegate().print(i);
        }

        public void print(boolean b) {
            this.delegate().print(b);
        }

        public void print(char c) {
            this.delegate().print(c);
        }

        public void print(float f) {
            this.delegate().print(f);
        }

        public void print(double d) {
            this.delegate().print(d);
        }

        public void print(Object obj) {
            this.delegate().print(obj);
        }

        public void print(String s) {
            this.delegate().print(s);
        }

        public void println(double x) {
            this.delegate().println(x);
        }

        public void println(Object x) {
            this.delegate().println(x);
        }

        public void println(float x) {
            this.delegate().println(x);
        }

        public void println(int x) {
            this.delegate().println(x);
        }

        public void println(char x) {
            this.delegate().println(x);
        }

        public void println(boolean x) {
            this.delegate().println(x);
        }

        public void println(String x) {
            this.delegate().println(x);
        }

        public void println(char[] x) {
            this.delegate().println(x);
        }

        public void println() {
            this.delegate().println();
        }

        public void println(long x) {
            this.delegate().println(x);
        }

        public void write(int b) {
            this.delegate().write(b);
        }

        public void write(byte[] b) throws IOException {
            this.delegate().write(b);
        }

        public void write(byte[] b, int off, int len) {
            this.delegate().write(b, off, len);
        }

        static {
            $assertionsDisabled = !(class$org$apache$tools$ant$module$bridge$AntBridge == null ? (class$org$apache$tools$ant$module$bridge$AntBridge = AntBridge.class$("org.apache.tools.ant.module.bridge.AntBridge")) : class$org$apache$tools$ant$module$bridge$AntBridge).desiredAssertionStatus();
        }
    }

    private static final class MultiplexInputStream
    extends InputStream {
        static final /* synthetic */ boolean $assertionsDisabled;

        private InputStream delegate() {
            ThreadGroup tg;
            Thread t = Thread.currentThread();
            for (tg = t.getThreadGroup(); tg != null && !delegateIns.containsKey(tg); tg = tg.getParent()) {
            }
            InputStream is = (InputStream)delegateIns.get(tg);
            if (is != null && !suspendedDelegationTasks.contains(t)) {
                return is;
            }
            if (delegating > 0) {
                if (!$assertionsDisabled && origIn == null) {
                    throw new AssertionError();
                }
                return origIn;
            }
            return System.in;
        }

        public int read() throws IOException {
            return this.delegate().read();
        }

        public int read(byte[] b) throws IOException {
            return this.delegate().read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate().read(b, off, len);
        }

        public int available() throws IOException {
            return this.delegate().available();
        }

        public boolean markSupported() {
            return this.delegate().markSupported();
        }

        public void mark(int readlimit) {
            this.delegate().mark(readlimit);
        }

        public void close() throws IOException {
            this.delegate().close();
        }

        public long skip(long n) throws IOException {
            return this.delegate().skip(n);
        }

        public void reset() throws IOException {
            this.delegate().reset();
        }

        static {
            $assertionsDisabled = !(class$org$apache$tools$ant$module$bridge$AntBridge == null ? (class$org$apache$tools$ant$module$bridge$AntBridge = AntBridge.class$("org.apache.tools.ant.module.bridge.AntBridge")) : class$org$apache$tools$ant$module$bridge$AntBridge).desiredAssertionStatus();
        }
    }

    private static final class MaskedClassLoader
    extends AllPermissionURLClassLoader {
        public MaskedClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (AntBridge.masked(name)) {
                Class<?> c = this.findLoadedClass(name);
                if (c == null) {
                    c = this.findClass(name);
                }
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            return super.loadClass(name, resolve);
        }
    }

    static class AllPermissionURLClassLoader
    extends URLClassLoader {
        private static PermissionCollection allPermission;

        private static synchronized PermissionCollection getAllPermissions() {
            if (allPermission == null) {
                allPermission = new Permissions();
                allPermission.add(new AllPermission());
            }
            return allPermission;
        }

        public AllPermissionURLClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        protected final PermissionCollection getPermissions(CodeSource cs) {
            return AllPermissionURLClassLoader.getAllPermissions();
        }

        public String toString() {
            return super.toString() + "[parent=" + this.getParent() + ",urls=" + Arrays.asList((Object[])this.getURLs()) + "]";
        }

        public URL getResource(String name) {
            URL u = super.getResource(name);
            if (err.isLoggable(1)) {
                err.log("APURLCL.gR: " + name + " -> " + u + " [" + this + "]");
            }
            return u;
        }

        public Enumeration findResources(String name) throws IOException {
            try {
                Enumeration<URL> us = super.findResources(name);
                if (err.isLoggable(1)) {
                    ArrayList<URL> resources = Collections.list(us);
                    us = Collections.enumeration(resources);
                    err.log("APURLCL.fRs: " + name + " -> " + resources + " [" + this + "]");
                }
                return us;
            }
            catch (IOException e) {
                if (err.isLoggable(1)) {
                    err.notify(1, (Throwable)e);
                }
                throw e;
            }
        }
    }

    private static final class JarFilter
    implements FilenameFilter {
        JarFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.toLowerCase(Locale.US).endsWith(".jar");
        }
    }

    private static final class MiscListener
    implements PropertyChangeListener,
    LookupListener {
        private ModuleInfo[] modules = null;

        MiscListener() {
        }

        public void propertyChange(PropertyChangeEvent ev) {
            String prop = ev.getPropertyName();
            if ("antHome".equals(prop) || "extraClasspath".equals(prop) || "automaticExtraClasspath".equals(prop)) {
                err.log("AntBridge got settings change in " + prop);
                AntBridge.fireChange();
            } else if ("enabled".equals(prop)) {
                err.log("AntBridge got module enablement change on " + ev.getSource());
                AntBridge.fireChange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent ev) {
            err.log("AntModule got ModuleInfo change");
            MiscListener miscListener = this;
            synchronized (miscListener) {
                if (this.modules != null) {
                    for (int i = 0; i < this.modules.length; ++i) {
                        this.modules[i].removePropertyChangeListener((PropertyChangeListener)this);
                    }
                    this.modules = null;
                }
            }
            AntBridge.fireChange();
        }

        public synchronized ModuleInfo[] getEnabledModules() {
            int i;
            if (this.modules == null) {
                Collection c = modulesResult.allInstances();
                this.modules = c.toArray(new ModuleInfo[c.size()]);
                for (i = 0; i < this.modules.length; ++i) {
                    this.modules[i].addPropertyChangeListener((PropertyChangeListener)this);
                }
            }
            ArrayList<ModuleInfo> enabledModules = new ArrayList<ModuleInfo>(this.modules.length);
            for (i = 0; i < this.modules.length; ++i) {
                if (!this.modules[i].isEnabled()) continue;
                enabledModules.add(this.modules[i]);
            }
            return enabledModules.toArray(new ModuleInfo[enabledModules.size()]);
        }
    }
}

