/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.archive.ui;

import java.awt.Image;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.j2ee.archive.ui.RootNode;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class ConfigFilesNode
extends FilterNode {
    private static final DataFilter VISIBILITY_QUERY_FILTER = new VisibilityQueryDataFilter();

    public ConfigFilesNode(DataFolder folder) {
        super(folder.getNodeDelegate(), folder.createNodeChildren(VISIBILITY_QUERY_FILTER));
    }

    public Image getIcon(int type) {
        return this.computeIcon(false, type);
    }

    public Image getOpenedIcon(int type) {
        return this.computeIcon(true, type);
    }

    private Image computeIcon(boolean opened, int type) {
        Node folderNode = this.getOriginal();
        Image image = opened ? folderNode.getOpenedIcon(type) : folderNode.getIcon(type);
        return image;
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(FindAction.class)};
    }

    public String getDisplayName() {
        return NbBundle.getMessage(RootNode.class, (String)"LBL_Node_DocBase");
    }

    protected static final class VisibilityQueryDataFilter
    implements ChangeListener,
    ChangeableDataFilter {
        EventListenerList ell = new EventListenerList();

        public VisibilityQueryDataFilter() {
            VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
        }

        public boolean acceptDataObject(DataObject obj) {
            boolean retVal = false;
            FileObject fo = obj.getPrimaryFile();
            if (!"classes".equals(fo.getName()) && !"lib".equals(fo.getName())) {
                retVal = VisibilityQuery.getDefault().isVisible(fo);
            }
            return retVal;
        }

        public void stateChanged(ChangeEvent e) {
            Object[] listeners = this.ell.getListenerList();
            ChangeEvent event = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ChangeListener.class) continue;
                if (event == null) {
                    event = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(event);
            }
        }

        public void addChangeListener(ChangeListener listener) {
            this.ell.add(ChangeListener.class, listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.ell.remove(ChangeListener.class, listener);
        }
    }
}

