/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.log;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.command.log.RlogCommand;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.util.CommandDuplicator;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class RLogExecutor
extends ExecutorSupport {
    private final File localRoot;
    private boolean failedOnSymbolicLink;

    public static RLogExecutor[] splitCommand(RlogCommand cmd, File[] roots, GlobalOptions options) {
        if (cmd.getDisplayName() == null) {
            cmd.setDisplayName(NbBundle.getMessage((Class)RLogExecutor.class, (String)"MSG_RLogExecutor_CmdDisplayName"));
        }
        if (options == null) {
            options = CvsVersioningSystem.createGlobalOptions();
        }
        CvsVersioningSystem cvs = CvsVersioningSystem.getInstance();
        AdminHandler ah = cvs.getAdminHandler();
        CommandDuplicator cloner = CommandDuplicator.getDuplicator((Command)cmd);
        ArrayList<RLogExecutor> executors = new ArrayList<RLogExecutor>();
        try {
            File[][] split = ExecutorSupport.splitByCvsRoot(roots);
            for (int i = 0; i < split.length; ++i) {
                File[] files = split[i];
                GlobalOptions currentOptions = (GlobalOptions)options.clone();
                currentOptions.setCVSRoot(Utils.getCVSRootFor(files[0]));
                String remoteRepository = null;
                File directory = null;
                for (int j = 0; j < files.length; ++j) {
                    File file = files[j];
                    File dir = file.isDirectory() ? file : file.getParentFile();
                    String repository = ah.getRepositoryForDirectory(dir.getAbsolutePath(), "").substring(1);
                    if (remoteRepository == null || remoteRepository.equals(repository)) {
                        remoteRepository = repository;
                        directory = dir;
                        continue;
                    }
                    RlogCommand command = (RlogCommand)cloner.duplicate();
                    command.setModule(remoteRepository);
                    command.setDisplayName(NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$actions$log$RLogExecutor == null ? RLogExecutor.class$("org.netbeans.modules.versioning.system.cvss.ui.actions.log.RLogExecutor") : class$org$netbeans$modules$versioning$system$cvss$ui$actions$log$RLogExecutor), (String)"MSG_RLogExecutor_CmdContext", (Object)remoteRepository));
                    RLogExecutor executor = new RLogExecutor(cvs, command, directory, currentOptions);
                    executors.add(executor);
                    remoteRepository = repository;
                    directory = dir;
                }
                RlogCommand command = (RlogCommand)cloner.duplicate();
                command.setModule(remoteRepository);
                command.setDisplayName(NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$actions$log$RLogExecutor == null ? RLogExecutor.class$("org.netbeans.modules.versioning.system.cvss.ui.actions.log.RLogExecutor") : class$org$netbeans$modules$versioning$system$cvss$ui$actions$log$RLogExecutor), (String)"MSG_RLogExecutor_CmdContext", remoteRepository));
                RLogExecutor executor = new RLogExecutor(cvs, command, directory, currentOptions);
                executors.add(executor);
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return new RLogExecutor[0];
        }
        return executors.toArray(new RLogExecutor[executors.size()]);
    }

    private RLogExecutor(CvsVersioningSystem cvs, RlogCommand cmd, File localRoot, GlobalOptions options) {
        super(cvs, (Command)cmd, options);
        this.localRoot = localRoot;
    }

    public File getFile() {
        return this.localRoot;
    }

    public void fileInfoGenerated(FileInfoEvent e) {
        LogInformation information = (LogInformation)e.getInfoContainer();
        String remotePath = information.getRepositoryFilename();
        File f = this.remote2local(remotePath);
        information.setFile(f);
        super.fileInfoGenerated(e);
    }

    protected void commandFinished(ClientRuntime.Result result) {
    }

    private File remote2local(String remotePath) {
        String repository;
        AdminHandler ah = CvsVersioningSystem.getInstance().getAdminHandler();
        try {
            repository = ah.getRepositoryForDirectory(this.localRoot.getAbsolutePath(), "").substring(1);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
        int idx = remotePath.indexOf(repository);
        if (idx == -1) {
            return null;
        }
        if ((idx = remotePath.indexOf(47, idx + repository.length())) == -1) {
            return null;
        }
        String remoteRelativePath = remotePath.substring(idx);
        if ((idx = remoteRelativePath.indexOf(44)) != -1) {
            remoteRelativePath = remoteRelativePath.substring(0, idx);
        }
        if ((idx = remoteRelativePath.lastIndexOf(47)) != -1 && idx >= 6 && "/Attic".equals(remoteRelativePath.substring(idx - 6, idx))) {
            remoteRelativePath = remoteRelativePath.substring(0, idx - 6) + remoteRelativePath.substring(idx);
        }
        return new File(this.localRoot, remoteRelativePath);
    }

    public List getLogEntries() {
        return this.toRefresh;
    }

    public void messageSent(MessageEvent e) {
        super.messageSent(e);
        if (!this.failedOnSymbolicLink && e.isError()) {
            String msg = e.getMessage();
            this.failedOnSymbolicLink = msg != null && msg.indexOf("failed assertion `strncmp (repository,") != -1;
        }
    }

    public boolean hasFailedOnSymbolicLink() {
        return this.failedOnSymbolicLink;
    }

    protected boolean logCommandOutput() {
        return false;
    }

    protected void report(String title, String prompt, List messages, int type) {
        if (!this.failedOnSymbolicLink) {
            super.report(title, prompt, messages, type);
        }
    }
}

