/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.editor.options.MacroInputPanel;
import org.netbeans.modules.editor.options.MacrosEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MacrosEditorPanel
extends JPanel {
    PairStringModel model;
    private MacrosEditor editor;
    private FontSizeTable macrosTable;
    private JButton addButton;
    private JButton editButton;
    private JScrollPane macrosPane;
    private JButton removeButton;
    static /* synthetic */ Class class$java$awt$Window;

    public MacrosEditorPanel(MacrosEditor editor) {
        this.editor = editor;
        this.model = new PairStringModel();
        this.initComponents();
        this.macrosTable = new FontSizeTable();
        this.macrosTable.setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
        this.macrosTable.setModel(this.model);
        this.macrosTable.setShowVerticalLines(false);
        this.macrosTable.setShowHorizontalLines(false);
        this.macrosTable.setSelectionMode(0);
        TableColumnModel col = this.macrosTable.getColumnModel();
        col.getColumn(0).setMaxWidth(3000);
        col.getColumn(0).setPreferredWidth(30);
        col.getColumn(1).setMaxWidth(7000);
        col.getColumn(1).setPreferredWidth(70);
        this.macrosPane.setViewportView(this.macrosTable);
        this.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_MEP"));
        this.macrosTable.getAccessibleContext().setAccessibleName(this.getBundleString("ACSN_MEP_Table"));
        this.macrosTable.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_MEP_Table"));
        this.addButton.setMnemonic(this.getBundleString("MEP_Add_Mnemonic").charAt(0));
        this.editButton.setMnemonic(this.getBundleString("MEP_Edit_Mnemonic").charAt(0));
        this.removeButton.setMnemonic(this.getBundleString("MEP_Remove_Mnemonic").charAt(0));
        this.addButton.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_MEP_Add"));
        this.editButton.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_MEP_Edit"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_MEP_Remove"));
        this.enableButtons(false);
        this.macrosTable.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = MacrosEditorPanel.class$("java.awt.Window")) : class$java$awt$Window, MacrosEditorPanel.this).setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 0);
        this.macrosTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (MacrosEditorPanel.this.macrosTable.getRowCount() == 0) {
                    MacrosEditorPanel.this.enableButtons(false);
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                MacrosEditorPanel.this.enableButtons(!lsm.isSelectionEmpty());
            }
        });
    }

    private void enableButtons(boolean enable) {
        this.editButton.setEnabled(enable);
        this.removeButton.setEnabled(enable);
    }

    private String getBundleString(String s) {
        return NbBundle.getMessage((Class)MacrosEditorPanel.class, (String)s);
    }

    public void setValue(Map m) {
        HashMap hm = m != null ? new HashMap(m) : new HashMap();
        if (hm.containsKey(null)) {
            hm.remove(null);
        }
        this.model.setData(new TreeMap(hm));
        if (this.model.getRowCount() > 0) {
            this.macrosTable.setRowSelectionInterval(0, 0);
        }
    }

    public Map getValue() {
        return this.model.getData();
    }

    private void notifyEditor() {
        if (this.editor != null) {
            this.editor.customEditorChange();
        }
    }

    private void initComponents() {
        this.macrosPane = new JScrollPane();
        this.addButton = new JButton();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 11, 11)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.macrosPane, gridBagConstraints);
        this.addButton.setText(this.getBundleString("MEP_Add"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MacrosEditorPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.addButton, gridBagConstraints);
        this.editButton.setText(this.getBundleString("MEP_Edit"));
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MacrosEditorPanel.this.editButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.editButton, gridBagConstraints);
        this.removeButton.setText(this.getBundleString("MEP_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MacrosEditorPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.removeButton, gridBagConstraints);
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        String[] macro = this.getMacro(null);
        if (macro == null) {
            return;
        }
        int index = this.model.putPair(macro);
        this.macrosTable.setRowSelectionInterval(index, index);
        this.notifyEditor();
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        int index = this.macrosTable.getSelectedRow();
        if (index != -1) {
            String[] pair = this.model.getPair(index);
            if ((pair = this.getMacro(pair)) != null) {
                this.model.removePair(index);
                index = this.model.putPair(pair);
                this.macrosTable.setRowSelectionInterval(index, index);
                this.notifyEditor();
            }
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int index = this.macrosTable.getSelectedRow();
        if (index != -1) {
            this.model.removePair(index);
            if (index >= this.model.getRowCount()) {
                --index;
            }
            if (index >= 0) {
                this.macrosTable.setRowSelectionInterval(index, index);
            }
            this.notifyEditor();
        }
    }

    private String[] getMacro(String[] macro) {
        String[] retVal;
        MacroInputPanel input = new MacroInputPanel();
        HelpCtx.setHelpIDString((JComponent)input, HelpCtx.findHelp((Component)this) != null ? HelpCtx.findHelp((Component)this).getHelpID() : null);
        if (macro != null) {
            input.setMacro(macro);
        }
        DialogDescriptor dd = new DialogDescriptor((Object)input, this.getBundleString("MEP_EnterMacro"));
        Dialog dial = DialogDisplayer.getDefault().createDialog(dd);
        input.requestFocus();
        dial.setVisible(true);
        if (dd.getValue() == DialogDescriptor.OK_OPTION && !"".equals((retVal = input.getMacro())[0])) {
            int existingKeyPosition = this.model.containsKey(retVal[0]);
            if (existingKeyPosition >= 0) {
                if (macro != null && macro[0].equals(retVal[0])) {
                    return retVal;
                }
                String[] existingPair = this.model.getPair(existingKeyPosition);
                NotifyDescriptor.Confirmation NDConfirm = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)MacrosEditorPanel.class, (String)"MEP_Overwrite", (Object)retVal[0]), 0, 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)NDConfirm);
                if (NDConfirm.getValue() != NotifyDescriptor.YES_OPTION) {
                    return null;
                }
            }
            return retVal;
        }
        return null;
    }

    private final class FontSizeTable
    extends JTable {
        private boolean needCalcRowHeight = true;

        private FontSizeTable() {
        }

        public void updateUI() {
            super.updateUI();
            this.needCalcRowHeight = true;
        }

        public void paint(Graphics g) {
            if (this.needCalcRowHeight) {
                this.calcRowHeight(g);
            }
            super.paint(g);
        }

        private void calcRowHeight(Graphics g) {
            Font f = this.getFont();
            FontMetrics fm = g.getFontMetrics(f);
            int rowHeight = fm.getHeight();
            this.needCalcRowHeight = false;
            this.setRowHeight(rowHeight);
        }
    }

    private class PairStringModel
    extends AbstractTableModel {
        String[] columns;
        TreeMap data;
        String[] keys;

        public PairStringModel() {
            this.columns = new String[]{MacrosEditorPanel.this.getBundleString("MEP_MacroTitle"), MacrosEditorPanel.this.getBundleString("MEP_ExpandTitle")};
            this.data = new TreeMap();
            this.keys = new String[0];
        }

        public void setData(TreeMap data) {
            this.data = data;
            this.updateKeys();
        }

        private void updateKeys() {
            this.keys = this.data.keySet().toArray(new String[0]);
            this.fireTableDataChanged();
        }

        public TreeMap getData() {
            return this.data;
        }

        public int getRowCount() {
            return this.keys.length;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int column) {
            return this.columns[column];
        }

        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return this.keys[row];
            }
            return this.data.get(this.keys[row]);
        }

        public int putPair(String[] pair) {
            this.data.put(pair[0], pair[1]);
            this.updateKeys();
            return Arrays.binarySearch(this.keys, pair[0]);
        }

        public void removePair(int row) {
            this.data.remove(this.getValueAt(row, 0));
            this.updateKeys();
        }

        public String[] getPair(int row) {
            String key = (String)this.getValueAt(row, 0);
            String[] retVal = new String[]{key, (String)this.data.get(key)};
            return retVal;
        }

        public int containsKey(String key) {
            return Arrays.binarySearch(this.keys, key);
        }
    }
}

