/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification.persistence.hints;

import java.awt.Dialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.editor.hints.spi.ChangeInfo;
import org.netbeans.modules.j2ee.common.JMIGenerationUtil;
import org.netbeans.modules.j2ee.verification.JEEVerificationContextInfo;
import org.netbeans.modules.j2ee.verification.JEEVerificationHint;
import org.netbeans.modules.j2ee.verification.persistence.BeanAccessType;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIHelper;
import org.netbeans.modules.j2ee.verification.persistence.hints.PickOrCreateFieldPanel;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class CreateIdAnnotationHint
extends JEEVerificationHint {
    public CreateIdAnnotationHint(JEEVerificationContextInfo problemContext) {
        super(problemContext);
    }

    public String getText() {
        return NbBundle.getMessage(CreateIdAnnotationHint.class, (String)"MSG_MissingIDAnnotationHint");
    }

    public ChangeInfo implement() {
        PickOrCreateFieldPanel pnlPickOrCreateField = new PickOrCreateFieldPanel();
        pnlPickOrCreateField.setAvailableFields(this.getAvailableFields());
        DialogDescriptor ddesc = new DialogDescriptor((Object)pnlPickOrCreateField, NbBundle.getMessage(CreateIdAnnotationHint.class, (String)"LBL_AddIDAnnotationDlgTitle"));
        Dialog dlg = DialogDisplayer.getDefault().createDialog(ddesc);
        pnlPickOrCreateField.setDlgDescriptor(ddesc);
        dlg.setLocationRelativeTo(null);
        dlg.setVisible(true);
        if (ddesc.getValue() == DialogDescriptor.OK_OPTION) {
            if (pnlPickOrCreateField.wasCreateNewFieldSelected()) {
                this.createIDField(pnlPickOrCreateField.getNewIdName(), pnlPickOrCreateField.getSelectedIdType());
            } else {
                FieldWrapper fw = (FieldWrapper)pnlPickOrCreateField.getSelectedField();
                this.createIDField(fw.getField().getName(), null);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getAvailableFields() {
        ArrayList<FieldWrapper> fields = new ArrayList<FieldWrapper>();
        JavaModel.getJavaRepository().beginTrans(false);
        try {
            JavaModel.setClassPath((Resource)this.getProblemContext().getJavaClass().getResource());
            for (Object o : this.getProblemContext().getJavaClass().getContents()) {
                if (!(o instanceof Field)) continue;
                Field f = (Field)o;
                fields.add(new FieldWrapper(f));
            }
        }
        finally {
            JavaModel.getJavaRepository().endTrans(false);
        }
        return fields.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIDField(String fieldName, String fieldType) {
        assert (fieldName != null && fieldName.length() > 0);
        JavaClass javaClass = this.getProblemContext().getJavaClass();
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            JavaModel.setClassPath((Resource)javaClass.getResource());
            Field idField = null;
            idField = javaClass.getField(fieldName, false);
            if (idField == null) {
                idField = JMIGenerationUtil.createField((Element)javaClass, (String)fieldName, (int)2, (String)fieldType);
                javaClass.getFeatures().add(0, idField);
            }
            if (PersistenceAPIHelper.findBeanAccessType(javaClass) == BeanAccessType.PROPERTY) {
                String idType = idField.getTypeName().getName();
                Method getter = CreateIdAnnotationHint.createMethodIfNeeded(javaClass, PersistenceAPIHelper.getAccessorName(fieldName), idType, Collections.EMPTY_LIST);
                getter.setBodyText("return " + fieldName + ";");
                Annotation idAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.persistence.Id", (List)Collections.EMPTY_LIST);
                getter.getAnnotations().add(idAnnotation);
                List<Type> setterArg = Collections.singletonList(idField.getType());
                String getterName = PersistenceAPIHelper.getMutatorName(fieldName);
                if (javaClass.getMethod(getterName, setterArg, false) == null) {
                    Method setter = CreateIdAnnotationHint.createMethodIfNeeded(javaClass, getterName, "void", setterArg);
                    Parameter idParameter = JMIGenerationUtil.createParameter((Element)javaClass, (String)fieldName, (String)idType);
                    setter.getParameters().add(idParameter);
                    setter.setBodyText("this." + fieldName + " = " + fieldName + ";");
                }
            } else {
                Annotation idAnnotation = JMIGenerationUtil.createAnnotation((Element)idField, (String)"javax.persistence.Id", (List)Collections.EMPTY_LIST);
                idField.getAnnotations().add(idAnnotation);
            }
        }
        finally {
            JavaModel.getJavaRepository().endTrans(false);
        }
    }

    private static Method createMethodIfNeeded(JavaClass parentClass, String methodName, String returnType, List args) {
        Method method = parentClass.getMethod(methodName, args, false);
        if (method == null) {
            method = JMIGenerationUtil.createMethod((Element)parentClass, (String)methodName, (int)1, (String)returnType);
            parentClass.getFeatures().add(method);
        }
        return method;
    }

    public int getType() {
        return 2;
    }

    private class FieldWrapper {
        private Field field;

        FieldWrapper(Field field) {
            this.field = field;
        }

        Field getField() {
            return this.field;
        }

        public String toString() {
            return this.field.getTypeName().getName() + "   " + this.field.getName();
        }
    }
}

