/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification.persistence.rules.clazz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.modules.j2ee.metadata.JMIClassIntrospector;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.persistence.BeanAccessType;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIHelper;
import org.netbeans.modules.j2ee.verification.persistence.predicates.clazz.AnnotatedAsIdClassPred;

public class AllPropertiesOfIdClassDefinedInEntity
extends AbstractRule {
    private List<String> missingAccessorNames = new ArrayList<String>();

    public AllPropertiesOfIdClassDefinedInEntity() {
        super(null, Arrays.asList(new AnnotatedAsIdClassPred()));
    }

    public String getId() {
        return "AllPropertiesOfIdClassDefinedInEntity";
    }

    protected String getMessageKey() {
        return "MSG_MissingIdProperty";
    }

    protected boolean isApplicable(Element subject, ProblemFinderContext ctx) {
        return (ctx.isIsEntityClass() || ctx.isMappedSuperclass()) && ctx.getBeanAccessType() == BeanAccessType.PROPERTY && super.isApplicable(subject, ctx);
    }

    public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (this.isApplicable(subject, ctx)) {
            JavaClass javaClass = ctx.getMainJavaClass();
            JavaClass idClass = PersistenceAPIHelper.getIdClass(javaClass);
            if (idClass == null) {
                return null;
            }
            for (ClassMember cm : idClass.getContents()) {
                if (!(cm instanceof Method)) continue;
                Method idMethod = (Method)Method.class.cast(cm);
                if (JMIClassIntrospector.isGetter((Method)idMethod)) {
                    Method entityMethod = javaClass.getMethod(idMethod.getName(), Collections.emptyList(), false);
                    if (entityMethod != null) continue;
                    this.missingAccessorNames.add(idMethod.getName() + "()");
                    continue;
                }
                if (!JMIClassIntrospector.isSetter((Method)idMethod)) continue;
                Parameter param = (Parameter)Parameter.class.cast(idMethod.getParameters().get(0));
                Method entityMethod = javaClass.getMethod(idMethod.getName(), Arrays.asList(param.getType()), false);
                if (entityMethod != null) continue;
                String methodName = idMethod.getName() + "(" + param.getType().getName() + ")";
                this.missingAccessorNames.add(methodName);
            }
            if (!this.missingAccessorNames.isEmpty()) {
                return this.createProblem(ctx, subject);
            }
        }
        return null;
    }

    protected Object[] getMessageParameters() {
        StringBuilder sb = new StringBuilder();
        for (String f : this.missingAccessorNames) {
            sb.append(f).append(" ");
        }
        Object[] result = new Object[]{sb.toString()};
        return result;
    }

    public void reset() {
        this.missingAccessorNames.clear();
    }
}

