/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxws.api;

import java.util.Iterator;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.jaxws.JAXWSViewAccessor;
import org.netbeans.modules.websvc.jaxws.spi.JAXWSViewImpl;
import org.netbeans.modules.websvc.jaxws.spi.JAXWSViewProvider;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public final class JAXWSView {
    private JAXWSViewImpl impl;
    private static final Lookup.Result implementations = Lookup.getDefault().lookup(new Lookup.Template(JAXWSViewProvider.class));

    private JAXWSView(JAXWSViewImpl impl) {
        if (impl == null) {
            throw new IllegalArgumentException();
        }
        this.impl = impl;
    }

    public static JAXWSView getJAXWSView() {
        Iterator it = implementations.allInstances().iterator();
        while (it.hasNext()) {
            JAXWSViewProvider impl = (JAXWSViewProvider)it.next();
            JAXWSView wsv = impl.findJAXWSView();
            if (wsv == null) continue;
            return wsv;
        }
        return null;
    }

    public Node createJAXWSView(Project project) {
        return this.impl.createJAXWSView(project);
    }

    static {
        JAXWSViewAccessor.DEFAULT = new JAXWSViewAccessor(){

            public JAXWSView createJAXWSView(JAXWSViewImpl spiWebServicesView) {
                return new JAXWSView(spiWebServicesView);
            }

            public JAXWSViewImpl getJAXWSViewImpl(JAXWSView wsv) {
                return wsv == null ? null : wsv.impl;
            }
        };
    }
}

