/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.tree.Tree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Diagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Warner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Check {
    protected static final Context.Key<Check> checkKey;
    private final Name.Table names;
    private final Log log;
    private final Symtab syms;
    private final Infer infer;
    private final Target target;
    private final Source source;
    private final Name classDollar;
    private final Name thisDollar;
    private final Types types;
    boolean skipAnnotations;
    boolean allowGenerics;
    boolean allowVariance;
    boolean allowAnnotations;
    boolean warnunchecked;
    boolean deprecation;
    boolean checkDeprecatedAnnotation;
    boolean complexInference;
    public Map<Name, Symbol.ClassSymbol> compiled = new HashMap<Name, Symbol.ClassSymbol>();
    public Name deprecatedSource;
    public Name uncheckedSource;
    private Validator validator = new Validator();
    Warner overrideWarner = new Warner();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sun$tools$javac$comp$Check;

    public static Check instance(Context context) {
        Check instance = context.get(checkKey);
        if (instance == null) {
            instance = new Check(context);
        }
        return instance;
    }

    protected Check(Context context) {
        context.put(checkKey, this);
        this.names = Name.Table.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.infer = Infer.instance(context);
        this.types = Types.instance(context);
        Options options = Options.instance(context);
        this.target = Target.instance(context);
        this.source = Source.instance(context);
        this.classDollar = this.names.fromString(new StringBuffer().append("class").append(this.target.syntheticNameChar()).toString());
        this.thisDollar = this.names.fromString(new StringBuffer().append("this").append(this.target.syntheticNameChar()).toString());
        Source source = Source.instance(context);
        this.allowGenerics = source.allowGenerics();
        this.allowAnnotations = source.allowAnnotations();
        this.warnunchecked = options.lint("unchecked");
        this.deprecation = options.lint("deprecation");
        this.checkDeprecatedAnnotation = options.lint("dep-ann");
        this.complexInference = options.get("-complexinference") != null;
        this.skipAnnotations = options.get("skipAnnotations") != null;
    }

    void warnDeprecated(int pos, Symbol sym) {
        if (this.deprecatedSource == null) {
            this.deprecatedSource = this.log.currentSource();
        } else if (this.deprecatedSource != this.log.currentSource()) {
            this.deprecatedSource = this.names.asterisk;
        }
        if (this.deprecation) {
            this.log.warning(pos, "has.been.deprecated", new Object[]{sym, sym.location()});
        }
    }

    public void warnUnchecked(int pos, String msg, Object[] args) {
        if (this.uncheckedSource == null) {
            this.uncheckedSource = this.log.currentSource();
        } else if (this.uncheckedSource != this.log.currentSource()) {
            this.uncheckedSource = this.names.asterisk;
        }
        if (this.warnunchecked) {
            this.log.warning(pos, msg, args);
        }
    }

    public Type completionError(int pos, Symbol.CompletionFailure ex) {
        this.log.error(pos, "cant.access", new Object[]{ex.sym, ex.errmsg});
        if (ex instanceof ClassReader.BadClassFile) {
            throw new Abort();
        }
        return this.syms.errType;
    }

    Type typeError(int pos, Object problem, Type found, Type req) {
        this.log.error(pos, "prob.found.req", new Object[]{problem, found, req});
        return this.syms.errType;
    }

    Type typeError(int pos, String problem, Type found, Type req, Object explanation) {
        this.log.error(pos, "prob.found.req.1", new Object[]{problem, found, req, explanation});
        return this.syms.errType;
    }

    Type typeTagError(int pos, Object required, Object found) {
        this.log.error(pos, "type.found.req", new Object[]{found, required});
        return this.syms.errType;
    }

    void earlyRefError(int pos, Symbol sym) {
        this.log.error(pos, "cant.ref.before.ctor.called", new Object[]{sym});
    }

    void duplicateError(int pos, Symbol sym) {
        if (!sym.type.isErroneous()) {
            this.log.error(pos, "already.defined", new Object[]{sym, sym.location()});
        }
    }

    void checkTransparentVar(int pos, Symbol.VarSymbol v, Scope s) {
        if (s.next != null) {
            Scope.Entry e = s.next.lookup(v.name);
            while (e.scope != null && e.sym.owner == v.owner) {
                if (e.sym.kind == 4 && (e.sym.owner.kind & 0x14) != 0 && v.name != this.names.error) {
                    this.duplicateError(pos, e.sym);
                    return;
                }
                e = e.next();
            }
        }
    }

    void checkTransparentClass(int pos, Symbol.ClassSymbol c, Scope s) {
        if (s.next != null) {
            Scope.Entry e = s.next.lookup(c.name);
            while (e.scope != null && e.sym.owner == c.owner) {
                if (e.sym.kind == 2 && (e.sym.owner.kind & 0x14) != 0 && c.name != this.names.error) {
                    this.duplicateError(pos, e.sym);
                    return;
                }
                e = e.next();
            }
        }
    }

    boolean checkUniqueClassName(int pos, Name name, Scope s) {
        Scope.Entry e = s.lookup(name);
        while (e.scope == s) {
            if (e.sym.kind == 2 && e.sym.name != this.names.error) {
                this.duplicateError(pos, e.sym);
                return false;
            }
            e = e.next();
        }
        Symbol sym = s.owner;
        while (sym != null) {
            if (sym.kind == 2 && sym.name == name && sym.name != this.names.error) {
                this.duplicateError(pos, sym);
                return true;
            }
            sym = sym.owner;
        }
        return true;
    }

    Name localClassName(Symbol.ClassSymbol c) {
        Symbol.ClassSymbol topClass = c.outermostClass();
        int i = 1;
        Name flatname;
        while (this.compiled.get(flatname = this.names.fromString(new StringBuffer().append("").append(c.owner.enclClass().flatname).append(this.target.syntheticNameChar()).append(i).append(c.name).toString())) != null) {
            ++i;
        }
        return flatname;
    }

    Type checkType(int pos, Type found, Type req) {
        if (req.tag == 19) {
            return req;
        }
        if (found.tag == 16) {
            return this.instantiatePoly(pos, (Type.ForAll)found, req, this.convertWarner(pos, found, req));
        }
        if (req.tag == 18) {
            return found;
        }
        if (this.types.isAssignable(found, req, this.convertWarner(pos, found, req))) {
            return found;
        }
        if (found.tag <= 7 && req.tag <= 7) {
            return this.typeError(pos, new Diagnostic("possible.loss.of.precision", new Object[0]), found, req);
        }
        if (found.isSuperBound()) {
            this.log.error(pos, "assignment.from.super-bound", new Object[]{found});
            return this.syms.errType;
        }
        if (req.isExtendsBound()) {
            this.log.error(pos, "assignment.to.extends-bound", new Object[]{req});
            return this.syms.errType;
        }
        return this.typeError(pos, new Diagnostic("incompatible.types", new Object[0]), found, req);
    }

    Type instantiatePoly(int pos, Type.ForAll t, Type pt, Warner warn) {
        if (pt == Infer.anyPoly && this.complexInference) {
            return t;
        }
        if (pt == Infer.anyPoly || pt.tag == 18) {
            Type newpt = t.qtype.tag <= 9 ? t.qtype : this.syms.objectType;
            return this.instantiatePoly(pos, t, newpt, warn);
        }
        if (pt.tag == 19) {
            return pt;
        }
        try {
            return this.infer.instantiateExpr(t, pt, warn);
        }
        catch (Infer.NoInstanceException ex) {
            if (ex.isAmbiguous) {
                Diagnostic d = ex.getDiagnostic();
                this.log.error(pos, new StringBuffer().append("undetermined.type").append(d != null ? ".1" : "").toString(), new Object[]{t, d});
                return this.syms.errType;
            }
            Diagnostic d = ex.getDiagnostic();
            return this.typeError(pos, new Diagnostic(new StringBuffer().append("incompatible.types").append(d != null ? ".1" : "").toString(), new Object[]{d}), t, pt);
        }
    }

    Type checkCastable(int pos, Type found, Type req) {
        if (found.tag == 16) {
            this.instantiatePoly(pos, (Type.ForAll)found, req, this.castWarner(pos, found, req));
            return req;
        }
        if (this.types.isCastable(found, req, this.castWarner(pos, found, req))) {
            return req;
        }
        return this.typeError(pos, new Diagnostic("inconvertible.types", new Object[0]), found, req);
    }

    boolean isTypeVar(Type t) {
        return t.tag == 14 || t.tag == 11 && this.isTypeVar(this.types.elemtype(t));
    }

    private void checkExtends(int pos, Type a, Type.TypeVar bs) {
        if (a.isUnbound()) {
            return;
        }
        if (a.tag != 15) {
            a = this.types.upperBound(a);
            List<Type> l = this.types.getBounds(bs);
            while (l.nonEmpty()) {
                if (!this.types.isSubType(a, (Type)l.head)) {
                    this.log.error(pos, "not.within.bounds", new Object[]{a});
                    return;
                }
                l = l.tail;
            }
        } else if (a.isExtendsBound()) {
            if (!this.types.isCastable(bs.bound(), this.types.upperBound(a), Warner.noWarnings)) {
                this.log.error(pos, "not.within.bounds", new Object[]{a});
            }
        } else if (a.isSuperBound() && this.types.notSoftSubtype(this.types.lowerBound(a), bs.bound())) {
            this.log.error(pos, "not.within.bounds", new Object[]{a});
        }
    }

    Type checkNonVoid(int pos, Type t) {
        if (t.tag == 9) {
            this.log.error(pos, "void.not.allowed.here", new Object[0]);
            return this.syms.errType;
        }
        return t;
    }

    Type checkClassType(int pos, Type t) {
        if (t.tag != 10 && t.tag != 19) {
            return this.typeTagError(pos, new Diagnostic("type.req.class", new Object[0]), t.tag == 14 ? new Diagnostic("type.parameter", new Object[]{t}) : t);
        }
        return t;
    }

    Type checkClassType(int pos, Type t, boolean noBounds) {
        t = this.checkClassType(pos, t);
        if (noBounds && t.isParameterized()) {
            List<Type> args = t.typarams();
            while (args.nonEmpty()) {
                if (((Type)args.head).tag == 15) {
                    return this.typeTagError(pos, Log.getLocalizedString("type.req.exact", new Object[0]), args.head);
                }
                args = args.tail;
            }
        }
        return t;
    }

    Type checkReifiableReferenceType(int pos, Type t) {
        if (t.tag != 10 && t.tag != 11 && t.tag != 19) {
            return this.typeTagError(pos, new Diagnostic("type.req.class.array", new Object[0]), t);
        }
        if (!this.types.isReifiable(t)) {
            this.log.error(pos, "illegal.generic.type.for.instof", new Object[0]);
            return this.syms.errType;
        }
        return t;
    }

    Type checkRefType(int pos, Type t) {
        switch (t.tag) {
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 19: {
                return t;
            }
        }
        return this.typeTagError(pos, new Diagnostic("type.req.ref", new Object[0]), t);
    }

    Type checkNullOrRefType(int pos, Type t) {
        switch (t.tag) {
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: {
                return t;
            }
        }
        return this.typeTagError(pos, new Diagnostic("type.req.ref", new Object[0]), t);
    }

    boolean checkDisjoint(int pos, long flags, long set1, long set2) {
        if ((flags & set1) != 0L && (flags & set2) != 0L) {
            this.log.error(pos, "illegal.combination.of.modifiers", new Object[]{TreeInfo.flagNames(TreeInfo.firstFlag(flags & set1)), TreeInfo.flagNames(TreeInfo.firstFlag(flags & set2))});
            return false;
        }
        return true;
    }

    long checkFlags(int pos, long flags, Symbol sym, Tree tree) {
        long mask;
        long implicit = 0L;
        switch (sym.kind) {
            case 4: {
                if (sym.owner.kind != 2) {
                    mask = 0x200000010L;
                    break;
                }
                if ((sym.owner.flags_field & 0x200L) != 0L) {
                    implicit = 25L;
                    mask = 25L;
                    break;
                }
                mask = 16607L;
                break;
            }
            case 16: {
                if (sym.name == this.names.init) {
                    if ((sym.owner.flags_field & 0x4000L) != 0L) {
                        implicit = 2L;
                        mask = 2L;
                    } else {
                        mask = 7L;
                    }
                } else if ((sym.owner.flags_field & 0x200L) != 0L) {
                    implicit = 1025L;
                    mask = 1025L;
                } else {
                    mask = 3391L;
                }
                if (((flags | implicit) & 0x400L) != 0L) break;
                implicit |= sym.owner.flags_field & 0x800L;
                break;
            }
            case 2: {
                if (sym.isLocal()) {
                    mask = 19472L;
                    if (sym.name.len == 0) {
                        mask |= 8L;
                    }
                    if ((sym.owner.flags_field & 8L) == 0L && (flags & 0x4000L) != 0L) {
                        this.log.error(pos, "enums.must.be.static", new Object[0]);
                    }
                } else if (sym.owner.kind == 2) {
                    mask = 19991L;
                    if (sym.owner.owner.kind == 1 || (sym.owner.flags_field & 8L) != 0L) {
                        mask |= 8L;
                    } else if ((flags & 0x4000L) != 0L) {
                        this.log.error(pos, "enums.must.be.static", new Object[0]);
                    }
                    if ((flags & 0x4200L) != 0L) {
                        implicit = 8L;
                    }
                } else {
                    mask = 28177L;
                }
                if ((flags & 0x200L) != 0L) {
                    implicit |= 0x400L;
                }
                if ((flags & 0x4000L) != 0L) {
                    mask &= 0xFFFFFFFFFFFFFBEFL;
                    implicit |= this.implicitEnumFinalFlag(tree);
                }
                implicit |= sym.owner.flags_field & 0x800L;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        long illegal = flags & 0xFFFL & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        if (illegal != 0L) {
            this.log.error(pos, "mod.not.allowed.here", new Object[]{TreeInfo.flagNames(illegal)});
        } else if (sym.kind != 2 && !this.checkDisjoint(pos, flags, 1024L, 10L) || !this.checkDisjoint(pos, flags, 1536L, 304L) || !this.checkDisjoint(pos, flags, 1L, 6L) || !this.checkDisjoint(pos, flags, 2L, 5L) || !this.checkDisjoint(pos, flags, 16L, 64L) || sym.kind == 2 || this.checkDisjoint(pos, flags, 1280L, 2048L)) {
            // empty if block
        }
        return flags & (mask | 0xFFFFFFFFFFFFF000L) | implicit;
    }

    private long implicitEnumFinalFlag(Tree tree) {
        if (tree.tag != 3) {
            return 0L;
        }
        class SpecialTreeVisitor
        extends Tree.Visitor {
            boolean specialized = false;

            SpecialTreeVisitor() {
            }

            public void visitTree(Tree tree) {
            }

            public void visitVarDef(Tree.VarDef tree) {
                if ((tree.mods.flags & 0x4000L) != 0L && tree.init instanceof Tree.NewClass && ((Tree.NewClass)tree.init).def != null) {
                    this.specialized = true;
                }
            }
        }
        SpecialTreeVisitor sts = new SpecialTreeVisitor();
        Tree.ClassDef cdef = (Tree.ClassDef)tree;
        for (Tree defs : cdef.defs) {
            defs.accept(sts);
            if (!sts.specialized) continue;
            return 0L;
        }
        return 16L;
    }

    void validate(Tree tree) {
        try {
            if (tree != null) {
                tree.accept(this.validator);
            }
        }
        catch (Symbol.CompletionFailure ex) {
            this.completionError(tree.pos, ex);
        }
    }

    void validate(List<Tree> trees) {
        List<Tree> l = trees;
        while (l.nonEmpty()) {
            this.validate((Tree)l.head);
            l = l.tail;
        }
    }

    void validateTypeParams(List<Tree.TypeParameter> trees) {
        List<Tree.TypeParameter> l = trees;
        while (l.nonEmpty()) {
            this.validate((Tree)l.head);
            l = l.tail;
        }
    }

    boolean subset(Type t, List<Type> ts) {
        List<Type> l = ts;
        while (l.nonEmpty()) {
            if (this.types.isSubType(t, (Type)l.head)) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    boolean intersects(Type t, List<Type> ts) {
        List<Type> l = ts;
        while (l.nonEmpty()) {
            if (this.types.isSubType(t, (Type)l.head) || this.types.isSubType((Type)l.head, t)) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    List<Type> incl(Type t, List<Type> ts) {
        return this.subset(t, ts) ? ts : this.excl(t, ts).prepend(t);
    }

    List<Type> excl(Type t, List<Type> ts) {
        if (ts.isEmpty()) {
            return ts;
        }
        List<Type> ts1 = this.excl(t, ts.tail);
        if (this.types.isSubType((Type)ts.head, t)) {
            return ts1;
        }
        if (ts1 == ts.tail) {
            return ts;
        }
        return ts1.prepend((Type)ts.head);
    }

    List<Type> union(List<Type> ts1, List<Type> ts2) {
        List<Type> ts = ts1;
        List<Type> l = ts2;
        while (l.nonEmpty()) {
            ts = this.incl((Type)l.head, ts);
            l = l.tail;
        }
        return ts;
    }

    List<Type> diff(List<Type> ts1, List<Type> ts2) {
        List<Type> ts = ts1;
        List<Type> l = ts2;
        while (l.nonEmpty()) {
            ts = this.excl((Type)l.head, ts);
            l = l.tail;
        }
        return ts;
    }

    public List<Type> intersect(List<Type> ts1, List<Type> ts2) {
        List<Type> ts = Type.emptyList;
        List<Type> l = ts1;
        while (l.nonEmpty()) {
            if (this.subset((Type)l.head, ts2)) {
                ts = this.incl((Type)l.head, ts);
            }
            l = l.tail;
        }
        l = ts2;
        while (l.nonEmpty()) {
            if (this.subset((Type)l.head, ts1)) {
                ts = this.incl((Type)l.head, ts);
            }
            l = l.tail;
        }
        return ts;
    }

    boolean isUnchecked(Symbol.ClassSymbol exc) {
        return exc.kind == 31 || exc.isSubClass(this.syms.errorType.tsym, this.types) || exc.isSubClass(this.syms.runtimeExceptionType.tsym, this.types);
    }

    boolean isUnchecked(Type exc) {
        return exc.tag == 14 ? this.isUnchecked(this.types.supertype(exc)) : (exc.tag == 10 ? this.isUnchecked((Symbol.ClassSymbol)exc.tsym) : exc.tag == 17);
    }

    boolean isUnchecked(int pos, Type exc) {
        try {
            return this.isUnchecked(exc);
        }
        catch (Symbol.CompletionFailure ex) {
            this.completionError(pos, ex);
            return true;
        }
    }

    boolean isHandled(Type exc, List<Type> handled) {
        return this.isUnchecked(exc) || this.subset(exc, handled);
    }

    List<Type> unHandled(List<Type> thrown, List<Type> handled) {
        List<Type> unhandled = Type.emptyList;
        List<Type> l = thrown;
        while (l.nonEmpty()) {
            if (!this.isHandled((Type)l.head, handled)) {
                unhandled = unhandled.prepend((Type)l.head);
            }
            l = l.tail;
        }
        return unhandled;
    }

    static int protection(long flags) {
        switch ((short)(flags & 7L)) {
            case 2: {
                return 3;
            }
            case 4: {
                return 1;
            }
            default: {
                return 0;
            }
            case 0: 
        }
        return 2;
    }

    private static String protectionString(long flags) {
        long flags1 = flags & 7L;
        return flags1 == 0L ? "package" : TreeInfo.flagNames(flags1);
    }

    static Object cannotOverride(Symbol.MethodSymbol m, Symbol.MethodSymbol other) {
        String key = (other.owner.flags() & 0x200L) == 0L ? "cant.override" : ((m.owner.flags() & 0x200L) == 0L ? "cant.implement" : "clashes.with");
        return new Diagnostic(key, new Object[]{m, m.location(), other, other.location()});
    }

    static Object overrides(Symbol.MethodSymbol m, Symbol.MethodSymbol other) {
        String key = (other.owner.flags() & 0x200L) == 0L ? "unchecked.override" : ((m.owner.flags() & 0x200L) == 0L ? "unchecked.implement" : "unchecked.clash.with");
        return new Diagnostic(key, new Object[]{m, m.location(), other, other.location()});
    }

    void checkOverride(Tree tree, Symbol.MethodSymbol m, Symbol.MethodSymbol other, Symbol.ClassSymbol origin) {
        if ((m.flags() & 0x80001000L) == 0L && (other.flags() & 0x1000L) == 0L) {
            if ((m.flags() & 8L) != 0L && (other.flags() & 8L) == 0L) {
                this.log.error(TreeInfo.positionFor(m, tree), "override.static", new Object[]{Check.cannotOverride(m, other)});
            } else if ((other.flags() & 0x10L) != 0L || (m.flags() & 8L) == 0L && (other.flags() & 8L) != 0L) {
                this.log.error(TreeInfo.positionFor(m, tree), "override.meth", new Object[]{Check.cannotOverride(m, other), TreeInfo.flagNames(other.flags() & 0x18L)});
            } else if ((m.owner.flags() & 0x2000L) != 0L) {
                this.log.error(TreeInfo.positionFor(m, tree), "annotation.override", new Object[]{other, other.owner});
            } else if (((m.flags() ^ other.flags()) & 0x400000000L) != 0L) {
                this.log.warning(TreeInfo.positionFor(m, tree), (m.flags() & 0x400000000L) != 0L ? "override.varargs.missing" : "override.varargs.extra", new Object[]{Check.cannotOverride(m, other)});
            } else if ((origin.flags() & 0x200L) == 0L && Check.protection(m.flags()) > Check.protection(other.flags())) {
                this.log.error(TreeInfo.positionFor(m, tree), "override.weaker.access", new Object[]{Check.cannotOverride(m, other), Check.protectionString(other.flags())});
            } else {
                if ((other.flags() & 0x80000000L) != 0L) {
                    this.log.warning(TreeInfo.positionFor(m, tree), "override.bridge", new Object[]{Check.overrides(m, other)});
                }
                Type mt = this.types.memberType(origin.type, m);
                Type ot = this.types.memberType(origin.type, other);
                List<Type> mtvars = mt.typarams();
                List<Type> otvars = ot.typarams();
                Type mtres = mt.restype();
                Type otres = this.types.subst(ot.restype(), otvars, mtvars);
                this.overrideWarner.warned = false;
                boolean resultTypesOK = this.types.returnTypeSubstitutable(mt, ot, otres, this.overrideWarner);
                if (!resultTypesOK) {
                    if (this.source.allowCovariantReturns() || m.owner == origin || !m.owner.isSubClass(other.owner, this.types)) {
                        this.typeError(TreeInfo.positionFor(m, tree), new Diagnostic("override.incompatible.ret", new Object[]{Check.cannotOverride(m, other)}), mtres, otres);
                    }
                } else if (this.overrideWarner.warned) {
                    this.warnUnchecked(TreeInfo.positionFor(m, tree), "prob.found.req", new Object[]{new Diagnostic("override.unchecked.ret", new Object[]{Check.overrides(m, other)}), mtres, otres});
                } else {
                    List<Type> otthrown = this.types.subst(ot.thrown(), otvars, mtvars);
                    List<Type> unhandled = this.unHandled(mt.thrown(), otthrown);
                    if (unhandled.nonEmpty()) {
                        this.log.error(TreeInfo.positionFor(m, tree), "override.meth.doesnt.throw", new Object[]{Check.cannotOverride(m, other), unhandled.head});
                    }
                }
                if ((other.flags() & 0x20000L) != 0L && (m.flags() & 0x20000L) == 0L && m.outermostClass() != other.outermostClass()) {
                    this.warnDeprecated(TreeInfo.positionFor(m, tree), other);
                }
            }
        }
    }

    public void checkCompatibleConcretes(int pos, Type site) {
        Type sup = this.types.supertype(site);
        if (sup.tag != 10) {
            return;
        }
        Type t1 = sup;
        while (t1.tsym.type.isParameterized()) {
            Scope.Entry e1 = t1.tsym.members().elems;
            while (e1 != null) {
                Symbol s1 = e1.sym;
                if (s1.kind == 16 && (s1.flags() & 0x80001008L) == 0L && s1.isInheritedIn(site.tsym, this.types) && ((Symbol.MethodSymbol)s1).implementation(site.tsym, this.types, true) == s1) {
                    Type st1 = this.types.memberType(t1, s1);
                    int s1ArgsLength = st1.argtypes().length();
                    if (st1 != s1.type) {
                        Type t2 = sup;
                        while (t2.tag == 10) {
                            Scope.Entry e2 = t1.tsym.members().lookup(s1.name);
                            while (e2.scope != null) {
                                Type st2;
                                Symbol s2 = e2.sym;
                                if (s2 != s1 && s2.kind == 16 && (s2.flags() & 0x80001008L) == 0L && s2.type.argtypes().length() == s1ArgsLength && s2.isInheritedIn(site.tsym, this.types) && ((Symbol.MethodSymbol)s2).implementation(site.tsym, this.types, true) == s2 && this.types.overrideEquivalent(st1, st2 = this.types.memberType(t2, s2))) {
                                    this.log.error(pos, "concrete.inheritance.conflict", new Object[]{s1, t1, s2, t2, sup});
                                }
                                e2 = e2.next();
                            }
                            t2 = this.types.supertype(t2);
                        }
                    }
                }
                e1 = e1.sibling;
            }
            t1 = this.types.supertype(t1);
        }
    }

    public boolean checkCompatibleAbstracts(int pos, Type t1, Type t2) {
        return this.checkCompatibleAbstracts(pos, t1, t2, this.types.makeCompoundType(t1, t2));
    }

    public boolean checkCompatibleAbstracts(int pos, Type t1, Type t2, Type site) {
        Symbol sym = this.firstIncompatibility(t1, t2, site);
        if (sym != null) {
            this.log.error(pos, "types.incompatible.diff.ret", new Object[]{t1, t2, new StringBuffer().append(sym.name).append("(").append(this.types.memberType(t2, sym).argtypes()).append(")").toString()});
            return false;
        }
        return true;
    }

    private Symbol firstIncompatibility(Type t1, Type t2, Type site) {
        HashMap<Symbol.TypeSymbol, Type> interfaces2;
        HashMap<Symbol.TypeSymbol, Type> interfaces1 = new HashMap<Symbol.TypeSymbol, Type>();
        this.closure(t1, interfaces1);
        if (t1 == t2) {
            interfaces2 = interfaces1;
        } else {
            interfaces2 = new HashMap<Symbol.TypeSymbol, Type>();
            this.closure(t2, interfaces1, interfaces2);
        }
        for (Type t3 : interfaces1.values()) {
            for (Type t4 : interfaces2.values()) {
                Symbol s = this.firstDirectIncompatibility(t3, t4, site);
                if (s == null) continue;
                return s;
            }
        }
        return null;
    }

    private void closure(Type t, Map<Symbol.TypeSymbol, Type> typeMap) {
        if (t.tag != 10) {
            return;
        }
        if (typeMap.put(t.tsym, t) == null) {
            this.closure(this.types.supertype(t), typeMap);
            for (Type i : this.types.interfaces(t)) {
                this.closure(i, typeMap);
            }
        }
    }

    private void closure(Type t, Map<Symbol.TypeSymbol, Type> typesSkip, Map<Symbol.TypeSymbol, Type> typeMap) {
        if (t.tag != 10) {
            return;
        }
        if (typesSkip.get(t.tsym) != null) {
            return;
        }
        if (typeMap.put(t.tsym, t) == null) {
            this.closure(this.types.supertype(t), typesSkip, typeMap);
            for (Type i : this.types.interfaces(t)) {
                this.closure(i, typesSkip, typeMap);
            }
        }
    }

    private Symbol firstDirectIncompatibility(Type t1, Type t2, Type site) {
        Scope.Entry e1 = t1.tsym.members().elems;
        while (e1 != null) {
            Symbol.MethodSymbol impl;
            Symbol s1 = e1.sym;
            Type st1 = null;
            if (s1.kind == 16 && s1.isInheritedIn(site.tsym, this.types) && ((impl = ((Symbol.MethodSymbol)s1).implementation(site.tsym, this.types, false)) == null || (impl.flags() & 0x400L) != 0L)) {
                Scope.Entry e2 = t2.tsym.members().lookup(s1.name);
                while (e2.scope != null) {
                    Symbol s2 = e2.sym;
                    if (s1 != s2 && s2.kind == 16 && s2.isInheritedIn(site.tsym, this.types)) {
                        Type st2;
                        if (st1 == null) {
                            st1 = this.types.memberType(t1, s1);
                        }
                        if (this.types.overrideEquivalent(st1, st2 = this.types.memberType(t2, s2))) {
                            Type rt2;
                            boolean compat;
                            List<Type> tvars1 = st1.typarams();
                            List<Type> tvars2 = st2.typarams();
                            Type rt1 = st1.restype();
                            boolean bl = compat = this.types.isSameType(rt1, rt2 = this.types.subst(st2.restype(), tvars2, tvars1)) || rt1.tag >= 10 && rt2.tag >= 10 && (this.types.covariantReturnType(rt1, rt2, Warner.noWarnings) || this.types.covariantReturnType(rt2, rt1, Warner.noWarnings));
                            if (!compat) {
                                return s2;
                            }
                        }
                    }
                    e2 = e2.next();
                }
            }
            e1 = e1.sibling;
        }
        return null;
    }

    void checkOverride(Tree tree, Symbol.MethodSymbol m) {
        Symbol.ClassSymbol origin = (Symbol.ClassSymbol)m.owner;
        if ((origin.flags() & 0x4000L) != 0L && this.names.finalize.equals(m.name) && m.overrides(this.syms.enumFinalFinalize, origin, this.types, false)) {
            this.log.error(tree.pos, "enum.no.finalize", new Object[0]);
            return;
        }
        Type t = this.types.supertype(origin.type);
        while (t.tag == 10) {
            Symbol.TypeSymbol c = t.tsym;
            Scope.Entry e = c.members().lookup(m.name);
            while (e.scope != null) {
                if (m.overrides(e.sym, origin, this.types, false)) {
                    this.checkOverride(tree, m, (Symbol.MethodSymbol)e.sym, origin);
                }
                e = e.next();
            }
            t = this.types.supertype(t);
        }
    }

    void checkAllDefined(int pos, Symbol.ClassSymbol c) {
        try {
            Symbol.MethodSymbol undef = this.firstUndef(c, c);
            if (undef != null) {
                if ((c.flags() & 0x4000L) != 0L && this.types.supertype((Type)c.type).tsym == this.syms.enumSym && (c.flags() & 0x10L) == 0L) {
                    c.flags_field |= 0x400L;
                } else {
                    Symbol.MethodSymbol undef1 = new Symbol.MethodSymbol(undef.flags(), undef.name, this.types.memberType(c.type, undef), undef.owner);
                    this.log.error(pos, "does.not.override.abstract", new Object[]{c, undef1, undef1.location()});
                }
            }
        }
        catch (Symbol.CompletionFailure ex) {
            this.completionError(pos, ex);
        }
    }

    private Symbol.MethodSymbol firstUndef(Symbol.ClassSymbol impl, Symbol.ClassSymbol c) {
        Symbol.MethodSymbol undef = null;
        if (c == impl || (c.flags() & 0x600L) != 0L) {
            Scope s = c.members();
            Scope.Entry e = s.elems;
            while (undef == null && e != null) {
                Symbol.MethodSymbol absmeth;
                Symbol.MethodSymbol implmeth;
                if (e.sym.kind == 16 && (e.sym.flags() & 0x200400L) == 1024L && ((implmeth = (absmeth = (Symbol.MethodSymbol)e.sym).implementation(impl, this.types, true)) == null || implmeth == absmeth)) {
                    undef = absmeth;
                }
                e = e.sibling;
            }
            if (undef == null) {
                Type st = this.types.supertype(c.type);
                if (st.tag == 10) {
                    undef = this.firstUndef(impl, (Symbol.ClassSymbol)st.tsym);
                }
            }
            List<Type> l = this.types.interfaces(c.type);
            while (undef == null && l.nonEmpty()) {
                undef = this.firstUndef(impl, (Symbol.ClassSymbol)((Type)l.head).tsym);
                l = l.tail;
            }
        }
        return undef;
    }

    void checkNonCyclic(int pos, Type t) {
        this.checkNonCyclicInternal(pos, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkNonCyclicInternal(int pos, Type t) {
        boolean complete = true;
        Symbol.TypeSymbol c = t.tsym;
        if ((c.flags_field & 0x40000000L) != 0L) {
            return true;
        }
        if ((c.flags_field & 0x8000000L) != 0L) {
            this.noteCyclic(pos, (Symbol.ClassSymbol)c);
        } else if (!c.type.isErroneous()) {
            try {
                c.flags_field |= 0x8000000L;
                if (c.type.tag == 10) {
                    Type st;
                    Type.ClassType clazz = (Type.ClassType)c.type;
                    if (clazz.interfaces_field != null) {
                        List<Type> l = clazz.interfaces_field;
                        while (l.nonEmpty()) {
                            complete &= this.checkNonCyclicInternal(pos, (Type)l.head);
                            l = l.tail;
                        }
                    }
                    if (clazz.supertype_field != null && (st = clazz.supertype_field) != null && st.tag == 10) {
                        complete &= this.checkNonCyclicInternal(pos, st);
                    }
                    if (c.owner.kind == 2) {
                        complete &= this.checkNonCyclicInternal(pos, c.owner.type);
                    }
                }
            }
            finally {
                c.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            }
        }
        if (complete) {
            boolean bl = complete = (c.flags_field & 0x10000000L) == 0L && c.completer == null;
        }
        if (complete) {
            c.flags_field |= 0x40000000L;
        }
        return complete;
    }

    private void noteCyclic(int pos, Symbol.ClassSymbol c) {
        this.log.error(pos, "cyclic.inheritance", new Object[]{c});
        List<Type> l = this.types.interfaces(c.type);
        while (l.nonEmpty()) {
            l.head = new Type.ErrorType((Symbol.ClassSymbol)((Type)l.head).tsym);
            l = l.tail;
        }
        Type st = this.types.supertype(c.type);
        if (st.tag == 10) {
            ((Type.ClassType)c.type).supertype_field = new Type.ErrorType((Symbol.ClassSymbol)st.tsym);
        }
        c.type = new Type.ErrorType(c);
        c.flags_field |= 0x40000000L;
    }

    void checkImplementations(Tree.ClassDef tree) {
        this.checkImplementations(tree, tree.sym);
    }

    void checkImplementations(Tree.ClassDef tree, Symbol.ClassSymbol ic) {
        Symbol.ClassSymbol origin = tree.sym;
        if ((this.allowGenerics || origin != ic) && (ic.flags() & 0x400L) != 0L) {
            Scope.Entry e = ic.members().elems;
            while (e != null) {
                Symbol.MethodSymbol absmeth;
                Symbol.MethodSymbol implmeth;
                if (e.sym.kind == 16 && (e.sym.flags() & 0x408L) == 1024L && (implmeth = (absmeth = (Symbol.MethodSymbol)e.sym).implementation(origin, this.types, false)) != null && implmeth != absmeth && (implmeth.owner.flags() & 0x200L) == (origin.flags() & 0x200L)) {
                    this.checkOverride(tree, implmeth, absmeth, origin);
                }
                e = e.sibling;
            }
        }
        Type st = this.types.supertype(ic.type);
        if (st.tag == 10) {
            this.checkImplementations(tree, (Symbol.ClassSymbol)st.tsym);
        }
        List<Type> l = this.types.interfaces(ic.type);
        while (l.nonEmpty()) {
            this.checkImplementations(tree, (Symbol.ClassSymbol)((Type)l.head).tsym);
            l = l.tail;
        }
    }

    void checkCompatibleSupertypes(int pos, Type c) {
        List<Type> supertypes = this.types.interfaces(c);
        Type supertype = this.types.supertype(c);
        if (supertype.tag == 10 && (supertype.tsym.flags() & 0x400L) != 0L) {
            supertypes = supertypes.prepend(supertype);
        }
        List<Type> l = supertypes;
        while (l.nonEmpty()) {
            if (this.allowGenerics && !((Type)l.head).typarams().isEmpty() && !this.checkCompatibleAbstracts(pos, (Type)l.head, (Type)l.head, c)) {
                return;
            }
            List<Type> m = supertypes;
            while (m != l) {
                if (!this.checkCompatibleAbstracts(pos, (Type)l.head, (Type)m.head, c)) {
                    return;
                }
                m = m.tail;
            }
            l = l.tail;
        }
        this.checkCompatibleConcretes(pos, c);
    }

    void checkClassBounds(int pos, Type type) {
        this.checkClassBounds(pos, new HashMap<Symbol.TypeSymbol, Type>(), type);
    }

    void checkClassBounds(int pos, Map<Symbol.TypeSymbol, Type> seensofar, Type type) {
        if (type.isErroneous()) {
            return;
        }
        List<Type> l = this.types.interfaces(type);
        while (l.nonEmpty()) {
            List<Type> newparams;
            List<Type> oldparams;
            Type it = (Type)l.head;
            Type oldit = seensofar.put(it.tsym, it);
            if (oldit != null && !this.types.containsTypeEquivalent(oldparams = oldit.allparams(), newparams = it.allparams())) {
                this.log.error(pos, "cant.inherit.diff.arg", new Object[]{it.tsym, Type.toString(oldparams), Type.toString(newparams)});
            }
            this.checkClassBounds(pos, seensofar, it);
            l = l.tail;
        }
        Type st = this.types.supertype(type);
        if (st != null) {
            this.checkClassBounds(pos, seensofar, st);
        }
    }

    void checkNotRepeated(int pos, Type it, Set<Type> its) {
        if (its.contains(it)) {
            this.log.error(pos, "repeated.interface", new Object[0]);
        } else {
            its.add(it);
        }
    }

    void validateAnnotationType(Tree restype) {
        if (restype != null) {
            this.validateAnnotationType(restype.pos, restype.type);
        }
    }

    void validateAnnotationType(int pos, Type type) {
        if (type.isPrimitive()) {
            return;
        }
        if (this.types.isSameType(type, this.syms.stringType)) {
            return;
        }
        if ((type.tsym.flags() & 0x4000L) != 0L) {
            return;
        }
        if ((type.tsym.flags() & 0x2000L) != 0L) {
            return;
        }
        if (this.types.lowerBound((Type)type).tsym == this.syms.classType.tsym) {
            return;
        }
        if (this.types.isArray(type) && !this.types.isArray(this.types.elemtype(type))) {
            this.validateAnnotationType(pos, this.types.elemtype(type));
            return;
        }
        this.log.error(pos, "invalid.annotation.member.type", new Object[0]);
    }

    public void validateAnnotations(List<Tree.Annotation> annotations, Symbol s) {
        if (this.skipAnnotations) {
            return;
        }
        for (Tree.Annotation a : annotations) {
            this.validateAnnotation(a, s);
        }
    }

    public void validateAnnotation(Tree.Annotation a, Symbol s) {
        this.validateAnnotation(a);
        if (!this.annotationApplicable(a, s)) {
            this.log.error(a.pos, "annotation.type.not.applicable", new Object[0]);
        }
        if (a.annotationType.type.tsym == this.syms.overrideType.tsym && !this.isOverrider(s)) {
            this.log.error(a.pos, "method.does.not.override.superclass", new Object[0]);
        }
    }

    boolean isOverrider(Symbol s) {
        if (s.kind != 16) {
            return false;
        }
        Symbol.MethodSymbol m = (Symbol.MethodSymbol)s;
        Symbol.TypeSymbol owner = (Symbol.TypeSymbol)m.owner;
        Type sup = this.types.supertype(m.owner.type);
        while (sup.tag == 10) {
            Scope.Entry e = sup.tsym.members().lookup(m.name);
            while (e.scope != null) {
                if (m.overrides(e.sym, owner, this.types, true)) {
                    return true;
                }
                e = e.next();
            }
            sup = this.types.supertype(sup);
        }
        return false;
    }

    boolean annotationApplicable(Tree.Annotation a, Symbol s) {
        Attribute.Compound atTarget = a.annotationType.type.tsym.attribute(this.syms.annotationTargetType.tsym);
        if (atTarget == null) {
            return true;
        }
        Attribute atValue = atTarget.member(this.names.value);
        if (!(atValue instanceof Attribute.Array)) {
            return true;
        }
        Attribute.Array arr = (Attribute.Array)atValue;
        for (Attribute app : arr.values) {
            if (!(app instanceof Attribute.Enum)) {
                return true;
            }
            Attribute.Enum e = (Attribute.Enum)app;
            if (e.value.name == this.names.TYPE) {
                if (s.kind != 2) continue;
                return true;
            }
            if (e.value.name == this.names.FIELD) {
                if (s.kind != 4 || s.owner.kind == 16) continue;
                return true;
            }
            if (e.value.name == this.names.METHOD) {
                if (s.kind != 16 || s.isConstructor()) continue;
                return true;
            }
            if (e.value.name == this.names.PARAMETER) {
                if (s.kind != 4 || s.owner.kind != 16 || (s.flags() & 0x200000000L) == 0L) continue;
                return true;
            }
            if (e.value.name == this.names.CONSTRUCTOR) {
                if (s.kind != 16 || !s.isConstructor()) continue;
                return true;
            }
            if (e.value.name == this.names.LOCAL_VARIABLE) {
                if (s.kind != 4 || s.owner.kind != 16 || (s.flags() & 0x200000000L) != 0L) continue;
                return true;
            }
            if (e.value.name == this.names.ANNOTATION_TYPE) {
                if (s.kind != 2 || (s.flags() & 0x2000L) == 0L) continue;
                return true;
            }
            if (e.value.name == this.names.PACKAGE) {
                if (s.kind != 1) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public void validateAnnotation(Tree.Annotation a) {
        Symbol m3;
        if (a.type.isErroneous()) {
            return;
        }
        HashSet<Symbol.MethodSymbol> members = new HashSet<Symbol.MethodSymbol>();
        Scope.Entry e = a.annotationType.type.tsym.members().elems;
        while (e != null) {
            if (e.sym.kind == 16) {
                members.add((Symbol.MethodSymbol)e.sym);
            }
            e = e.sibling;
        }
        for (Tree arg : a.args) {
            if (arg.tag != 30) continue;
            Tree.Assign assign = (Tree.Assign)arg;
            Symbol m2 = TreeInfo.symbol(assign.lhs);
            if (m2 == null || m2.type.isErroneous()) continue;
            if (!members.remove(m2)) {
                this.log.error(arg.pos, "duplicate.annotation.member.value", new Object[]{m2.name, a.type});
            }
            if (assign.rhs.tag != 8192) continue;
            this.validateAnnotation((Tree.Annotation)assign.rhs);
        }
        for (Symbol m3 : members) {
            if (m3.defaultValue != null || m3.type.isErroneous()) continue;
            this.log.error(a.pos, "annotation.missing.default.value", new Object[]{a.type, m3.name});
        }
        if (a.annotationType.type.tsym != this.syms.annotationTargetType.tsym || a.args.tail == null) {
            return;
        }
        if (((Tree)a.args.head).tag != 30) {
            return;
        }
        Tree.Assign assign = (Tree.Assign)a.args.head;
        m3 = TreeInfo.symbol(assign.lhs);
        if (m3.name != this.names.value) {
            return;
        }
        Tree rhs = assign.rhs;
        if (rhs.tag != 28) {
            return;
        }
        Tree.NewArray na = (Tree.NewArray)rhs;
        HashSet<Symbol> targets = new HashSet<Symbol>();
        for (Tree elem : na.elems) {
            if (targets.add(TreeInfo.symbol(elem))) continue;
            this.log.error(elem.pos, "repeated.annotation.target", new Object[0]);
        }
    }

    void checkDeprecatedAnnotation(int pos, Symbol s) {
        if (this.checkDeprecatedAnnotation && this.allowAnnotations && (s.flags() & 0x20000L) != 0L && !this.syms.deprecatedType.isErroneous() && s.attribute(this.syms.deprecatedType.tsym) == null) {
            this.log.warning(pos, "missing.deprecated.annotation", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkNonCyclicElements(Tree.ClassDef tree) {
        if ((tree.sym.flags_field & 0x2000L) == 0L) {
            return;
        }
        if (!$assertionsDisabled && (tree.sym.flags_field & 0x8000000L) != 0L) {
            throw new AssertionError();
        }
        try {
            tree.sym.flags_field |= 0x8000000L;
            for (Tree def : tree.defs) {
                if (def.tag != 4) continue;
                Tree.MethodDef meth = (Tree.MethodDef)def;
                this.checkAnnotationResType(meth.pos, meth.restype.type);
            }
        }
        finally {
            tree.sym.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            tree.sym.flags_field |= 8L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkNonCyclicElementsInternal(int pos, Symbol.TypeSymbol tsym) {
        if ((tsym.flags_field & 8L) != 0L) {
            return;
        }
        if ((tsym.flags_field & 0x8000000L) != 0L) {
            this.log.error(pos, "cyclic.annotation.element", new Object[0]);
            return;
        }
        try {
            tsym.flags_field |= 0x8000000L;
            Scope.Entry e = tsym.members().elems;
            while (e != null) {
                Symbol s = e.sym;
                if (s.kind == 16) {
                    this.checkAnnotationResType(pos, ((Symbol.MethodSymbol)s).type.restype());
                }
                e = e.sibling;
            }
        }
        finally {
            tsym.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            tsym.flags_field |= 8L;
        }
    }

    void checkAnnotationResType(int pos, Type type) {
        switch (type.tag) {
            case 10: {
                if ((type.tsym.flags() & 0x2000L) == 0L) break;
                this.checkNonCyclicElementsInternal(pos, type.tsym);
                break;
            }
            case 11: {
                this.checkAnnotationResType(pos, this.types.elemtype(type));
                break;
            }
        }
    }

    void checkCyclicConstructors(Tree.ClassDef tree) {
        HashMap<Symbol, Symbol> callMap = new HashMap<Symbol, Symbol>();
        List<Tree> l = tree.defs;
        while (l.nonEmpty()) {
            Tree.Apply app = TreeInfo.firstConstructorCall((Tree)l.head);
            if (app != null) {
                Tree.MethodDef meth = (Tree.MethodDef)l.head;
                if (TreeInfo.name(app.meth) == this.names._this) {
                    callMap.put(meth.sym, TreeInfo.symbol(app.meth));
                } else {
                    meth.sym.flags_field |= 0x40000000L;
                }
            }
            l = l.tail;
        }
        Symbol[] ctors = new Symbol[]{};
        for (Symbol caller : ctors = callMap.keySet().toArray(ctors)) {
            this.checkCyclicConstructor(tree, caller, callMap);
        }
    }

    private void checkCyclicConstructor(Tree.ClassDef tree, Symbol ctor, Map<Symbol, Symbol> callMap) {
        if (ctor != null && (ctor.flags_field & 0x40000000L) == 0L) {
            if ((ctor.flags_field & 0x8000000L) != 0L) {
                this.log.error(TreeInfo.positionFor(ctor, tree), "recursive.ctor.invocation", new Object[0]);
            } else {
                ctor.flags_field |= 0x8000000L;
                this.checkCyclicConstructor(tree, callMap.remove(ctor), callMap);
                ctor.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            }
            ctor.flags_field |= 0x40000000L;
        }
    }

    boolean checkUnique(int pos, Symbol sym, Scope s) {
        if (sym.owner.name == this.names.any) {
            return false;
        }
        Scope.Entry e = s.lookup(sym.name);
        while (e.scope == s) {
            if (sym != e.sym && sym.kind == e.sym.kind && sym.name != this.names.error && (sym.kind != 16 || this.types.overrideEquivalent(sym.type, e.sym.type))) {
                this.duplicateError(pos, e.sym);
                return false;
            }
            e = e.next();
        }
        return true;
    }

    boolean checkUniqueImport(int pos, Symbol sym, Scope s) {
        Scope.Entry e = s.lookup(sym.name);
        while (e.scope != null) {
            boolean isClassDecl;
            boolean bl = isClassDecl = e.scope == s;
            if ((isClassDecl || sym != e.sym) && sym.kind == e.sym.kind && sym.name != this.names.error) {
                if (!e.sym.type.isErroneous()) {
                    String what = e.sym.toString();
                    if (!isClassDecl) {
                        this.log.error(pos, "already.defined.single.import", new Object[]{what});
                    } else if (sym != e.sym) {
                        this.log.error(pos, "already.defined.this.unit", new Object[]{what});
                    }
                }
                return false;
            }
            e = e.next();
        }
        return true;
    }

    public void checkCanonical(Tree tree) {
        if (!this.isCanonical(tree)) {
            this.log.error(tree.pos, "import.requires.canonical", new Object[]{TreeInfo.symbol(tree)});
        }
    }

    private boolean isCanonical(Tree tree) {
        while (tree.tag == 34) {
            Tree.Select s = (Tree.Select)tree;
            if (s.sym.owner != TreeInfo.symbol(s.selected)) {
                return false;
            }
            tree = s.selected;
        }
        return true;
    }

    public Warner castWarner(int pos, Type found, Type expected) {
        return new ConversionWarner(pos, "unchecked.cast.to.type", found, expected);
    }

    public Warner convertWarner(int pos, Type found, Type expected) {
        return new ConversionWarner(pos, "unchecked.assign", found, expected);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$tools$javac$comp$Check == null ? (class$com$sun$tools$javac$comp$Check = Check.class$("com.sun.tools.javac.comp.Check")) : class$com$sun$tools$javac$comp$Check).desiredAssertionStatus();
        checkKey = new Context.Key();
    }

    private class ConversionWarner
    extends Warner {
        final String key;
        final Type found;
        final Type expected;

        public ConversionWarner(int pos, String key, Type found, Type expected) {
            super(pos);
            this.key = key;
            this.found = found;
            this.expected = expected;
        }

        public void warnUnchecked() {
            boolean warned = this.warned;
            super.warnUnchecked();
            if (warned) {
                return;
            }
            Diagnostic problem = new Diagnostic(this.key, new Object[0]);
            Check.this.warnUnchecked(this.pos(), "prob.found.req", new Object[]{problem, this.found, this.expected});
        }
    }

    class Validator
    extends Tree.Visitor {
        Validator() {
        }

        public void visitTypeArray(Tree.TypeArray tree) {
            Check.this.validate(tree.elemtype);
        }

        public void visitTypeApply(Tree.TypeApply tree) {
            if (tree.type.tag == 10) {
                List<Type> formals = tree.type.tsym.type.typarams();
                List<Type> actuals = tree.type.typarams();
                List<Tree> args = tree.arguments;
                List<Type> forms = formals;
                ListBuffer<Type.TypeVar> tvars_buf = new ListBuffer<Type.TypeVar>();
                while (args.nonEmpty() && forms.nonEmpty()) {
                    Check.this.validate((Tree)args.head);
                    tvars_buf.append(Check.this.types.substBound((Type.TypeVar)forms.head, formals, Type.removeBounds(actuals)));
                    args = args.tail;
                    forms = forms.tail;
                }
                args = tree.arguments;
                List tvars = tvars_buf.toList();
                while (args.nonEmpty() && tvars.nonEmpty()) {
                    ((Tree)args.head).type.withTypeVar((Type)tvars.head);
                    args = args.tail;
                    tvars = tvars.tail;
                }
                args = tree.arguments;
                tvars = tvars_buf.toList();
                while (args.nonEmpty() && tvars.nonEmpty()) {
                    Check.this.checkExtends(((Tree)args.head).pos, ((Tree)args.head).type, (Type.TypeVar)tvars.head);
                    args = args.tail;
                    tvars = tvars.tail;
                }
                if (tree.type.outer().isRaw()) {
                    Check.this.log.error(tree.pos, "improperly.formed.type.inner.raw.param", new Object[0]);
                }
                if (tree.clazz.tag == 34) {
                    this.visitSelectInternal((Tree.Select)tree.clazz);
                }
            }
        }

        public void visitTypeParameter(Tree.TypeParameter tree) {
            Check.this.validate(tree.bounds);
            Check.this.checkClassBounds(tree.pos, tree.type);
        }

        public void visitSelect(Tree.Select tree) {
            if (tree.type.tag == 10) {
                this.visitSelectInternal(tree);
                if (tree.selected.type.isParameterized() && tree.type.tsym.type.typarams().nonEmpty()) {
                    Check.this.log.error(tree.pos, "improperly.formed.type.param.missing", new Object[0]);
                }
            }
        }

        public void visitSelectInternal(Tree.Select tree) {
            if (tree.type.outer().tag == 10) {
                Check.this.validate(tree.selected);
            } else if (tree.selected.type.isParameterized()) {
                Check.this.log.error(tree.pos, "cant.select.static.class.from.param.type", new Object[0]);
            }
        }

        public void visitTree(Tree tree) {
        }
    }
}

