/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.jvm.ByteCodes;
import com.sun.tools.javac.jvm.Code;
import com.sun.tools.javac.jvm.Pool;
import com.sun.tools.javac.tree.Tree;

public class Items {
    Pool pool;
    Code code;
    Symtab syms;
    Types types;
    private final Item voidItem;
    private final Item thisItem;
    private final Item superItem;
    private final Item[] stackItem = new Item[9];
    static /* synthetic */ Class class$com$sun$tools$javac$jvm$Items;

    public Items(Pool pool, Code code, Symtab syms, Types types) {
        this.code = code;
        this.pool = pool;
        this.types = types;
        this.voidItem = new Item(8){

            public String toString() {
                return "void";
            }
        };
        this.thisItem = new SelfItem(false);
        this.superItem = new SelfItem(true);
        for (int i = 0; i < 8; ++i) {
            this.stackItem[i] = new StackItem(i);
        }
        this.stackItem[8] = this.voidItem;
        this.syms = syms;
    }

    Item makeVoidItem() {
        return this.voidItem;
    }

    Item makeThisItem() {
        return this.thisItem;
    }

    Item makeSuperItem() {
        return this.superItem;
    }

    Item makeStackItem(Type type) {
        return this.stackItem[Code.typecode(type)];
    }

    Item makeIndexedItem(Type type) {
        return new IndexedItem(type);
    }

    LocalItem makeLocalItem(Symbol.VarSymbol v) {
        return new LocalItem(v.erasure(this.types), v.adr);
    }

    private LocalItem makeLocalItem(Type type, int reg) {
        return new LocalItem(type, reg);
    }

    Item makeStaticItem(Symbol member) {
        return new StaticItem(member);
    }

    Item makeMemberItem(Symbol member, boolean nonvirtual) {
        return new MemberItem(member, nonvirtual);
    }

    Item makeImmediateItem(Type type, Object value) {
        return new ImmediateItem(type, value);
    }

    Item makeAssignItem(Item lhs) {
        return new AssignItem(lhs);
    }

    CondItem makeCondItem(int opcode, Code.Chain truejumps, Code.Chain falsejumps) {
        return new CondItem(opcode, truejumps, falsejumps);
    }

    CondItem makeCondItem(int opcode) {
        return this.makeCondItem(opcode, null, null);
    }

    class CondItem
    extends Item {
        Code.Chain trueJumps;
        Code.Chain falseJumps;
        int opcode;
        Tree tree;
        static final /* synthetic */ boolean $assertionsDisabled;

        CondItem(int opcode, Code.Chain truejumps, Code.Chain falsejumps) {
            super(5);
            this.opcode = opcode;
            this.trueJumps = truejumps;
            this.falseJumps = falsejumps;
        }

        Item load() {
            Code.Chain trueChain = null;
            Code.Chain falseChain = this.jumpFalse();
            if (!this.isFalse()) {
                Items.this.code.resolve(this.trueJumps);
                Items.this.code.emitop0(4);
                trueChain = Items.this.code.branch(167);
            }
            if (falseChain != null) {
                Items.this.code.resolve(falseChain);
                Items.this.code.emitop0(3);
            }
            Items.this.code.resolve(trueChain);
            return Items.this.stackItem[this.typecode];
        }

        void duplicate() {
            this.load().duplicate();
        }

        void drop() {
            this.load().drop();
        }

        void stash(int toscode) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        CondItem mkCond() {
            return this;
        }

        Code.Chain jumpTrue() {
            if (this.tree == null) {
                Code cfr_ignored_0 = Items.this.code;
                return Code.mergeChains(this.trueJumps, Items.this.code.branch(this.opcode));
            }
            int startpc = Items.this.code.curPc();
            Code cfr_ignored_1 = Items.this.code;
            Code.Chain c = Code.mergeChains(this.trueJumps, Items.this.code.branch(this.opcode));
            Items.this.code.crt.put(this.tree, 128, startpc, Items.this.code.curPc());
            return c;
        }

        Code.Chain jumpFalse() {
            if (this.tree == null) {
                Code cfr_ignored_0 = Items.this.code;
                Code cfr_ignored_1 = Items.this.code;
                return Code.mergeChains(this.falseJumps, Items.this.code.branch(Code.negate(this.opcode)));
            }
            int startpc = Items.this.code.curPc();
            Code cfr_ignored_2 = Items.this.code;
            Code cfr_ignored_3 = Items.this.code;
            Code.Chain c = Code.mergeChains(this.falseJumps, Items.this.code.branch(Code.negate(this.opcode)));
            Items.this.code.crt.put(this.tree, 256, startpc, Items.this.code.curPc());
            return c;
        }

        CondItem negate() {
            Code cfr_ignored_0 = Items.this.code;
            CondItem c = new CondItem(Code.negate(this.opcode), this.falseJumps, this.trueJumps);
            c.tree = this.tree;
            return c;
        }

        int width() {
            throw new AssertionError();
        }

        boolean isTrue() {
            return this.falseJumps == null && this.opcode == 167;
        }

        boolean isFalse() {
            return this.trueJumps == null && this.opcode == 168;
        }

        public String toString() {
            return "cond(" + Code.mnem(this.opcode) + ")";
        }

        static {
            $assertionsDisabled = !(class$com$sun$tools$javac$jvm$Items == null ? (class$com$sun$tools$javac$jvm$Items = Items.class$("com.sun.tools.javac.jvm.Items")) : class$com$sun$tools$javac$jvm$Items).desiredAssertionStatus();
        }
    }

    class AssignItem
    extends Item {
        Item lhs;
        static final /* synthetic */ boolean $assertionsDisabled;

        AssignItem(Item lhs) {
            super(lhs.typecode);
            this.lhs = lhs;
        }

        Item load() {
            this.lhs.stash(this.typecode);
            this.lhs.store();
            return Items.this.stackItem[this.typecode];
        }

        void duplicate() {
            this.load().duplicate();
        }

        void drop() {
            this.lhs.store();
        }

        void stash(int toscode) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        int width() {
            return this.lhs.width() + Code.width(this.typecode);
        }

        public String toString() {
            return "assign(lhs = " + this.lhs + ")";
        }

        static {
            $assertionsDisabled = !(class$com$sun$tools$javac$jvm$Items == null ? (class$com$sun$tools$javac$jvm$Items = Items.class$("com.sun.tools.javac.jvm.Items")) : class$com$sun$tools$javac$jvm$Items).desiredAssertionStatus();
        }
    }

    class ImmediateItem
    extends Item {
        Object value;
        static final /* synthetic */ boolean $assertionsDisabled;

        ImmediateItem(Type type, Object value) {
            super(Code.typecode(type));
            this.value = value;
        }

        private void ldc() {
            int idx = Items.this.pool.put(this.value);
            if (this.typecode == 1 || this.typecode == 3) {
                Items.this.code.emitop2(20, idx);
            } else if (idx <= 255) {
                Items.this.code.emitop1(18, idx);
            } else {
                Items.this.code.emitop2(19, idx);
            }
        }

        Item load() {
            switch (this.typecode) {
                case 0: 
                case 5: 
                case 6: 
                case 7: {
                    int ival = ((Number)this.value).intValue();
                    if (-1 <= ival && ival <= 5) {
                        Items.this.code.emitop0(3 + ival);
                        break;
                    }
                    if (-128 <= ival && ival <= 127) {
                        Items.this.code.emitop1(16, ival);
                        break;
                    }
                    if (Short.MIN_VALUE <= ival && ival <= Short.MAX_VALUE) {
                        Items.this.code.emitop2(17, ival);
                        break;
                    }
                    this.ldc();
                    break;
                }
                case 1: {
                    long lval = ((Number)this.value).longValue();
                    if (lval == 0L || lval == 1L) {
                        Items.this.code.emitop0(9 + (int)lval);
                        break;
                    }
                    this.ldc();
                    break;
                }
                case 2: {
                    float fval = ((Number)this.value).floatValue();
                    if (this.isPosZero(fval) || (double)fval == 1.0 || (double)fval == 2.0) {
                        Items.this.code.emitop0(11 + (int)fval);
                        break;
                    }
                    this.ldc();
                    break;
                }
                case 3: {
                    double dval = ((Number)this.value).doubleValue();
                    if (this.isPosZero(dval) || dval == 1.0) {
                        Items.this.code.emitop0(14 + (int)dval);
                        break;
                    }
                    this.ldc();
                    break;
                }
                case 4: {
                    this.ldc();
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            return Items.this.stackItem[this.typecode];
        }

        private boolean isPosZero(float x) {
            return x == 0.0f && 1.0f / x > 0.0f;
        }

        private boolean isPosZero(double x) {
            return x == 0.0 && 1.0 / x > 0.0;
        }

        CondItem mkCond() {
            int ival = ((Number)this.value).intValue();
            return Items.this.makeCondItem(ival != 0 ? 167 : 168);
        }

        Item coerce(int targetcode) {
            if (this.typecode == targetcode) {
                return this;
            }
            switch (targetcode) {
                case 0: {
                    if (Code.truncate(this.typecode) == 0) {
                        return this;
                    }
                    return new ImmediateItem(Items.this.syms.intType, new Integer(((Number)this.value).intValue()));
                }
                case 1: {
                    return new ImmediateItem(Items.this.syms.longType, new Long(((Number)this.value).longValue()));
                }
                case 2: {
                    return new ImmediateItem(Items.this.syms.floatType, new Float(((Number)this.value).floatValue()));
                }
                case 3: {
                    return new ImmediateItem(Items.this.syms.doubleType, new Double(((Number)this.value).doubleValue()));
                }
                case 5: {
                    return new ImmediateItem(Items.this.syms.byteType, new Integer((byte)((Number)this.value).intValue()));
                }
                case 6: {
                    return new ImmediateItem(Items.this.syms.charType, new Integer((char)((Number)this.value).intValue()));
                }
                case 7: {
                    return new ImmediateItem(Items.this.syms.shortType, new Integer((short)((Number)this.value).intValue()));
                }
            }
            return super.coerce(targetcode);
        }

        public String toString() {
            return "immediate(" + this.value + ")";
        }

        static {
            $assertionsDisabled = !(class$com$sun$tools$javac$jvm$Items == null ? (class$com$sun$tools$javac$jvm$Items = Items.class$("com.sun.tools.javac.jvm.Items")) : class$com$sun$tools$javac$jvm$Items).desiredAssertionStatus();
        }
    }

    class MemberItem
    extends Item {
        Symbol member;
        boolean nonvirtual;

        MemberItem(Symbol member, boolean nonvirtual) {
            super(Code.typecode(member.erasure(Items.this.types)));
            this.member = member;
            this.nonvirtual = nonvirtual;
        }

        Item load() {
            Items.this.code.emitop2(180, Items.this.pool.put(this.member));
            return Items.this.stackItem[this.typecode];
        }

        void store() {
            Items.this.code.emitop2(181, Items.this.pool.put(this.member));
        }

        Item invoke() {
            Type.MethodType mtype = (Type.MethodType)this.member.externalType(Items.this.types);
            int rescode = Code.typecode(mtype.restype);
            if ((this.member.owner.flags() & 0x200L) != 0L) {
                Items.this.code.emitInvokeinterface(Items.this.pool.put(this.member), mtype);
            } else if (this.nonvirtual) {
                Items.this.code.emitInvokespecial(Items.this.pool.put(this.member), mtype);
            } else {
                Items.this.code.emitInvokevirtual(Items.this.pool.put(this.member), mtype);
            }
            return Items.this.stackItem[rescode];
        }

        void duplicate() {
            Items.this.stackItem[4].duplicate();
        }

        void drop() {
            Items.this.stackItem[4].drop();
        }

        void stash(int toscode) {
            Items.this.stackItem[4].stash(toscode);
        }

        int width() {
            return 1;
        }

        public String toString() {
            return "member(" + this.member + (this.nonvirtual ? " nonvirtual)" : ")");
        }
    }

    class StaticItem
    extends Item {
        Symbol member;

        StaticItem(Symbol member) {
            super(Code.typecode(member.erasure(Items.this.types)));
            this.member = member;
        }

        Item load() {
            Items.this.code.emitop2(178, Items.this.pool.put(this.member));
            return Items.this.stackItem[this.typecode];
        }

        void store() {
            Items.this.code.emitop2(179, Items.this.pool.put(this.member));
        }

        Item invoke() {
            Type.MethodType mtype = (Type.MethodType)this.member.erasure(Items.this.types);
            int argsize = Code.width(mtype.argtypes);
            int rescode = Code.typecode(mtype.restype);
            int sdiff = Code.width(rescode) - argsize;
            Items.this.code.emitInvokestatic(Items.this.pool.put(this.member), mtype);
            return Items.this.stackItem[rescode];
        }

        public String toString() {
            return "static(" + this.member + ")";
        }
    }

    class LocalItem
    extends Item {
        int reg;
        Type type;
        static final /* synthetic */ boolean $assertionsDisabled;

        LocalItem(Type type, int reg) {
            super(Code.typecode(type));
            if (!$assertionsDisabled && reg < 0) {
                throw new AssertionError();
            }
            this.type = type;
            this.reg = reg;
        }

        Item load() {
            if (this.reg <= 3) {
                Items.this.code.emitop0(26 + Code.truncate(this.typecode) * 4 + this.reg);
            } else {
                Items.this.code.emitop1w(21 + Code.truncate(this.typecode), this.reg);
            }
            return Items.this.stackItem[this.typecode];
        }

        void store() {
            if (this.reg <= 3) {
                Items.this.code.emitop0(59 + Code.truncate(this.typecode) * 4 + this.reg);
            } else {
                Items.this.code.emitop1w(54 + Code.truncate(this.typecode), this.reg);
            }
            Items.this.code.setDefined(this.reg);
        }

        void incr(int x) {
            if (this.typecode == 0 && x >= Short.MIN_VALUE && x <= Short.MAX_VALUE) {
                Items.this.code.emitop1w(132, this.reg, x);
            } else {
                this.load();
                if (x >= 0) {
                    Items.this.makeImmediateItem(Items.this.syms.intType, new Integer(x)).load();
                    Items.this.code.emitop0(96);
                } else {
                    Items.this.makeImmediateItem(Items.this.syms.intType, new Integer(-x)).load();
                    Items.this.code.emitop0(100);
                }
                Items.this.makeStackItem(Items.this.syms.intType).coerce(this.typecode);
                this.store();
            }
        }

        public String toString() {
            return "localItem(type=" + this.type + "; reg=" + this.reg + ")";
        }

        static {
            $assertionsDisabled = !(class$com$sun$tools$javac$jvm$Items == null ? (class$com$sun$tools$javac$jvm$Items = Items.class$("com.sun.tools.javac.jvm.Items")) : class$com$sun$tools$javac$jvm$Items).desiredAssertionStatus();
        }
    }

    class SelfItem
    extends Item {
        boolean isSuper;

        SelfItem(boolean isSuper) {
            super(4);
            this.isSuper = isSuper;
        }

        Item load() {
            Items.this.code.emitop0(42);
            return Items.this.stackItem[this.typecode];
        }

        public String toString() {
            return this.isSuper ? "super" : "this";
        }
    }

    class IndexedItem
    extends Item {
        IndexedItem(Type type) {
            super(Code.typecode(type));
        }

        Item load() {
            Items.this.code.emitop0(46 + this.typecode);
            return Items.this.stackItem[this.typecode];
        }

        void store() {
            Items.this.code.emitop0(79 + this.typecode);
        }

        void duplicate() {
            Items.this.code.emitop0(92);
        }

        void drop() {
            Items.this.code.emitop0(88);
        }

        void stash(int toscode) {
            Items.this.code.emitop0(91 + 3 * (Code.width(toscode) - 1));
        }

        int width() {
            return 2;
        }

        public String toString() {
            return "indexed(" + ByteCodes.typecodeNames[this.typecode] + ")";
        }
    }

    class StackItem
    extends Item {
        StackItem(int typecode) {
            super(typecode);
        }

        Item load() {
            return this;
        }

        void duplicate() {
            Items.this.code.emitop0(this.width() == 2 ? 92 : 89);
        }

        void drop() {
            Items.this.code.emitop0(this.width() == 2 ? 88 : 87);
        }

        void stash(int toscode) {
            Items.this.code.emitop0((this.width() == 2 ? 91 : 90) + 3 * (Code.width(toscode) - 1));
        }

        int width() {
            return Code.width(this.typecode);
        }

        public String toString() {
            return "stack(" + ByteCodes.typecodeNames[this.typecode] + ")";
        }
    }

    abstract class Item {
        int typecode;

        Item(int typecode) {
            this.typecode = typecode;
        }

        Item load() {
            throw new AssertionError();
        }

        void store() {
            throw new AssertionError((Object)("store unsupported: " + this));
        }

        Item invoke() {
            throw new AssertionError(this);
        }

        void duplicate() {
        }

        void drop() {
        }

        void stash(int toscode) {
            Items.this.stackItem[toscode].duplicate();
        }

        CondItem mkCond() {
            this.load();
            return Items.this.makeCondItem(154);
        }

        Item coerce(int targetcode) {
            if (this.typecode == targetcode) {
                return this;
            }
            this.load();
            int typecode1 = Code.truncate(this.typecode);
            int targetcode1 = Code.truncate(targetcode);
            if (typecode1 != targetcode1) {
                int offset = targetcode1 > typecode1 ? targetcode1 - 1 : targetcode1;
                Items.this.code.emitop0(133 + typecode1 * 3 + offset);
            }
            if (targetcode != targetcode1) {
                Items.this.code.emitop0(145 + targetcode - 5);
            }
            return Items.this.stackItem[targetcode];
        }

        Item coerce(Type targettype) {
            return this.coerce(Code.typecode(targettype));
        }

        int width() {
            return 0;
        }

        public abstract String toString();
    }
}

