/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.gjast;

import com.sun.tools.javac.tree.Tree;
import com.sun.tools.javac.tree.TreeScanner;
import org.netbeans.lib.java.parser.ASTContext;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.Token;

class ASVerifier {
    String filename;
    Tree tree;

    static void verify(String filename, Tree.TopLevel tree, ASTContext astContext) {
        ASVerifier verifier = new ASVerifier(filename, tree);
        verifier.verifyTreeAttribution();
        verifier.verifyASTrees((ASTree)tree, astContext);
    }

    ASVerifier(String filename, Tree.TopLevel tree) {
        this.filename = filename;
        this.tree = tree;
    }

    void verifyASTrees(ASTree ast, ASTContext astContext) {
        ASTree[] subs;
        if (ast instanceof Token && astContext.getToken(ast.getFirstToken()) != ast) {
            this.throwInvalidTokenFailure((Tree)ast);
        }
        if ((subs = ast.getSubTrees()) != null) {
            for (int i = 0; i < subs.length; ++i) {
                if (subs[i] == null) continue;
                this.verifyASTrees(subs[i], astContext);
            }
        }
    }

    void verifyTreeAttribution() {
        this.tree.accept(new TreeScanner(){

            public void visitTopLevel(Tree.TopLevel tree) {
                if (tree.packge == null) {
                    ASVerifier.this.throwNoSymbolFailure(tree, "packge");
                }
                super.visitTopLevel(tree);
            }

            public void visitImport(Tree.Import tree) {
                if (!tree.qualid.toString().endsWith("*")) {
                    super.visitImport(tree);
                }
            }

            public void visitClassDef(Tree.ClassDef tree) {
                if (tree.type == null) {
                    ASVerifier.this.throwNoTypeFailure(tree);
                }
                if (tree.sym == null) {
                    ASVerifier.this.throwNoSymbolFailure(tree, "sym");
                }
                super.visitClassDef(tree);
            }

            public void visitMethodDef(Tree.MethodDef tree) {
                if (tree.type == null) {
                    ASVerifier.this.throwNoTypeFailure(tree);
                }
                if (tree.sym == null) {
                    ASVerifier.this.throwNoSymbolFailure(tree, "sym");
                }
                super.visitMethodDef(tree);
            }

            public void visitVarDef(Tree.VarDef tree) {
                if (tree.type == null) {
                    ASVerifier.this.throwNoTypeFailure(tree);
                }
                if (tree.sym == null) {
                    ASVerifier.this.throwNoSymbolFailure(tree, "sym");
                }
                super.visitVarDef(tree);
            }

            public void visitNewClass(Tree.NewClass tree) {
                if (tree.constructor == null) {
                    ASVerifier.this.throwNoSymbolFailure(tree, "constructor");
                }
                super.visitNewClass(tree);
            }

            public void visitAssignop(Tree.Assignop tree) {
                if (tree.operator == null) {
                    ASVerifier.this.throwNoSymbolFailure(tree, "operator");
                }
                super.visitAssignop(tree);
            }

            public void visitUnary(Tree.Unary tree) {
                if (tree.operator == null) {
                    ASVerifier.this.throwNoSymbolFailure(tree, "operator");
                }
                super.visitUnary(tree);
            }

            public void visitBinary(Tree.Binary tree) {
                if (tree.operator == null) {
                    ASVerifier.this.throwNoSymbolFailure(tree, "operator");
                }
                super.visitBinary(tree);
            }

            public void visitSelect(Tree.Select tree) {
                if (tree.sym == null) {
                    ASVerifier.this.throwNoSymbolFailure(tree, "sym");
                }
                super.visitSelect(tree);
            }

            public void visitIdent(Tree.Ident tree) {
                if (tree.sym == null) {
                    ASVerifier.this.throwNoSymbolFailure(tree, "sym");
                }
                super.visitIdent(tree);
            }
        });
    }

    void throwNoTypeFailure(Tree tree) {
        this.throwFailure("no type found for", tree);
    }

    void throwNoSymbolFailure(Tree tree, String symname) {
        this.throwFailure("no " + symname + " symbol found for", tree);
    }

    void throwInvalidTokenFailure(Tree tree) {
        this.throwFailure("Token.getFirstToken() is not self-referential for", tree);
    }

    void throwFailure(String msg, Tree tree) {
        throw new AssertionError((Object)(msg + ' ' + tree.getClass().getName() + " in " + this.filename + ": \"" + tree.toString() + "\""));
    }
}

