/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.gjast.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.netbeans.lib.gjast.test.DumpASTree;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserTest
extends TestCase {
    public static final String srcdir = System.getProperty("test.source.dir", "test_sources");
    String diffOutput = "";

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String[] files = ParserTest.findFiles(srcdir);
        if (files == null) {
            throw new AssertionError((Object)"srcdir directory not found");
        }
        for (int i = 0; i < files.length; ++i) {
            suite.addTest((Test)new ParserTest(files[i]));
        }
        return suite;
    }

    public ParserTest(String filename) {
        super(filename);
    }

    protected void runTest() {
        DumpASTree.dump(new StringBuffer().append(srcdir).append(File.separator).append(this.getName()).toString(), "1.4");
        boolean pass = this.diffOutputs();
        ParserTest.assertTrue((String)this.diffOutput, (boolean)pass);
    }

    boolean diffOutputs() {
        String src1 = this.getSource(this.getName(), "old");
        String src2 = this.getSource(this.getName(), "new");
        return src1.length() != 0 && src1.equals(src2);
    }

    String getSource(String name, String suffix) {
        try {
            int n;
            String file = new StringBuffer().append(DumpASTree.dumpDir).append(File.separator).append(name).append(".").append(suffix).toString();
            FileReader fr = new FileReader(file);
            BufferedReader in = new BufferedReader(fr);
            StringWriter out = new StringWriter();
            char[] buf = new char[8192];
            while ((n = in.read(buf)) > 0) {
                out.write(buf, 0, n);
            }
            fr.close();
            return out.toString();
        }
        catch (IOException e) {
            return "";
        }
    }

    public static String[] findFiles(String topdir) {
        SourceFileFilter filter = new SourceFileFilter();
        ArrayList<String> nargs = new ArrayList<String>();
        ParserTest.expand(null, topdir, filter, nargs);
        String[] files = nargs.toArray(new String[0]);
        return files;
    }

    private static void expand(File dir, String name, SourceFileFilter filter, List<String> nargs) {
        File f;
        File file = f = dir != null ? new File(dir, name) : new File(name);
        if (filter.acceptFile(name)) {
            nargs.add(name);
            return;
        }
        String[] subnames = f.list();
        if (subnames == null) {
            return;
        }
        for (String sn : subnames) {
            if (!filter.acceptDirectory(sn)) continue;
            ParserTest.expand(f, sn, filter, nargs);
        }
    }

    public static class SourceFileFilter {
        public boolean acceptFile(String name) {
            return name.endsWith(".java") && !name.startsWith("s.") && !name.startsWith("p.");
        }

        public boolean acceptDirectory(String name) {
            return !name.equals("SCCS") && !name.equals("CVS") && !name.equals("Codemgr_wsdata") && !name.equals("deleted_files");
        }
    }
}

