/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.modules.j2ee.deployment.plugins.api.UISupport;
import org.netbeans.modules.j2ee.sun.ide.j2ee.LogHyperLinkSupport;
import org.openide.ErrorManager;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;

public final class LogViewerSupport
extends Thread {
    private InputOutput io;
    private String url;
    private static final HashMap logsMap = new HashMap();
    private long sampleInterval = 10000L;
    private File logfile;
    private boolean startAtBeginning = false;
    private boolean working = false;
    private LogHyperLinkSupport.AppServerLogSupport logSupport;
    private BufferedReader reader = null;
    private boolean initRingerDone = false;
    private static int OLD_LINES = 600;
    private static int MAX_LINES = 25000;
    private static int LINES = 2000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogViewerSupport getLogViewerSupport(File file, String url, long sampleInterval, boolean startAtBeginning) {
        HashMap hashMap = logsMap;
        synchronized (hashMap) {
            LogViewerSupport logViewer = (LogViewerSupport)logsMap.get(url);
            if (logViewer == null) {
                logViewer = new LogViewerSupport(file, url, sampleInterval, startAtBeginning);
                logsMap.put(url, logViewer);
            }
            logViewer.sampleInterval = sampleInterval;
            logViewer.startAtBeginning = startAtBeginning;
            return logViewer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLogViewerSupport(String url) {
        HashMap hashMap = logsMap;
        synchronized (hashMap) {
            LogViewerSupport logViewer = (LogViewerSupport)logsMap.get(url);
            if (logViewer != null) {
                logsMap.remove(url);
                logViewer.working = false;
            }
        }
    }

    private LogViewerSupport(File file, String url, long sampleInterval, boolean startAtBeginning) {
        this.logfile = file;
        this.url = url;
        this.sampleInterval = sampleInterval;
        this.startAtBeginning = startAtBeginning;
        this.io = UISupport.getServerIO((String)url);
        this.logSupport = new LogHyperLinkSupport.AppServerLogSupport("", "/");
        this.setDaemon(true);
        this.start();
    }

    protected void printLine(String line) {
        String s = this.filterLine(line);
        if (!s.equals("") && !s.equals(" ")) {
            LogHyperLinkSupport.LineInfo lineInfo = this.logSupport.analyzeLine(s);
            if (lineInfo.isError()) {
                if (lineInfo.isAccessible()) {
                    try {
                        this.io.getOut().println(s, (OutputListener)this.logSupport.getLink(lineInfo.message(), lineInfo.path(), lineInfo.line()));
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                } else {
                    this.io.getOut().println(s);
                }
            } else {
                this.io.getOut().println(s);
            }
        }
    }

    public void stopTailing() {
        this.working = false;
    }

    private void initRingBuffer(Ring ring) {
        block9: {
            try {
                if (this.reader != null) {
                    try {
                        this.reader.close();
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                    this.reader = null;
                }
                if (!this.logfile.exists()) break block9;
                this.reader = new BufferedReader(new FileReader(this.logfile));
                try {
                    String line;
                    while ((line = this.reader.readLine()) != null) {
                        ring.add(line);
                    }
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                if (this.startAtBeginning) {
                    ring.output();
                }
                ring.setMaxCount(LINES);
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block54: {
            long currentIndex = 0L;
            long currentNbofFileLogs = this.logfile.getParentFile().list().length;
            boolean needTosleep = true;
            boolean needToRotate = false;
            boolean alreadyRotated = false;
            this.working = true;
            int lines = 0;
            Ring ring = new Ring(OLD_LINES);
            currentIndex = this.logfile.length();
            block37: while (true) {
                try {
                    while (this.working) {
                        needTosleep = true;
                        try {
                            String line;
                            if (!this.initRingerDone) {
                                this.initRingBuffer(ring);
                                currentIndex = this.logfile.length();
                                this.initRingerDone = true;
                            }
                            if (lines >= MAX_LINES) {
                                this.io.getOut().reset();
                                lines = ring.output();
                            }
                            long fileLength = this.logfile.length();
                            long newNbofFileLogs = this.logfile.getParentFile().list().length;
                            if (fileLength < currentIndex) {
                                needToRotate = true;
                            }
                            if (currentNbofFileLogs < newNbofFileLogs) {
                                needToRotate = true;
                                currentNbofFileLogs = newNbofFileLogs;
                            }
                            if (needToRotate) {
                                try {
                                    String string = line = this.reader != null ? this.reader.readLine() : null;
                                    if (line != null) {
                                        alreadyRotated = false;
                                    }
                                    while (line != null) {
                                        this.printLine(line);
                                        ring.add(line);
                                        line = this.reader.readLine();
                                        ++lines;
                                    }
                                }
                                catch (IOException ex) {
                                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                                    needToRotate = true;
                                }
                                if (!alreadyRotated) {
                                    this.printLine("----Log File Rotated---");
                                    alreadyRotated = true;
                                }
                                try {
                                    if (this.reader != null) {
                                        this.reader.close();
                                    }
                                }
                                catch (IOException ex) {
                                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                                }
                                if (this.logfile.exists()) {
                                    this.reader = new BufferedReader(new FileReader(this.logfile));
                                    currentIndex = 0L;
                                    needToRotate = false;
                                } else {
                                    this.reader = null;
                                }
                            }
                            try {
                                String string = line = this.reader != null ? this.reader.readLine() : null;
                                if (line != null) {
                                    alreadyRotated = false;
                                }
                                while (line != null) {
                                    this.printLine(line);
                                    ring.add(line);
                                    line = this.reader.readLine();
                                    ++lines;
                                }
                            }
                            catch (IOException ex) {
                                ErrorManager.getDefault().notify(1, (Throwable)ex);
                                needTosleep = false;
                                needToRotate = true;
                            }
                            currentIndex = this.logfile.length();
                            currentNbofFileLogs = this.logfile.getParentFile().list().length;
                        }
                        catch (Exception ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                            this.working = true;
                        }
                        finally {
                            try {
                                LogViewerSupport ex = this;
                                synchronized (ex) {
                                    if (needTosleep) {
                                        this.wait(100L);
                                    }
                                    continue block37;
                                }
                            }
                            catch (InterruptedException ex) {}
                            continue;
                            continue block37;
                        }
                    }
                    break block54;
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                    this.working = false;
                    break block54;
                }
                break;
            }
            finally {
                if (this.reader != null) {
                    try {
                        this.reader.close();
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                }
            }
        }
    }

    private String filterLine(String line) {
        if (!line.startsWith("[#")) {
            if (line.endsWith("|#]")) {
                line = line.substring(0, line.length() - 3);
            }
            return line;
        }
        String[] s = line.split("\\|");
        if (s == null) {
            return line;
        }
        if (s.length <= 6) {
            return "";
        }
        return s[6];
    }

    public InputOutput showLogViewer(boolean forced) throws IOException {
        this.io = UISupport.getServerIO((String)this.url);
        this.working = true;
        if (forced && this.io.isClosed()) {
            this.initRingerDone = false;
            this.io.getOut().reset();
        }
        this.io.select();
        return this.io;
    }

    private class Ring {
        private int maxCount;
        private int count;
        private LinkedList anchor;

        public Ring(int max) {
            this.maxCount = max;
            this.count = 0;
            this.anchor = new LinkedList();
        }

        public String add(String line) {
            if (line == null || line.equals("")) {
                return null;
            }
            while (this.count >= this.maxCount) {
                this.anchor.removeFirst();
                --this.count;
            }
            this.anchor.addLast(line);
            ++this.count;
            return line;
        }

        public void setMaxCount(int newMax) {
            this.maxCount = newMax;
        }

        public int output() {
            int i = 0;
            Iterator it = this.anchor.iterator();
            while (it.hasNext()) {
                LogViewerSupport.this.printLine((String)it.next());
                ++i;
            }
            return i;
        }

        public void reset() {
            this.anchor = new LinkedList();
        }
    }
}

