/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import ui.DOMParserSaveEncoding;
import ui.DOMTree;
import ui.DefaultImages;

public class TreeView
extends JFrame
implements ActionListener,
TextListener {
    private static final long serialVersionUID = 3688504394090098738L;
    static final boolean DEBUG = true;
    static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.DOMParser";
    static int WARNING = 0;
    static int ERROR = 1;
    static int FATAL_ERROR = 2;
    static final String title = "TreeViewer";
    static final String openString = "Open";
    static final String quitString = "Quit";
    static final String reloadString = "Reload current XML file";
    static final String expandString = "Expand Tree";
    static final String collapseString = "Collapse Tree";
    ErrorStorer ef;
    String fname;
    DOMTree m_tree;
    JTextArea sourceText;
    JTextArea messageText;
    Vector textLine;
    FileNameInput fni;
    DOMParserSaveEncoding parser;
    Image openFolder = DefaultImages.createOpenFolderImage();
    Image closedFolder = DefaultImages.createClosedFolderImage();
    Image leafImage = DefaultImages.createLeafImage();

    public TreeView() {
        this((String)null);
    }

    public TreeView(String string) {
        super(string);
        this.parser = new DOMParserSaveEncoding();
        this.ef = new ErrorStorer();
        this.fname = string;
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem(openString);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem(quitString);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        JMenu jMenu2 = new JMenu("Shortcuts");
        jMenuItem = new JMenuItem(expandString);
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem(collapseString);
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem(reloadString);
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
        this.getContentPane().add(this.createUI(this.fname));
    }

    JComponent createUI(String string) {
        System.out.println("START createUI:" + string);
        this.messageText = new JTextArea(3, 40);
        this.messageText.setFont(new Font("dialog", 0, 12));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.messageText){
            private static final long serialVersionUID = 3978426918603075632L;

            public Dimension getPreferredSize() {
                Dimension dimension = TreeView.this.getSize();
                return new Dimension(dimension.width, dimension.height / 4);
            }

            public Dimension getMinimumSize() {
                return new Dimension(100, 100);
            }
        }, "Center");
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Messages"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.sourceText = new JTextArea();
        this.sourceText.setFont(new Font("monospaced", 0, 12));
        this.sourceText.setBackground(Color.white);
        this.sourceText.setForeground(Color.black);
        this.sourceText.setSelectedTextColor(Color.black);
        this.sourceText.setSelectionColor(Color.red);
        this.sourceText.setEditable(false);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JScrollPane(this.sourceText){
            private static final long serialVersionUID = 4121135831458068789L;

            public Dimension getPreferredSize() {
                Dimension dimension = TreeView.this.getSize();
                return new Dimension(dimension.width / 2, dimension.height * 3 / 5);
            }

            public Dimension getMinimumSize() {
                return new Dimension(100, 100);
            }
        }, "Center");
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Source View"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.m_tree = new DOMTree();
        this.m_tree.setCellRenderer(new XMLTreeCellRenderer());
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreeNode treeNode = (TreeNode)treeSelectionEvent.getPath().getLastPathComponent();
                TreeView.this.nodeSelected(treeNode);
            }
        });
        this.m_tree.setRowHeight(18);
        this.m_tree.setFont(new Font("dialog", 0, 12));
        jPanel3.add((Component)new JScrollPane(this.m_tree){
            private static final long serialVersionUID = 3977860665971126320L;

            public Dimension getPreferredSize() {
                Dimension dimension = TreeView.this.getSize();
                return new Dimension(dimension.width / 2, dimension.height * 3 / 5);
            }

            public Dimension getMinimumSize() {
                return new Dimension(100, 100);
            }
        }, "Center");
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Tree View"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.refreshUI(string);
        JSplitPane jSplitPane = new JSplitPane(1, true, jPanel3, jPanel2);
        JSplitPane jSplitPane2 = new JSplitPane(0, true, jSplitPane, jPanel);
        System.out.println("END createUI:" + string);
        return jSplitPane2;
    }

    void refreshUI(String string) {
        System.out.println("START refreshUI:" + string);
        this.messageText.selectAll();
        this.messageText.cut();
        if (string == null || string.equals("")) {
            this.messageText.setForeground(Color.red);
            this.messageText.append("No input XML filename specified:" + string + "\n");
            return;
        }
        this.fname = string;
        Document document = this.getRoot(string);
        if (document == null) {
            this.messageText.setForeground(Color.red);
            this.messageText.append("Unable to get new DOM Tree for:" + string + "\n");
            return;
        }
        this.m_tree.setDocument(document);
        this.sourceText.selectAll();
        this.sourceText.cut();
        this.readXMLFile(this.fname, this.sourceText);
        this.setTitle("TreeViewer: " + string);
        if (this.m_tree != null) {
            this.expandTree();
        }
        if (this.ef != null && this.ef.getErrorNodes() != null && this.ef.getErrorNodes().size() > 0) {
            this.messageText.setForeground(Color.red);
            this.messageText.append("XML source, " + this.fname + " has errors.\n");
            this.messageText.append("Please click on red Tree View items for details.\n");
            Hashtable hashtable = this.ef.getErrorNodes();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Node node = (Node)enumeration.nextElement();
                this.messageText.append("node=" + node.getNodeName() + ", error=" + ((ParseError)hashtable.get(node)).getMsg() + "\n");
            }
        }
        System.out.println("END refreshUI:" + string);
    }

    public Document getRoot(String string) {
        System.out.println("START getRoot:" + string);
        if (string == null || string.equals("")) {
            return null;
        }
        try {
            this.ef.resetErrors();
            this.parser.setErrorHandler(this.ef);
            this.parser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            this.parser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
            this.parser.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            this.parser.parse(string);
            Document document = this.parser.getDocument();
            return document;
        }
        catch (Exception exception) {
            System.err.println("Error: Invalid XML document could not get ROOT");
            System.exit(1);
            return null;
        }
    }

    synchronized void readXMLFile(String string, JTextArea jTextArea) {
        Object object;
        System.out.println("START readXMLFile" + string);
        if (string == null || string.equals("")) {
            return;
        }
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            object = TreeView.createURL(string);
            inputStream = ((URL)object).openStream();
            String string2 = this.parser.getJavaEncoding();
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string2));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            }
        }
        catch (Exception exception) {
            System.err.println("ERROR: Xerces.readXMLFile: " + exception);
            return;
        }
        int n = 0;
        this.textLine = new Vector();
        String string3 = "\n";
        int n2 = string3.length();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while ((object = bufferedReader.readLine()) != null) {
                stringBuffer.append((String)object + string3);
                this.textLine.addElement(new Integer(n));
                n += ((String)object).length() + n2;
            }
            jTextArea.append(stringBuffer.toString());
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return;
        }
        System.out.println("END readXMLFile" + string);
    }

    void nodeSelected(TreeNode treeNode) {
        Object object;
        Node node = this.m_tree.getNode(treeNode);
        if (node == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.messageText.selectAll();
        this.messageText.cut();
        Object object2 = object = this.ef == null ? null : this.ef.getError(node);
        if (object != null) {
            this.messageText.setForeground(Color.red);
            ParseError parseError = (ParseError)object;
            stringBuffer.append("Error: " + parseError.getMsg() + "\n");
            int n = parseError.getLineNo();
            int n2 = 0;
            int n3 = 0;
            int n4 = this.textLine.size();
            if (n < n4) {
                n2 = (Integer)this.textLine.elementAt(n - 1);
                n3 = n == n4 ? n2 : (Integer)this.textLine.elementAt(n);
            } else {
                n2 = (Integer)this.textLine.elementAt(n4 - 1);
                n3 = n2 + 2;
            }
            this.sourceText.select(n2, n3);
        } else {
            this.messageText.setForeground(Color.black);
            this.sourceText.select(0, 0);
        }
        if (node.getNodeType() == 1 || node.getNodeType() == 3 || node.getNodeType() == 4) {
            stringBuffer.append(node.toString());
        }
        this.messageText.append(stringBuffer.toString());
    }

    public void textValueChanged(TextEvent textEvent) {
        try {
            if (this.fni != null) {
                ((Component)this.fni).setVisible(false);
            }
            this.fname = ((JTextField)textEvent.getSource()).getText();
            System.out.println("textValueChanged:" + this.fname);
            this.refreshUI(this.fname);
        }
        catch (Exception exception) {
            System.err.println("Error: while trying to refresh gui");
            System.exit(1);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        System.err.println("ACTION: " + actionEvent.getActionCommand() + ", " + actionEvent.paramString());
        if (actionEvent.getActionCommand().equals(quitString)) {
            System.exit(0);
        } else if (actionEvent.getActionCommand().equals(openString)) {
            this.fni = new FileNameInput("Open File");
            this.fni.addTextListener(this);
            ((Component)this.fni).setVisible(true);
        } else if (actionEvent.getActionCommand().equals(expandString)) {
            this.expandTree();
        } else if (actionEvent.getActionCommand().equals(collapseString)) {
            int n = this.m_tree.getRowCount();
            int n2 = 0;
            while (n2 < n) {
                this.m_tree.collapseRow(n2);
                ++n2;
            }
        } else {
            this.refreshUI(this.fname);
        }
    }

    void expandTree() {
        int n = 0;
        int n2 = 0;
        while (n2 <= 4) {
            n = this.m_tree.getRowCount();
            int n3 = 0;
            while (n3 < n) {
                this.m_tree.expandRow(n3);
                ++n3;
            }
            ++n2;
        }
    }

    static URL createURL(String string) throws Exception {
        try {
            URL uRL = new URL(string);
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            URL uRL = new URL("file:" + new File(string).getAbsolutePath());
            return uRL;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        var1_1 = -1;
        var2_2 = "org.apache.xerces.parsers.DOMParser";
        var3_3 = 0;
        while (var3_3 < var0.length) {
            var4_4 = var0[var3_3];
            if (!var4_4.startsWith("-")) ** GOTO lbl17
            if (var4_4.equals("-p")) {
                if (var3_3 == var0.length - 1) {
                    System.err.println("error: missing parser class");
                    System.exit(1);
                }
                var2_2 = var0[++var3_3];
                var1_1 = var3_3;
            } else {
                if (var4_4.equals("-h")) {
                    TreeView.printUsage();
                    System.exit(1);
                }
lbl17:
                // 4 sources

                System.err.println(var4_4 + ':');
                var5_5 = null;
                var5_5 = var1_1 == var0.length - 1 ? new TreeView("") : new TreeView(var4_4);
                var5_5.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        System.exit(0);
                    }
                });
                var5_5.setSize(790, 590);
                var5_5.setVisible(true);
            }
            ++var3_3;
        }
    }

    private static void printUsage() {
        System.err.println("usage: java ui.TreeViewer (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name  Specify DOM parser class by name.");
        System.err.println("           Default parser: org.apache.xerces.parsers.DOMParser");
        System.err.println("  -h       This help screen.");
    }

    class ParseError {
        String fileName;
        int lineNo;
        int charOffset;
        Object key;
        String msg;

        public ParseError(String string, int n, int n2, Object object, String string2) {
            this.fileName = string;
            this.lineNo = n;
            this.charOffset = n2;
            this.key = object;
            this.msg = string2;
        }

        public String getFileName() {
            return this.fileName;
        }

        public int getLineNo() {
            return this.lineNo;
        }

        public int getCharOffset() {
            return this.charOffset;
        }

        public Object getKey() {
            return this.key;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String string) {
            this.msg = string;
        }
    }

    class ErrorStorer
    implements ErrorHandler {
        Hashtable errorNodes = null;

        public Hashtable getErrorNodes() {
            return this.errorNodes;
        }

        public Object getError(Node node) {
            if (this.errorNodes == null) {
                return null;
            }
            return this.errorNodes.get(node);
        }

        public void resetErrors() {
            if (this.errorNodes != null) {
                this.errorNodes.clear();
            }
        }

        public void warning(SAXParseException sAXParseException) {
            this.handleError(sAXParseException, WARNING);
        }

        public void error(SAXParseException sAXParseException) {
            this.handleError(sAXParseException, ERROR);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.handleError(sAXParseException, FATAL_ERROR);
        }

        private void handleError(SAXParseException sAXParseException, int n) {
            System.out.println("!!! handleError: " + sAXParseException.getMessage());
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("at line number, ");
            stringBuffer.append(sAXParseException.getLineNumber());
            stringBuffer.append(": ");
            stringBuffer.append(sAXParseException.getMessage());
            Node node = null;
            try {
                node = (Node)TreeView.this.parser.getProperty("http://apache.org/xml/properties/dom/current-element-node");
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            if (node == null) {
                System.err.println("Error in handleError. getCurrentNode()==null!");
                return;
            }
            if (this.errorNodes == null) {
                this.errorNodes = new Hashtable();
            }
            ParseError parseError = (ParseError)this.errorNodes.get(node);
            ParseError parseError2 = null;
            if (parseError != null) {
                parseError2 = parseError;
                stringBuffer = new StringBuffer(parseError.getMsg() + "\n" + stringBuffer.toString());
                parseError2.setMsg(stringBuffer.toString());
            } else {
                parseError2 = new ParseError(sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), "", stringBuffer.toString());
            }
            this.errorNodes.put(node, parseError2);
        }
    }

    class FileNameInput
    extends JFrame
    implements ActionListener {
        private static final long serialVersionUID = 3257562893292615472L;
        JLabel fileLabel = new JLabel("Enter XML file name:");
        JTextField textField = new JTextField();
        JButton ok;
        JButton cancel;
        Vector textListeners;

        public FileNameInput() {
            this("");
        }

        public FileNameInput(String string) {
            super(string);
            this.textField.addActionListener(this);
            this.ok = new JButton("ok");
            this.cancel = new JButton("cancel");
            JPanel jPanel = new JPanel();
            jPanel.add(this.ok);
            jPanel.add(this.cancel);
            this.ok.addActionListener(this);
            this.cancel.addActionListener(this);
            this.getContentPane().add((Component)this.fileLabel, "North");
            this.getContentPane().add((Component)this.textField, "Center");
            this.getContentPane().add((Component)jPanel, "South");
            ((Component)this).setSize(400, 100);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.ok || actionEvent.getSource() == this.textField) {
                System.out.println("FileNameInput: pressed OK");
                TextEvent textEvent = new TextEvent(this.textField, 900);
                this.deliverEvent(textEvent);
                ((Component)this).setVisible(false);
            } else if (actionEvent.getSource() == this.cancel) {
                System.out.println("FileNameInput: pressed cancel");
                ((Component)this).setVisible(false);
            }
        }

        public void addTextListener(TextListener textListener) {
            if (textListener == null) {
                return;
            }
            if (this.textListeners == null) {
                this.textListeners = new Vector();
            }
            this.textListeners.addElement(textListener);
        }

        public void removeTextListener(TextListener textListener) {
            if (textListener == null || this.textListeners == null) {
                return;
            }
            this.textListeners.removeElement(textListener);
        }

        protected void deliverEvent(EventObject eventObject) {
            if (eventObject instanceof TextEvent) {
                Vector vector;
                TextEvent textEvent = (TextEvent)eventObject;
                Vector vector2 = this.textListeners;
                synchronized (vector2) {
                    vector = (Vector)this.textListeners.clone();
                }
                int n = vector.size();
                int n2 = 0;
                while (n2 < n) {
                    ((TextListener)vector.elementAt(n2)).textValueChanged(textEvent);
                    ++n2;
                }
            }
        }
    }

    class XMLTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 3761130444229720113L;

        XMLTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Element element;
            Attr attr;
            Node node = ((DOMTree)jTree).getNode(object);
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (bl) {
                component.setBackground(Color.blue);
            }
            if (TreeView.this.ef != null && TreeView.this.ef.getErrorNodes() != null && object != null && node != null && TreeView.this.ef.getErrorNodes().containsKey(node)) {
                component.setForeground(Color.red);
            }
            if (node != null) {
                if (bl3) {
                    this.setIcon(new ImageIcon(TreeView.this.leafImage));
                } else if (bl2) {
                    this.setIcon(new ImageIcon(TreeView.this.openFolder));
                } else {
                    this.setIcon(new ImageIcon(TreeView.this.closedFolder));
                }
            }
            if (node != null && node instanceof Element && (attr = (element = (Element)node).getAttributeNode("gender")) != null) {
                if (attr.getValue().equals("male")) {
                    this.setIcon(new ImageIcon("male.gif"));
                } else if (attr.getValue().equals("female")) {
                    this.setIcon(new ImageIcon("female.gif"));
                }
            }
            return component;
        }
    }
}

