IF(EXISTS /usr/include/dlfcn.h)
  SET(CMAKE_DL_LIBS "")
  SET(CMAKE_SHARED_LIBRARY_C_FLAGS "-fPIC")            # -pic 
  SET(CMAKE_SHARED_LIBRARY_CREATE_C_FLAGS "-shared")       # -shared
  SET(CMAKE_SHARED_LIBRARY_LINK_C_FLAGS "")         # +s, flag for exe link to use shared lib
  SET(CMAKE_SHARED_LIBRARY_RUNTIME_C_FLAG "-Wl,-rpath,")       # -rpath
  SET(CMAKE_SHARED_LIBRARY_RUNTIME_C_FLAG_SEP ":")   # : or empty
# XXX we set these so that they will be detected
  SET(CMAKE_SHARED_LIBRARY_SONAME_C_FLAG "-Wl,-soname,")
  SET(CMAKE_SHARED_LIBRARY_SONAME_CXX_FLAG "-Wl,-soname,")
ENDIF(EXISTS /usr/include/dlfcn.h)

IF($ENV{LOCALBASE})
SET(OPENBSD_LOCALBASE $ENV{LOCALBASE})
ELSE($ENV{LOCALBASE})
SET(OPENBSD_LOCALBASE /usr/local)
ENDIF($ENV{LOCALBASE})
IF($ENV{X11BASE})
SET(OPENBSD_X11BASE $ENV{X11BASE})
ELSE($ENV{X11BASE})
SET(OPENBSD_X11BASE /usr/X11R6)
ENDIF($ENV{X11BASE})
SET(CMAKE_OPENBSD_SHARED_LIBS "TRUE")

SET(CMAKE_SYSTEM_INCLUDE_PATH ${CMAKE_SYSTEM_INCLUDE_PATH} /usr/include  
  ${OPENBSD_LOCALBASE}/include ${OPENBSD_X11BASE}/include)
SET(CMAKE_SYSTEM_LIBRARY_PATH ${CMAKE_SYSTEM_LIBRARY_PATH} /usr/lib 
  ${OPENBSD_LOCALBASE}/lib ${OPENBSD_X11BASE}/lib)
SET(CMAKE_SYSTEM_PROGRAM_PATH ${CMAKE_SYSTEM_PROGRAM_PATH} /bin /usr/bin 
  ${OPENBSD_LOCALBASE}/bin /sbin /usr/sbin ${OPENBSD_LOCALBASE}/sbin)
# somewhat klugy, but produces the correct names.
SET(CMAKE_CXX_CREATE_SHARED_LIBRARY
      "<CMAKE_CXX_COMPILER> <CMAKE_SHARED_LIBRARY_CXX_FLAGS> <LANGUAGE_COMPILE_FLAGS> <LINK_FLAGS> <CMAKE_SHARED_LIBRARY_CREATE_CXX_FLAGS> -o <TARGET> <OBJECTS> <LINK_LIBRARIES>")
SET(CMAKE_C_CREATE_SHARED_LIBRARY
      "<CMAKE_C_COMPILER> <CMAKE_SHARED_LIBRARY_C_FLAGS> <LANGUAGE_COMPILE_FLAGS> <LINK_FLAGS> <CMAKE_SHARED_LIBRARY_CREATE_C_FLAGS> -o <TARGET> <OBJECTS> <LINK_LIBRARIES>")
SET(CMAKE_Fortran_CREATE_SHARED_LIBRARY
      "<CMAKE_Fortran_COMPILER> <CMAKE_SHARED_LIBRARY_Fortran_FLAGS> <LANGUAGE_COMPILE_FLAGS> <LINK_FLAGS> <CMAKE_SHARED_LIBRARY_CREATE_Fortran_FLAGS> -o <TARGET> <OBJECTS> <LINK_LIBRARIES>")
