#ifndef __ETHOS_VERSION_H__
#define __ETHOS_VERSION_H__

/**
 * SECTION:ethos-version
 * @title: Versioning
 * @short_description: compile time version checking
 *
 * Ethos provides some API and definitions for compile-time
 * version checking.
 */

/**
 * ETHOS_MAJOR_VERSION:
 *
 * Major version of Ethos, e.g. 1 in "1.2.3"
 */
#define ETHOS_MAJOR_VERSION      (0)

/**
 * ETHOS_MINOR_VERSION:
 *
 * Minor version of Ethos, e.g. 2 in "1.2.3"
 */
#define ETHOS_MINOR_VERSION      (2)

/**
 * ETHOS_MICRO_VERSION:
 *
 * Micro version of Ethos, e.g. 3 in "1.2.3"
 */
#define ETHOS_MICRO_VERSION      (2)

/**
 * ETHOS_API_VERSION_S:
 *
 * Version of the API of Ethos
 */
#define ETHOS_API_VERSION_S      "1.0"

/**
 * ETHOS_VERSION_S:
 *
 * Stringified version of Ethos, e.g. "1.2.3".
 *
 * Useful for display.
 */
#define ETHOS_VERSION_S          ""

/**
 * ETHOS_VERSION_HEX:
 *
 * Hexadecimally encoded version of Ethos, e.g. 0x01020300"
 *
 * Useful for comparisons.
 */
#define ETHOS_VERSION_HEX        (ETHOS_MAJOR_VERSION << 24 | \
                                  ETHOS_MINOR_VERSION << 16 | \
                                  ETHOS_MICRO_VERSION <<  8)

/**
 * ETHOS_CHECK_VERSION:
 * @major: major component of the version to check
 * @minor: minor component of the version to check
 * @micro: micro component of the version to check
 *
 * Checks whether the decomposed version (@major, @minor, @micro) is
 * bigger than the version of Ethos. This is a compile-time
 * check only.
 */
#define ETHOS_CHECK_VERSION(major,minor,micro)   \
        (ETHOS_MAJOR_VERSION >= (major) ||       \
         (ETHOS_MAJOR_VERSION == (major) &&      \
          ETHOS_MINOR_VERSION > (minor)) ||      \
         (ETHOS_MAJOR_VERSION == (major) &&      \
          ETHOS_MINOR_VERSION == (minor) &&      \
          ETHOS_MICRO_VERSION >= (micro)))

#endif /* __ETHOS_VERSION_H__ */
