'\"
'\" Generated from file '/usr/ports/obj/tcllib-1.11.1/tcllib-1.11.1/modules/textutil/adjust.man' by tcllib/doctools with format 'nroff'
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "textutil::adjust" n 0.7 textutil "Text and string utilities, macro processing"
.BS
.SH NAME
textutil::adjust \- Procedures to adjust, indent, and undent paragraphs
.SH SYNOPSIS
package require \fBTcl  8.2\fR
.sp
package require \fBtextutil::adjust  ?0.7?\fR
.sp
\fB::textutil::adjust::adjust\fR \fIstring\fR ?\fIoption value...\fR?
.sp
\fB::textutil::adjust::readPatterns\fR \fIfilename\fR
.sp
\fB::textutil::adjust::listPredefined\fR
.sp
\fB::textutil::adjust::getPredefined\fR \fIfilename\fR
.sp
\fB::textutil::adjust::indent\fR \fIstring\fR \fIprefix\fR ?\fIskip\fR?
.sp
\fB::textutil::adjust::undent\fR \fIstring\fR
.sp
.BE
.SH DESCRIPTION
The package \fBtextutil::adjust\fR provides commands that manipulate
strings or texts (a.k.a. long strings or string with embedded newlines
or paragraphs), adjusting, or indenting them.
.PP
The complete set of procedures is described below.
.TP
\fB::textutil::adjust::adjust\fR \fIstring\fR ?\fIoption value...\fR?
Do a justification on the \fIstring\fR according to the options.  The
string is taken as one big paragraph, ignoring any newlines.  Then the
line is formatted according to the options used, and the command
returns a new string with enough lines to contain all the printable
chars in the input string. A line is a set of characters between the
beginning of the string and a newline, or between 2 newlines, or
between a newline and the end of the string. If the input string is
small enough, the returned string won't contain any newlines.
.sp
Together with \fB::textutil::adjust::indent\fR it is possible to
create properly wrapped paragraphs with arbitrary indentations.
.sp
By default, any occurrence of space or tabulation characters are
replaced by a single space so that each word in a line is separated
from the next one by exactly one space character, and this forms a
\fIreal\fR line.
Each \fIreal\fR line is placed in a \fIlogical\fR line, which has
exactly a given length (see the option \fB-length\fR below).
The \fIreal\fR line may be shorter. Again by default, trailing spaces
are ignored before returning the string (see the option \fB-full\fR
below).
.sp
The following options may be used after the \fIstring\fR parameter,
and change the way the command places a \fIreal\fR line in a
\fIlogical\fR line.
.RS
.TP
\fB-full\fR \fIboolean\fR
If set to \fBfalse\fR (default), trailing space characters are
deleted before returning the string. If set to \fBtrue\fR, any
trailing space characters are left in the string.
.TP
\fB-hyphenate\fR \fIboolean\fR
If set to \fBfalse\fR (default), no hyphenation will be done. If set
to \fBtrue\fR, the command will try to hyphenate the last word of a
line. \fINote\fR: Hyphenation patterns must be loaded prior, using
the command \fB::textutil::adjust::readPatterns\fR.
.TP
\fB-justify\fR \fBcenter|left|plain|right\fR
Sets the justification of the returned string to either \fBleft\fR
(default), \fBcenter\fR, \fBplain\fR or \fBright\fR. The
justification means that any line in the returned string but the last
one is build according to the value.
If the justification is set to \fBplain\fR and the number of
printable chars in the last line is less than 90% of the length of a
line (see the option \fB-length\fR), then this line is justified
with the \fBleft\fR value, avoiding the expansion of this line when
it is too small. The meaning of each value is:
.RS
.TP
\fBcenter\fR
The real line is centered in the logical line. If needed, a set of
space characters are added at the beginning (half of the needed set)
and at the end (half of the needed set) of the line if required (see
the option \fB-full\fR).
.TP
\fBleft\fR
The real line is set on the left of the logical line. It means that
there are no space chars at the beginning of this line. If required,
all needed space chars are added at the end of the line (see the
option \fB-full\fR).
.TP
\fBplain\fR
The real line is exactly set in the logical line. It means that there
are no leading or trailing space chars. All the needed space chars are
added in the \fIreal\fR line, between 2 (or more) words.
.TP
\fBright\fR
The real line is set on the right of the logical line. It means that
there are no space chars at the end of this line, and there may be
some space chars at the beginning, despite of the \fB-full\fR option.
.RE
.TP
\fB-length\fR \fIinteger\fR
Set the length of the \fIlogical\fR line in the string to
\fIinteger\fR.  \fIinteger\fR must be a positive integer
value. Defaults to \fB72\fR.
.TP
\fB-strictlength\fR
\fIboolean\fR]
If set to \fBfalse\fR (default), a line can exceed the specified
\fB-length\fR if a single word is longer than \fB-length\fR. If
set to \fBtrue\fR, words that are longer than \fB-length\fR are
split so that no line exceeds the specified \fB-length\fR.
.RE
.TP
\fB::textutil::adjust::readPatterns\fR \fIfilename\fR
Loads the internal storage for hyphenation patterns with the contents
of the file \fIfilename\fR. This has to be done prior to calling
command \fB::textutil::adjust::adjust\fR with "\fB-hyphenate\fR
\fBtrue\fR", or the hyphenation process will not work correctly.
.sp
The package comes with a number of predefined pattern files, and the
command \fB::textutil::adjust::listPredefined\fR can be used to find
out their names.
.TP
\fB::textutil::adjust::listPredefined\fR
This command returns a list containing the names of the hyphenation
files coming with this package.
.TP
\fB::textutil::adjust::getPredefined\fR \fIfilename\fR
Use this command to query the package for the full path name of the
hyphenation file \fIfilename\fR coming with the package. Only the
filenames found in the list returned by
\fB::textutil::adjust::listPredefined\fR are legal arguments for this
command.
.TP
\fB::textutil::adjust::indent\fR \fIstring\fR \fIprefix\fR ?\fIskip\fR?
Each line in the \fIstring\fR is indented by adding the string
\fIprefix\fR at its beginning. The modified string is returned
as the result of the command.
.sp
If \fIskip\fR is specified the first \fIskip\fR lines are left
untouched. The default for \fIskip\fR is \fB0\fR, causing the
modification of all lines. Negative values for \fIskip\fR are treated
like \fB0\fR. In other words, \fIskip\fR > \fB0\fR creates a
hanging indentation.
.sp
Together with \fB::textutil::adjust::adjust\fR it is possible to
create properly wrapped paragraphs with arbitrary indentations.
.TP
\fB::textutil::adjust::undent\fR \fIstring\fR
The command computes the common prefix for all lines in \fIstring\fR
consisting solely out of whitespace, removes this from each line and
returns the modified string.
.sp
Lines containing only whitespace are always reduced to completely
empty lines. They and empty lines are also ignored when computing the
prefix to remove.
.sp
Together with \fB::textutil::adjust::adjust\fR it is possible to
create properly wrapped paragraphs with arbitrary indentations.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fItextutil\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH "SEE ALSO"
regexp(n), split(n), string(n)
.SH KEYWORDS
TeX, adjusting, formatting, hyphenation, indenting, justification, paragraph, string, undenting