'\"
'\" Generated from file '/usr/ports/obj/tcllib-1.11.1/tcllib-1.11.1/modules/struct/graph1.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2002 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "struct::graph v1" n 1.2.1 struct "Tcl Data Structures"
.BS
.SH NAME
struct::graph v1 \- Create and manipulate directed graph objects
.SH SYNOPSIS
package require \fBTcl  8.2\fR
.sp
package require \fBstruct::graph  ?1.2.1?\fR
.sp
\fBgraphName\fR \fIoption\fR ?\fIarg arg ...\fR?
.sp
\fIgraphName\fR \fBdestroy\fR
.sp
\fIgraphName\fR \fBarc append\fR \fIarc\fR ?-key \fIkey\fR? \fIvalue\fR
.sp
\fIgraphName\fR \fBarc delete\fR \fIarc\fR ?\fIarc\fR ...?
.sp
\fIgraphName\fR \fBarc exists\fR \fIarc\fR
.sp
\fIgraphName\fR \fBarc get\fR \fIarc\fR ?-key \fIkey\fR?
.sp
\fIgraphName\fR \fBarc getall\fR \fIarc\fR
.sp
\fIgraphName\fR \fBarc keys\fR \fIarc\fR
.sp
\fIgraphName\fR \fBarc keyexists\fR \fIarc\fR ?-key \fIkey\fR?
.sp
\fIgraphName\fR \fBarc insert\fR \fIstart\fR \fIend\fR ?\fIchild\fR?
.sp
\fIgraphName\fR \fBarc lappend\fR \fIarc\fR ?-key \fIkey\fR? \fIvalue\fR
.sp
\fIgraphName\fR \fBarc set\fR \fIarc\fR ?-key \fIkey\fR? ?\fIvalue\fR?
.sp
\fIgraphName\fR \fBarc source\fR \fIarc\fR
.sp
\fIgraphName\fR \fBarc target\fR \fIarc\fR
.sp
\fIgraphName\fR \fBarc unset\fR \fIarc\fR ?-key \fIkey\fR?
.sp
\fIgraphName\fR \fBarcs\fR ?-key \fIkey\fR? ?-value \fIvalue\fR? ?-in|-out|-adj|-inner|-embedding \fInodelist\fR?
.sp
\fIgraphName\fR \fBnode append\fR \fInode\fR ?-key \fIkey\fR? \fIvalue\fR
.sp
\fIgraphName\fR \fBnode degree\fR ?-in|-out? \fInode\fR
.sp
\fIgraphName\fR \fBnode delete\fR \fInode\fR ?\fInode\fR ...?
.sp
\fIgraphName\fR \fBnode exists\fR \fInode\fR
.sp
\fIgraphName\fR \fBnode get\fR \fInode\fR ?-key \fIkey\fR?
.sp
\fIgraphName\fR \fBnode getall\fR \fInode\fR
.sp
\fIgraphName\fR \fBnode keys\fR \fInode\fR
.sp
\fIgraphName\fR \fBnode keyexists\fR \fInode\fR ?-key \fIkey\fR?
.sp
\fIgraphName\fR \fBnode insert\fR ?\fIchild\fR?
.sp
\fIgraphName\fR \fBnode lappend\fR \fInode\fR ?-key \fIkey\fR? \fIvalue\fR
.sp
\fIgraphName\fR \fBnode opposite\fR \fInode\fR \fIarc\fR
.sp
\fIgraphName\fR \fBnode set\fR \fInode\fR ?-key \fIkey\fR? ?\fIvalue\fR?
.sp
\fIgraphName\fR \fBnode unset\fR \fInode\fR ?-key \fIkey\fR?
.sp
\fIgraphName\fR \fBnodes\fR ?-key \fIkey\fR? ?-value \fIvalue\fR? ?-in|-out|-adj|-inner|-embedding \fInodelist\fR?
.sp
\fIgraphName\fR \fBget\fR ?-key \fIkey\fR?
.sp
\fIgraphName\fR \fBgetall\fR
.sp
\fIgraphName\fR \fBkeys\fR
.sp
\fIgraphName\fR \fBkeyexists\fR ?-key \fIkey\fR?
.sp
\fIgraphName\fR \fBset\fR ?-key \fIkey\fR? ?\fIvalue\fR?
.sp
\fIgraphName\fR \fBswap\fR \fInode1\fR \fInode2\fR
.sp
\fIgraphName\fR \fBunset\fR ?-key \fIkey\fR?
.sp
\fIgraphName\fR \fBwalk\fR \fInode\fR ?-order \fIorder\fR? ?-type \fItype\fR? ?-dir \fIdirection\fR? -command \fIcmd\fR
.sp
.BE
.SH DESCRIPTION
.PP
The \fB::struct::graph\fR command creates a new graph object with an
associated global Tcl command whose name is \fIgraphName\fR.  This
command may be used to invoke various operations on the graph.  It has
the following general form:
.TP
\fBgraphName\fR \fIoption\fR ?\fIarg arg ...\fR?
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command.
.PP
.PP
A directed graph is a structure containing two collections of
elements, called \fInodes\fR and \fIarcs\fR respectively, together
with a relation ("connectivity") that places a general structure upon
the nodes and arcs.
.PP
Each arc is connected to two nodes, one of which is called the
\fIsource\fR and the other the \fItarget\fR. This imposes a
direction upon the arc, which is said to go from the source to the
target. It is allowed that source and target of an arc are the same
node. Such an arc is called a \fIloop\fR. Whenever a node is source
or target of an arc both are said to be \fIadjacent\fR. This extends
into a relation between nodes, i.e. if two nodes are connected through
at least one arc they are said to be \fIadjacent\fR too.
.PP
Each node can be the source and target for any number of arcs. The
former are called the \fIoutgoing arcs\fR of the node, the latter
the \fIincoming arcs\fR of the node. The number of edges in either
set is called the \fIin-\fR resp. the \fIout-degree\fR of the node.
.PP
In addition to maintaining the node and arc relationships, this graph
implementation allows any number of keyed values to be associated with
each node and arc.
.PP
The following commands are possible for graph objects:
.TP
\fIgraphName\fR \fBdestroy\fR
Destroy the graph, including its storage space and associated command.
.TP
\fIgraphName\fR \fBarc append\fR \fIarc\fR ?-key \fIkey\fR? \fIvalue\fR
Appends a \fIvalue\fR to one of the keyed values associated with an
\fIarc\fR. If no \fIkey\fR is specified, the key \fBdata\fR is
assumed.
.TP
\fIgraphName\fR \fBarc delete\fR \fIarc\fR ?\fIarc\fR ...?
Remove the specified arcs from the graph.
.TP
\fIgraphName\fR \fBarc exists\fR \fIarc\fR
Return true if the specified \fIarc\fR exists in the graph.
.TP
\fIgraphName\fR \fBarc get\fR \fIarc\fR ?-key \fIkey\fR?
Return the value associated with the key \fIkey\fR for the \fIarc\fR.
If no key is specified, the key \fBdata\fR is assumed.
.TP
\fIgraphName\fR \fBarc getall\fR \fIarc\fR
Returns a serialized list of key/value pairs (suitable for use with
[\fBarray set\fR]) for the \fIarc\fR.
.TP
\fIgraphName\fR \fBarc keys\fR \fIarc\fR
Returns a list of keys for the \fIarc\fR.
.TP
\fIgraphName\fR \fBarc keyexists\fR \fIarc\fR ?-key \fIkey\fR?
Return true if the specified \fIkey\fR exists for the \fIarc\fR. If no
\fIkey\fR is specified, the key \fBdata\fR is assumed.
.TP
\fIgraphName\fR \fBarc insert\fR \fIstart\fR \fIend\fR ?\fIchild\fR?
Insert an arc named \fIchild\fR into the graph beginning at the node
\fIstart\fR and ending at the node \fIend\fR. If the name of the new
arc is not specified the system will generate a unique name of the
form \fIarc\fR\fIx\fR.
.TP
\fIgraphName\fR \fBarc lappend\fR \fIarc\fR ?-key \fIkey\fR? \fIvalue\fR
Appends a \fIvalue\fR (as a list) to one of the keyed values
associated with an \fIarc\fR.  If no \fIkey\fR is specified, the key
\fBdata\fR is assumed.
.TP
\fIgraphName\fR \fBarc set\fR \fIarc\fR ?-key \fIkey\fR? ?\fIvalue\fR?
Set or get one of the keyed values associated with an arc.  If no key
is specified, the key \fBdata\fR is assumed.  Each arc that is
added to a graph has the empty string assigned to the key
\fBdata\fR automatically.  An arc may have any number of keyed
values associated with it.  If \fIvalue\fR is not specified, this
command returns the current value assigned to the key; if \fIvalue\fR
is specified, this command assigns that value to the key.
.TP
\fIgraphName\fR \fBarc source\fR \fIarc\fR
Return the node the given \fIarc\fR begins at.
.TP
\fIgraphName\fR \fBarc target\fR \fIarc\fR
Return the node the given \fIarc\fR ends at.
.TP
\fIgraphName\fR \fBarc unset\fR \fIarc\fR ?-key \fIkey\fR?
Remove a keyed value from the arc \fIarc\fR.  If no key is specified,
the key \fBdata\fR is assumed.
.TP
\fIgraphName\fR \fBarcs\fR ?-key \fIkey\fR? ?-value \fIvalue\fR? ?-in|-out|-adj|-inner|-embedding \fInodelist\fR?
Return a list of arcs in the graph. If no restriction is specified a
list containing all arcs is returned. Restrictions can limit the list
of returned arcs based on the nodes that are connected by the arc, on
the keyed values associated with the arc, or both. The restrictions
that involve connected nodes have a list of nodes as argument,
specified after the name of the restriction itself.
.RS
.TP
\fB-in\fR
Return a list of all arcs whose target is one of the nodes in the
\fInodelist\fR.
.TP
\fB-out\fR
Return a list of all arcs whose source is one of the nodes in the
\fInodelist\fR.
.TP
\fB-adj\fR
Return a list of all arcs adjacent to at least one of the nodes in the
\fInodelist\fR. This is the union of the nodes returned by
\fB-in\fR and \fB-out\fR.
.TP
\fB-inner\fR
Return a list of all arcs adjacent to two of the nodes in the
\fInodelist\fR. This is the set of arcs in the subgraph spawned by the
specified nodes.
.TP
\fB-embedding\fR
Return a list of all arcs adjacent to exactly one of the nodes in the
\fInodelist\fR. This is the set of arcs connecting the subgraph
spawned by the specified nodes to the rest of the graph.
.TP
\fB-key\fR \fIkey\fR
Limit the list of arcs that are returned to those arcs that have an
associated key \fIkey\fR.
.TP
\fB-value\fR \fIvalue\fR
This restriction can only be used in combination with
\fB-key\fR. It limits the list of arcs that are returned to those
arcs whose associated key \fIkey\fR has the value \fIvalue\fR.
.RE
.sp
The restrictions imposed by either \fB-in\fR, \fB-out\fR,
\fB-adj\fR, \fB-inner\fR, or \fB-embedded\fR are applied
first. Specifying more than one of them is illegal.
At last the restrictions set via \fB-key\fR (and \fB-value\fR)
are applied.
Specifying more than one \fB-key\fR (and \fB-value\fR) is
illegal.
.TP
\fIgraphName\fR \fBnode append\fR \fInode\fR ?-key \fIkey\fR? \fIvalue\fR
Appends a \fIvalue\fR to one of the keyed values associated with an
\fInode\fR. If no \fIkey\fR is specified, the key \fBdata\fR is
assumed.
.TP
\fIgraphName\fR \fBnode degree\fR ?-in|-out? \fInode\fR
Return the number of arcs adjacent to the specified \fInode\fR. If one
of the restrictions \fB-in\fR or \fB-out\fR is given only the
incoming resp. outgoing arcs are counted.
.TP
\fIgraphName\fR \fBnode delete\fR \fInode\fR ?\fInode\fR ...?
Remove the specified nodes from the graph.  All of the nodes' arcs
will be removed as well to prevent unconnected arcs.
.TP
\fIgraphName\fR \fBnode exists\fR \fInode\fR
Return true if the specified \fInode\fR exists in the graph.
.TP
\fIgraphName\fR \fBnode get\fR \fInode\fR ?-key \fIkey\fR?
Return the value associated with the key \fIkey\fR for the \fInode\fR.
If no key is specified, the key \fBdata\fR is assumed.
.TP
\fIgraphName\fR \fBnode getall\fR \fInode\fR
Returns a serialized list of key/value pairs (suitable for use with
[\fBarray set\fR]) for the \fInode\fR.
.TP
\fIgraphName\fR \fBnode keys\fR \fInode\fR
Returns a list of keys for the \fInode\fR.
.TP
\fIgraphName\fR \fBnode keyexists\fR \fInode\fR ?-key \fIkey\fR?
Return true if the specified \fIkey\fR exists for the \fInode\fR. If
no \fIkey\fR is specified, the key \fBdata\fR is assumed.
.TP
\fIgraphName\fR \fBnode insert\fR ?\fIchild\fR?
Insert a node named \fIchild\fR into the graph. The nodes has no arcs
connected to it. If the name of the new child is not specified the
system will generate a unique name of the form \fInode\fR\fIx\fR.
.TP
\fIgraphName\fR \fBnode lappend\fR \fInode\fR ?-key \fIkey\fR? \fIvalue\fR
Appends a \fIvalue\fR (as a list) to one of the keyed values
associated with an \fInode\fR. If no \fIkey\fR is specified, the key
\fBdata\fR is assumed.
.TP
\fIgraphName\fR \fBnode opposite\fR \fInode\fR \fIarc\fR
Return the node at the other end of the specified \fIarc\fR, which has
to be adjacent to the given \fInode\fR.
.TP
\fIgraphName\fR \fBnode set\fR \fInode\fR ?-key \fIkey\fR? ?\fIvalue\fR?
Set or get one of the keyed values associated with a node.  If no key
is specified, the key \fBdata\fR is assumed.  Each node that is
added to a graph has the empty string assigned to the key
\fBdata\fR automatically.  A node may have any number of keyed
values associated with it.  If \fIvalue\fR is not specified, this
command returns the current value assigned to the key; if \fIvalue\fR
is specified, this command assigns that value to the key.
.TP
\fIgraphName\fR \fBnode unset\fR \fInode\fR ?-key \fIkey\fR?
Remove a keyed value from the node \fInode\fR.  If no key is
specified, the key \fBdata\fR is assumed.
.TP
\fIgraphName\fR \fBnodes\fR ?-key \fIkey\fR? ?-value \fIvalue\fR? ?-in|-out|-adj|-inner|-embedding \fInodelist\fR?
Return a list of nodes in the graph. Restrictions can limit the list
of returned nodes based on neighboring nodes, or based on the keyed
values associated with the node. The restrictions that involve
neighboring nodes have a list of nodes as argument, specified after
the name of the restriction itself.
.sp
The possible restrictions are the same as for method
\fBarcs\fR. The set of nodes to return is computed as the union of
all source and target nodes for all the arcs satisfying the
restriction as defined for \fBarcs\fR.
.TP
\fIgraphName\fR \fBget\fR ?-key \fIkey\fR?
Return the value associated with the key \fIkey\fR for the graph. If
no key is specified, the key \fBdata\fR is assumed.
.TP
\fIgraphName\fR \fBgetall\fR
Returns a serialized list of key/value pairs (suitable for use with
[\fBarray set\fR]) for the whole graph.
.TP
\fIgraphName\fR \fBkeys\fR
Returns a list of keys for the whole graph.
.TP
\fIgraphName\fR \fBkeyexists\fR ?-key \fIkey\fR?
Return true if the specified \fIkey\fR exists for the whole graph. If no
\fIkey\fR is specified, the key \fBdata\fR is assumed.
.TP
\fIgraphName\fR \fBset\fR ?-key \fIkey\fR? ?\fIvalue\fR?
Set or get one of the keyed values associated with a graph. If no key
is specified, the key \fBdata\fR is assumed. Each graph has the
empty string assigned to the key \fBdata\fR automatically. A graph
may have any number of keyed values associated with it. If \fIvalue\fR
is not specified, this command returns the current value assigned to
the key; if \fIvalue\fR is specified, this command assigns that value
to the key.
.TP
\fIgraphName\fR \fBswap\fR \fInode1\fR \fInode2\fR
Swap the position of \fInode1\fR and \fInode2\fR in the graph.
.TP
\fIgraphName\fR \fBunset\fR ?-key \fIkey\fR?
Remove a keyed value from the graph. If no key is specified, the key
\fBdata\fR is assumed.
.TP
\fIgraphName\fR \fBwalk\fR \fInode\fR ?-order \fIorder\fR? ?-type \fItype\fR? ?-dir \fIdirection\fR? -command \fIcmd\fR
Perform a breadth-first or depth-first walk of the graph starting at
the node \fInode\fR going in either the direction of outgoing or
opposite to the incoming arcs.
.sp
The type of walk, breadth-first or depth-first, is determined by the
value of \fItype\fR; \fBbfs\fR indicates breadth-first,
\fBdfs\fR indicates depth-first.  Depth-first is the default.
.sp
The order of the walk, pre-order, post-order or both-order is
determined by the value of \fIorder\fR; \fBpre\fR indicates
pre-order, \fBpost\fR indicates post-order, \fBboth\fR indicates
both-order. Pre-order is the default. Pre-order walking means that a
node is visited before any of its neighbors (as defined by the
\fIdirection\fR, see below). Post-order walking means that a parent is
visited after any of its neighbors. Both-order walking means that a
node is visited before \fIand\fR after any of its neighbors. The
combination of a bread-first walk with post- or both-order is illegal.
.sp
The direction of the walk is determined by the value of \fIdir\fR;
\fBbackward\fR indicates the direction opposite to the incoming
arcs, \fBforward\fR indicates the direction of the outgoing arcs.
.sp
As the walk progresses, the command \fIcmd\fR will be evaluated at
each node, with the mode of the call (\fBenter\fR or
\fBleave\fR) and values \fIgraphName\fR and the name of the current
node appended. For a pre-order walk, all nodes are \fBenter\fRed, for a
post-order all nodes are left. In a both-order walk the first visit of
a node \fBenter\fRs it, the second visit \fBleave\fRs it.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIstruct :: graph\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
cgraph, graph
.SH COPYRIGHT
.nf
Copyright (c) 2002 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi