'\"
'\" Generated from file '/usr/ports/obj/tcllib-1.11.1/tcllib-1.11.1/modules/sasl/sasl.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2005-2006, Pat Thoyts <patthoyts@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "SASL" n 1.3.0 sasl "Simple Authentication and Security Layer (SASL)"
.BS
.SH NAME
SASL \- Implementation of SASL mechanisms for Tcl
.SH SYNOPSIS
package require \fBTcl  8.2\fR
.sp
package require \fBSASL  ?1.3?\fR
.sp
\fB::SASL::new\fR \fIoption value ?...?\fR
.sp
\fB::SASL::configure\fR \fIoption value\fR ?\fI...\fR?
.sp
\fB::SASL::step\fR \fIcontext\fR \fIchallenge\fR ?\fI...\fR?
.sp
\fB::SASL::response\fR \fIcontext\fR
.sp
\fB::SASL::reset\fR \fIcontext\fR
.sp
\fB::SASL::cleanup\fR \fIcontext\fR
.sp
\fB::SASL::mechanisms\fR ?\fItype\fR? ?\fIminimum\fR?
.sp
\fB::SASL::register\fR \fImechanism\fR \fIpreference\fR \fIclientproc\fR ?\fIserverproc\fR?
.sp
.BE
.SH DESCRIPTION
.PP
The Simple Authentication and Security Layer (SASL) is a framework
for providing authentication and authorization to comunications
protocols. The SASL framework is structured to permit negotiation
among a number of authentication mechanisms. SASL may be used in
SMTP, IMAP and HTTP authentication. It is also in use in XMPP, LDAP
and BEEP. See \fBMECHANISMS\fR for the set of available SASL
mechanisms provided with tcllib.
.PP
The SASL framework operates using a simple multi-step challenge
response mechanism. All the mechanisms work the same way although the
number of steps may vary. In this implementation a callback procedure
must be provided from which the SASL framework will obtain users
details. See \fBCALLBACK PROCEDURE\fR for details of this
procedure.
.SH COMMANDS
.TP
\fB::SASL::new\fR \fIoption value ?...?\fR
Contruct a new SASL context. See \fBOPTIONS\fR for details of the
possible options to this command. A context token is required for most
of the SASL procedures.
.TP
\fB::SASL::configure\fR \fIoption value\fR ?\fI...\fR?
Modify and inspect the SASL context option. See \fBOPTIONS\fR for
further details.
.TP
\fB::SASL::step\fR \fIcontext\fR \fIchallenge\fR ?\fI...\fR?
This is the core procedure for using the SASL framework. The
\fBstep\fR procedure should be called until it returns 0. Each step takes a
server challenge string and the response is calculated and stored in
the context. Each mechanism may require one or more steps. For some
steps there may be no server challenge required in which case an empty
string should be provided for this parameter. All mechanisms should accept
an initial empty challenge.
.TP
\fB::SASL::response\fR \fIcontext\fR
Returns the next response string that should be sent to the server.
.TP
\fB::SASL::reset\fR \fIcontext\fR
Re-initialize the SASL context. Discards any internal state and
permits the token to be reused.
.TP
\fB::SASL::cleanup\fR \fIcontext\fR
Release all resources associated with the SASL context. The context
token may not be used again after this procedure has been called.
.TP
\fB::SASL::mechanisms\fR ?\fItype\fR? ?\fIminimum\fR?
Returns a list of all the available SASL mechanisms. The list is
sorted by the mechanism preference value (see \fBregister\fR) with the
preferred mechanisms and the head of the list. Any mechanism with a
preference value less than the\fIminimum\fR (which defaults to 0) is removed
from the returned list. This permits a security threshold to be set. Mechanisms
with a preference less that 25 transmit authentication are particularly
susceptible to eavesdropping and should not be provided unless a secure
channel is in use (eg: tls).
.sp
The \fItype\fR parameter
may be one of \fIclient\fR or \fIserver\fR and defaults to \fIclient\fR.
Only mechanisms that have an implementation matching the \fItype\fR are
returned (this permits servers to correctly declare support only for
mechanisms that actually provide a server implementation).
.TP
\fB::SASL::register\fR \fImechanism\fR \fIpreference\fR \fIclientproc\fR ?\fIserverproc\fR?
New mechanisms can be added to the package by registering the
mechanism name and the implementing procedures. The server procedure
is optional. The preference value is an integer that is used to order
the list returned by the \fBmechanisms\fR command. Higher values
indicate a preferred mechanism. If the mechanism is already registered
then the recorded values are updated.
.PP
.SH OPTIONS
.TP
\fB-callback\fR
Specify a command to be evaluated when the SASL mechanism requires
information about the user. The command is called with the current
SASL context and a name specifying the information desired. See
\fBEXAMPLES\fR.
.TP
\fB-mechanism\fR
Set the SASL mechanism to be used. See \fBmechanisms\fR for a list of
supported authentication mechanisms.
.TP
\fB-service\fR
Set the service type for this context. Some mechanisms may make use of
this parameter (eg DIGEST-MD5, GSSAPI and Kerberos). If not set it
defaults to an empty string. If the \fB-type\fR is set to 'server'
then this option should be set to a valid service identity. Some
examples of valid service names are smtp, ldap, beep and xmpp.
.TP
\fB-server\fR
This option is used to set the server name used in SASL challenges
when operating as a SASL server.
.TP
\fB-type\fR
The context type may be one of 'client' or 'server'. The default is to
operate as a client application and respond to server
challenges. Mechanisms may be written to support server-side SASL and
setting this option will cause each \fBstep\fR to issue the next
challenge. A new context must be created for each incoming client
connection when in server mode.
.PP
.SH "CALLBACK PROCEDURE"
When the SASL framework requires any user details it will call the
procedure provided when the context was created with an argument that
specfies the item of information required.
.PP
In all cases a single response string should be returned.
.TP
login
The callback procedure should return the users authorization identity.
Return an empty string unless this is to be different to the authentication
identity. Read [1] for a discussion about the specific meaning of
authorization and authentication identities within SASL.
.TP
username
The callback procedure should return the users authentication identity.
Read [1] for a discussion about the specific meaning of
authorization and authentication identities within SASL.
.TP
password
The callback procedure should return the password that matches the
authentication identity as used within the current realm.
.sp
For server mechanisms the password callback should always be called with
the authentication identity and the realm as the first two parameters.
.TP
realm
Some SASL mechanisms use realms to partition authentication identities.
The realm string is protocol dependent and is often the current DNS
domain or in the case of the NTLM mechanism it is the Windows NT domain name.
.TP
hostname
Returns the client host name - typically [info host].
.PP
.SH MECHANISMS
.TP
ANONYMOUS
As used in FTP this mechanism only passes an email address for
authentication. The ANONYMOUS mechanism is specified in [2].
.TP
PLAIN
This is the simplest mechanism. The users authentication details are
transmitted in plain text. This mechanism should not be provided
unless an encrypted link is in use - typically after SSL or TLS has
been negotiated.
.TP
LOGIN
The LOGIN [1] mechanism transmits the users details with base64
encoding. This is no more secure than PLAIN and likewise should not be
used without a secure link.
.TP
CRAM-MD5
This mechanism avoids sending the users password over the network in
plain text by hashing the password with a server provided random value
(known as a nonce). A disadvantage of this mechanism is that the
server must maintain a database of plaintext passwords for
comparison. CRAM-MD5 was defined in [4].
.TP
DIGEST-MD5
This mechanism improves upon the CRAM-MD5 mechanism by avoiding the
need for the server to store plaintext passwords. With digest
authentication the server needs to store the MD5 digest of the users
password which helps to make the system more secure. As in CRAM-MD5
the password is hashed with a server nonce and other data before being
transmitted across the network. Specified in [3].
.TP
OTP
OTP is the One-Time Password system described in RFC 2289 [6].
This mechanism is secure against replay attacks and also avoids storing
password or password equivalents on the server. Only a digest of a seed
and a passphrase is ever transmitted across the network. Requires the
\fBotp\fR package from tcllib and one or more of the cryptographic
digest packages (md5 or sha-1 are the most commonly used).
.TP
NTLM
This is a proprietary protocol developed by Microsoft [5] and is
in common use for authenticating users in a Windows network
environment. NTLM uses DES encryption and MD4 digests of the users
password to authenticate a connection. Certain weaknesses have been
found in NTLM and thus there are a number of versions of the protocol.
As this mechanism has additional dependencies it is made available as
a separate sub-package. To enable this mechanism your application must
load the SASL::NTLM package.
.TP
X-GOOGLE-TOKEN
This is a proprietary protocol developed by Google and used for
authenticating users for the Google Talk service. This mechanism makes
a pair of HTTP requests over an SSL channel and so this mechanism
depends upon the availability of the tls and http packages. To enable
this mechanism your application must load the SASL::XGoogleToken package.
In addition you are recommended to make use of the autoproxy package to
handle HTTP proxies reasonably transparently.
.PP
.SH EXAMPLES
See the examples subdirectory for more complete samples using SASL
with network protocols. The following should give an idea how the SASL
commands are to be used. In reality this should be event
driven. Each time the \fBstep\fR command is called, the last server
response should be provided as the command argument so that the SASL
mechanism can take appropriate action.
.nf

proc ClientCallback {context command args} {
    switch -exact -- $command {
        login    { return "" }
        username { return $::tcl_platform(user) }
        password { return "SecRet" }
        realm    { return "" }
        hostname { return [info host] }
        default  { return -code error unxpected }
    }
}

proc Demo {{mech PLAIN}} {
    set ctx [SASL::new -mechanism $mech -callback ClientCallback]
    set challenge ""
    while {1} {
        set more_steps [SASL::step $ctx challenge]
        puts "Send '[SASL::response $ctx]'"
        puts "Read server response into challenge var"
        if {!$more_steps} {break}
    }
    SASL::cleanup $ctx
}

.fi
.SH REFERENCES
.IP [1]
Myers, J. "Simple Authentication and Security Layer (SASL)",
RFC 2222, October 1997.
(\fIhttp://www.ietf.org/rfc/rfc2222.txt\fR)
.IP [2]
Newman, C. "Anonymous SASL Mechanism",
RFC 2245, November 1997.
(\fIhttp://www.ietf.org/rfc/rfc2245.txt\fR)
.IP [3]
Leach, P., Newman, C. "Using Digest Authentication as a SASL
Mechanism", RFC 2831, May 2000,
(\fIhttp://www.ietf.org/rfc/rfc2831.txt\fR)
.IP [4]
Klensin, J., Catoe, R. and Krumviede, P.,
"IMAP/POP AUTHorize Extension for Simple Challenge/Response"
RFC 2195, September 1997.
(\fIhttp://www.ietf.org/rfc/rfc2195.txt\fR)
.IP [5]
No official specification is available. However,
\fIhttp://davenport.sourceforge.net/ntlm.html\fR provides a good
description.
.IP [6]
Haller, N. et al., "A One-Time Password System",
RFC 2289, February 1998,
(\fIhttp://www.ieft.org/rfc/rfc2289.txt\fR)
.PP
.SH AUTHORS
Pat Thoyts
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIsasl\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
SASL, authentication
.SH COPYRIGHT
.nf
Copyright (c) 2005-2006, Pat Thoyts <patthoyts@users.sourceforge.net>

.fi