/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.SQLObject;
import java.io.Serializable;
import java.util.EventObject;

public class SQLObjectEvent
extends EventObject
implements Serializable {
    protected int[] changedIndices;
    protected SQLObject[] children;
    protected String propertyName;
    protected Object oldValue;
    protected Object newValue;

    public SQLObjectEvent(SQLObject source, int[] changedIndices, SQLObject[] children) {
        super(source);
        this.changedIndices = changedIndices;
        this.children = children;
        this.propertyName = "children";
    }

    public SQLObjectEvent(SQLObject source, String propertyName, Object oldValue, Object newValue) {
        super(source);
        this.propertyName = propertyName;
        this.changedIndices = null;
        this.children = null;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public SQLObjectEvent(SQLObject source, String propertyName) {
        super(source);
        this.propertyName = propertyName;
        this.changedIndices = null;
        this.children = null;
    }

    public SQLObject getSQLSource() {
        return (SQLObject)this.source;
    }

    public int[] getChangedIndices() {
        return this.changedIndices;
    }

    public void setChangedIndices(int[] argChangedIndices) {
        this.changedIndices = argChangedIndices;
    }

    public SQLObject[] getChildren() {
        return this.children;
    }

    public void setChildren(SQLObject[] argChildren) {
        this.children = argChildren;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String argPropertyName) {
        this.propertyName = argPropertyName;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public void setNewValue(Object newValue) {
        this.newValue = newValue;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(Object oldValue) {
        this.oldValue = oldValue;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("SQLObjectEvent[");
        sb.append("source=").append(this.source);
        if (this.propertyName != null) {
            sb.append(" propertyName=").append(this.propertyName);
            sb.append(" oldValue=").append(this.oldValue);
            sb.append(" newValue=").append(this.newValue);
        }
        if (this.changedIndices != null) {
            sb.append(" changed indices=");
            for (i = 0; i < this.changedIndices.length; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(this.changedIndices[i]);
            }
        }
        if (this.children != null) {
            sb.append(" children=");
            for (i = 0; i < this.children.length; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(this.children[i] == null ? "null" : this.children[i].getName());
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

