/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectSessionImpl;
import ca.sqlpower.architect.LogWriter;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.DDLStatement;
import ca.sqlpower.architect.qfa.ArchitectExceptionReportFactory;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.MonitorableWorker;
import ca.sqlpower.architect.swingui.SaveDocument;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLScriptDialog
extends JDialog {
    private static final Logger logger = Logger.getLogger(SQLScriptDialog.class);
    private List<DDLStatement> statements;
    private ArrayList<ASUtils.LabelValueBean> statementResultList;
    private JProgressBar progressBar = new JProgressBar();
    private Component parent;
    private String header;
    private JLabel statusLabel;
    private ArchitectDataSource targetDataSource;
    private JTextPane sqlScriptArea;
    private AbstractDocument sqlDoc;
    private boolean closeParent;
    private MonitorableWorker executeTask = new ExecuteSQLScriptWorker();

    public SQLScriptDialog(Frame owner, String title, String header, boolean modal, DDLGenerator gen, ArchitectDataSource targetDataSource, boolean closeParent) throws HeadlessException {
        super(owner, title, modal);
        if (modal && owner == null) {
            JOptionPane.showMessageDialog(null, "Debug: This action tried to create a null-parented modal dialog");
        }
        this.statementResultList = new ArrayList();
        this.statusLabel = new JLabel();
        this.parent = owner;
        this.header = header;
        this.statements = gen.getDdlStatements();
        this.targetDataSource = targetDataSource;
        this.closeParent = closeParent;
        this.add(this.buildPanel());
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }

    public SQLScriptDialog(Dialog owner, String title, String header, boolean modal, DDLGenerator gen, ArchitectDataSource targetDataSource, boolean closeParent) throws HeadlessException {
        super(owner, title, modal);
        if (modal && owner == null) {
            JOptionPane.showMessageDialog(null, "Debug: This action tried to create a null-parented modal dialog");
        }
        this.statementResultList = new ArrayList();
        this.statusLabel = new JLabel();
        this.parent = owner;
        this.header = header;
        this.statements = gen.getDdlStatements();
        this.targetDataSource = targetDataSource;
        this.closeParent = closeParent;
        logger.info((Object)("The list size is :" + this.statements.size()));
        this.add(this.buildPanel());
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }

    private JPanel buildPanel() {
        FormLayout sqlLayout = new FormLayout("4dlu, min:grow, 4dlu", "pref, 4dlu, pref, 6dlu, fill:300dlu:grow,6dlu, pref, 6dlu, pref");
        CellConstraints cc = new CellConstraints();
        this.sqlDoc = new DefaultStyledDocument();
        SimpleAttributeSet att = new SimpleAttributeSet();
        StyleConstants.setForeground(att, Color.black);
        for (DDLStatement ddl : this.statements) {
            try {
                this.sqlDoc.insertString(this.sqlDoc.getLength(), ddl.getSQLText() + ddl.getSqlTerminator(), att);
            }
            catch (BadLocationException e) {
                ASUtils.showExceptionDialog("Could not create document for results", e);
                logger.error((Object)"Could not create document for results", (Throwable)e);
            }
        }
        this.sqlScriptArea = new JTextPane();
        this.sqlScriptArea.setMargin(new Insets(6, 10, 4, 6));
        this.sqlScriptArea.setDocument(this.sqlDoc);
        this.sqlScriptArea.setEditable(false);
        this.sqlScriptArea.setAutoscrolls(true);
        JScrollPane sp = new JScrollPane(this.sqlScriptArea);
        CopyAction copy = new CopyAction(this.sqlDoc);
        AbstractAction execute = null;
        if (this.targetDataSource != null) {
            execute = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    new Thread(SQLScriptDialog.this.executeTask).start();
                }
            };
        }
        AbstractAction save = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                logger.info((Object)("SQL_FILE_FILTER:" + ((ASUtils.FileExtensionFilter)ASUtils.SQL_FILE_FILTER).toString()));
                new SaveDocument(SQLScriptDialog.this.parent, SQLScriptDialog.this.sqlDoc, (ASUtils.FileExtensionFilter)ASUtils.SQL_FILE_FILTER);
            }
        };
        CloseAction close = new CloseAction();
        close.setWhatToClose(this);
        ButtonBarBuilder barBuilder = new ButtonBarBuilder();
        JButton copyButton = new JButton(copy);
        copyButton.setText("Copy");
        barBuilder.addGridded((JComponent)copyButton);
        barBuilder.addRelatedGap();
        barBuilder.addGlue();
        JButton executeButton = new JButton(execute);
        executeButton.setText("Execute");
        barBuilder.addGridded((JComponent)executeButton);
        barBuilder.addRelatedGap();
        barBuilder.addGlue();
        if (execute == null) {
            executeButton.setEnabled(false);
        }
        JButton saveButton = new JButton(save);
        saveButton.setText("Save");
        barBuilder.addGridded((JComponent)saveButton);
        barBuilder.addRelatedGap();
        barBuilder.addGlue();
        JButton closeButton = new JButton(close);
        closeButton.setText("Close");
        barBuilder.addGridded((JComponent)closeButton);
        Object panel = logger.isDebugEnabled() ? new FormDebugPanel(sqlLayout) : new JPanel((LayoutManager)sqlLayout);
        PanelBuilder pb = new PanelBuilder(sqlLayout, (JPanel)panel);
        pb.setDefaultDialogBorder();
        pb.add((Component)new JLabel(this.header), cc.xy(2, 1));
        if (this.targetDataSource != null) {
            pb.add((Component)new JLabel("Your Target Database is " + this.targetDataSource.getName()), cc.xy(2, 3));
        }
        pb.add((Component)sp, cc.xy(2, 5));
        pb.add((Component)barBuilder.getPanel(), cc.xy(2, 7, "c,c"));
        pb.add((Component)this.progressBar, cc.xy(2, 9));
        return pb.getPanel();
    }

    public MonitorableWorker getExecuteTask() {
        return this.executeTask;
    }

    public void setExecuteTask(MonitorableWorker v) {
        this.executeTask = v;
    }

    public ArrayList<ASUtils.LabelValueBean> getStatementResultList() {
        return this.statementResultList;
    }

    public void setStatementResultList(ArrayList<ASUtils.LabelValueBean> statementResultList) {
        this.statementResultList = statementResultList;
    }

    private class ExecuteSQLScriptWorker
    extends MonitorableWorker {
        private int stmtsTried = 0;
        private int stmtsCompleted = 0;
        private boolean finished = false;
        private boolean hasStarted = false;

        private ExecuteSQLScriptWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void doStuff() {
            block37: {
                Statement stmt;
                Connection con;
                this.finished = false;
                this.hasStarted = true;
                if (this.isCanceled() || this.finished) {
                    return;
                }
                SQLDatabase target = new SQLDatabase(SQLScriptDialog.this.targetDataSource);
                SQLScriptDialog.this.statusLabel.setText("Creating objects in target database " + target.getDataSource());
                this.stmtsTried = 0;
                this.stmtsCompleted = 0;
                logger.debug((Object)("the Target Database is: " + target.getDataSource()));
                try {
                    con = target.getConnection();
                }
                catch (ArchitectException ex) {
                    this.finished = true;
                    throw new RuntimeException("Couldn't connect to target database: " + ex.getMessage() + "\nPlease check the connection settings and try again.", ex);
                }
                catch (Exception ex) {
                    this.finished = true;
                    logger.error((Object)"Unexpected exception in DDL generation", (Throwable)ex);
                    throw new RuntimeException("You have to specify a target database connection\nbefore executing this script.");
                }
                try {
                    logger.debug((Object)("the connection thinks it is: " + con.getMetaData().getURL()));
                    stmt = con.createStatement();
                }
                catch (SQLException ex) {
                    this.finished = true;
                    throw new RuntimeException("Couldn't generate DDL statements: " + ex.getMessage() + "\nThe problem was reported by " + "the target database.");
                }
                LogWriter logWriter = null;
                try {
                    logWriter = new LogWriter(ArchitectSessionImpl.getInstance().getUserSettings().getDDLUserSettings().getString("DDLUserSettings.PROP_DDL_LOG_PATH", ""));
                }
                catch (ArchitectException ex) {
                    this.finished = true;
                    ArchitectException fex = ex;
                    throw new RuntimeException("A problem with the DDL log file prevented\n DDL generation from running:\n\n" + fex.getMessage());
                }
                logWriter.info("Starting DDL Generation at " + new Date(System.currentTimeMillis()));
                logWriter.info("Database Target: " + target.getDataSource());
                logWriter.info("Playpen Dump: " + target.getDataSource());
                SQLScriptDialog.this.statementResultList.add(new ASUtils.LabelValueBean("Target Table Creation Log", "\n"));
                Iterator it = SQLScriptDialog.this.statements.iterator();
                while (it.hasNext() && !this.finished && !this.isCanceled()) {
                    DDLStatement ddlStmt = (DDLStatement)it.next();
                    String status = "Unknown";
                    try {
                        ++this.stmtsTried;
                        logWriter.info("executing: " + ddlStmt.getSQLText());
                        stmt.executeUpdate(ddlStmt.getSQLText());
                        ++this.stmtsCompleted;
                        status = "OK";
                    }
                    catch (SQLException ex) {
                        final SQLException fex = ex;
                        final String fsql = ddlStmt.getSQLText();
                        final LogWriter fLogWriter = logWriter;
                        logWriter.info("sql statement failed: " + ex.getMessage());
                        status = "SQL statement failed: " + ex.getMessage();
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                public void run() {
                                    JTextArea jta = new JTextArea(fsql, 25, 40);
                                    jta.setEditable(false);
                                    JScrollPane jsp = new JScrollPane(jta);
                                    JLabel errorLabel = new JLabel("<html>This SQL statement failed: " + fex.getMessage() + "<p>Do you want to continue?</html>");
                                    JPanel jp = new JPanel(new BorderLayout());
                                    jp.add((Component)jsp, "Center");
                                    jp.add((Component)errorLabel, "South");
                                    int decision = JOptionPane.showConfirmDialog(SQLScriptDialog.this, jp, "SQL Failure", 0);
                                    if (decision == 1) {
                                        fLogWriter.info("Export cancelled by user.");
                                        SQLScriptDialog.this.statementResultList.add(new ASUtils.LabelValueBean("Wizard cancelled by user", ""));
                                        ExecuteSQLScriptWorker.this.cancelJob();
                                    }
                                }
                            });
                        }
                        catch (InterruptedException ex2) {
                            logger.warn((Object)"DDL Worker was interrupted during InvokeAndWait", (Throwable)ex2);
                            status = "DDL Worker was interrupted during InvokeAndWait";
                        }
                        catch (InvocationTargetException ex2) {
                            InvocationTargetException fex2 = ex2;
                            status = "Worker thread died: " + fex2.getMessage();
                            throw new RuntimeException("Worker thread died: " + fex2.getMessage());
                        }
                        if (!this.isCanceled()) continue;
                        this.finished = true;
                    }
                    finally {
                        SQLScriptDialog.this.statementResultList.add(new ASUtils.LabelValueBean(ddlStmt.toString(), status));
                    }
                }
                Object var16_22 = null;
                String resultsMessage = (this.stmtsCompleted == 0 ? "Did not execute any out of " : "Successfully executed " + this.stmtsCompleted + " out of ") + this.stmtsTried + " statements.";
                logWriter.info(resultsMessage);
                JOptionPane.showMessageDialog(SQLScriptDialog.this, resultsMessage);
                logWriter.flush();
                logWriter.close();
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)"SQLException while closing statement", (Throwable)ex);
                }
                try {
                    if (con != null) {
                        con.close();
                    }
                    break block37;
                }
                catch (SQLException ex) {
                    logger.error((Object)"Couldn't close connection", (Throwable)ex);
                }
                break block37;
                {
                    catch (Exception exc) {
                        logWriter.info("Caught Unexpected Exception " + exc);
                        ASUtils.showExceptionDialog(SQLScriptDialog.this, "Couldn't finish running this SQL Script", exc, new ArchitectExceptionReportFactory());
                        Object var16_23 = null;
                        resultsMessage = (this.stmtsCompleted == 0 ? "Did not execute any out of " : "Successfully executed " + this.stmtsCompleted + " out of ") + this.stmtsTried + " statements.";
                        logWriter.info(resultsMessage);
                        JOptionPane.showMessageDialog(SQLScriptDialog.this, resultsMessage);
                        logWriter.flush();
                        logWriter.close();
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (SQLException ex) {
                            logger.error((Object)"SQLException while closing statement", (Throwable)ex);
                        }
                        try {
                            if (con != null) {
                                con.close();
                            }
                            break block37;
                        }
                        catch (SQLException ex) {
                            logger.error((Object)"Couldn't close connection", (Throwable)ex);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var16_24 = null;
                    resultsMessage = (this.stmtsCompleted == 0 ? "Did not execute any out of " : "Successfully executed " + this.stmtsCompleted + " out of ") + this.stmtsTried + " statements.";
                    logWriter.info(resultsMessage);
                    JOptionPane.showMessageDialog(SQLScriptDialog.this, resultsMessage);
                    logWriter.flush();
                    logWriter.close();
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException ex) {
                        logger.error((Object)"SQLException while closing statement", (Throwable)ex);
                    }
                    try {
                        if (con != null) {
                            con.close();
                        }
                    }
                    catch (SQLException ex) {
                        logger.error((Object)"Couldn't close connection", (Throwable)ex);
                    }
                    throw throwable;
                }
            }
            this.finished = true;
        }

        public void cleanup() {
        }

        public Integer getJobSize() throws ArchitectException {
            if (SQLScriptDialog.this.statements != null) {
                return new Integer(SQLScriptDialog.this.statements.size());
            }
            return null;
        }

        public int getProgress() throws ArchitectException {
            return this.stmtsTried;
        }

        public boolean isFinished() throws ArchitectException {
            return this.finished;
        }

        public String getMessage() {
            return null;
        }

        public void cancelJob() {
            this.setCancelled(true);
            this.finished = true;
        }

        public boolean hasStarted() {
            return this.hasStarted;
        }

        public void setHasStarted(boolean hasStarted) {
            this.hasStarted = hasStarted;
        }
    }

    private class CloseAction
    extends AbstractAction {
        Component c;

        private CloseAction() {
        }

        public void setWhatToClose(Component c) {
            this.c = c;
        }

        public void actionPerformed(ActionEvent e) {
            this.c.setVisible(false);
            if (SQLScriptDialog.this.closeParent) {
                SQLScriptDialog.this.parent.setVisible(false);
            }
        }
    }

    private class CopyAction
    extends AbstractAction {
        AbstractDocument doc;

        public CopyAction(AbstractDocument doc) {
            this.doc = doc;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                StringSelection selection = new StringSelection(this.doc.getText(0, this.doc.getLength()));
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
            }
            catch (BadLocationException e1) {
                logger.debug((Object)("Unable to get the text for copying" + e1));
            }
        }
    }
}

