/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.qfa.ArchitectExceptionReportFactory;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.architect.swingui.action.ProgressAction;
import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportPlaypenToPDFAction
extends ProgressAction {
    private static final Logger logger = Logger.getLogger(ExportPlaypenToPDFAction.class);
    private static final String FILE_KEY = "FILE_KEY";
    private static int OUTSIDE_PADDING = 10;
    private PlayPen pp;

    public ExportPlaypenToPDFAction() {
        super("Export Playpen", null);
        this.putValue("ShortDescription", "Export Playpen to PDF");
    }

    @Override
    public void setup(ProgressAction.ActionMonitor monitor, Map<String, Object> properties) {
        int response;
        monitor.started = true;
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(ASUtils.PDF_FILE_FILTER);
        monitor.setJobSize(this.pp.getPlayPenContentPane().getComponentCount());
        File file = null;
        do {
            if ((response = chooser.showSaveDialog(null)) != 0) {
                return;
            }
            file = chooser.getSelectedFile();
            String fileName = file.getName();
            if (fileName.endsWith(".pdf")) continue;
            file = new File(file.getPath() + ".pdf");
        } while (file.exists() && (response = JOptionPane.showConfirmDialog(null, "The file\n" + file.getPath() + "\nalready exists. Do you want to overwrite it?", "File Exists", 0)) != 0);
        logger.debug((Object)("Saving to file: " + file.getName() + " (" + file.getPath() + ")"));
        properties.put(FILE_KEY, file);
    }

    public void setPlayPen(PlayPen pp) {
        this.pp = pp;
    }

    @Override
    public void cleanUp(ProgressAction.ActionMonitor monitor) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStuff(ProgressAction.ActionMonitor monitor, Map<String, Object> properties) {
        PlayPen playPen = new PlayPen(this.pp);
        int width = playPen.getBounds().width + 2 * OUTSIDE_PADDING;
        int height = playPen.getBounds().height + 2 * OUTSIDE_PADDING;
        Rectangle ppSize = new Rectangle((float)width, (float)height);
        OutputStream out = null;
        Document d = null;
        ArchitectFrame c = ArchitectFrame.getMainInstance();
        try {
            out = new BufferedOutputStream(new FileOutputStream((File)properties.get(FILE_KEY)));
            d = new Document(ppSize);
            d.addTitle("Architect Playpen PDF Export");
            d.addAuthor(System.getProperty("user.name"));
            d.addCreator("Power*Architect version 1.0.0");
            PdfWriter writer = PdfWriter.getInstance((Document)d, (OutputStream)out);
            d.open();
            PdfContentByte cb = writer.getDirectContent();
            Graphics2D g = cb.createGraphicsShapes((float)width, (float)height);
            g.translate(OUTSIDE_PADDING, OUTSIDE_PADDING);
            PlayPenContentPane contentPane = playPen.getContentPane();
            int j = 0;
            for (int i = contentPane.getComponentCount() - 1; i >= 0; --i) {
                PlayPenComponent ppc = contentPane.getComponent(i);
                g.translate(ppc.getLocation().x, ppc.getLocation().y);
                ppc.paint(g);
                g.translate(-ppc.getLocation().x, -ppc.getLocation().y);
                monitor.setProgress(j);
                ++j;
            }
            playPen.paintComponent(g);
            g.dispose();
        }
        catch (Exception ex) {
            ASUtils.showExceptionDialog(c, "Could not export the playpen", ex, new ArchitectExceptionReportFactory());
        }
        finally {
            if (d != null) {
                try {
                    d.close();
                }
                catch (Exception ex) {
                    ASUtils.showExceptionDialog(c, "Could not close document for exporting playpen", ex, new ArchitectExceptionReportFactory());
                }
            }
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    ASUtils.showExceptionDialog(null, "Could not close pdf file for exporting playpen", ex, new ArchitectExceptionReportFactory());
                }
            }
        }
    }

    @Override
    public String getDialogMessage() {
        return "Creating PDF";
    }

    @Override
    public String getButtonText() {
        return "Run in Background";
    }
}

