/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.util;

public class Passwords {
    public static int QUALITY_LENIENT = 1;
    public static int QUALITY_STRICT = 9;

    private Passwords() {
    }

    public static boolean checkQuality(String pw, int severity) {
        if (pw.length() < 6) {
            return false;
        }
        boolean hasUpperCase = false;
        boolean hasLowerCase = false;
        boolean hasDigits = false;
        boolean hasPunctuation = false;
        for (int i = 0; i < pw.length(); ++i) {
            char ch = pw.charAt(i);
            if (ch < ' ' && ch > '~') {
                return false;
            }
            if ('A' <= ch && ch <= 'Z') {
                hasUpperCase = true;
                continue;
            }
            if ('a' <= ch && ch <= 'z') {
                hasLowerCase = true;
                continue;
            }
            if ('0' <= ch && ch <= '9') {
                hasDigits = true;
                continue;
            }
            hasPunctuation = true;
        }
        if (severity <= QUALITY_LENIENT) {
            return true;
        }
        return hasUpperCase && hasLowerCase && (hasDigits || hasPunctuation);
    }
}

