/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui.dialogs;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ResourceDialog
extends Dialog {
    protected static final int CONTROL_OFFSET = 10;
    protected String title;
    protected int style;
    protected Text uriField;
    protected String uriText;

    public ResourceDialog(Shell parent, String title, int style) {
        super(parent);
        this.title = title != null ? title : CommonUIPlugin.INSTANCE.getString("_UI_ResourceDialog_title");
        this.style = style;
        this.normalizeStyle();
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
    }

    protected void normalizeStyle() {
        if ((this.style & 0xFFFFCFF9) != 0) {
            throw new IllegalArgumentException("extraneous style bits specified (only SWT.MULTI, SWT.SINGLE, SWT.OPEN, SWT.SAVE allowed");
        }
        if ((this.style & 2) == 0 && (this.style & 4) == 0) {
            this.style |= 4;
        } else if ((this.style & 2) != 0 && (this.style & 4) != 0) {
            throw new IllegalArgumentException("conflicting style bits specified (sWT.MUTLI and SWT.SINGLE)");
        }
        if ((this.style & 0x1000) == 0 && (this.style & 0x2000) == 0) {
            this.style |= 0x1000;
        } else if ((this.style & 0x1000) != 0 && (this.style & 0x2000) != 0) {
            throw new IllegalArgumentException("conflicting style bits specified (sWT.OPEN and SWT.SAVE)");
        }
        if (this.isMulti() && this.isSave()) {
            throw new IllegalArgumentException("conflicting style bits specified (sWT.MULTI and SWT.SAVE)");
        }
    }

    protected boolean isSave() {
        return (this.style & 0x2000) != 0;
    }

    protected boolean isMulti() {
        return (this.style & 2) != 0;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        FormData data;
        boolean resourcesBundleIsAvailable = Platform.getBundle((String)"org.eclipse.core.resources") != null;
        Composite composite = (Composite)super.createDialogArea(parent);
        FormLayout layout = new FormLayout();
        composite.setLayout((Layout)layout);
        GridData data2 = new GridData();
        data2.verticalAlignment = 4;
        data2.grabExcessVerticalSpace = true;
        data2.horizontalAlignment = 4;
        data2.grabExcessHorizontalSpace = true;
        if (!resourcesBundleIsAvailable) {
            data2.widthHint = 330;
        }
        composite.setLayoutData((Object)data2);
        Composite buttonComposite = new Composite(composite, 0);
        data2 = new FormData();
        data2.top = new FormAttachment(0, 10);
        data2.left = new FormAttachment(30, 0);
        data2.right = new FormAttachment(100, -10);
        buttonComposite.setLayoutData((Object)data2);
        buttonComposite.setLayout((Layout)new FormLayout());
        Label resourceURILabel = new Label(composite, 16384);
        resourceURILabel.setText(CommonUIPlugin.INSTANCE.getString(this.isMulti() ? "_UI_ResourceURIs_label" : "_UI_ResourceURI_label"));
        FormData data3 = new FormData();
        data3.top = new FormAttachment((Control)buttonComposite, 10, 0x1000000);
        data3.left = new FormAttachment(0, 10);
        resourceURILabel.setLayoutData((Object)data3);
        this.uriField = new Text(composite, 2048);
        data3 = new FormData();
        data3.top = new FormAttachment((Control)buttonComposite, 10);
        data3.left = new FormAttachment(0, 10);
        data3.right = new FormAttachment(100, -10);
        this.uriField.setLayoutData((Object)data3);
        Button browseFileSystemButton = new Button(buttonComposite, 8);
        browseFileSystemButton.setText(CommonUIPlugin.INSTANCE.getString("_UI_BrowseFileSystem_label"));
        this.prepareBrowseFileSystemButton(browseFileSystemButton);
        if (resourcesBundleIsAvailable) {
            Button browseWorkspaceButton = new Button(buttonComposite, 8);
            data = new FormData();
            data.right = new FormAttachment(100);
            browseWorkspaceButton.setLayoutData((Object)data);
            data = new FormData();
            data.right = new FormAttachment((Control)browseWorkspaceButton, -10);
            browseFileSystemButton.setLayoutData((Object)data);
            browseWorkspaceButton.setText(CommonUIPlugin.INSTANCE.getString("_UI_BrowseWorkspace_label"));
            this.prepareBrowseWorkspaceButton(browseWorkspaceButton);
        } else {
            FormData data4 = new FormData();
            data4.right = new FormAttachment(100);
            browseFileSystemButton.setLayoutData((Object)data4);
        }
        Label separatorLabel = new Label(composite, 258);
        data = new FormData();
        data.top = new FormAttachment((Control)this.uriField, 15);
        data.left = new FormAttachment(0, -10);
        data.right = new FormAttachment(100, 10);
        separatorLabel.setLayoutData((Object)data);
        composite.setTabList(new Control[]{this.uriField, buttonComposite});
        return composite;
    }

    protected void prepareBrowseFileSystemButton(Button browseFileSystemButton) {
        browseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDialog = new FileDialog(ResourceDialog.this.getShell(), ResourceDialog.this.style);
                fileDialog.open();
                String filterPath = fileDialog.getFilterPath();
                if (ResourceDialog.this.isMulti()) {
                    String[] fileNames = fileDialog.getFileNames();
                    StringBuffer uris = new StringBuffer();
                    int i = 0;
                    int len = fileNames.length;
                    while (i < len) {
                        uris.append(URI.createFileURI((String)(String.valueOf(filterPath) + File.separator + fileNames[i])).toString());
                        uris.append("  ");
                        ++i;
                    }
                    ResourceDialog.this.uriField.setText((String.valueOf(ResourceDialog.this.uriField.getText()) + "  " + uris.toString()).trim());
                } else {
                    String fileName = fileDialog.getFileName();
                    if (fileName != null) {
                        ResourceDialog.this.uriField.setText(URI.createFileURI((String)(String.valueOf(filterPath) + File.separator + fileName)).toString());
                    }
                }
            }
        });
    }

    protected void prepareBrowseWorkspaceButton(Button browseWorkspaceButton) {
        browseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (ResourceDialog.this.isMulti()) {
                    StringBuffer uris = new StringBuffer();
                    IFile[] files = WorkspaceResourceDialog.openFileSelection(ResourceDialog.this.getShell(), null, null, true, null, null);
                    int i = 0;
                    int len = files.length;
                    while (i < len) {
                        uris.append(URI.createPlatformResourceURI((String)files[i].getFullPath().toString(), (boolean)true));
                        uris.append("  ");
                        ++i;
                    }
                    ResourceDialog.this.uriField.setText((String.valueOf(ResourceDialog.this.uriField.getText()) + "  " + uris.toString()).trim());
                } else {
                    IFile file = null;
                    if (ResourceDialog.this.isSave()) {
                        file = WorkspaceResourceDialog.openNewFile(ResourceDialog.this.getShell(), null, null, null, null);
                    } else {
                        IFile[] files = WorkspaceResourceDialog.openFileSelection(ResourceDialog.this.getShell(), null, null, false, null, null);
                        if (files.length != 0) {
                            file = files[0];
                        }
                    }
                    if (file != null) {
                        ResourceDialog.this.uriField.setText(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true).toString());
                    }
                }
            }
        });
    }

    protected void okPressed() {
        this.uriText = this.getURIText();
        if (this.processResources()) {
            super.okPressed();
        } else {
            this.uriField.selectAll();
            this.uriField.setFocus();
        }
    }

    public String getURIText() {
        return this.uriField != null && !this.uriField.isDisposed() ? this.uriField.getText() : this.uriText;
    }

    public List getURIs() {
        ArrayList<URI> uris = new ArrayList<URI>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getURIText());
        while (stringTokenizer.hasMoreTokens()) {
            String uri = stringTokenizer.nextToken();
            uris.add(URI.createURI((String)uri));
        }
        return uris;
    }

    protected boolean processResources() {
        return true;
    }
}

