/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.converter.ui.contribution.base;

import org.eclipse.emf.converter.ConverterPlugin;
import org.eclipse.emf.converter.ModelConverter;
import org.eclipse.emf.converter.ui.contribution.base.ModelConverterPage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ModelConverterURIPage
extends ModelConverterPage {
    protected Text uriText;
    protected Button browseFileSystemButton;
    protected Button browseWorkspaceButton;

    public ModelConverterURIPage(ModelConverter modelConverter, String pageName) {
        super(modelConverter, pageName);
    }

    public void dispose() {
        if (this.uriText != null) {
            this.uriText.removeListener(24, (Listener)this);
            this.uriText = null;
        }
        if (this.browseFileSystemButton != null) {
            this.browseFileSystemButton.removeListener(13, (Listener)this);
            this.browseFileSystemButton = null;
        }
        if (this.browseWorkspaceButton != null) {
            this.browseWorkspaceButton.removeListener(13, (Listener)this);
            this.browseWorkspaceButton = null;
        }
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 8;
        composite.setLayout((Layout)layout);
        this.createURIControl(composite);
        this.addControl(composite);
        this.setControl((Control)composite);
    }

    protected void createURIControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = -5;
        layout.marginRight = -5;
        composite.setLayout((Layout)layout);
        Label uriLabel = new Label(composite, 16384);
        uriLabel.setLayoutData((Object)new GridData(32));
        uriLabel.setText(this.getURITextLabel());
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayoutData((Object)new GridData(896));
        RowLayout layout2 = new RowLayout();
        layout2.justify = true;
        layout2.pack = true;
        layout2.spacing = 5;
        layout2.marginRight = 0;
        buttonComposite.setLayout((Layout)layout2);
        this.browseFileSystemButton = new Button(buttonComposite, 8);
        this.browseFileSystemButton.setText(this.getBrowseFileSystemButtonLabel());
        this.browseFileSystemButton.addListener(13, (Listener)this);
        this.browseWorkspaceButton = new Button(buttonComposite, 8);
        this.browseWorkspaceButton.setText(this.getBrowseWorkspaceButtonLabel());
        this.browseWorkspaceButton.addListener(13, (Listener)this);
        Composite uriComposite = new Composite(parent, 0);
        uriComposite.setLayoutData((Object)new GridData(768));
        GridLayout layout3 = new GridLayout(2, false);
        layout3.marginTop = -5;
        layout3.marginLeft = -5;
        layout3.marginRight = -5;
        uriComposite.setLayout((Layout)layout3);
        this.uriText = new Text(uriComposite, 2052);
        this.uriText.setLayoutData((Object)new GridData(768));
        this.setURIText(this.getURITextInitialValue());
        if (this.uriText.getText().length() > 0) {
            this.uriText.selectAll();
        }
        this.uriText.addListener(24, (Listener)this);
        this.addURIControl(uriComposite);
    }

    protected String getURITextLabel() {
        return "";
    }

    protected String getBrowseFileSystemButtonLabel() {
        return ConverterPlugin.INSTANCE.getString("_UI_BrowseFileSystemFile_label");
    }

    protected String getBrowseWorkspaceButtonLabel() {
        return ConverterPlugin.INSTANCE.getString("_UI_BrowseWorkspace_label");
    }

    protected String getURITextInitialValue() {
        return "";
    }

    protected void addURIControl(Composite parent) {
    }

    protected void addControl(Composite parent) {
    }

    protected void doHandleEvent(Event event) {
        if (event.type == 24 && event.widget == this.uriText) {
            this.uriTextModified(this.uriText.getText().trim());
        } else if (event.type == 13 && event.widget == this.browseFileSystemButton) {
            this.browseFileSystem();
        } else if (event.type == 13 && event.widget == this.browseWorkspaceButton) {
            this.browseWorkspace();
        } else {
            super.doHandleEvent(event);
        }
        this.getContainer().updateButtons();
    }

    protected void uriTextModified(String text) {
        this.setErrorMessage(null);
        this.setMessage(null);
    }

    protected boolean supportMultipleURIs() {
        return false;
    }

    protected void setURIText(String uri) {
        StringBuffer text;
        if (!(uri = uri.trim()).equals(text = new StringBuffer(this.uriText.getText()))) {
            if (this.supportMultipleURIs()) {
                Point textSelection = this.uriText.getSelection();
                text.delete(textSelection.x, textSelection.y);
                uri = text.append(" ").append(uri).toString();
            }
            this.uriText.setText(uri.trim());
        }
    }

    protected boolean browseFileSystem() {
        return true;
    }

    protected boolean browseWorkspace() {
        return true;
    }
}

