/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.Socket;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.rubypeople.rdt.internal.debug.core.DebuggerNotFoundException;
import org.rubypeople.rdt.internal.debug.core.RdtDebugCorePlugin;
import org.rubypeople.rdt.internal.debug.core.RubyExceptionBreakpoint;
import org.rubypeople.rdt.internal.debug.core.SuspensionPoint;
import org.rubypeople.rdt.internal.debug.core.model.IRubyDebugTarget;
import org.rubypeople.rdt.internal.debug.core.model.RubyProcessingException;
import org.rubypeople.rdt.internal.debug.core.model.RubyStackFrame;
import org.rubypeople.rdt.internal.debug.core.model.RubyThread;
import org.rubypeople.rdt.internal.debug.core.model.RubyVariable;
import org.rubypeople.rdt.internal.debug.core.model.ThreadInfo;
import org.rubypeople.rdt.internal.debug.core.parsing.FramesReader;
import org.rubypeople.rdt.internal.debug.core.parsing.LoadResultReader;
import org.rubypeople.rdt.internal.debug.core.parsing.MultiReaderStrategy;
import org.rubypeople.rdt.internal.debug.core.parsing.SuspensionReader;
import org.rubypeople.rdt.internal.debug.core.parsing.ThreadInfoReader;
import org.rubypeople.rdt.internal.debug.core.parsing.VariableReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class RubyDebuggerProxy {
    public static final String DEBUGGER_ACTIVE_KEY = "org.rubypeople.rdt.debug.ui.debuggerActive";
    private Socket socket;
    private PrintWriter writer;
    private IRubyDebugTarget debugTarget;
    private RubyLoop rubyLoop;
    private XmlPullParser xpp;
    protected MultiReaderStrategy multiReaderStrategy;

    public RubyDebuggerProxy(IRubyDebugTarget iRubyDebugTarget) {
        this.debugTarget = iRubyDebugTarget;
        iRubyDebugTarget.setRubyDebuggerProxy(this);
    }

    public boolean checkConnection() {
        try {
            return this.getSocket().isConnected();
        }
        catch (DebuggerNotFoundException debuggerNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void start() {
        try {
            this.setBreakPoints();
            this.startRubyLoop();
        }
        catch (IOException iOException) {}
    }

    public void stop() {
        if (this.rubyLoop == null) {
            return;
        }
        this.rubyLoop.setShouldStop();
        this.rubyLoop.interrupt();
    }

    protected Socket acquireSocket() throws IOException {
        int n = 10;
        int n2 = 0;
        while (n2 < n) {
            try {
                this.socket = new Socket("localhost", this.debugTarget.getPort());
                return this.socket;
            }
            catch (IOException iOException) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                ++n2;
            }
        }
        return null;
    }

    protected Socket getSocket() throws IOException, DebuggerNotFoundException {
        if (this.socket == null) {
            this.socket = this.acquireSocket();
            if (this.socket == null) {
                throw new DebuggerNotFoundException();
            }
        }
        return this.socket;
    }

    public PrintWriter getWriter() throws IOException, DebuggerNotFoundException {
        if (this.writer == null) {
            this.writer = new PrintWriter(this.getSocket().getOutputStream(), true);
        }
        return this.writer;
    }

    public void setWriter(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    public XmlPullParser getXpp() {
        if (this.xpp == null) {
            try {
                XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance((String)"org.kxml2.io.KXmlParser,org.kxml2.io.KXmlSerializer", null);
                this.xpp = xmlPullParserFactory.newPullParser();
                this.xpp.setInput((Reader)new BufferedReader(new InputStreamReader(this.getSocket().getInputStream())));
            }
            catch (XmlPullParserException xmlPullParserException) {
                xmlPullParserException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this.xpp;
    }

    public void setXpp(XmlPullParser xmlPullParser) {
        this.xpp = xmlPullParser;
    }

    protected MultiReaderStrategy getMultiReaderStrategy() {
        if (this.multiReaderStrategy == null) {
            this.multiReaderStrategy = new MultiReaderStrategy(this.getXpp());
        }
        return this.multiReaderStrategy;
    }

    protected void setBreakPoints() throws IOException {
        IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.rubypeople.rdt.debug");
        int n = 0;
        while (n < iBreakpointArray.length) {
            this.addBreakpoint(iBreakpointArray[n]);
            ++n;
        }
    }

    public void addBreakpoint(IBreakpoint iBreakpoint) {
        try {
            if (iBreakpoint.isEnabled()) {
                if (iBreakpoint instanceof RubyExceptionBreakpoint) {
                    this.println("catch " + ((RubyExceptionBreakpoint)iBreakpoint).getException());
                } else {
                    this.printBreakpoint("add", iBreakpoint.getMarker().getResource().getName(), iBreakpoint.getMarker().getAttribute("lineNumber", -1));
                }
            }
        }
        catch (IOException iOException) {
            RdtDebugCorePlugin.log(iOException);
        }
        catch (CoreException coreException) {
            RdtDebugCorePlugin.log(coreException);
        }
    }

    public void removeBreakpoint(IBreakpoint iBreakpoint) {
        try {
            if (iBreakpoint instanceof RubyExceptionBreakpoint) {
                this.println("catch off");
            } else {
                this.printBreakpoint("remove", iBreakpoint.getMarker().getResource().getName(), iBreakpoint.getMarker().getAttribute("lineNumber", -1));
            }
        }
        catch (IOException iOException) {
            RdtDebugCorePlugin.log(iOException);
        }
    }

    public void updateBreakpoint(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
        try {
            if (iBreakpoint instanceof RubyExceptionBreakpoint) {
                this.println("catch off");
            } else {
                this.printBreakpoint("remove", iBreakpoint.getMarker().getResource().getName(), iMarkerDelta.getAttribute("lineNumber", -1));
            }
            this.addBreakpoint(iBreakpoint);
        }
        catch (IOException iOException) {
            RdtDebugCorePlugin.log(iOException);
        }
    }

    protected void printBreakpoint(String string, String string2, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("b ");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        stringBuffer.append(":");
        stringBuffer.append(n);
        this.println(stringBuffer.toString());
    }

    public void startRubyLoop() {
        this.rubyLoop = new RubyLoop();
        this.rubyLoop.start();
    }

    public void resume(RubyThread rubyThread) {
        try {
            this.println("th " + rubyThread.getId() + ";cont");
        }
        catch (IOException iOException) {}
    }

    protected void println(String string) throws IOException {
        RdtDebugCorePlugin.debug("Sending debugger: " + string);
        try {
            this.getWriter().println(string);
        }
        catch (IOException iOException) {
            RdtDebugCorePlugin.debug("Could not send to debugger. Exception occured.", iOException);
            throw iOException;
        }
    }

    protected IRubyDebugTarget getDebugTarget() {
        return this.debugTarget;
    }

    public RubyVariable[] readVariables(RubyStackFrame rubyStackFrame) {
        try {
            this.println("th " + ((RubyThread)rubyStackFrame.getThread()).getId() + " ; v l " + rubyStackFrame.getIndex());
            return new VariableReader(this.getMultiReaderStrategy()).readVariables(rubyStackFrame);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage());
        }
    }

    public RubyVariable[] readInstanceVariables(RubyVariable rubyVariable) {
        try {
            this.println("th " + ((RubyThread)rubyVariable.getStackFrame().getThread()).getId() + " ; v i " + rubyVariable.getStackFrame().getIndex() + " " + rubyVariable.getObjectId());
            return new VariableReader(this.getMultiReaderStrategy()).readVariables(rubyVariable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage());
        }
    }

    public RubyVariable readInspectExpression(RubyStackFrame rubyStackFrame, String string) throws RubyProcessingException {
        try {
            this.println("th " + ((RubyThread)rubyStackFrame.getThread()).getId() + " ; v inspect " + rubyStackFrame.getIndex() + " " + string);
            RubyVariable[] rubyVariableArray = new VariableReader(this.getMultiReaderStrategy()).readVariables(rubyStackFrame);
            if (rubyVariableArray.length == 0) {
                return null;
            }
            return rubyVariableArray[0];
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public void readStepOverEnd(RubyStackFrame rubyStackFrame) {
        try {
            this.println("th " + ((RubyThread)rubyStackFrame.getThread()).getId() + " ; next " + rubyStackFrame.getIndex());
        }
        catch (Exception exception) {
            RdtDebugCorePlugin.log(exception);
        }
    }

    public void readStepReturnEnd(RubyStackFrame rubyStackFrame) {
        try {
            this.println("th " + ((RubyThread)rubyStackFrame.getThread()).getId() + " ; next " + (rubyStackFrame.getIndex() + 1));
        }
        catch (Exception exception) {
            RdtDebugCorePlugin.log(exception);
        }
    }

    public void readStepIntoEnd(RubyStackFrame rubyStackFrame) {
        try {
            this.println("th " + ((RubyThread)rubyStackFrame.getThread()).getId() + " ; step " + rubyStackFrame.getIndex());
        }
        catch (Exception exception) {
            RdtDebugCorePlugin.log(exception);
        }
    }

    public RubyStackFrame[] readFrames(RubyThread rubyThread) {
        try {
            this.println("th " + rubyThread.getId() + " ; f ");
            return new FramesReader(this.getMultiReaderStrategy()).readFrames(rubyThread);
        }
        catch (IOException iOException) {
            RdtDebugCorePlugin.log(iOException);
            return null;
        }
    }

    public ThreadInfo[] readThreads() {
        try {
            this.println("th l");
            return new ThreadInfoReader(this.getMultiReaderStrategy()).readThreads();
        }
        catch (Exception exception) {
            RdtDebugCorePlugin.log(exception);
            return null;
        }
    }

    public LoadResultReader.LoadResult readLoadResult(String string) {
        try {
            this.println("load " + string);
            return new LoadResultReader(this.getMultiReaderStrategy()).readLoadResult();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void closeSocket() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    class RubyLoop
    extends Thread {
        public RubyLoop() {
            this.setName("RubyDebuggerLoop");
        }

        public void setShouldStop() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block11: {
                try {
                    try {
                        System.setProperty("org.rubypeople.rdt.debug.ui.debuggerActive", "true");
                        RubyDebuggerProxy.this.getDebugTarget().updateThreads();
                        RubyDebuggerProxy.this.println("cont");
                        RdtDebugCorePlugin.debug("Waiting for breakpoints.");
                        while ((var1_1 = new SuspensionReader(RubyDebuggerProxy.this.getMultiReaderStrategy()).readSuspension()) != null) {
                            RdtDebugCorePlugin.debug(var1_1);
                            new Thread(this, var1_1){
                                final /* synthetic */ RubyLoop this$1;
                                private final /* synthetic */ SuspensionPoint val$hit;
                                {
                                    this.this$1 = rubyLoop;
                                    this.val$hit = suspensionPoint;
                                }

                                public void run() {
                                    RubyLoop.access$0(this.this$1).getDebugTarget().suspensionOccurred(this.val$hit);
                                }
                            }.start();
                        }
                    }
                    catch (DebuggerNotFoundException var1_2) {
                        throw var1_2;
                    }
                    catch (Exception var1_3) {
                        RdtDebugCorePlugin.debug("Exception in socket reader loop.", var1_3);
                    }
                }
                catch (Throwable var3_4) {
                    var2_5 = null;
                    System.setProperty("org.rubypeople.rdt.debug.ui.debuggerActive", "false");
                    RubyDebuggerProxy.this.getDebugTarget().terminate();
                    try {
                        RubyDebuggerProxy.this.closeSocket();
                    }
                    catch (IOException var4_7) {
                        RdtDebugCorePlugin.log(var4_7);
                    }
                    RdtDebugCorePlugin.debug("Socket reader loop finished.");
                    throw var3_4;
                }
                {
                    var2_6 = null;
                }
                System.setProperty("org.rubypeople.rdt.debug.ui.debuggerActive", "false");
                RubyDebuggerProxy.this.getDebugTarget().terminate();
                ** try [egrp 2[TRYBLOCK] [4 : 121->131)] { 
lbl37:
                // 1 sources

                RubyDebuggerProxy.this.closeSocket();
                break block11;
lbl39:
                // 1 sources

                catch (IOException var4_8) {
                    RdtDebugCorePlugin.log(var4_8);
                }
            }
            RdtDebugCorePlugin.debug("Socket reader loop finished.");
        }

        static /* synthetic */ RubyDebuggerProxy access$0(RubyLoop rubyLoop) {
            return rubyLoop.RubyDebuggerProxy.this;
        }
    }
}

