/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences.formatter;

import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.internal.ui.preferences.formatter.FormatterMessages;
import org.rubypeople.rdt.internal.ui.preferences.formatter.ProfileManager;

public class AlreadyExistsDialog
extends StatusDialog {
    private Composite fComposite;
    protected Text fNameText;
    private Button fRenameRadio;
    private Button fOverwriteRadio;
    private final int NUM_COLUMNS = 2;
    private final StatusInfo fOk;
    private final StatusInfo fEmpty;
    private final StatusInfo fDuplicate;
    private final ProfileManager.CustomProfile fProfile;
    private final ProfileManager fProfileManager;

    public AlreadyExistsDialog(Shell shell, ProfileManager.CustomProfile customProfile, ProfileManager profileManager) {
        super(shell);
        this.fProfile = customProfile;
        this.fProfileManager = profileManager;
        this.fOk = new StatusInfo();
        this.fDuplicate = new StatusInfo(4, FormatterMessages.AlreadyExistsDialog_message_profile_already_exists);
        this.fEmpty = new StatusInfo(4, FormatterMessages.AlreadyExistsDialog_message_profile_name_empty);
    }

    public void create() {
        super.create();
        this.setTitle(FormatterMessages.AlreadyExistsDialog_dialog_title);
    }

    public Control createDialogArea(Composite composite) {
        this.initializeComposite(composite);
        this.createLabel(Messages.format(FormatterMessages.AlreadyExistsDialog_dialog_label, this.fProfile.getName()));
        this.fRenameRadio = this.createRadioButton(FormatterMessages.AlreadyExistsDialog_rename_radio_button_desc);
        this.fNameText = this.createTextField();
        this.fOverwriteRadio = this.createRadioButton(FormatterMessages.AlreadyExistsDialog_overwrite_radio_button_desc);
        this.fRenameRadio.setSelection(true);
        this.fNameText.setText(this.fProfile.getName());
        this.fNameText.setSelection(0, this.fProfile.getName().length());
        this.fNameText.setFocus();
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                AlreadyExistsDialog.this.doValidation();
            }
        });
        this.fRenameRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AlreadyExistsDialog.this.fNameText.setEnabled(true);
                AlreadyExistsDialog.this.fNameText.setFocus();
                AlreadyExistsDialog.this.fNameText.setSelection(0, AlreadyExistsDialog.this.fNameText.getText().length());
                AlreadyExistsDialog.this.doValidation();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.fOverwriteRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AlreadyExistsDialog.this.fNameText.setEnabled(false);
                AlreadyExistsDialog.this.doValidation();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.updateStatus(this.fDuplicate);
        AlreadyExistsDialog.applyDialogFont((Control)this.fComposite);
        return this.fComposite;
    }

    private void initializeComposite(Composite composite) {
        this.fComposite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.numColumns = 2;
        this.fComposite.setLayout((Layout)gridLayout);
    }

    private Label createLabel(String string) {
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.widthHint = this.convertWidthInCharsToPixels(60);
        Label label = new Label(this.fComposite, 64);
        label.setText(string);
        label.setLayoutData((Object)gridData);
        return label;
    }

    private Button createRadioButton(String string) {
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.widthHint = this.convertWidthInCharsToPixels(60);
        Button button = new Button(this.fComposite, 16);
        button.setLayoutData((Object)gridData);
        button.setText(string);
        return button;
    }

    private Text createTextField() {
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        Text text = new Text(this.fComposite, 2052);
        text.setLayoutData((Object)gridData);
        return text;
    }

    protected void doValidation() {
        if (this.fOverwriteRadio.getSelection()) {
            this.updateStatus(this.fOk);
            return;
        }
        String string = this.fNameText.getText().trim();
        if (string.length() == 0) {
            this.updateStatus(this.fEmpty);
            return;
        }
        if (this.fProfileManager.containsName(string)) {
            this.updateStatus(this.fDuplicate);
            return;
        }
        this.updateStatus(this.fOk);
    }

    protected void okPressed() {
        if (!this.getStatus().isOK()) {
            return;
        }
        if (this.fRenameRadio.getSelection()) {
            this.fProfile.rename(this.fNameText.getText().trim(), this.fProfileManager);
        }
        super.okPressed();
    }
}

