/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.viewsupport;

import java.util.ArrayList;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.rubypeople.rdt.internal.ui.JDTOriginally;

public class ContainerCheckedTreeViewer
extends CheckboxTreeViewer
implements JDTOriginally {
    public ContainerCheckedTreeViewer(Composite composite) {
        super(composite);
        this.initViewer();
    }

    public ContainerCheckedTreeViewer(Composite composite, int n) {
        super(composite, n);
        this.initViewer();
    }

    public ContainerCheckedTreeViewer(Tree tree) {
        super(tree);
        this.initViewer();
    }

    private void initViewer() {
        this.setUseHashlookup(true);
        this.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                ContainerCheckedTreeViewer.this.doCheckStateChanged(checkStateChangedEvent.getElement());
            }
        });
        this.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                Widget widget = ContainerCheckedTreeViewer.this.findItem(treeExpansionEvent.getElement());
                if (widget instanceof TreeItem) {
                    ContainerCheckedTreeViewer.this.initializeItem((TreeItem)widget);
                }
            }
        });
    }

    protected void doCheckStateChanged(Object object) {
        Widget widget = this.findItem(object);
        if (widget instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)widget;
            treeItem.setGrayed(false);
            this.updateChildrenItems(treeItem);
            this.updateParentItems(treeItem.getParentItem());
        }
    }

    private void initializeItem(TreeItem treeItem) {
        if (treeItem.getChecked() && !treeItem.getGrayed()) {
            this.updateChildrenItems(treeItem);
        }
    }

    private void updateChildrenItems(TreeItem treeItem) {
        Item[] itemArray = this.getChildren((Widget)treeItem);
        boolean bl = treeItem.getChecked();
        int n = 0;
        while (n < itemArray.length) {
            TreeItem treeItem2 = (TreeItem)itemArray[n];
            if (treeItem2.getData() != null && (treeItem2.getChecked() != bl || treeItem2.getGrayed())) {
                treeItem2.setChecked(bl);
                treeItem2.setGrayed(false);
                this.updateChildrenItems(treeItem2);
            }
            ++n;
        }
    }

    private void updateParentItems(TreeItem treeItem) {
        if (treeItem != null) {
            Item[] itemArray = this.getChildren((Widget)treeItem);
            boolean bl = false;
            boolean bl2 = false;
            int n = 0;
            while (n < itemArray.length) {
                TreeItem treeItem2 = (TreeItem)itemArray[n];
                bl |= treeItem2.getChecked();
                bl2 |= !treeItem2.getChecked() || treeItem2.getGrayed();
                ++n;
            }
            treeItem.setChecked(bl);
            treeItem.setGrayed(bl && bl2);
            this.updateParentItems(treeItem.getParentItem());
        }
    }

    public boolean setChecked(Object object, boolean bl) {
        if (super.setChecked(object, bl)) {
            this.doCheckStateChanged(object);
            return true;
        }
        return false;
    }

    public void setCheckedElements(Object[] objectArray) {
        super.setCheckedElements(objectArray);
        int n = 0;
        while (n < objectArray.length) {
            this.doCheckStateChanged(objectArray[n]);
            ++n;
        }
    }

    protected void setExpanded(Item item, boolean bl) {
        super.setExpanded(item, bl);
        if (bl && item instanceof TreeItem) {
            this.initializeItem((TreeItem)item);
        }
    }

    public Object[] getCheckedElements() {
        Object[] objectArray = super.getCheckedElements();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < objectArray.length) {
            Item[] itemArray;
            Object object = objectArray[n];
            arrayList.add(object);
            Widget widget = this.findItem(object);
            if (widget != null && (itemArray = this.getChildren(widget)).length == 1 && itemArray[0].getData() == null) {
                this.collectChildren(object, arrayList);
            }
            ++n;
        }
        return arrayList.toArray();
    }

    private void collectChildren(Object object, ArrayList arrayList) {
        Object[] objectArray = this.getFilteredChildren(object);
        int n = 0;
        while (n < objectArray.length) {
            Object object2 = objectArray[n];
            arrayList.add(object2);
            this.collectChildren(object2, arrayList);
            ++n;
        }
    }
}

