/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.util.RubyElementVisitor;
import org.rubypeople.rdt.ui.RubyElementLabelProvider;

public class RubyTypeSelectionDialog
extends ElementListSelectionDialog {
    public RubyTypeSelectionDialog(Shell shell) {
        super(shell, (ILabelProvider)new RubyElementLabelProvider());
        this.setElements(this.getElements());
        this.setMultipleSelection(false);
    }

    protected Object[] getElements() {
        return this.getAllTypes();
    }

    private IRubyElement[] getAllTypes() {
        ArrayList<IRubyElement> arrayList = new ArrayList<IRubyElement>();
        IProject[] iProjectArray = RubyCore.getRubyProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            IRubyElement[] iRubyElementArray = RubyTypeSelectionDialog.findElements(iProjectArray[n], 3);
            arrayList.addAll(Arrays.asList(iRubyElementArray));
            ++n;
        }
        IRubyElement[] iRubyElementArray = new IRubyElement[arrayList.size()];
        System.arraycopy(arrayList.toArray(), 0, iRubyElementArray, 0, iRubyElementArray.length);
        return iRubyElementArray;
    }

    public static IRubyElement[] findElements(IFile iFile, int n) {
        IRubyScript iRubyScript = RubyCore.create((IFile)iFile);
        try {
            iRubyScript.reconcile();
            IRubyElement[] iRubyElementArray = iRubyScript.getChildren();
            ArrayList<IRubyElement> arrayList = new ArrayList<IRubyElement>();
            int n2 = 0;
            while (n2 < iRubyElementArray.length) {
                if (iRubyElementArray[n2].isType(n)) {
                    arrayList.add(iRubyElementArray[n2]);
                }
                ++n2;
            }
            IRubyElement[] iRubyElementArray2 = new IRubyElement[arrayList.size()];
            System.arraycopy(arrayList.toArray(), 0, iRubyElementArray2, 0, arrayList.size());
            return iRubyElementArray2;
        }
        catch (RubyModelException rubyModelException) {
            RubyPlugin.log(rubyModelException);
            return new IRubyElement[0];
        }
    }

    public static IRubyElement[] findElements(IProject iProject, int n) {
        if (iProject == null) {
            return new IRubyElement[0];
        }
        try {
            IRubyElement[] iRubyElementArray;
            ArrayList<IRubyElement> arrayList = new ArrayList<IRubyElement>();
            RubyElementVisitor rubyElementVisitor = new RubyElementVisitor();
            iProject.accept((IResourceVisitor)rubyElementVisitor);
            Object[] objectArray = rubyElementVisitor.getCollectedRubyFiles();
            int n2 = 0;
            while (n2 < objectArray.length) {
                iRubyElementArray = (IRubyElement[])objectArray[n2];
                IRubyElement[] iRubyElementArray2 = RubyTypeSelectionDialog.findElements((IFile)iRubyElementArray, n);
                int n3 = 0;
                while (n3 < iRubyElementArray2.length) {
                    arrayList.add(iRubyElementArray2[n3]);
                    ++n3;
                }
                ++n2;
            }
            Object[] objectArray2 = arrayList.toArray();
            iRubyElementArray = new IRubyElement[arrayList.size()];
            System.arraycopy(objectArray2, 0, iRubyElementArray, 0, objectArray2.length);
            return iRubyElementArray;
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
            return new RubyElement[0];
        }
    }
}

