/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.internal.validation;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class TaskListUtility {
    private static final String PLUGIN_ID = "org.eclipse.wst.html.ui";
    private static final String VALIDATION_MARKER = "org.eclipse.wst.html.ui.problemmarker";
    private static final String VALIDATION_MARKER_OWNER = "owner";
    private static final String VALIDATION_MARKER_SEVERITY = "validationSeverity";
    private static final String VALIDATION_MARKER_TARGETOBJECT = "targetObject";
    private static final String VALIDATION_MARKER_GROUP = "groupName";
    private static final String VALIDATION_MARKER_MESSAGEID = "messageId";
    private static final int DEPTH_INFINITE = 2;
    private static final int DEPTH_ZERO = 0;
    private static final IMarker[] NO_MARKERS = new IMarker[0];

    public static IMarker addTask(String pluginId, IResource resource, String location, String messageId, String message, int markerType, String targetObjectName, String groupName, int offset, int length) throws CoreException {
        if (message == null || resource == null) {
            return null;
        }
        int severity = TaskListUtility.getSeverity(markerType);
        IMarker item = resource.createMarker(VALIDATION_MARKER);
        boolean offsetSet = offset != -1 && length != -1;
        int size = offsetSet ? 10 : 8;
        String[] attribNames = new String[size];
        Object[] attribValues = new Object[size];
        attribNames[0] = VALIDATION_MARKER_OWNER;
        attribValues[0] = pluginId;
        attribNames[1] = VALIDATION_MARKER_SEVERITY;
        attribValues[1] = new Integer(markerType);
        attribNames[2] = VALIDATION_MARKER_TARGETOBJECT;
        attribValues[2] = targetObjectName == null ? "" : targetObjectName;
        attribNames[3] = VALIDATION_MARKER_GROUP;
        attribValues[3] = groupName == null ? "" : groupName;
        attribNames[4] = "message";
        attribValues[4] = message;
        attribNames[5] = VALIDATION_MARKER_MESSAGEID;
        attribValues[5] = messageId;
        attribNames[6] = "severity";
        attribValues[6] = new Integer(severity);
        try {
            Integer lineNumber = Integer.valueOf(location);
            attribNames[7] = "lineNumber";
            attribValues[7] = lineNumber;
        }
        catch (NumberFormatException numberFormatException) {
            attribNames[7] = "location";
            attribValues[7] = location;
        }
        if (offsetSet) {
            attribNames[8] = "charStart";
            attribValues[8] = new Integer(offset);
            attribNames[9] = "charEnd";
            attribValues[9] = new Integer(offset + length);
        }
        item.setAttributes(attribNames, attribValues);
        return item;
    }

    private static int getSeverity(int severityEnumValue) {
        switch (severityEnumValue) {
            case 1: {
                return 2;
            }
            case 4: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        return 1;
    }

    private static int getDepth(IResource resource) {
        if (resource instanceof IProject) {
            return 2;
        }
        if (resource instanceof IWorkspaceRoot) {
            return 2;
        }
        return 0;
    }

    private static IMarker[] getValidationTasks(IResource resource, int severity, int depth) {
        int validCount;
        IMarker[] tempMarkers;
        block14: {
            tempMarkers = null;
            validCount = 0;
            try {
                IMarker[] allMarkers = null;
                try {
                    allMarkers = resource.findMarkers(VALIDATION_MARKER, false, depth);
                }
                catch (CoreException coreException) {
                    return NO_MARKERS;
                }
                if (allMarkers.length == 0) break block14;
                tempMarkers = new IMarker[allMarkers.length];
                int i = 0;
                while (i < allMarkers.length) {
                    block16: {
                        IMarker marker;
                        block15: {
                            marker = allMarkers[i];
                            Integer filterSeverity = (Integer)marker.getAttribute(VALIDATION_MARKER_SEVERITY);
                            if (filterSeverity == null) {
                                try {
                                    marker.setAttribute("severity", TaskListUtility.getSeverity(severity));
                                    break block15;
                                }
                                catch (CoreException coreException) {
                                    break block16;
                                }
                                catch (Throwable throwable) {
                                    break block16;
                                }
                            }
                            if ((severity & filterSeverity) == 0) break block16;
                        }
                        tempMarkers[validCount++] = marker;
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
        if (validCount == 0) {
            return NO_MARKERS;
        }
        IMarker[] validMarkers = new IMarker[validCount];
        System.arraycopy(tempMarkers, 0, validMarkers, 0, validCount);
        return validMarkers;
    }

    private static IMarker[] getValidationTasks(IResource resource, String[] messageOwners, int depth) {
        IMarker[] markers = TaskListUtility.getValidationTasks(resource, 7, depth);
        if (markers.length == 0) {
            return NO_MARKERS;
        }
        IMarker[] temp = new IMarker[markers.length];
        int validCount = 0;
        int i = 0;
        while (i < markers.length) {
            block6: {
                IMarker marker = markers[i];
                try {
                    Object owner = marker.getAttribute(VALIDATION_MARKER_OWNER);
                    if (owner == null || !(owner instanceof String)) break block6;
                    int j = 0;
                    while (j < messageOwners.length) {
                        String messageOwner = messageOwners[j];
                        if (((String)owner).equals(messageOwner)) {
                            temp[validCount++] = marker;
                            break;
                        }
                        ++j;
                    }
                }
                catch (CoreException coreException) {
                    return NO_MARKERS;
                }
            }
            ++i;
        }
        IMarker[] result = new IMarker[validCount];
        System.arraycopy(temp, 0, result, 0, validCount);
        return result;
    }

    private static IMarker[] getValidationTasks(IResource resource, String[] messageOwner, String objectName, String groupName, int depth) throws CoreException {
        if (messageOwner == null || resource == null) {
            return NO_MARKERS;
        }
        int validCount = 0;
        IMarker[] validList = null;
        IMarker[] markers = TaskListUtility.getValidationTasks(resource, messageOwner, depth);
        if (markers != null) {
            validList = new IMarker[markers.length];
            int i = 0;
            while (i < markers.length) {
                Object group;
                Object targetObject;
                IMarker marker = markers[i];
                if ((objectName == null || (targetObject = marker.getAttribute(VALIDATION_MARKER_TARGETOBJECT)) != null && targetObject instanceof String && ((String)targetObject).equals(objectName)) && (groupName == null || (group = marker.getAttribute(VALIDATION_MARKER_GROUP)) != null && group instanceof String && ((String)group).equals(groupName))) {
                    validList[validCount++] = marker;
                }
                ++i;
            }
        }
        if (validCount == 0) {
            return NO_MARKERS;
        }
        IMarker[] result = new IMarker[validCount];
        System.arraycopy(validList, 0, result, 0, validCount);
        return result;
    }

    public static void removeAllTasks(IResource resource, String owner, String objectName) throws CoreException {
        TaskListUtility.removeAllTasks(resource, new String[]{owner}, objectName);
    }

    public static void removeAllTasks(IResource resource, String[] owners, String objectName) throws CoreException {
        TaskListUtility.removeAllTasks(resource, owners, objectName, TaskListUtility.getDepth(resource));
    }

    protected static void removeAllTasks(IResource resource, String[] owners, String objectName, int depth) throws CoreException {
        TaskListUtility.removeTaskSubset(resource, owners, objectName, null, depth);
    }

    protected static void removeTaskSubset(IResource resource, String[] owners, String objectName, String groupName, int depth) throws CoreException {
        if (owners == null || resource == null) {
            return;
        }
        IMarker[] allTasks = TaskListUtility.getValidationTasks(resource, owners, objectName, groupName, depth);
        if (allTasks.length > 0) {
            ResourcesPlugin.getWorkspace().deleteMarkers(allTasks);
        }
    }
}

